/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.exceptions;

import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrg;
import org.compiere.util.Env;

public class TaxNoExemptFoundException
extends AdempiereException {
    private static final long serialVersionUID = -5489066603806460132L;
    private static final String AD_Message = "TaxNoExemptFound";

    public TaxNoExemptFoundException(int AD_Org_ID) {
        super(TaxNoExemptFoundException.buildMessage(AD_Org_ID));
    }

    private static final String buildMessage(int AD_Org_ID) {
        StringBuilder msg = new StringBuilder("@").append(AD_Message).append("@");
        msg.append("@AD_Org_ID@:").append(TaxNoExemptFoundException.getOrgString(AD_Org_ID));
        return msg.toString();
    }

    private static final String getOrgString(int AD_Org_ID) {
        if (AD_Org_ID <= 0) {
            return "*";
        }
        MOrg org = MOrg.get(Env.getCtx(), AD_Org_ID);
        if (org == null || org.get_ID() != AD_Org_ID) {
            return "?";
        }
        return org.getName();
    }
}

