/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.ClassGraph;
import java.time.Duration;
import java.time.Instant;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public abstract class AnnotationBasedFactory {
    private boolean scanSuccessful;
    private final AtomicBoolean scanCompleted = new AtomicBoolean(false);
    private CompletableFuture<Void> threadBlockerFuture = new CompletableFuture();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedFactory.class);
    private final ClassGraph.FailureHandler defaultScanFailureHandler = throwable -> {
        s_log.severe(throwable.getMessage());
        this.signalScanCompletion(false);
    };

    protected void signalScanCompletion(boolean succeeded) {
        this.scanSuccessful = succeeded;
        this.scanCompleted.set(true);
        try {
            this.threadBlockerFuture.complete(null);
        }
        catch (Exception exception) {}
    }

    protected void blockWhileScanning() {
        String className = this.getClass().getSimpleName();
        if (!this.scanCompleted.get()) {
            try {
                Instant start = Instant.now();
                this.threadBlockerFuture.get();
                if (s_log.isLoggable(Level.FINE)) {
                    s_log.fine(() -> String.format("%s waited %d(ms) for class scanning to end", className, Duration.between(start, Instant.now()).toMillis()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (!this.scanSuccessful) {
            throw new RuntimeException(className + " - annotation scan unsuccessful");
        }
    }

    protected ExecutorService getExecutorService() {
        return executorService;
    }

    protected int getMaxThreads() {
        int max;
        int defaultMax = max = Runtime.getRuntime().availableProcessors() * 5;
        Properties properties = Ini.getProperties();
        String maxSize = properties.getProperty("MaxThreadPoolSize");
        if (maxSize != null) {
            try {
                max = Integer.parseInt(maxSize) / 5;
            }
            catch (Exception exception) {}
        }
        if (max <= 0) {
            max = defaultMax;
        }
        return max;
    }

    protected ClassGraph.FailureHandler getScanFailureHandler() {
        return this.defaultScanFailureHandler;
    }
}

