/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MIndexColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.process.TableIndexValidate;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

@Process
public class CreateTableIndex
extends SvrProcess {
    private int p_AD_Table_ID = 0;
    private int countTable = 0;
    private int countIndex = 0;
    private int countError = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_AD_Table_ID = para[i2].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("AD_Table_ID=" + this.p_AD_Table_ID);
        }
        Trx trx = Trx.get(this.get_TrxName(), true);
        DatabaseMetaData md = trx.getConnection().getMetaData();
        if (this.p_AD_Table_ID > 0) {
            MTable table2 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
            if (table2 != null) {
                this.processDatabaseTable(md, table2);
            }
        } else {
            this.processDatabase(md);
        }
        trx.close();
        return Msg.getMsg(this.getCtx(), "CreateTableIndexProcessResult", new Object[]{this.countTable, this.countIndex, this.countError});
    }

    private void processDatabase(DatabaseMetaData md) throws Exception {
        String tableName = null;
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        String[] types = new String[]{"TABLE"};
        ResultSet rs = md.getTables(catalog, schema, tableName, types);
        while (rs.next()) {
            MTable table2;
            String dbTableName = rs.getString("TABLE_NAME");
            if (dbTableName == null || (table2 = MTable.get(this.getCtx(), dbTableName)) == null) continue;
            this.processDatabaseTable(md, table2);
        }
        rs.close();
    }

    private void processDatabaseTable(DatabaseMetaData md, MTable table2) throws Exception {
        Hashtable<String, DatabaseTableIndex> htIndexes = new Hashtable<String, DatabaseTableIndex>();
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        String tableName = table2.getTableName();
        if (md.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (md.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        this.addLog(Msg.getMsg(this.getCtx(), "CreateTableIndexProcessTable") + tableName);
        this.addLog(table2.getAD_Table_ID(), null, null, table2.toString(), table2.get_Table_ID(), table2.getAD_Table_ID());
        ++this.countTable;
        ResultSet rs = md.getIndexInfo(catalog, schema, tableName, false, true);
        while (rs.next()) {
            String dbIndexName = rs.getString("INDEX_NAME");
            if (dbIndexName == null) continue;
            String key = dbIndexName.toLowerCase();
            DatabaseTableIndex dbTableIndex = htIndexes.get(key);
            if (dbTableIndex == null) {
                dbTableIndex = new DatabaseTableIndex(dbIndexName, new String[30], true, null);
            }
            String columnName = rs.getString("COLUMN_NAME");
            short pos = rs.getShort("ORDINAL_POSITION");
            if (pos > 0) {
                dbTableIndex.columns[pos - 1] = columnName;
            }
            dbTableIndex.isNonUnique = rs.getBoolean("NON_UNIQUE");
            dbTableIndex.ascOrDesc = rs.getString("ASC_OR_DESC");
            htIndexes.put(key, dbTableIndex);
        }
        rs.close();
        if (!htIndexes.isEmpty()) {
            this.processTableIndex(md, table2, htIndexes);
        }
        htIndexes = null;
    }

    private void processTableIndex(DatabaseMetaData md, MTable table2, Hashtable<String, DatabaseTableIndex> htIndexes) throws Exception {
        String catalog = DB.getDatabase().getCatalog();
        String schema = DB.getDatabase().getSchema();
        String tableName = table2.getTableName();
        if (md.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        } else if (md.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        }
        ResultSet rs = md.getPrimaryKeys(catalog, schema, tableName);
        while (rs.next()) {
            String primaryKeyName = rs.getString("PK_NAME");
            String key = primaryKeyName.toLowerCase();
            DatabaseTableIndex dbTableIndex = htIndexes.get(key);
            if (dbTableIndex == null) continue;
            htIndexes.remove(key);
        }
        rs.close();
        if (htIndexes.isEmpty()) {
            return;
        }
        ArrayList<MTableIndex> tableIndexesToValidate = new ArrayList<MTableIndex>();
        MTableIndex[] tableIndexes = MTableIndex.get(table2);
        MTableIndex[] mTableIndexArray = tableIndexes;
        int n = tableIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            MTableIndex tableIndex = mTableIndexArray[n2];
            String key = tableIndex.getName().toLowerCase();
            DatabaseTableIndex dbTableIndex = htIndexes.get(key);
            tableIndexesToValidate.add(tableIndex);
            if (dbTableIndex != null) {
                htIndexes.remove(key);
            }
            ++n2;
        }
        String getColumnIDSql = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ? AND LOWER(ColumnName) = ?";
        Enumeration<DatabaseTableIndex> en = htIndexes.elements();
        while (en.hasMoreElements()) {
            DatabaseTableIndex dbTableIndex = en.nextElement();
            this.addLog(Msg.getMsg(this.getCtx(), "CreateTableIndexCreateTableIndex") + dbTableIndex.indexName);
            Trx trx = Trx.get(Trx.createTrxName("CreateTableIndex"), true);
            trx.setDisplayName(this.getClass().getName() + "_process_createMTableIndex");
            try {
                try {
                    MTableIndex tableIndex = new MTableIndex(this.getCtx(), 0, this.get_TrxName());
                    tableIndex.setAD_Table_ID(table2.getAD_Table_ID());
                    tableIndex.setName(dbTableIndex.indexName);
                    tableIndex.setIsUnique(!dbTableIndex.isNonUnique);
                    tableIndex.saveEx();
                    this.addLog(tableIndex.getAD_TableIndex_ID(), null, null, tableIndex.toString(), tableIndex.get_Table_ID(), tableIndex.getAD_TableIndex_ID());
                    int i2 = 0;
                    while (i2 < 30) {
                        String dbIndexColumn = dbTableIndex.columns[i2];
                        if (dbIndexColumn == null) break;
                        int AD_Column_ID = DB.getSQLValue(null, getColumnIDSql, table2.getAD_Table_ID(), dbIndexColumn.toLowerCase());
                        String columnName = dbIndexColumn;
                        if (AD_Column_ID > 0) {
                            columnName = MColumn.getColumnName(this.getCtx(), AD_Column_ID);
                        }
                        MIndexColumn indexColumn = new MIndexColumn(this.getCtx(), 0, this.get_TrxName());
                        indexColumn.setAD_TableIndex_ID(tableIndex.getAD_TableIndex_ID());
                        if (AD_Column_ID > 0) {
                            indexColumn.setAD_Column_ID(AD_Column_ID);
                        } else {
                            indexColumn.setColumnSQL(columnName);
                        }
                        String ascOrDesc = dbTableIndex.ascOrDesc;
                        if (ascOrDesc != null && ascOrDesc.equals("D")) {
                            indexColumn.setColumnSQL(columnName + " DESC");
                        }
                        indexColumn.setSeqNo(i2 + 1);
                        indexColumn.saveEx();
                        this.addLog(indexColumn.getAD_IndexColumn_ID(), null, null, indexColumn.toString(), indexColumn.get_Table_ID(), indexColumn.getAD_IndexColumn_ID());
                        ++i2;
                    }
                    if (trx != null) {
                        trx.commit();
                    }
                    ++this.countIndex;
                }
                catch (Exception e) {
                    this.addLog(Msg.getMsg(this.getCtx(), "Error") + e.getLocalizedMessage());
                    if (trx != null) {
                        trx.rollback();
                    }
                    ++this.countError;
                    if (trx == null) continue;
                    trx.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (trx != null) {
                    trx.close();
                }
                throw throwable;
            }
            if (trx == null) continue;
            trx.close();
        }
        for (MTableIndex tableIndex : tableIndexesToValidate) {
            this.addLog(Msg.getMsg(this.getCtx(), "CreateTableIndexValidateTableIndex") + tableIndex.getName());
            this.addLog(tableIndex.getAD_TableIndex_ID(), null, null, tableIndex.toString(), tableIndex.get_Table_ID(), tableIndex.getAD_TableIndex_ID());
            Trx trx = Trx.get(Trx.createTrxName("ValidateTableIndex"), true);
            trx.setDisplayName(this.getClass().getName() + "_process_validateTableIndex");
            try {
                try {
                    String result = TableIndexValidate.validateTableIndex(this.getCtx(), tableIndex, trx.getTrxName(), this.getProcessInfo());
                    this.addLog(result);
                    if (trx != null) {
                        trx.commit();
                    }
                    ++this.countIndex;
                }
                catch (Exception e) {
                    this.addLog(Msg.getMsg(this.getCtx(), "Error") + e.getLocalizedMessage());
                    if (trx != null) {
                        trx.rollback();
                    }
                    ++this.countError;
                    if (trx == null) continue;
                    trx.close();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (trx != null) {
                    trx.close();
                }
                throw throwable;
            }
            if (trx == null) continue;
            trx.close();
        }
    }

    private class DatabaseTableIndex {
        private String indexName;
        private String[] columns;
        private boolean isNonUnique;
        private String ascOrDesc;

        private DatabaseTableIndex(String indexName, String[] columns, boolean isNonUnique, String ascOrDesc) {
            this.indexName = indexName;
            this.columns = columns;
            this.isNonUnique = isNonUnique;
            this.ascOrDesc = ascOrDesc;
        }
    }
}

