/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class MPrintFormatProcess
extends SvrProcess {
    private BigDecimal m_AD_PrintFormat_ID;
    private BigDecimal m_AD_Table_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i2 = 0;
        while (i2 < para.length) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() != null) {
                if (name.equals("AD_PrintFormat_ID")) {
                    this.m_AD_PrintFormat_ID = (BigDecimal)para[i2].getParameter();
                } else if (name.equals("AD_Table_ID")) {
                    this.m_AD_Table_ID = (BigDecimal)para[i2].getParameter();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para[i2]);
                }
            }
            ++i2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_AD_Table_ID != null && this.m_AD_Table_ID.intValue() > 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Create from AD_Table_ID=" + String.valueOf(this.m_AD_Table_ID));
            }
            MPrintFormat pf = MPrintFormat.createFromTable(this.getCtx(), this.m_AD_Table_ID.intValue(), this.getRecord_ID());
            this.addLog(this.m_AD_Table_ID.intValue(), null, new BigDecimal(pf.getItemCount()), pf.getName());
            return pf.getName() + " #" + pf.getItemCount();
        }
        if (this.m_AD_PrintFormat_ID != null && this.m_AD_PrintFormat_ID.intValue() > 0) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Copy from AD_PrintFormat_ID=" + String.valueOf(this.m_AD_PrintFormat_ID));
            }
            MPrintFormat pf = MPrintFormat.copy(this.getCtx(), this.m_AD_PrintFormat_ID.intValue(), this.getRecord_ID());
            this.addLog(this.m_AD_PrintFormat_ID.intValue(), null, new BigDecimal(pf.getItemCount()), pf.getName());
            return pf.getName() + " #" + pf.getItemCount();
        }
        throw new Exception(MSG_InvalidArguments);
    }
}

