/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Tree_Favorite_Node;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MTreeFavoriteNode
extends X_AD_Tree_Favorite_Node {
    private static final long serialVersionUID = -1085269880909860587L;
    public static final String SQL_CHECK_MENU_EXISTS = "SELECT CASE WHEN COUNT(AD_Menu_ID) > 0 THEN 'Y' ELSE 'N' END FROM AD_Tree_Favorite_Node WHERE AD_Tree_Favorite_ID=? AND NVL(Parent_ID, 0)=? AND AD_Menu_ID=?";

    public MTreeFavoriteNode(Properties ctx, String AD_Tree_Favorite_Node_UU, String trxName) {
        super(ctx, AD_Tree_Favorite_Node_UU, trxName);
    }

    public MTreeFavoriteNode(Properties ctx, int AD_Tree_Favorite_Node_ID, String trxName) {
        super(ctx, AD_Tree_Favorite_Node_ID, trxName);
    }

    public MTreeFavoriteNode(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static boolean isMenuExists(int menuID, int nodeID, int treeFavID) {
        return "Y".equalsIgnoreCase(DB.getSQLValueStringEx(null, SQL_CHECK_MENU_EXISTS, treeFavID, nodeID, menuID));
    }

    public static MTreeFavoriteNode getFavouriteTreeNodeFromMenuID(int AD_Tree_Favorite_ID, int Menu_ID) {
        Query query = new Query(Env.getCtx(), "AD_Tree_Favorite_Node", "AD_Tree_Favorite_ID=? AND AD_Menu_ID=? AND IsFavourite='Y' AND AD_Client_ID IN (0,?)", null);
        query.setOnlyActiveRecords(true);
        query.setParameters(AD_Tree_Favorite_ID, Menu_ID, Env.getAD_Client_ID(Env.getCtx()));
        return (MTreeFavoriteNode)query.first();
    }

    public static MTreeFavoriteNode create(int AD_Client_ID, int AD_Org_ID, int AD_Tree_Favorite_ID, int AD_Menu_ID, int Parent_ID, int SeqNo, String folderName, boolean isSummary, boolean isCollapsible, boolean isFavourite) {
        MTreeFavoriteNode favNode = (MTreeFavoriteNode)MTable.get(Env.getCtx(), 200221).getPO(0, null);
        favNode.set_ValueOfColumn("AD_Client_ID", (Object)AD_Client_ID);
        favNode.setAD_Org_ID(AD_Org_ID);
        favNode.setAD_Tree_Favorite_ID(AD_Tree_Favorite_ID);
        favNode.setAD_Menu_ID(AD_Menu_ID);
        favNode.setParent_ID(Parent_ID);
        favNode.setSeqNo(SeqNo);
        if (isSummary) {
            favNode.setName(folderName);
        }
        favNode.setIsSummary(isSummary);
        favNode.setIsCollapsible(isCollapsible);
        favNode.setIsFavourite(isFavourite);
        if (!favNode.save()) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "NodeNotCreate"));
        }
        return favNode;
    }
}

