/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_C_BPartner;
import org.compiere.model.X_I_BPartner;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MBPartner
extends X_C_BPartner
implements ImmutablePOSupport {
    private static final long serialVersionUID = 2256035503713773448L;
    private static CLogger s_log = CLogger.getCLogger(MBPartner.class);
    protected MUser[] m_contacts = null;
    protected MBPartnerLocation[] m_locations = null;
    protected MBPBankAccount[] m_accounts = null;
    protected Integer m_primaryC_BPartner_Location_ID = null;
    protected Integer m_primaryAD_User_ID = null;
    protected MBPGroup m_group = null;

    public static MBPartner getTemplate(Properties ctx, int AD_Client_ID) {
        MBPartner template = MBPartner.getBPartnerCashTrx(ctx, AD_Client_ID);
        if (template == null) {
            template = new MBPartner(ctx, 0, null);
        }
        if (template != null) {
            template.set_ValueNoCheck("C_BPartner_ID", 0);
            template.set_ValueNoCheck("C_BPartner_UU", null);
            template.setAD_OrgBP_ID(0);
            template.setLogo_ID(0);
            template.setValue("");
            template.setName("");
            template.setName2(null);
            template.setDUNS("");
            template.setFirstSale(null);
            template.setSO_CreditLimit(Env.ZERO);
            template.setSO_CreditUsed(Env.ZERO);
            template.setTotalOpenBalance(Env.ZERO);
            template.setActualLifeTimeValue(Env.ZERO);
            template.setPotentialLifeTimeValue(Env.ZERO);
            template.setAcqusitionCost(Env.ZERO);
            template.setShareOfCustomer(0);
            template.setSalesVolume(0);
            Timestamp ts = new Timestamp(System.currentTimeMillis());
            template.set_ValueNoCheck("Created", ts);
            template.set_ValueNoCheck("Updated", ts);
            template.set_ValueNoCheck("CreatedBy", Env.getAD_User_ID(ctx));
            template.set_ValueNoCheck("UpdatedBy", Env.getAD_User_ID(ctx));
        }
        return template;
    }

    public static MBPartner getBPartnerCashTrx(Properties ctx, int AD_Client_ID) {
        MBPartner retValue = (MBPartner)MClientInfo.get(ctx, AD_Client_ID).getC_BPartnerCashTrx();
        if (retValue == null) {
            s_log.log(Level.SEVERE, "Not found for AD_Client_ID=" + AD_Client_ID);
        }
        return retValue;
    }

    public static MBPartner get(Properties ctx, String Value) {
        return MBPartner.get(ctx, Value, null);
    }

    public static MBPartner get(Properties ctx, String Value, String trxName) {
        if (Value == null || Value.length() == 0) {
            return null;
        }
        MBPartner retValue = (MBPartner)new Query(ctx, "C_BPartner", "Value=? AND AD_Client_ID=?", trxName).setParameters(Value, Env.getAD_Client_ID(ctx)).firstOnly();
        return retValue;
    }

    public static MBPartner getFirstWithTaxID(Properties ctx, String taxID, String trxName) {
        MBPartner retValue = (MBPartner)new Query(ctx, "C_BPartner", "TaxID=? AND AD_Client_ID=?", trxName).setParameters(taxID, Env.getAD_Client_ID(ctx)).setOrderBy("C_BPartner_ID").first();
        return retValue;
    }

    public static MBPartner get(Properties ctx, int C_BPartner_ID) {
        return MBPartner.get(ctx, C_BPartner_ID, null);
    }

    public static MBPartner get(Properties ctx, int C_BPartner_ID, String trxName) {
        MBPartner retValue = (MBPartner)new Query(ctx, "C_BPartner", "C_BPartner_ID=? AND AD_Client_ID=?", trxName).setParameters(C_BPartner_ID, Env.getAD_Client_ID(ctx)).firstOnly();
        return retValue;
    }

    public static BigDecimal getNotInvoicedAmt(int C_BPartner_ID) {
        BigDecimal retValue;
        block6: {
            retValue = null;
            String sql = "SELECT COALESCE(SUM(COALESCE(currencyBase((ol.QtyDelivered-ol.QtyInvoiced)*ol.PriceActual,o.C_Currency_ID,o.DateOrdered, o.AD_Client_ID,o.AD_Org_ID) ,0)),0) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE o.IsSOTrx='Y' AND Bill_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public MBPartner(Properties ctx) {
        this(ctx, -1, null);
    }

    public MBPartner(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBPartner(Properties ctx, String C_BPartner_UU, String trxName) {
        super(ctx, C_BPartner_UU, trxName);
        if (Util.isEmpty(C_BPartner_UU)) {
            this.setInitialDefaults();
        }
    }

    public MBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        super(ctx, C_BPartner_ID, trxName);
        if (C_BPartner_ID == -1) {
            this.initTemplate(Env.getContextAsInt(ctx, "AD_Client_ID"));
            C_BPartner_ID = 0;
        }
        if (C_BPartner_ID == 0) {
            this.setInitialDefaults();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
    }

    private void setInitialDefaults() {
        this.setIsCustomer(true);
        this.setIsProspect(true);
        this.setSendEMail(false);
        this.setIsOneTime(false);
        this.setIsVendor(false);
        this.setIsSummary(false);
        this.setIsEmployee(false);
        this.setIsSalesRep(false);
        this.setIsTaxExempt(false);
        this.setIsPOTaxExempt(false);
        this.setIsDiscountPrinted(false);
        this.setSO_CreditLimit(Env.ZERO);
        this.setSO_CreditUsed(Env.ZERO);
        this.setTotalOpenBalance(Env.ZERO);
        this.setSOCreditStatus("X");
        this.setFirstSale(null);
        this.setActualLifeTimeValue(Env.ZERO);
        this.setPotentialLifeTimeValue(Env.ZERO);
        this.setAcqusitionCost(Env.ZERO);
        this.setShareOfCustomer(0);
        this.setSalesVolume(0);
    }

    public MBPartner(X_I_BPartner impBP) {
        this(impBP.getCtx(), 0, impBP.get_TrxName());
        this.setClientOrg(impBP);
        this.setUpdatedBy(impBP.getUpdatedBy());
        String value = impBP.getValue();
        if (value == null || value.length() == 0) {
            value = impBP.getEMail();
        }
        if (value == null || value.length() == 0) {
            value = impBP.getContactName();
        }
        this.setValue(value);
        String name = impBP.getName();
        if (name == null || name.length() == 0) {
            name = impBP.getContactName();
        }
        if (name == null || name.length() == 0) {
            name = impBP.getEMail();
        }
        this.setName(name);
        this.setName2(impBP.getName2());
        this.setDescription(impBP.getDescription());
        this.setDUNS(impBP.getDUNS());
        this.setTaxID(impBP.getTaxID());
        this.setNAICS(impBP.getNAICS());
        this.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
    }

    public MBPartner(MBPartner copy) {
        this(Env.getCtx(), copy);
    }

    public MBPartner(Properties ctx, MBPartner copy) {
        this(ctx, copy, null);
    }

    public MBPartner(Properties ctx, MBPartner copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_contacts = copy.m_contacts != null ? (MUser[])Arrays.stream(copy.m_contacts).map(e -> new MUser(ctx, (MUser)e, trxName)).toArray(MUser[]::new) : null;
        this.m_locations = copy.m_locations != null ? (MBPartnerLocation[])Arrays.stream(copy.m_locations).map(e -> new MBPartnerLocation(ctx, (MBPartnerLocation)e, trxName)).toArray(MBPartnerLocation[]::new) : null;
        this.m_accounts = copy.m_accounts != null ? (MBPBankAccount[])Arrays.stream(copy.m_accounts).map(e -> new MBPBankAccount(ctx, (MBPBankAccount)e, trxName)).toArray(MBPBankAccount[]::new) : null;
        this.m_primaryC_BPartner_Location_ID = copy.m_primaryC_BPartner_Location_ID;
        this.m_primaryAD_User_ID = copy.m_primaryAD_User_ID;
        this.m_group = copy.m_group != null ? new MBPGroup(ctx, copy.m_group, trxName) : null;
    }

    public MBPartner(Properties ctx, int C_BPartner_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_BPartner_ID, trxName, virtualColumns);
    }

    protected boolean initTemplate(int AD_Client_ID) {
        boolean success;
        block8: {
            if (AD_Client_ID == 0) {
                throw new IllegalArgumentException("Client_ID=0");
            }
            success = true;
            String sql = "SELECT * FROM C_BPartner WHERE C_BPartner_ID IN (SELECT C_BPartnerCashTrx_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        success = this.load(rs);
                    } else {
                        this.load(0, null, new String[0]);
                        success = false;
                        this.log.severe("None found");
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.setStandardDefaults();
        this.set_ValueNoCheck("C_BPartner_ID", I_ZERO);
        this.setValue("");
        this.setName("");
        this.setName2(null);
        this.set_ValueNoCheck("C_BPartner_UU", "");
        return success;
    }

    public MUser[] getContacts(boolean reload) {
        ArrayList<MUser> list;
        block7: {
            if (!reload && this.m_contacts != null && this.m_contacts.length != 0) {
                return this.m_contacts;
            }
            list = new ArrayList<MUser>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement("SELECT * FROM AD_User WHERE C_BPartner_ID=? AND IsActive = 'Y' ORDER BY AD_User_ID", this.get_TrxName());
                    pstmt.setInt(1, this.getC_BPartner_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUser(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM AD_User WHERE C_BPartner_ID=? AND IsActive = 'Y' ORDER BY AD_User_ID", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_contacts = new MUser[list.size()];
        list.toArray(this.m_contacts);
        return this.m_contacts;
    }

    public MUser getContact(int AD_User_ID) {
        MUser[] users = this.getContacts(false);
        if (users.length == 0) {
            return null;
        }
        int i2 = 0;
        while (AD_User_ID != 0 && i2 < users.length) {
            if (users[i2].getAD_User_ID() == AD_User_ID) {
                return users[i2];
            }
            ++i2;
        }
        return users[0];
    }

    public MBPartnerLocation[] getLocations(boolean reload) {
        ArrayList<MBPartnerLocation> list;
        block7: {
            if (!reload && this.m_locations != null && this.m_locations.length != 0) {
                return this.m_locations;
            }
            list = new ArrayList<MBPartnerLocation>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement("SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY C_BPartner_Location_ID", this.get_TrxName());
                    pstmt.setInt(1, this.getC_BPartner_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MBPartnerLocation(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM C_BPartner_Location WHERE C_BPartner_ID=? AND IsActive='Y' ORDER BY C_BPartner_Location_ID", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_locations = new MBPartnerLocation[list.size()];
        list.toArray(this.m_locations);
        return this.m_locations;
    }

    public MBPartnerLocation getLocation(int C_BPartner_Location_ID) {
        MBPartnerLocation[] locations = this.getLocations(false);
        if (locations.length == 0) {
            return null;
        }
        MBPartnerLocation retValue = null;
        int i2 = 0;
        while (i2 < locations.length) {
            if (locations[i2].getC_BPartner_Location_ID() == C_BPartner_Location_ID) {
                return locations[i2];
            }
            if (retValue == null && locations[i2].isBillTo()) {
                retValue = locations[i2];
            }
            ++i2;
        }
        if (retValue == null) {
            return locations[0];
        }
        return retValue;
    }

    public MBPBankAccount[] getBankAccounts(boolean requery) {
        ArrayList<MBPBankAccount> list;
        block7: {
            if (this.m_accounts != null && this.m_accounts.length >= 0 && !requery) {
                return this.m_accounts;
            }
            list = new ArrayList<MBPBankAccount>();
            String sql = "SELECT * FROM C_BP_BankAccount WHERE C_BPartner_ID=? AND IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_BPartner_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MBPBankAccount(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_accounts = new MBPBankAccount[list.size()];
        list.toArray(this.m_accounts);
        return this.m_accounts;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MBPartner[ID=").append(this.get_ID()).append(",Value=").append(this.getValue()).append(",Name=").append(this.getName()).append(",Open=").append(this.getTotalOpenBalance()).append("]");
        return sb.toString();
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    @Deprecated(forRemoval=true, since="11")
    public int getAD_OrgBP_ID_Int() {
        return this.getAD_OrgBP_ID();
    }

    public int getPrimaryC_BPartner_Location_ID() {
        if (this.m_primaryC_BPartner_Location_ID == null) {
            MBPartnerLocation[] locs = this.getLocations(false);
            int i2 = 0;
            while (this.m_primaryC_BPartner_Location_ID == null && i2 < locs.length) {
                if (locs[i2].isBillTo()) {
                    this.setPrimaryC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                    break;
                }
                ++i2;
            }
            if (this.m_primaryC_BPartner_Location_ID == null && locs.length > 0) {
                this.setPrimaryC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.m_primaryC_BPartner_Location_ID == null) {
            return 0;
        }
        return this.m_primaryC_BPartner_Location_ID;
    }

    public MBPartnerLocation getPrimaryC_BPartner_Location() {
        if (this.m_primaryC_BPartner_Location_ID == null) {
            this.m_primaryC_BPartner_Location_ID = this.getPrimaryC_BPartner_Location_ID();
        }
        if (this.m_primaryC_BPartner_Location_ID == null) {
            return null;
        }
        return new MBPartnerLocation(this.getCtx(), this.m_primaryC_BPartner_Location_ID, null);
    }

    public int getPrimaryAD_User_ID() {
        if (this.m_primaryAD_User_ID == null) {
            MUser[] users = this.getContacts(false);
            if (this.m_primaryAD_User_ID == null && users.length > 0) {
                this.setPrimaryAD_User_ID(users[0].getAD_User_ID());
            }
        }
        if (this.m_primaryAD_User_ID == null) {
            return -1;
        }
        return this.m_primaryAD_User_ID;
    }

    public void setPrimaryC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        this.m_primaryC_BPartner_Location_ID = C_BPartner_Location_ID;
    }

    public void setPrimaryAD_User_ID(int AD_User_ID) {
        this.m_primaryAD_User_ID = AD_User_ID;
    }

    public void setTotalOpenBalance() {
        BigDecimal TotalOpenBalance;
        BigDecimal SO_CreditUsed;
        block8: {
            this.log.info("");
            SO_CreditUsed = null;
            TotalOpenBalance = null;
            String sql = "SELECT COALESCE((SELECT SUM(currencyBase(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsSOTrx='Y' AND i.IsPaid='N' AND i.DocStatus IN ('CO','CL')),0), COALESCE((SELECT SUM(currencyBase(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsPaid='N' AND i.DocStatus IN ('CO','CL')),0) - COALESCE((SELECT SUM(currencyBase(Paymentavailable(p.C_Payment_ID),p.C_Currency_ID,p.DateTrx,p.AD_Client_ID,p.AD_Org_ID)) FROM C_Payment_v p WHERE p.C_BPartner_ID=bp.C_BPartner_ID AND p.IsAllocated='N' AND p.C_Charge_ID IS NULL AND p.DocStatus IN ('CO','CL')),0) FROM C_BPartner bp WHERE C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_BPartner_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        SO_CreditUsed = rs.getBigDecimal(1);
                        TotalOpenBalance = rs.getBigDecimal(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (SO_CreditUsed != null) {
            super.setSO_CreditUsed(SO_CreditUsed);
        }
        if (TotalOpenBalance != null) {
            super.setTotalOpenBalance(TotalOpenBalance);
        }
        this.setSOCreditStatus();
    }

    public void setActualLifeTimeValue() {
        BigDecimal ActualLifeTimeValue;
        block7: {
            ActualLifeTimeValue = null;
            String sql = "SELECT COALESCE ((SELECT SUM(currencyBase(i.GrandTotal,i.C_Currency_ID,i.DateInvoiced, i.AD_Client_ID,i.AD_Org_ID)) FROM C_Invoice_v i WHERE i.C_BPartner_ID=bp.C_BPartner_ID AND i.IsSOTrx='Y' AND i.DocStatus IN ('CO','CL')),0) FROM C_BPartner bp WHERE C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_BPartner_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        ActualLifeTimeValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (ActualLifeTimeValue != null) {
            super.setActualLifeTimeValue(ActualLifeTimeValue);
        }
    }

    public void setSOCreditStatus() {
        BigDecimal creditLimit = this.getSO_CreditLimit();
        if ("X".equals(this.getSOCreditStatus()) || "S".equals(this.getSOCreditStatus()) || Env.ZERO.compareTo(creditLimit) == 0) {
            return;
        }
        if (creditLimit.compareTo(this.getTotalOpenBalance()) < 0) {
            this.setSOCreditStatus("H");
        } else {
            BigDecimal watchAmt = creditLimit.multiply(this.getCreditWatchRatio());
            if (watchAmt.compareTo(this.getTotalOpenBalance()) < 0) {
                this.setSOCreditStatus("W");
            } else {
                this.setSOCreditStatus("O");
            }
        }
    }

    public String getSOCreditStatus(BigDecimal additionalAmt) {
        if (additionalAmt == null || additionalAmt.signum() == 0) {
            return this.getSOCreditStatus();
        }
        BigDecimal creditLimit = this.getSO_CreditLimit();
        if ("X".equals(this.getSOCreditStatus()) || "S".equals(this.getSOCreditStatus()) || Env.ZERO.compareTo(creditLimit) == 0) {
            return this.getSOCreditStatus();
        }
        if ((creditLimit = creditLimit.subtract(additionalAmt)).compareTo(this.getTotalOpenBalance()) < 0) {
            return "H";
        }
        BigDecimal watchAmt = creditLimit.multiply(this.getCreditWatchRatio());
        if (watchAmt.compareTo(this.getTotalOpenBalance()) < 0) {
            return "W";
        }
        return "O";
    }

    public BigDecimal getCreditWatchRatio() {
        return this.getBPGroup().getCreditWatchRatio();
    }

    public boolean isCreditStopHold() {
        String status = this.getSOCreditStatus();
        return "S".equals(status) || "H".equals(status);
    }

    public MBPGroup getBPGroup() {
        if (this.m_group == null) {
            this.m_group = this.getC_BP_Group_ID() == 0 ? MBPGroup.getDefault(this.getCtx()) : MBPGroup.getCopy(this.getCtx(), this.getC_BP_Group_ID(), this.get_TrxName());
        }
        return this.m_group;
    }

    public void setBPGroup(MBPGroup group) {
        this.m_group = group;
        if (this.m_group == null) {
            return;
        }
        this.setC_BP_Group_ID(this.m_group.getC_BP_Group_ID());
        if (this.m_group.getC_Dunning_ID() != 0) {
            this.setC_Dunning_ID(this.m_group.getC_Dunning_ID());
        }
        if (this.m_group.getM_PriceList_ID() != 0) {
            this.setM_PriceList_ID(this.m_group.getM_PriceList_ID());
        }
        if (this.m_group.getPO_PriceList_ID() != 0) {
            this.setPO_PriceList_ID(this.m_group.getPO_PriceList_ID());
        }
        if (this.m_group.getM_DiscountSchema_ID() != 0) {
            this.setM_DiscountSchema_ID(this.m_group.getM_DiscountSchema_ID());
        }
        if (this.m_group.getPO_DiscountSchema_ID() != 0) {
            this.setPO_DiscountSchema_ID(this.m_group.getPO_DiscountSchema_ID());
        }
    }

    @Override
    public int getM_PriceList_ID() {
        int ii = super.getM_PriceList_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getM_PriceList_ID();
        }
        return ii;
    }

    @Override
    public int getPO_PriceList_ID() {
        int ii = super.getPO_PriceList_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getPO_PriceList_ID();
        }
        return ii;
    }

    @Override
    public int getM_DiscountSchema_ID() {
        int ii = super.getM_DiscountSchema_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getM_DiscountSchema_ID();
        }
        return ii;
    }

    @Override
    public int getPO_DiscountSchema_ID() {
        int ii = super.getPO_DiscountSchema_ID();
        if (ii == 0) {
            ii = this.getBPGroup().getPO_DiscountSchema_ID();
        }
        return ii;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("C_BP_Group_ID")) {
            MBPGroup grp = this.getBPGroup();
            if (grp == null) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@:  @C_BP_Group_ID@"));
                return false;
            }
            this.setBPGroup(grp);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        StringBuilder msgacc;
        if (!success) {
            return success;
        }
        if (newRecord) {
            this.insert_Tree("BP");
            msgacc = new StringBuilder("p.C_BP_Group_ID=").append(this.getC_BP_Group_ID() > 999999 && Env.isLogMigrationScript(this.get_TableName()) ? "toRecordId('C_BP_Group'," + DB.TO_STRING(MBPGroup.get(this.getC_BP_Group_ID()).getC_BP_Group_UU()) + ")" : Integer.valueOf(this.getC_BP_Group_ID()));
            this.insert_Accounting("C_BP_Customer_Acct", "C_BP_Group_Acct", msgacc.toString());
            this.insert_Accounting("C_BP_Vendor_Acct", "C_BP_Group_Acct", msgacc.toString());
        }
        if (newRecord || this.is_ValueChanged("Value")) {
            this.update_Tree("BP");
        }
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            msgacc = new StringBuilder("C_BPartner_ID=").append(this.getC_BPartner_ID());
            MAccount.updateValueDescription(this.getCtx(), msgacc.toString(), this.get_TrxName());
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("BP");
        }
        return success;
    }

    @Override
    protected boolean postDelete() {
        MImage img;
        if (this.getLogo_ID() > 0 && !(img = new MImage(this.getCtx(), this.getLogo_ID(), this.get_TrxName())).delete(true)) {
            this.log.warning("Associated image could not be deleted for bpartner - AD_Image_ID=" + this.getLogo_ID());
            return false;
        }
        return true;
    }

    @Override
    public MBPartner markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

