/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.adempiere.base.sso.SSOUtils;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCountry;
import org.compiere.model.MMFARegisteredDevice;
import org.compiere.model.MMFARegistration;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.MTree_Base;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class Login {
    private String loginErrMsg;
    private boolean isPasswordExpired;
    private boolean isSSOLogin = false;
    private static CLogger log = CLogger.getCLogger(Login.class);
    private Properties m_ctx = null;

    public String getLoginErrMsg() {
        return this.loginErrMsg;
    }

    public boolean isPasswordExpired() {
        return this.isPasswordExpired;
    }

    @Deprecated
    public static Properties initTest(boolean isClient) {
        KeyNamePair[] orgs;
        KeyNamePair[] clients;
        Properties ctx;
        Login login;
        KeyNamePair[] roles;
        if (!Adempiere.startupEnvironment(true)) {
            System.exit(1);
        }
        if ((roles = (login = new Login(ctx = Env.getCtx())).getRoles(CConnection.get(), "SuperUser", "System", true)) != null && roles.length > 0 && (clients = login.getClients(roles[0])) != null && clients.length > 0 && (orgs = login.getOrgs(clients[0])) != null && orgs.length > 0) {
            login.getWarehouses(orgs[0]);
            login.loadPreferences(orgs[0], null, null, null);
        }
        Env.setContext(ctx, "#Date", "2000-01-01");
        return ctx;
    }

    public static boolean isJavaOK(boolean isClient) {
        String jVersion = System.getProperty("java.version");
        if (jVersion.startsWith("1.8.0") || jVersion.startsWith("9.") || jVersion.startsWith("10.") || jVersion.startsWith("11.")) {
            return true;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(System.getProperty("java.vm.name")).append(" - ").append(jVersion);
        msg.append("  <>  1.8.0 | 9 | 10 | 11");
        if (isClient) {
            JOptionPane.showMessageDialog(null, msg.toString(), Adempiere.getName() + " - Java Version Check", 0);
        } else {
            log.severe(msg.toString());
        }
        return false;
    }

    public Login(Properties ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Context missing");
        }
        this.m_ctx = ctx;
    }

    @Deprecated(since="2", forRemoval=true)
    protected KeyNamePair[] getRoles(CConnection cc, String app_user, String app_pwd, boolean force) {
        DB.setDBTarget(cc);
        Env.setContext(this.m_ctx, "#Host", cc.getAppsHost());
        Env.setContext(this.m_ctx, "#Database", cc.getDbName());
        Connection conn = DB.getConnectionRO();
        if (conn == null) {
            log.saveError("NoDatabase", "");
            return null;
        }
        try {
            conn.close();
        }
        catch (SQLException sQLException) {}
        if (app_pwd == null) {
            return null;
        }
        return this.getRoles(app_user, app_pwd, force);
    }

    @Deprecated(since="2", forRemoval=true)
    public KeyNamePair[] getRoles(Principal app_user) {
        if (app_user == null) {
            return null;
        }
        return this.getRoles(app_user.getName(), null, false);
    }

    @Deprecated(since="2", forRemoval=true)
    public KeyNamePair[] getRoles(String app_user, String app_pwd) {
        return this.getRoles(app_user, app_pwd, false);
    }

    @Deprecated(since="2", forRemoval=true)
    private KeyNamePair[] getRoles(String app_user, String app_pwd, boolean force) {
        MUser user;
        StringBuilder sql;
        String userNameCol;
        ArrayList<KeyNamePair> list;
        KeyNamePair[] retValue;
        boolean hash_password;
        boolean authenticated;
        block30: {
            if (log.isLoggable(Level.INFO)) {
                log.info("User=" + app_user);
            }
            if (app_user == null) {
                log.warning("No Apps User");
                return null;
            }
            authenticated = false;
            MSystem system = MSystem.get(this.m_ctx);
            if (system == null) {
                throw new IllegalStateException("No System Info");
            }
            if (app_pwd == null || app_pwd.length() == 0) {
                log.warning("No Apps Password");
                return null;
            }
            if (system.isLDAP() && (authenticated = system.isLDAP(app_user, app_pwd))) {
                app_pwd = null;
            }
            hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
            retValue = null;
            list = new ArrayList<KeyNamePair>();
            boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
            userNameCol = email_login ? "AD_User.EMail" : "COALESCE(AD_User.LDAPUser,AD_User.Name)";
            if (hash_password) {
                String where = " " + userNameCol + " = ? AND EXISTS (SELECT * FROM AD_User_Roles ur         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND  EXISTS (SELECT * FROM AD_Client c         WHERE c.AD_Client_ID=AD_User.AD_Client_ID         AND c.IsActive='Y') AND  AD_User.IsActive='Y'";
                MUser user2 = (MUser)MTable.get(this.m_ctx, 114).createQuery(where, null).setParameters(app_user).firstOnly();
                if (user2 == null) {
                    user2 = MUser.get(this.m_ctx, 0);
                }
                if ((!system.isLDAP() || Util.isEmpty(user2.getLDAPUser())) && user2.authenticateHash(app_pwd)) {
                    authenticated = true;
                }
            } else {
                sql = new StringBuilder("SELECT AD_User.AD_User_ID ").append(" FROM AD_User ");
                sql.append(" WHERE ").append(userNameCol).append("=?");
                sql.append(" AND AD_User.IsActive='Y'").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE AD_User.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
                CPreparedStatement pstmt1 = null;
                ResultSet rs1 = null;
                try {
                    try {
                        pstmt1 = DB.prepareStatement(sql.toString(), null);
                        pstmt1.setString(1, app_user);
                        rs1 = pstmt1.executeQuery();
                        while (rs1.next()) {
                            user = new MUser(this.m_ctx, rs1.getInt(1), null);
                            if (system.isLDAP() && !Util.isEmpty(user.getLDAPUser()) || user.getPassword() == null || !user.getPassword().equals(app_pwd)) continue;
                            authenticated = true;
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, sql.toString(), ex);
                        log.saveError("DBLogin", ex);
                        retValue = null;
                        DB.close(rs1, pstmt1);
                        rs1 = null;
                        pstmt1 = null;
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs1, pstmt1);
                    rs1 = null;
                    pstmt1 = null;
                    throw throwable;
                }
                DB.close(rs1, pstmt1);
                rs1 = null;
                pstmt1 = null;
            }
        }
        if (authenticated) {
            ResultSet rs;
            CPreparedStatement pstmt;
            block33: {
                block31: {
                    block32: {
                        sql = new StringBuilder("SELECT AD_User.AD_User_ID, r.AD_Role_ID,r.Name").append(" FROM AD_User ").append(" INNER JOIN AD_User_Roles ur ON (AD_User.AD_User_ID=ur.AD_User_ID AND ur.IsActive='Y')").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive='Y') ");
                        sql.append("WHERE ").append(userNameCol).append("=?");
                        sql.append(" AND AD_User.IsActive='Y'").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE AD_User.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
                        sql.append(" ORDER BY r.Name");
                        pstmt = null;
                        rs = null;
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        pstmt.setString(1, app_user);
                        rs = pstmt.executeQuery();
                        if (rs.next()) break block31;
                        if (!force) break block32;
                        Env.setContext(this.m_ctx, "#AD_User_Name", "SuperUser");
                        Env.setContext(this.m_ctx, "#AD_User_ID", 100);
                        Env.setContext(this.m_ctx, "#AD_User_Description", "SuperUser Forced Login");
                        Env.setContext(this.m_ctx, "#User_Level", "S  ");
                        Env.setContext(this.m_ctx, "#User_Client", "0");
                        Env.setContext(this.m_ctx, "#User_Org", "0");
                        KeyNamePair[] keyNamePairArray = retValue = new KeyNamePair[]{new KeyNamePair(0, "System Administrator")};
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        app_pwd = null;
                        return keyNamePairArray;
                    }
                    log.saveError("UserPwdError", app_user, false);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    app_pwd = null;
                    return null;
                }
                try {
                    try {
                        Env.setContext(this.m_ctx, "#AD_User_Name", app_user);
                        Env.setContext(this.m_ctx, "#AD_User_ID", rs.getInt(1));
                        Env.setContext(this.m_ctx, "#SalesRep_ID", rs.getInt(1));
                        if (Ini.isClient()) {
                            if (MSystem.isSwingRememberUserAllowed()) {
                                Ini.setProperty("ApplicationUserID", app_user);
                            } else {
                                Ini.setProperty("ApplicationUserID", "");
                            }
                            if (Ini.isPropertyBool("StorePassword") && MSystem.isSwingRememberPasswordAllowed()) {
                                Ini.setProperty("ApplicationPassword", app_pwd);
                            }
                        }
                        do {
                            user = new MUser(this.m_ctx, rs.getInt(1), null);
                            boolean valid = false;
                            if (hash_password) {
                                valid = user.authenticateHash(app_pwd);
                            } else {
                                boolean bl = valid = user.getPassword() != null && user.getPassword().equals(app_pwd);
                            }
                            if (!valid) continue;
                            int AD_Role_ID = rs.getInt(2);
                            if (AD_Role_ID == 0) {
                                Env.setContext(this.m_ctx, "#SysAdmin", "Y");
                            }
                            String Name = rs.getString(3);
                            KeyNamePair p2 = new KeyNamePair(AD_Role_ID, Name);
                            list.add(p2);
                        } while (rs.next());
                        retValue = new KeyNamePair[list.size()];
                        list.toArray(retValue);
                        if (!log.isLoggable(Level.FINE)) break block33;
                        log.fine("User=" + app_user + " - roles #" + retValue.length);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, sql.toString(), ex);
                        log.saveError("DBLogin", ex);
                        retValue = null;
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        app_pwd = null;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    app_pwd = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            app_pwd = null;
        }
        return retValue;
    }

    public KeyNamePair[] getClients(KeyNamePair role) {
        ResultSet rs;
        CPreparedStatement pstmt;
        KeyNamePair[] retValue;
        block8: {
            String sql;
            ArrayList<KeyNamePair> list;
            block7: {
                if (role == null) {
                    throw new IllegalArgumentException("Role missing");
                }
                this.loginErrMsg = null;
                this.isPasswordExpired = false;
                list = new ArrayList<KeyNamePair>();
                retValue = null;
                sql = "SELECT DISTINCT r.UserLevel, r.ConnectionProfile,  c.AD_Client_ID,c.Name,r.RoleType,r.IsClientAdministrator FROM AD_Role r INNER JOIN AD_Client c ON (r.AD_Client_ID=c.AD_Client_ID) WHERE r.AD_Role_ID=? AND r.IsActive='Y' AND c.IsActive='Y'";
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, role.getKey());
                rs = pstmt.executeQuery();
                if (rs.next()) break block7;
                log.log(Level.SEVERE, "No Clients for Role: " + role.toStringX());
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
            try {
                try {
                    Env.setContext(this.m_ctx, "#AD_Role_ID", role.getKey());
                    Env.setContext(this.m_ctx, "#AD_Role_Name", role.getName());
                    Env.setContext(this.m_ctx, "#AD_Role_Type", rs.getString("RoleType"));
                    Env.setContext(this.m_ctx, "#IsClientAdmin", rs.getString("IsClientAdministrator"));
                    Ini.setProperty("Role", role.getName());
                    Env.setContext(this.m_ctx, "#User_Level", rs.getString(1));
                    do {
                        int AD_Client_ID = rs.getInt(3);
                        String Name = rs.getString(4);
                        KeyNamePair p2 = new KeyNamePair(AD_Client_ID, Name);
                        list.add(p2);
                    } while (rs.next());
                    retValue = new KeyNamePair[list.size()];
                    list.toArray(retValue);
                    if (!log.isLoggable(Level.FINE)) break block8;
                    log.fine("Role: " + role.toStringX() + " - clients #" + retValue.length);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql, ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public KeyNamePair[] getOrgs(KeyNamePair rol) {
        ResultSet rs;
        CPreparedStatement pstmt;
        KeyNamePair[] retValue;
        int AD_User_ID;
        int AD_Client_ID;
        block12: {
            MRole role;
            String sql;
            ArrayList<KeyNamePair> list;
            block11: {
                if (rol == null) {
                    throw new IllegalArgumentException("Role missing");
                }
                if (Env.getContext(this.m_ctx, "#AD_Client_ID").length() == 0) {
                    throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
                }
                AD_Client_ID = Env.getContextAsInt(this.m_ctx, "#AD_Client_ID");
                AD_User_ID = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
                list = new ArrayList<KeyNamePair>();
                retValue = null;
                sql = " SELECT DISTINCT r.UserLevel, r.ConnectionProfile,o.AD_Org_ID,o.Name,o.IsSummary,r.RoleType,r.IsClientAdministrator  FROM AD_Org o INNER JOIN AD_Role r on (r.AD_Role_ID=?) INNER JOIN AD_Client c on (c.AD_Client_ID=?) WHERE o.IsActive='Y'  AND o.AD_Client_ID IN (0, c.AD_Client_ID) AND (r.IsAccessAllOrgs='Y' OR (r.IsUseUserOrgAccess='N' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ra WHERE ra.AD_Role_ID=r.AD_Role_ID AND ra.IsActive='Y'))  OR (r.IsUseUserOrgAccess='Y' AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_User_OrgAccess ua WHERE ua.AD_User_ID=? AND ua.IsActive='Y'))) ORDER BY o.Name";
                pstmt = null;
                role = null;
                rs = null;
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, rol.getKey());
                pstmt.setInt(2, AD_Client_ID);
                pstmt.setInt(3, AD_User_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) break block11;
                log.log(Level.SEVERE, "No org for Role: " + rol.toStringX());
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
            try {
                try {
                    Env.setContext(this.m_ctx, "#AD_Role_ID", rol.getKey());
                    Env.setContext(this.m_ctx, "#AD_Role_Name", rol.getName());
                    Env.setContext(this.m_ctx, "#AD_Role_Type", rs.getString("RoleType"));
                    Env.setContext(this.m_ctx, "#IsClientAdmin", rs.getString("IsClientAdministrator"));
                    Ini.setProperty("Role", rol.getName());
                    Env.setContext(this.m_ctx, "#User_Level", rs.getString(1));
                    do {
                        int AD_Org_ID = rs.getInt(3);
                        String Name = rs.getString(4);
                        boolean summary = "Y".equals(rs.getString(5));
                        if (summary) {
                            if (role == null) {
                                role = MRole.get(this.m_ctx, rol.getKey());
                            }
                            this.getOrgsAddSummary(list, AD_Org_ID, Name, role);
                            continue;
                        }
                        KeyNamePair p2 = new KeyNamePair(AD_Org_ID, Name);
                        if (list.contains(p2)) continue;
                        list.add(p2);
                    } while (rs.next());
                    retValue = new KeyNamePair[list.size()];
                    list.toArray(retValue);
                    if (!log.isLoggable(Level.FINE)) break block12;
                    log.fine("Client: " + AD_Client_ID + ", AD_Role_ID=" + rol.getName() + ", AD_User_ID=" + AD_User_ID + " - orgs #" + retValue.length);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql, ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue == null || retValue.length == 0) {
            log.log(Level.WARNING, "No Org for Client: " + AD_Client_ID + ", AD_Role_ID=" + rol.getKey() + ", AD_User_ID=" + AD_User_ID);
            return null;
        }
        return retValue;
    }

    private void getOrgsAddSummary(ArrayList<KeyNamePair> list, int Summary_Org_ID, String Summary_Name, MRole role) {
        block10: {
            if (role == null) {
                log.warning("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Role");
                return;
            }
            if (role.getAD_Tree_Org_ID() == 0) {
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Summary Org=" + Summary_Name + "(" + Summary_Org_ID + ") - No Org Tree: " + String.valueOf(role));
                }
                return;
            }
            MTree_Base tree = MTree_Base.get(this.m_ctx, role.getAD_Tree_Org_ID(), null);
            String sql = "SELECT AD_Client_ID, AD_Org_ID, Name, IsSummary FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y') ORDER BY Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, tree.getAD_Tree_ID());
                    pstmt.setInt(2, Summary_Org_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Org_ID = rs.getInt(2);
                        String Name = rs.getString(3);
                        boolean summary = "Y".equals(rs.getString(4));
                        if (summary) {
                            this.getOrgsAddSummary(list, AD_Org_ID, Name, role);
                            continue;
                        }
                        KeyNamePair p2 = new KeyNamePair(AD_Org_ID, Name);
                        if (list.contains(p2)) continue;
                        list.add(p2);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public KeyNamePair[] getWarehouses(KeyNamePair org) {
        ResultSet rs;
        CPreparedStatement pstmt;
        KeyNamePair[] retValue;
        block9: {
            ArrayList<KeyNamePair> list;
            block7: {
                block8: {
                    if (org == null) {
                        throw new IllegalArgumentException("Org missing");
                    }
                    list = new ArrayList<KeyNamePair>();
                    retValue = null;
                    String sql = "SELECT M_Warehouse_ID, Name FROM M_Warehouse WHERE AD_Org_ID=? AND IsActive='Y'  AND IsInTransit='N' ORDER BY Name";
                    pstmt = null;
                    rs = null;
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, org.getKey());
                    rs = pstmt.executeQuery();
                    if (rs.next()) break block7;
                    if (!log.isLoggable(Level.INFO)) break block8;
                    log.info("No Warehouses for Org: " + org.toStringX());
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
            try {
                try {
                    do {
                        int AD_Warehouse_ID = rs.getInt(1);
                        String Name = rs.getString(2);
                        KeyNamePair p2 = new KeyNamePair(AD_Warehouse_ID, Name);
                        list.add(p2);
                    } while (rs.next());
                    retValue = new KeyNamePair[list.size()];
                    list.toArray(retValue);
                    if (!log.isLoggable(Level.FINE)) break block9;
                    log.fine("Org: " + org.toStringX() + " - warehouses #" + retValue.length);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, "getWarehouses", ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public String validateLogin(KeyNamePair org) {
        int AD_Client_ID = Env.getAD_Client_ID(this.m_ctx);
        int AD_Org_ID = org.getKey();
        int AD_Role_ID = Env.getAD_Role_ID(this.m_ctx);
        int AD_User_ID = Env.getAD_User_ID(this.m_ctx);
        String error = ModelValidationEngine.get().loginComplete(AD_Client_ID, AD_Org_ID, AD_Role_ID, AD_User_ID);
        if (error != null && error.length() > 0) {
            log.severe("Refused: " + error);
            return error;
        }
        if (!MRole.get(this.m_ctx, AD_Role_ID).isAccessAdvanced()) {
            if (MSysConfig.getBooleanValue("SYSTEM_IN_MAINTENANCE_MODE", false, 0)) {
                return Msg.getMsg(this.m_ctx, "SystemInMaintenance");
            }
            if (AD_Client_ID != 0 && MSysConfig.getBooleanValue("SYSTEM_IN_MAINTENANCE_MODE", false, AD_Client_ID)) {
                return Msg.getMsg(this.m_ctx, "SystemInMaintenance");
            }
        }
        Env.setPredefinedVariables(Env.getCtx(), -1, MRole.getDefault().getPredefinedContextVariables());
        return null;
    }

    public String loadPreferences(KeyNamePair org, KeyNamePair warehouse, Timestamp timestamp, String printerName) {
        String retValue;
        block33: {
            if (log.isLoggable(Level.INFO)) {
                log.info("Org: " + org.toStringX());
            }
            if (this.m_ctx == null || org == null) {
                throw new IllegalArgumentException("Required parameter missing");
            }
            if (Env.getContext(this.m_ctx, "#AD_Client_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_Client_ID");
            }
            if (Env.getContext(this.m_ctx, "#AD_User_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_User_ID");
            }
            if (Env.getContext(this.m_ctx, "#AD_Role_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_Role_ID");
            }
            Env.setContext(this.m_ctx, "#AD_Org_ID", org.getKey());
            Env.setContext(this.m_ctx, "#AD_Org_Name", org.getName());
            Ini.setProperty("Organization", org.getName());
            if (warehouse != null) {
                Env.setContext(this.m_ctx, "#M_Warehouse_ID", warehouse.getKey());
                Ini.setProperty("Warehouse", warehouse.getName());
            } else {
                Env.setContext(this.m_ctx, "#M_Warehouse_ID", "");
                Ini.setProperty("Warehouse", "");
            }
            long today = System.currentTimeMillis();
            if (timestamp != null) {
                today = timestamp.getTime();
            }
            Env.setContext(this.m_ctx, "#Date", new Timestamp(today));
            if (printerName == null) {
                printerName = "";
            }
            Env.setContext(this.m_ctx, "#Printer", printerName);
            Ini.setProperty("Printer", printerName);
            MRole.getDefault(this.m_ctx, false);
            this.loadUserPreferences();
            if (MRole.getDefault(this.m_ctx, false).isShowAcct()) {
                Env.setContext(this.m_ctx, "#ShowAcct", Ini.getProperty("ShowAcct"));
            } else {
                Env.setContext(this.m_ctx, "#ShowAcct", "N");
            }
            Env.setContext(this.m_ctx, "#ShowTrl", Ini.getProperty("ShowTrl"));
            Env.setContext(this.m_ctx, "#ShowAdvanced", MRole.getDefault().isAccessAdvanced());
            retValue = "";
            int AD_Client_ID = Env.getContextAsInt(this.m_ctx, "#AD_Client_ID");
            int AD_Org_ID = org.getKey();
            Env.setContext(this.m_ctx, "#YYYY", "Y");
            Env.setContext(this.m_ctx, "#DeveloperMode", Util.isDeveloperMode() ? "Y" : "N");
            Env.setContext(this.m_ctx, "#StdPrecision", 2);
            String sql = "SELECT * FROM C_AcctSchema a, AD_ClientInfo c WHERE a.C_AcctSchema_ID=c.C_AcctSchema1_ID AND c.AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int C_AcctSchema_ID = 0;
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (!rs.next()) {
                        if (AD_Client_ID != 0) {
                            retValue = "NoValidAcctInfo";
                        }
                    } else {
                        C_AcctSchema_ID = rs.getInt("C_AcctSchema_ID");
                        Env.setContext(this.m_ctx, "$C_AcctSchema_ID", C_AcctSchema_ID);
                        Env.setContext(this.m_ctx, "$C_Currency_ID", rs.getInt("C_Currency_ID"));
                        Env.setContext(this.m_ctx, "$HasAlias", rs.getString("HasAlias"));
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(Env.getCtx(), AD_Client_ID);
                    if (ass != null && ass.length > 1) {
                        MAcctSchema[] mAcctSchemaArray = ass;
                        int n = ass.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MAcctSchema as = mAcctSchemaArray[n2];
                            C_AcctSchema_ID = MClientInfo.get(Env.getCtx(), AD_Client_ID).getC_AcctSchema1_ID();
                            if (as.getAD_OrgOnly_ID() != 0 && !as.isSkipOrg(AD_Org_ID)) {
                                C_AcctSchema_ID = as.getC_AcctSchema_ID();
                                Env.setContext(this.m_ctx, "$C_AcctSchema_ID", C_AcctSchema_ID);
                                Env.setContext(this.m_ctx, "$C_Currency_ID", as.getC_Currency_ID());
                                Env.setContext(this.m_ctx, "$HasAlias", as.isHasAlias());
                                break;
                            }
                            ++n2;
                        }
                    }
                    sql = "SELECT ElementType FROM C_AcctSchema_Element WHERE C_AcctSchema_ID=? AND IsActive='Y'";
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_AcctSchema_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Env.setContext(this.m_ctx, "$Element_" + rs.getString("ElementType"), "Y");
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    sql = "SELECT Attribute, Value, AD_Window_ID, AD_Process_ID, AD_InfoWindow_ID, PreferenceFor FROM AD_Preference WHERE AD_Client_ID IN (0, @#AD_Client_ID@) AND AD_Org_ID IN (0, @#AD_Org_ID@) AND (AD_User_ID IS NULL OR AD_User_ID=0 OR AD_User_ID=@#AD_User_ID@) AND IsActive='Y' ORDER BY Attribute, AD_Client_ID, AD_User_ID DESC, AD_Org_ID";
                    sql = Env.parseContext(this.m_ctx, 0, sql, false);
                    if (sql.length() == 0) {
                        log.log(Level.SEVERE, "loadPreferences - Missing Environment");
                    } else {
                        pstmt = DB.prepareStatement(sql, null);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            int AD_Window_ID = rs.getInt(3);
                            boolean isAllWindow = rs.wasNull();
                            int AD_Process_ID = rs.getInt(4);
                            int AD_InfoWindow_ID = rs.getInt(5);
                            String PreferenceFor = rs.getString(6);
                            Object at = "";
                            if ("W".equals(PreferenceFor)) {
                                at = isAllWindow ? "P|" + rs.getString(1) : "P" + AD_Window_ID + "|" + rs.getString(1);
                            } else if ("P".equals(PreferenceFor)) {
                                at = "P" + AD_Window_ID + "|" + AD_InfoWindow_ID + "|" + AD_Process_ID + "|" + rs.getString(1);
                            } else if ("I".equals(PreferenceFor)) {
                                at = "P" + AD_Window_ID + "|" + AD_InfoWindow_ID + "|" + rs.getString(1);
                            }
                            String va = rs.getString(2);
                            Env.setContext(this.m_ctx, (String)at, va);
                        }
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Default Values ...");
                    }
                    sql = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE c.IsKey='Y' AND t.IsActive='Y' AND t.IsView='N' AND EXISTS (SELECT * FROM AD_Column cc  WHERE ColumnName = 'IsDefault' AND t.AD_Table_ID=cc.AD_Table_ID AND cc.IsActive='Y')";
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.loadDefault(rs.getString(1), rs.getString(2));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "loadPreferences", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block33;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        Env.setContext(this.m_ctx, "#C_Country_ID", MCountry.getDefault().getC_Country_ID());
        ModelValidationEngine.get().afterLoadPreferences(this.m_ctx);
        return retValue;
    }

    public void loadUserPreferences() {
        MUserPreference userPreference = MUserPreference.getUserPreference(Env.getAD_User_ID(this.m_ctx), Env.getAD_Client_ID(this.m_ctx));
        userPreference.fillPreferences();
    }

    private void loadDefault(String TableName, String ColumnName) {
        if (TableName.startsWith("AD_Window") || TableName.startsWith("AD_PrintFormat") || TableName.startsWith("AD_Workflow") || TableName.equals("AD_StorageProvider") || TableName.startsWith("M_Locator")) {
            return;
        }
        String value = null;
        StringBuilder sqlb = new StringBuilder("SELECT ").append(ColumnName).append(" FROM ").append(TableName).append(" WHERE IsDefault='Y' AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ").append(ColumnName);
        String sql = MRole.getDefault(this.m_ctx, false).addAccessSQL(sqlb.toString(), TableName, false, false);
        try {
            value = DB.getSQLValueString(value, sql, new Object[0]);
        }
        catch (DBException e) {
            log.log(Level.SEVERE, TableName + " (" + sql + ")", e);
            return;
        }
        if (value != null && value.length() != 0) {
            if (TableName.equals("C_DocType")) {
                Env.setContext(this.m_ctx, "#C_DocTypeTarget_ID", value);
            } else {
                Env.setContext(this.m_ctx, "#" + ColumnName, value);
            }
        }
    }

    public boolean batchLogin(Timestamp loginDate) {
        KeyNamePair pair;
        String uid = Ini.getProperty("ApplicationUserID");
        String pwd = Ini.getProperty("ApplicationPassword");
        String client = Ini.getProperty("Client");
        KeyNamePair[] clients = this.getClients(uid, pwd);
        if (clients == null || clients.length == 0) {
            log.severe("User/Password invalid: " + uid);
            return false;
        }
        KeyNamePair clientPP = null;
        KeyNamePair[] keyNamePairArray = clients;
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            pair = keyNamePairArray[n2];
            if (pair.getName().equalsIgnoreCase(client)) {
                clientPP = pair;
                break;
            }
            ++n2;
        }
        if (clientPP == null) {
            log.severe("Client invalid: " + client);
            if (log.isLoggable(Level.INFO)) {
                keyNamePairArray = clients;
                n = clients.length;
                n2 = 0;
                while (n2 < n) {
                    pair = keyNamePairArray[n2];
                    log.info("Option: " + String.valueOf(pair));
                    ++n2;
                }
            }
            return false;
        }
        KeyNamePair[] roles = this.getRoles(uid, clientPP);
        if (roles == null || roles.length == 0) {
            log.severe("No Roles for client: " + client);
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("User: " + uid);
        }
        String role = Ini.getProperty("Role");
        KeyNamePair rolePP = null;
        KeyNamePair[] keyNamePairArray2 = roles;
        int n3 = roles.length;
        int n4 = 0;
        while (n4 < n3) {
            KeyNamePair pair2 = keyNamePairArray2[n4];
            if (pair2.getName().equalsIgnoreCase(role)) {
                rolePP = pair2;
                break;
            }
            ++n4;
        }
        if (rolePP == null) {
            log.severe("Role invalid: " + role);
            if (log.isLoggable(Level.INFO)) {
                int i2 = 0;
                while (i2 < roles.length) {
                    log.info("Option: " + String.valueOf(roles[i2]));
                    ++i2;
                }
            }
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Role: " + role);
        }
        String org = Ini.getProperty("Organization");
        KeyNamePair[] orgs = this.getOrgs(rolePP);
        if (orgs == null || orgs.length == 0) {
            log.severe("No Orgs for Role: " + role);
            return false;
        }
        KeyNamePair orgPP = null;
        KeyNamePair[] keyNamePairArray3 = orgs;
        int n5 = orgs.length;
        int n6 = 0;
        while (n6 < n5) {
            KeyNamePair pair3 = keyNamePairArray3[n6];
            if (pair3.getName().equalsIgnoreCase(org)) {
                orgPP = pair3;
                break;
            }
            ++n6;
        }
        if (orgPP == null) {
            log.severe("Org invalid: " + org);
            if (log.isLoggable(Level.INFO)) {
                int i3 = 0;
                while (i3 < orgs.length) {
                    log.info("Option: " + String.valueOf(orgs[i3]));
                    ++i3;
                }
            }
            return false;
        }
        String wh = Ini.getProperty("Warehouse");
        KeyNamePair whPP = null;
        if (orgPP.getKey() != 0) {
            KeyNamePair[] whs = this.getWarehouses(orgPP);
            if (whs == null || whs.length == 0) {
                log.severe("No Warehouses for Org: " + org);
                return false;
            }
            int i4 = 0;
            while (i4 < whs.length) {
                KeyNamePair pair4 = whs[i4];
                if (pair4.getName().equalsIgnoreCase(wh)) {
                    whPP = pair4;
                    break;
                }
                ++i4;
            }
            if (whPP == null) {
                log.severe("Warehouse invalid: " + wh);
                if (log.isLoggable(Level.INFO)) {
                    i4 = 0;
                    while (i4 < whs.length) {
                        log.info("Option: " + String.valueOf(whs[i4]));
                        ++i4;
                    }
                }
                return false;
            }
        }
        String langName = Ini.getProperty("Language");
        Language language = Language.getLanguage(langName);
        Language.setLoginLanguage(language);
        Env.verifyLanguage(this.m_ctx, language);
        Env.setContext(this.m_ctx, "#AD_Language", language.getAD_Language());
        Locale loc = language.getLocale();
        Locale.setDefault(loc);
        Msg.getMsg(this.m_ctx, "0");
        String printerName = Ini.getProperty("Printer");
        if (loginDate == null) {
            loginDate = new Timestamp(System.currentTimeMillis());
        }
        this.loadPreferences(orgPP, whPP, loginDate, printerName);
        String error = this.validateLogin(orgPP);
        if (error != null && error.length() > 0) {
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("complete");
        }
        return true;
    }

    public boolean batchLogin() {
        return this.batchLogin(new Timestamp(System.currentTimeMillis()));
    }

    @Deprecated
    public Principal getPrincipal() {
        return null;
    }

    public KeyNamePair[] getClients(String app_user, String app_pwd) {
        return this.getClients(app_user, app_pwd, null);
    }

    public KeyNamePair[] getClients(String app_user, String app_pwd, String roleTypes) {
        return this.getClients(app_user, app_pwd, roleTypes, null);
    }

    public KeyNamePair[] getClients(String app_user, String app_pwd, String roleTypes, Object token) {
        if (log.isLoggable(Level.INFO)) {
            log.info("User=" + app_user);
        }
        if (Util.isEmpty(app_user)) {
            log.warning("No Apps User");
            return null;
        }
        boolean authenticated = false;
        try {
            this.isSSOLogin = token != null && SSOUtils.getSSOPrincipalService() != null && SSOUtils.getSSOPrincipalService().getUserName(token).equalsIgnoreCase(app_user);
        }
        catch (ParseException e) {
            log.warning("Parsing failed: " + e.getLocalizedMessage());
            this.isSSOLogin = false;
        }
        MSystem system = MSystem.get(this.m_ctx);
        if (system == null) {
            throw new IllegalStateException("No System Info");
        }
        if (!(this.isSSOLogin || app_pwd != null && app_pwd.length() != 0)) {
            log.warning("No Apps Password");
            return null;
        }
        this.loginErrMsg = null;
        this.isPasswordExpired = false;
        if (!this.isSSOLogin && system.isLDAP() && (authenticated = system.isLDAP(app_user, app_pwd))) {
            app_pwd = null;
        }
        MClient client = null;
        if (MSystem.isUseLoginPrefix()) {
            boolean hasTenant;
            String app_tenant = Login.getAppTenant(app_user);
            app_user = Login.getAppUser(app_user);
            boolean bl = hasTenant = !Util.isEmpty(app_tenant, true);
            if (MSystem.isLoginPrefixMandatory() && !hasTenant) {
                this.loginErrMsg = Msg.getMsg(this.m_ctx, "MissingLoginTenant");
                return null;
            }
            if (Util.isEmpty(app_user, true)) {
                this.loginErrMsg = Msg.getMsg(this.m_ctx, "MissingLoginUser");
                return null;
            }
            if (hasTenant && (client = MClient.getByLoginPrefix(app_tenant)) == null) {
                this.loginErrMsg = Msg.getMsg(this.m_ctx, "FailedLogin");
                return null;
            }
        }
        boolean hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
        boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
        KeyNamePair[] retValue = null;
        ArrayList<KeyNamePair> clientList = new ArrayList<KeyNamePair>();
        ArrayList<Integer> clientsValidated = new ArrayList<Integer>();
        StringBuilder where = new StringBuilder("Password IS NOT NULL AND ");
        if (email_login) {
            where.append("EMail=?");
        } else {
            where.append("COALESCE(LDAPUser,Name)=?");
        }
        boolean isSSOEnable = MSysConfig.getBooleanValue("ENABLE_SSO", false);
        ISSOPrincipalService ssoPrincipal = SSOUtils.getSSOPrincipalService();
        where.append("\tAND EXISTS (SELECT * FROM AD_User u ").append("\tINNER JOIN\tAD_Client c ON (u.AD_Client_ID = c.AD_Client_ID)\t").append("\tWHERE (COALESCE(u.AuthenticationType, c.AuthenticationType) IN ");
        where.append(isSSOEnable && ssoPrincipal != null && this.isSSOLogin ? " ('SSO', 'AAS') " : " ('APO', 'AAS') ");
        where.append("\tOR COALESCE(u.AuthenticationType, c.AuthenticationType) IS NULL) AND u.AD_User_ID = AD_User.AD_User_ID) ");
        String whereRoleType = MRole.getWhereRoleType(roleTypes, "r");
        where.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y'");
        if (!Util.isEmpty(whereRoleType)) {
            where.append(" AND ").append(whereRoleType);
        }
        where.append(") AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'");
        if (client != null) {
            where.append(" AND AD_Client_ID IN (0,").append(client.getAD_Client_ID()).append(")");
        }
        List users = null;
        try {
            PO.setCrossTenantSafe();
            users = new Query(this.m_ctx, "AD_User", where.toString(), null).setParameters(app_user).setOrderBy("AD_User_ID").list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        if (users.size() == 0) {
            log.saveError(this.isSSOLogin ? "UserNotFoundError" : "UserPwdError", app_user, false);
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, users.size() + " matched user found for :" + app_user);
        }
        int MAX_ACCOUNT_LOCK_MINUTES = MSysConfig.getIntValue("USER_LOCKING_MAX_ACCOUNT_LOCK_MINUTES", 0);
        int MAX_INACTIVE_PERIOD_DAY = MSysConfig.getIntValue("USER_LOCKING_MAX_INACTIVE_PERIOD_DAY", 0);
        int MAX_PASSWORD_AGE = MSysConfig.getIntValue("USER_LOCKING_MAX_PASSWORD_AGE_DAY", 0);
        long now = new Date().getTime();
        ArrayList<MUser> usersAuthenticated = new ArrayList<MUser>();
        boolean validButLocked = false;
        for (MUser user : users) {
            if (clientsValidated.contains(user.getAD_Client_ID())) {
                log.severe("Two users with password with the same name/email combination on same tenant: " + app_user);
                return null;
            }
            clientsValidated.add(user.getAD_Client_ID());
            boolean valid = false;
            if (authenticated || this.isSSOLogin) {
                valid = true;
            } else if (!system.isLDAP() || Util.isEmpty(user.getLDAPUser())) {
                if (hash_password) {
                    valid = user.authenticateHash(app_pwd);
                } else {
                    boolean bl = valid = user.getPassword() != null && user.getPassword().equals(app_pwd);
                }
            }
            if (!valid) continue;
            usersAuthenticated.add(user);
            if (user.isLocked()) {
                validButLocked = true;
                continue;
            }
            if (!authenticated) {
                if (user.isExpired()) {
                    this.isPasswordExpired = true;
                } else if (MAX_PASSWORD_AGE > 0 && !user.isNoPasswordReset()) {
                    long days;
                    if (user.getDatePasswordChanged() == null) {
                        user.setDatePasswordChanged(new Timestamp(now));
                    }
                    if ((days = (now - user.getDatePasswordChanged().getTime()) / 86400000L) > (long)MAX_PASSWORD_AGE) {
                        user.setIsExpired(true);
                        this.isPasswordExpired = true;
                    }
                }
            }
            StringBuilder sql = new StringBuilder("SELECT  DISTINCT cli.AD_Client_ID, cli.Name, u.AD_User_ID, u.Name").append(" FROM AD_User_Roles ur").append(" INNER JOIN AD_Role r on (ur.AD_Role_ID=r.AD_Role_ID)").append(" INNER JOIN AD_User u on (ur.AD_User_ID=u.AD_User_ID)").append(" INNER JOIN AD_Client cli on (ur.AD_Client_ID=cli.AD_Client_ID)").append(" WHERE ur.IsActive='Y'").append(" AND u.IsActive='Y'").append(" AND cli.IsActive='Y'");
            if (client != null) {
                sql.append(" AND r.AD_Client_ID=").append(client.getAD_Client_ID());
            }
            if (!Util.isEmpty(whereRoleType)) {
                sql.append(" AND ").append(whereRoleType);
            }
            sql.append(" AND  cli.AuthenticationType IN ").append(isSSOEnable && ssoPrincipal != null && this.isSSOLogin ? " ('SSO', 'AAS') " : " ('APO', 'AAS') ");
            sql.append(" AND ur.AD_User_ID=? ORDER BY cli.Name");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, user.getAD_User_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next() && rs != null) {
                        int AD_Client_ID = rs.getInt(1);
                        String Name = rs.getString(2);
                        KeyNamePair p2 = new KeyNamePair(AD_Client_ID, Name);
                        clientList.add(p2);
                    }
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql.toString(), ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    continue;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (clientList.size() > 0) {
            authenticated = true;
        }
        for (MUser user : usersAuthenticated) {
            long days;
            long minutes;
            if (MAX_ACCOUNT_LOCK_MINUTES > 0 && user.isLocked() && user.getDateAccountLocked() != null && (minutes = (now - user.getDateAccountLocked().getTime()) / 60000L) > (long)MAX_ACCOUNT_LOCK_MINUTES) {
                long days2;
                boolean inactive = false;
                if (MAX_INACTIVE_PERIOD_DAY > 0 && user.getDateLastLogin() != null && !user.isNoExpire() && (days2 = (now - user.getDateLastLogin().getTime()) / 86400000L) > (long)MAX_INACTIVE_PERIOD_DAY) {
                    inactive = true;
                }
                if (!inactive) {
                    user.setIsLocked(false);
                    user.setDateAccountLocked(null);
                    user.setFailedLoginCount(0);
                    Env.setContext(Env.getCtx(), "#AD_Client_ID", user.getAD_Client_ID());
                    if (!user.save()) {
                        log.severe("Failed to unlock user account");
                    }
                }
            }
            if (MAX_INACTIVE_PERIOD_DAY <= 0 || user.isLocked() || user.getDateLastLogin() == null || user.isNoExpire() || (days = (now - user.getDateLastLogin().getTime()) / 86400000L) <= (long)MAX_INACTIVE_PERIOD_DAY) continue;
            user.setIsLocked(true);
            user.setDateAccountLocked(new Timestamp(now));
            Env.setContext(Env.getCtx(), "#AD_Client_ID", user.getAD_Client_ID());
            if (user.save()) continue;
            log.severe("Failed to lock user account");
        }
        if (authenticated) {
            if (usersAuthenticated.size() == 1) {
                Env.setContext(Env.getCtx(), "#AD_User_ID", ((MUser)usersAuthenticated.get(0)).getAD_User_ID());
            }
            if (Ini.isClient()) {
                if (MSystem.isSwingRememberUserAllowed()) {
                    Ini.setProperty("ApplicationUserID", app_user);
                } else {
                    Ini.setProperty("ApplicationUserID", "");
                }
                if (Ini.isPropertyBool("StorePassword") && MSystem.isSwingRememberPasswordAllowed()) {
                    Ini.setProperty("ApplicationPassword", app_pwd);
                }
            }
            retValue = new KeyNamePair[clientList.size()];
            clientList.toArray(retValue);
            if (log.isLoggable(Level.FINE)) {
                log.fine("User=" + app_user + " - roles #" + retValue.length);
            }
            for (MUser user : usersAuthenticated) {
                user.setFailedLoginCount(0);
                user.setDateLastLogin(new Timestamp(now));
                Env.setContext(Env.getCtx(), "#AD_Client_ID", user.getAD_Client_ID());
                if (user.save()) continue;
                log.severe("Failed to update user record with date last login (" + user.getName() + " / clientID = " + user.getAD_Client_ID() + ")");
            }
        } else if (validButLocked) {
            this.loginErrMsg = Msg.getMsg(this.m_ctx, "UserAccountLocked", new Object[]{app_user});
        } else {
            boolean foundLockedAccount = false;
            for (MUser user : usersAuthenticated) {
                if (user.isLocked()) {
                    foundLockedAccount = true;
                    continue;
                }
                int count = user.getFailedLoginCount() + 1;
                boolean reachMaxAttempt = false;
                int MAX_LOGIN_ATTEMPT = MSysConfig.getIntValue("USER_LOCKING_MAX_LOGIN_ATTEMPT", 0);
                if (MAX_LOGIN_ATTEMPT > 0 && count >= MAX_LOGIN_ATTEMPT) {
                    this.loginErrMsg = Msg.getMsg(this.m_ctx, "ReachedMaxLoginAttempts", new Object[]{app_user});
                    reachMaxAttempt = true;
                } else if (MAX_LOGIN_ATTEMPT > 0) {
                    if (count == MAX_LOGIN_ATTEMPT - 1) {
                        this.loginErrMsg = Msg.getMsg(this.m_ctx, "FailedLoginAttempt", new Object[]{count, MAX_LOGIN_ATTEMPT});
                        reachMaxAttempt = false;
                    } else {
                        this.loginErrMsg = Msg.getMsg(this.m_ctx, "FailedLogin", true);
                    }
                } else {
                    reachMaxAttempt = false;
                }
                user.setFailedLoginCount(count);
                user.setIsLocked(reachMaxAttempt);
                user.setDateAccountLocked(user.isLocked() ? new Timestamp(now) : null);
                Env.setContext(Env.getCtx(), "#AD_Client_ID", user.getAD_Client_ID());
                if (user.save()) continue;
                log.severe("Failed to update user record with increase failed login count");
            }
            if (this.loginErrMsg == null && foundLockedAccount) {
                this.loginErrMsg = Msg.getMsg(this.m_ctx, "UserAccountLocked", new Object[]{app_user});
            }
        }
        if (this.isSSOLogin) {
            Env.setContext(Env.getCtx(), "#IsSSOLogin", true);
        } else {
            Env.setContext(Env.getCtx(), "#IsSSOLogin", false);
        }
        return retValue;
    }

    private static String getAppTenant(String app_user) {
        String separator;
        int idxSep;
        String appTenant = null;
        if (MSystem.isUseLoginPrefix() && (idxSep = app_user.indexOf(separator = MSysConfig.getValue("LOGIN_PREFIX_SEPARATOR", "/"))) >= 0) {
            appTenant = app_user.substring(0, idxSep);
        }
        return appTenant;
    }

    public static String getAppUser(String app_user) {
        String separator;
        int idxSep;
        String appUser = app_user;
        if (MSystem.isUseLoginPrefix() && (idxSep = app_user.indexOf(separator = MSysConfig.getValue("LOGIN_PREFIX_SEPARATOR", "/"))) >= 0) {
            appUser = app_user.substring(idxSep + 1);
        }
        return appUser;
    }

    public KeyNamePair[] getRoles(String app_user, KeyNamePair client) {
        return this.getRoles(app_user, client, null);
    }

    public KeyNamePair[] getRoles(String app_user, KeyNamePair client, String roleTypes) {
        ResultSet rs;
        CPreparedStatement pstmt;
        KeyNamePair[] retValue;
        block11: {
            StringBuilder sql;
            ArrayList<KeyNamePair> rolesList;
            block10: {
                if (client == null) {
                    throw new IllegalArgumentException("Tenant missing");
                }
                String whereRoleType = MRole.getWhereRoleType(roleTypes, "r");
                rolesList = new ArrayList<KeyNamePair>();
                retValue = null;
                sql = new StringBuilder("SELECT u.AD_User_ID, r.AD_Role_ID,r.Name ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive='Y')").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive='Y') ");
                sql.append("WHERE u.Password IS NOT NULL AND ur.AD_Client_ID=? AND ");
                boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
                if (email_login) {
                    sql.append("u.EMail=?");
                } else {
                    sql.append("COALESCE(u.LDAPUser,u.Name)=?");
                }
                sql.append(" AND r.IsMasterRole='N'");
                if (!Util.isEmpty(whereRoleType)) {
                    sql.append(" AND ").append(whereRoleType);
                }
                sql.append(" AND u.IsActive='Y' AND EXISTS (SELECT * FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
                sql.append(" AND (");
                sql.append(" (r.isaccessallorgs='Y' OR EXISTS (SELECT 1 FROM AD_Role_OrgAccess ro WHERE ro.AD_Role_ID=r.AD_Role_ID AND ro.IsActive='Y'))");
                sql.append(" OR ");
                sql.append(" (r.isuseuserorgaccess='Y' AND EXISTS (SELECT 1 FROM AD_User_Orgaccess uo WHERE uo.AD_User_ID=u.AD_User_ID AND uo.IsActive='Y')) ");
                sql.append(")");
                sql.append(" ORDER BY r.Name");
                pstmt = null;
                rs = null;
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, client.getKey());
                pstmt.setString(2, Login.getAppUser(app_user));
                rs = pstmt.executeQuery();
                if (rs.next()) break block10;
                log.log(Level.SEVERE, "No Roles for Client: " + client.toStringX());
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
            try {
                try {
                    do {
                        int AD_Role_ID = rs.getInt(2);
                        String Name = rs.getString(3);
                        KeyNamePair p2 = new KeyNamePair(AD_Role_ID, Name);
                        rolesList.add(p2);
                    } while (rs.next());
                    retValue = new KeyNamePair[rolesList.size()];
                    rolesList.toArray(retValue);
                    if (!log.isLoggable(Level.FINE)) break block11;
                    log.fine("Role: " + client.toStringX() + " - clients #" + retValue.length);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql.toString(), ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        Env.setContext(this.m_ctx, "#AD_Client_ID", client.getKey());
        Env.setContext(this.m_ctx, "#AD_Client_Name", client.getName());
        Ini.setProperty("Client", client.getName());
        return retValue;
    }

    public KeyNamePair[] getClients() {
        KeyNamePair[] retValue;
        block7: {
            if (Env.getContext(this.m_ctx, "#AD_User_ID").length() == 0) {
                throw new UnsupportedOperationException("Missing Context #AD_User_ID");
            }
            this.loginErrMsg = null;
            this.isPasswordExpired = false;
            boolean isSSOEnable = MSysConfig.getBooleanValue("ENABLE_SSO", false);
            int AD_User_ID = Env.getContextAsInt(this.m_ctx, "#AD_User_ID");
            retValue = null;
            ArrayList<KeyNamePair> clientList = new ArrayList<KeyNamePair>();
            StringBuilder sql = new StringBuilder("SELECT  DISTINCT cli.AD_Client_ID, cli.Name, u.AD_User_ID, u.Name");
            sql.append(" FROM AD_User_Roles ur").append(" INNER JOIN AD_User u on (ur.AD_User_ID=u.AD_User_ID)").append(" INNER JOIN AD_Client cli on (ur.AD_Client_ID=cli.AD_Client_ID)").append(" WHERE ur.IsActive='Y'").append(" AND cli.IsActive='Y'").append(" AND u.IsActive='Y'").append(" AND u.AD_User_ID=? ").append(" AND cli.AuthenticationType IN ").append(isSSOEnable && SSOUtils.getSSOPrincipalService() != null && this.isSSOLogin ? " ('SSO', 'AAS') " : " ('APO', 'AAS') ").append(" ORDER BY cli.Name");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_User_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next() && rs != null) {
                        int AD_Client_ID = rs.getInt(1);
                        String Name = rs.getString(2);
                        KeyNamePair p2 = new KeyNamePair(AD_Client_ID, Name);
                        clientList.add(p2);
                    }
                    retValue = new KeyNamePair[clientList.size()];
                    clientList.toArray(retValue);
                }
                catch (SQLException ex) {
                    log.log(Level.SEVERE, sql.toString(), ex);
                    retValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public boolean isMFARequired(String registerCookie) {
        if (registerCookie != null && MMFARegisteredDevice.isValid(registerCookie)) {
            return false;
        }
        return MMFARegistration.userHasValidRegistration();
    }
}

