/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.idempiere.expression.logic.LogicEvaluator;

public class Evaluator {
    private static CLogger s_log = CLogger.getCLogger(Evaluator.class);
    private static final Map<String, SQLLogicResult> sqlLogicCache = new ConcurrentHashMap<String, SQLLogicResult>();

    public static boolean isAllVariablesDefined(Evaluatee source, String logic) {
        if (logic == null || logic.length() == 0) {
            return true;
        }
        int pos = 0;
        while (pos < logic.length()) {
            int first = logic.indexOf(64, pos);
            if (first == -1) {
                return true;
            }
            int second = logic.indexOf(64, first + 1);
            if (second == -1) {
                s_log.severe("No second @ in Logic: " + logic);
                return false;
            }
            String variable = logic.substring(first + 1, second - 1);
            String eval = source.get_ValueAsString(variable);
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest(variable + "=" + eval);
            }
            if (eval == null || eval.length() == 0) {
                return false;
            }
            pos = second + 1;
        }
        return true;
    }

    public static boolean evaluateLogic(Evaluatee source, String logic) {
        return LogicEvaluator.evaluateLogic(source, logic);
    }

    public static void parseDepends(ArrayList<String> list, String parseString) {
        if (parseString == null || parseString.length() == 0) {
            return;
        }
        String s = parseString;
        while (s.indexOf(64) != -1) {
            int pos = s.indexOf(64);
            if ((pos = (s = s.substring(pos + 1)).indexOf(64)) == -1) continue;
            String variable = s.substring(0, pos);
            s = s.substring(pos + 1);
            if (variable.startsWith("~")) {
                variable = variable.substring(1);
            }
            if ((variable = variable.replaceFirst("[0-9][0-9]*\\|", "")).indexOf(".") > 0) {
                variable = variable.substring(0, variable.indexOf("."));
            }
            if (variable.indexOf(":") > 0) {
                variable = variable.substring(0, variable.indexOf(":"));
            }
            list.add(variable);
        }
    }

    public static boolean parseSQLLogic(String sqlLogic, Properties ctx, int windowNo, int tabNo, String targetObjectName) {
        String sql = sqlLogic.substring(5);
        boolean reverse = false;
        if (sql.startsWith("!")) {
            reverse = true;
            sql = sql.substring(1);
        }
        if ((sql = Env.parseContext(ctx, windowNo, tabNo, sql, false, false)).equals("")) {
            s_log.log(Level.WARNING, "(" + targetObjectName + ") - SQL variable parse failed: " + sqlLogic);
        } else {
            boolean bl;
            ResultSet rs;
            CPreparedStatement stmt;
            block11: {
                long since;
                SQLLogicResult cache = sqlLogicCache.get(sql);
                if (cache != null && (since = System.currentTimeMillis() - cache.timestamp) <= 500L) {
                    cache.timestamp = System.currentTimeMillis();
                    if (cache.value) {
                        return !reverse;
                    }
                    return reverse;
                }
                stmt = null;
                rs = null;
                stmt = DB.prepareStatement(sql, null);
                rs = stmt.executeQuery();
                boolean hasNext = rs.next();
                if (cache == null) {
                    cache = new SQLLogicResult();
                    sqlLogicCache.put(sql, cache);
                }
                cache.value = hasNext;
                cache.timestamp = System.currentTimeMillis();
                if (!hasNext) break block11;
                boolean bl2 = !reverse;
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                return bl2;
            }
            try {
                bl = reverse;
            }
            catch (SQLException e) {
                try {
                    s_log.log(Level.WARNING, "(" + targetObjectName + ") " + sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            return bl;
        }
        return false;
    }

    public static class SQLLogicResult {
        long timestamp;
        boolean value;
    }
}

