/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.DB;

public class POResultSet<T extends PO>
implements AutoCloseable {
    private String trxName;
    private ResultSet resultSet;
    private MTable table;
    private PreparedStatement statement;
    private T currentPO = null;
    private boolean closeOnError = true;

    public POResultSet(MTable table2, PreparedStatement ps, ResultSet rs, String trxName) {
        this.table = table2;
        this.statement = ps;
        this.resultSet = rs;
        this.trxName = trxName;
        this.closeOnError = false;
    }

    public boolean hasNext() throws DBException {
        if (this.currentPO != null) {
            return true;
        }
        this.currentPO = this.next();
        return this.currentPO != null;
    }

    public T next() throws DBException {
        if (this.currentPO != null) {
            T po = this.currentPO;
            this.currentPO = null;
            return po;
        }
        try {
            if (this.resultSet.next()) {
                return (T)this.table.getPO(this.resultSet, this.trxName);
            }
            this.close();
        }
        catch (SQLException e) {
            if (this.closeOnError) {
                this.close();
            }
            throw new DBException(e);
        }
        catch (RuntimeException e) {
            if (this.closeOnError) {
                this.close();
            }
            throw e;
        }
        return null;
    }

    public void setCloseOnError(boolean closeOnError) {
        this.closeOnError = closeOnError;
    }

    public boolean isCloseOnError() {
        return this.closeOnError;
    }

    @Override
    public void close() {
        DB.close(this.resultSet, this.statement);
        this.resultSet = null;
        this.statement = null;
        this.currentPO = null;
    }
}

