/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MUserDefInfo;
import org.compiere.model.MUserDefProc;
import org.compiere.model.MUserDefWin;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Menu;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MMenu
extends X_AD_Menu
implements ImmutablePOSupport {
    private static final long serialVersionUID = 8157805998814206274L;
    private static ImmutableIntPOCache<Integer, MMenu> s_cache = new ImmutableIntPOCache("AD_Menu", 50);
    private static CLogger s_log = CLogger.getCLogger(MMenu.class);

    public static MMenu get(int AD_Menu_ID) {
        return MMenu.get(Env.getCtx(), AD_Menu_ID);
    }

    public static MMenu get(Properties ctx, int AD_Menu_ID) {
        if (s_cache.containsKey(AD_Menu_ID)) {
            return s_cache.get(ctx, AD_Menu_ID, e -> new MMenu(Env.getCtx(), (MMenu)e));
        }
        MMenu menu = new MMenu(Env.getCtx(), AD_Menu_ID, null);
        if (menu.get_ID() == AD_Menu_ID) {
            s_cache.put(AD_Menu_ID, menu, e -> new MMenu(Env.getCtx(), (MMenu)e));
            return menu;
        }
        return null;
    }

    public MMenu(Properties ctx, MMenu copy) {
        this(ctx, copy, null);
    }

    public MMenu(Properties ctx, MMenu copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Deprecated
    public static MMenu[] get(Properties ctx, String whereClause) {
        return MMenu.get(ctx, whereClause, null);
    }

    public static MMenu[] get(Properties ctx, String whereClause, String trxName) {
        List<MMenu> list = new Query(ctx, "AD_Menu", whereClause, trxName).list();
        MMenu[] retValue = new MMenu[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMenu(Properties ctx, String AD_Menu_UU, String trxName) {
        super(ctx, AD_Menu_UU, trxName);
        if (Util.isEmpty(AD_Menu_UU)) {
            this.setInitialDefaults();
        }
    }

    public MMenu(Properties ctx, int AD_Menu_ID, String trxName) {
        super(ctx, AD_Menu_ID, trxName);
        if (AD_Menu_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEntityType("U");
        this.setIsReadOnly(false);
        this.setIsSOTrx(false);
        this.setIsSummary(false);
    }

    public MMenu(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String action;
        if (this.isSummary() && this.getAction() != null) {
            this.setAction(null);
        }
        if (this.isSummary() && this.isCentrallyMaintained()) {
            this.setIsCentrallyMaintained(false);
        }
        if ((action = this.getAction()) == null) {
            action = "";
        }
        if (this.getAD_Window_ID() != 0 && !action.equals("W")) {
            this.setAD_Window_ID(0);
        }
        if (this.getAD_Form_ID() != 0 && !action.equals("X")) {
            this.setAD_Form_ID(0);
        }
        if (this.getAD_Workflow_ID() != 0 && !action.equals("F")) {
            this.setAD_Workflow_ID(0);
        }
        if (this.getAD_Task_ID() != 0 && !action.equals("T")) {
            this.setAD_Task_ID(0);
        }
        if (this.getAD_Process_ID() != 0 && !action.equals("P") && !action.equals("R")) {
            this.setAD_Process_ID(0);
        }
        if (this.getAD_InfoWindow_ID() != 0 && !action.equals("I")) {
            this.setAD_InfoWindow_ID(0);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            this.insert_Tree("MM");
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.delete_Tree("MM");
        }
        return success;
    }

    public static int getMenu_ID(String menuName) {
        int retValue;
        block6: {
            retValue = 0;
            String SQL = "SELECT AD_Menu_ID FROM AD_Menu WHERE Name = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setString(1, menuName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return retValue;
    }

    @Override
    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    public String getDisplayedName() {
        if (!Util.isEmpty(this.getAction())) {
            MUserDefInfo userDef;
            if ("W".equals(this.getAction())) {
                MUserDefWin userDef2 = MUserDefWin.getBestMatch(this.getCtx(), this.getAD_Window_ID());
                if (userDef2 != null && userDef2.getName() != null) {
                    return userDef2.getName();
                }
            } else if ("P".equals(this.getAction()) || "R".equals(this.getAction())) {
                MUserDefProc userDef3 = MUserDefProc.getBestMatch(this.getCtx(), this.getAD_Process_ID());
                if (userDef3 != null && userDef3.getName() != null) {
                    return userDef3.getName();
                }
            } else if ("I".equals(this.getAction()) && (userDef = MUserDefInfo.getBestMatch(this.getCtx(), this.getAD_InfoWindow_ID())) != null && userDef.getName() != null) {
                return userDef.getName();
            }
        }
        return this.get_Translation("Name");
    }
}

