/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.MCharge;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLandedCost;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MRMALine;
import org.compiere.model.MRole;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MInvoiceLine
extends X_C_InvoiceLine {
    private static final long serialVersionUID = -1590896898028805978L;
    protected static CLogger s_log = CLogger.getCLogger(MInvoiceLine.class);
    protected MTax m_tax = null;
    protected int m_M_PriceList_ID = 0;
    protected Timestamp m_DateInvoiced = null;
    protected int m_C_BPartner_ID = 0;
    protected int m_C_BPartner_Location_ID = 0;
    protected boolean m_IsSOTrx = true;
    protected boolean m_priceSet = false;
    protected MProduct m_product = null;
    protected MCharge m_charge = null;
    protected String m_name = null;
    protected Integer m_precision = null;
    protected IProductPricing m_productPricing = null;
    protected MInvoice m_parent = null;

    public static MInvoiceLine getOfInOutLine(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        List list = new Query(sLine.getCtx(), "C_InvoiceLine", "C_InvoiceLine.M_InOutLine_ID=? AND C_Invoice.Processed='Y'", sLine.get_TrxName()).addJoinClause("JOIN C_Invoice ON (C_Invoice.C_Invoice_ID = C_InvoiceLine.C_Invoice_ID)").setParameters(sLine.getM_InOutLine_ID()).list();
        MInvoiceLine retValue = null;
        if (list.size() > 0) {
            retValue = (MInvoiceLine)list.get(0);
            if (list.size() > 1) {
                s_log.warning("More than one C_InvoiceLine of " + String.valueOf(sLine));
            }
        }
        return retValue;
    }

    public static MInvoiceLine getOfInOutLineFromMatchInv(MInOutLine sLine) {
        if (sLine == null) {
            return null;
        }
        List list = new Query(sLine.getCtx(), "C_InvoiceLine", "C_InvoiceLine_ID IN (SELECT C_InvoiceLine_ID FROM M_MatchInv WHERE M_InOutLine_ID=?)", sLine.get_TrxName()).setParameters(sLine.getM_InOutLine_ID()).list();
        MInvoiceLine retValue = null;
        if (list.size() > 0) {
            retValue = (MInvoiceLine)list.get(0);
            if (list.size() > 1) {
                s_log.warning("More than one C_InvoiceLine of " + String.valueOf(sLine));
            }
        }
        return retValue;
    }

    public MInvoiceLine(Properties ctx, String C_InvoiceLine_UU, String trxName) {
        super(ctx, C_InvoiceLine_UU, trxName);
        if (Util.isEmpty(C_InvoiceLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        this(ctx, C_InvoiceLine_ID, trxName, null);
    }

    public MInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_InvoiceLine_ID, trxName, virtualColumns);
        if (C_InvoiceLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsDescription(false);
        this.setIsPrinted(true);
        this.setLineNetAmt(Env.ZERO);
        this.setPriceEntered(Env.ZERO);
        this.setPriceActual(Env.ZERO);
        this.setPriceLimit(Env.ZERO);
        this.setPriceList(Env.ZERO);
        this.setM_AttributeSetInstance_ID(0);
        this.setTaxAmt(Env.ZERO);
        this.setQtyEntered(Env.ZERO);
        this.setQtyInvoiced(Env.ZERO);
    }

    public MInvoiceLine(MInvoice invoice) {
        this(invoice.getCtx(), 0, invoice.get_TrxName());
        if (invoice.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setInvoice(invoice);
    }

    public MInvoiceLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoiceLine(MInvoiceLine copy) {
        this(Env.getCtx(), copy);
    }

    public MInvoiceLine(Properties ctx, MInvoiceLine copy) {
        this(ctx, copy, null);
    }

    public MInvoiceLine(Properties ctx, MInvoiceLine copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_tax = copy.m_tax != null ? new MTax(ctx, copy.m_tax, trxName) : null;
        this.m_M_PriceList_ID = copy.m_M_PriceList_ID;
        this.m_DateInvoiced = copy.m_DateInvoiced;
        this.m_C_BPartner_ID = copy.m_C_BPartner_ID;
        this.m_C_BPartner_Location_ID = copy.m_C_BPartner_Location_ID;
        this.m_IsSOTrx = copy.m_IsSOTrx;
        this.m_product = copy.m_product != null ? new MProduct(ctx, copy.m_product, trxName) : null;
        this.m_charge = copy.m_charge != null ? new MCharge(ctx, copy.m_charge, trxName) : null;
        this.m_name = copy.m_name;
        this.m_precision = copy.m_precision;
        this.m_parent = null;
        this.m_priceSet = copy.m_priceSet;
    }

    public void setInvoice(MInvoice invoice) {
        this.m_parent = invoice;
        this.m_M_PriceList_ID = invoice.getM_PriceList_ID();
        this.m_DateInvoiced = invoice.getDateInvoiced();
        this.m_C_BPartner_ID = invoice.getC_BPartner_ID();
        this.m_C_BPartner_Location_ID = invoice.getC_BPartner_Location_ID();
        this.m_IsSOTrx = invoice.isSOTrx();
        this.m_precision = invoice.getPrecision();
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setIsDescription(oLine.isDescription());
        this.setDescription(oLine.getDescription());
        if (oLine.getM_Product_ID() == 0) {
            this.setC_Charge_ID(oLine.getC_Charge_ID());
        }
        this.setM_Product_ID(oLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
        this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        this.setPriceEntered(oLine.getPriceEntered());
        this.setPriceActual(oLine.getPriceActual());
        this.setPriceLimit(oLine.getPriceLimit());
        this.setPriceList(oLine.getPriceList());
        this.setC_Tax_ID(oLine.getC_Tax_ID());
        this.setLineNetAmt(oLine.getLineNetAmt());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
        this.setRRAmt(oLine.getRRAmt());
        this.setRRStartDate(oLine.getRRStartDate());
    }

    public void setShipLine(MInOutLine sLine) {
        int C_OrderLine_ID;
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        this.setM_RMALine_ID(sLine.getM_RMALine_ID());
        this.setLine(sLine.getLine());
        this.setIsDescription(sLine.isDescription());
        this.setDescription(sLine.getDescription());
        this.setM_Product_ID(sLine.getM_Product_ID());
        if (sLine.sameOrderLineUOM() || this.getProduct() == null) {
            this.setC_UOM_ID(sLine.getC_UOM_ID());
        } else {
            this.setC_UOM_ID(this.getProduct().getC_UOM_ID());
        }
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        if (this.getM_Product_ID() == 0) {
            this.setC_Charge_ID(sLine.getC_Charge_ID());
        }
        if ((C_OrderLine_ID = sLine.getC_OrderLine_ID()) != 0) {
            MOrderLine oLine = new MOrderLine(this.getCtx(), C_OrderLine_ID, this.get_TrxName());
            this.setS_ResourceAssignment_ID(oLine.getS_ResourceAssignment_ID());
            if (sLine.sameOrderLineUOM()) {
                this.setPriceEntered(oLine.getPriceEntered());
            } else {
                this.setPriceEntered(oLine.getPriceActual());
            }
            this.setPriceActual(oLine.getPriceActual());
            this.setPriceLimit(oLine.getPriceLimit());
            this.setPriceList(oLine.getPriceList());
            this.setC_Tax_ID(oLine.getC_Tax_ID());
            this.setLineNetAmt(oLine.getLineNetAmt());
            this.setC_Project_ID(oLine.getC_Project_ID());
        } else if (sLine.getM_RMALine_ID() != 0) {
            MRMALine rmaLine = new MRMALine(this.getCtx(), sLine.getM_RMALine_ID(), this.get_TrxName());
            this.setPrice();
            this.setPrice(rmaLine.getAmt());
            this.setC_Tax_ID(rmaLine.getC_Tax_ID());
            this.setLineNetAmt(rmaLine.getLineNetAmt());
        } else {
            this.setPrice();
            this.setTax();
        }
        this.setC_Project_ID(sLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(sLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(sLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(sLine.getC_Activity_ID());
        this.setC_Campaign_ID(sLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(sLine.getAD_OrgTrx_ID());
        this.setUser1_ID(sLine.getUser1_ID());
        this.setUser2_ID(sLine.getUser2_ID());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    @Override
    public void setM_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        super.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
    }

    public void setPrice() {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            this.setInvoice(this.getParent());
        }
        if (this.m_M_PriceList_ID == 0 || this.m_C_BPartner_ID == 0) {
            throw new IllegalStateException("setPrice - PriceList unknown!");
        }
        this.setPrice(this.m_M_PriceList_ID, this.m_C_BPartner_ID);
    }

    public void setPrice(int M_PriceList_ID, int C_BPartner_ID) {
        if (this.getM_Product_ID() == 0 || this.isDescription()) {
            return;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("M_PriceList_ID=" + M_PriceList_ID);
        }
        this.m_productPricing = Core.getProductPricing();
        this.m_productPricing.setInvoiceLine(this, this.get_TrxName());
        this.m_productPricing.setM_PriceList_ID(M_PriceList_ID);
        this.setPriceActual(this.m_productPricing.getPriceStd());
        this.setPriceList(this.m_productPricing.getPriceList());
        this.setPriceLimit(this.m_productPricing.getPriceLimit());
        if (this.getQtyEntered().compareTo(this.getQtyInvoiced()) == 0) {
            this.setPriceEntered(this.getPriceActual());
        } else {
            this.setPriceEntered(this.getPriceActual().multiply(this.getQtyInvoiced().divide(this.getQtyEntered(), 6, RoundingMode.HALF_UP)));
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(this.m_productPricing.getC_UOM_ID());
        }
        this.m_priceSet = true;
    }

    public void setPrice(BigDecimal PriceActual) {
        this.setPriceEntered(PriceActual);
        this.setPriceActual(PriceActual);
    }

    @Override
    public void setPriceActual(BigDecimal PriceActual) {
        if (PriceActual == null) {
            throw new IllegalArgumentException("PriceActual is mandatory");
        }
        this.set_ValueNoCheck("PriceActual", PriceActual);
    }

    public boolean setTax() {
        if (this.isDescription()) {
            return true;
        }
        int M_Warehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        String deliveryViaRule = null;
        int dropShipLocationId = -1;
        if (this.getC_OrderLine_ID() > 0) {
            MOrder order = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName()).getParent();
            deliveryViaRule = order.getDeliveryViaRule();
            dropShipLocationId = order.getDropShip_Location_ID();
        } else if (this.getM_InOutLine_ID() > 0) {
            deliveryViaRule = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName()).getParent().getDeliveryViaRule();
        } else if (this.getParent().getC_Order_ID() > 0) {
            deliveryViaRule = new MOrder(this.getCtx(), this.getParent().getC_Order_ID(), this.get_TrxName()).getDeliveryViaRule();
        }
        int C_Tax_ID = Core.getTaxLookup().get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), this.m_DateInvoiced, this.m_DateInvoiced, this.getAD_Org_ID(), M_Warehouse_ID, this.m_C_BPartner_Location_ID, this.m_C_BPartner_Location_ID, dropShipLocationId, this.m_IsSOTrx, deliveryViaRule, this.get_TrxName());
        if (C_Tax_ID == 0) {
            this.log.log(Level.SEVERE, "No Tax found");
            return false;
        }
        this.setC_Tax_ID(C_Tax_ID);
        return true;
    }

    public void setTaxAmt() {
        BigDecimal TaxAmt = Env.ZERO;
        if (this.getC_Tax_ID() == 0) {
            return;
        }
        this.setLineNetAmt();
        MTax tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        if (tax.isDocumentLevel() && this.m_IsSOTrx) {
            return;
        }
        TaxAmt = tax.calculateTax(this.getLineNetAmt(), this.isTaxIncluded(), this.getPrecision());
        if (this.isTaxIncluded()) {
            this.setLineTotalAmt(this.getLineNetAmt());
        } else {
            this.setLineTotalAmt(this.getLineNetAmt().add(TaxAmt));
        }
        super.setTaxAmt(TaxAmt);
    }

    public void setLineNetAmt() {
        BigDecimal bd = this.getPriceEntered().multiply(this.getQtyEntered());
        int precision = this.getPrecision();
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setLineNetAmt(bd);
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.getCopy(this.getCtx(), this.getC_Charge_ID(), this.get_TrxName());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public void setQty(int Qty) {
        this.setQty(new BigDecimal(Qty));
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setQtyInvoiced(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyInvoiced(BigDecimal QtyInvoiced) {
        MProduct product = this.getProduct();
        if (QtyInvoiced != null && product != null) {
            int precision = product.getUOMPrecision();
            QtyInvoiced = QtyInvoiced.setScale(precision, RoundingMode.HALF_UP);
        }
        super.setQtyInvoiced(QtyInvoiced);
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        super.setM_Product_ID(M_Product_ID);
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.getCopy(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInvoiceLine[").append(this.get_ID()).append(",").append(this.getLine()).append(",QtyInvoiced=").append(this.getQtyInvoiced()).append(",LineNetAmt=").append(this.getLineNetAmt()).append("]");
        return sb.toString();
    }

    public String getName() {
        block8: {
            if (this.m_name == null) {
                String sql = "SELECT COALESCE (p.Name, c.Name) FROM C_InvoiceLine il LEFT OUTER JOIN M_Product p ON (il.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge C ON (il.C_Charge_ID=c.C_Charge_ID) WHERE C_InvoiceLine_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getC_InvoiceLine_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_name = rs.getString(1);
                        }
                        if (this.m_name == null) {
                            this.m_name = "??";
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getName", e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                Object var2_2 = null;
            }
        }
        return this.m_name;
    }

    public void setName(String tempName) {
        this.m_name = tempName;
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    public int getPrecision() {
        if (this.m_precision != null) {
            return this.m_precision;
        }
        String sql = "SELECT c.StdPrecision FROM C_Currency c INNER JOIN C_Invoice x ON (x.C_Currency_ID=c.C_Currency_ID) WHERE x.C_Invoice_ID=?";
        int i = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
        if (i < 0) {
            this.log.warning("getPrecision = " + i + " - set to 2");
            i = 2;
        }
        this.m_precision = i;
        return this.m_precision;
    }

    public boolean isTaxIncluded() {
        if (this.m_M_PriceList_ID == 0) {
            this.m_M_PriceList_ID = DB.getSQLValue(this.get_TrxName(), "SELECT M_PriceList_ID FROM C_Invoice WHERE C_Invoice_ID=?", this.getC_Invoice_ID());
        }
        MPriceList pl = MPriceList.get(this.getCtx(), this.m_M_PriceList_ID, this.get_TrxName());
        return pl.isTaxIncluded();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("New=" + newRecord);
        }
        boolean parentComplete = this.getParent().isProcessed();
        boolean isReversal = this.getParent().isReversal();
        if (newRecord && parentComplete) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_Invoice_ID"));
            return false;
        }
        this.setInvoice(this.getParent());
        if (!parentComplete && !isReversal) {
            int C_UOM_ID;
            if (this.getC_Charge_ID() != 0) {
                if (this.getM_Product_ID() != 0) {
                    this.setM_Product_ID(0);
                }
            } else {
                boolean enforce;
                if (!this.m_priceSet && Env.ZERO.compareTo(this.getPriceActual()) == 0 && Env.ZERO.compareTo(this.getPriceList()) == 0) {
                    this.setPrice();
                }
                boolean bl = enforce = this.m_IsSOTrx && this.getParent().getM_PriceList().isEnforcePriceLimit();
                if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
                    enforce = false;
                }
                if (enforce && this.getPriceLimit() != Env.ZERO && this.getPriceActual().compareTo(this.getPriceLimit()) < 0) {
                    this.log.saveError("UnderLimitPrice", "PriceEntered=" + String.valueOf(this.getPriceEntered()) + ", PriceLimit=" + String.valueOf(this.getPriceLimit()));
                    return false;
                }
            }
            if (this.getC_Tax_ID() == 0) {
                this.setTax();
            }
            if (this.getLine() == 0) {
                String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM C_InvoiceLine WHERE C_Invoice_ID=?";
                int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
                this.setLine(ii);
            }
            if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
                this.setC_UOM_ID(C_UOM_ID);
            }
            if (newRecord || this.is_ValueChanged("QtyEntered")) {
                this.setQtyEntered(this.getQtyEntered());
            }
            if (newRecord || this.is_ValueChanged("QtyInvoiced")) {
                this.setQtyInvoiced(this.getQtyInvoiced());
            }
            this.setLineNetAmt();
            if (this.m_IsSOTrx || this.getTaxAmt().compareTo(Env.ZERO) == 0) {
                this.setTaxAmt();
            }
            if (this.getParent().getC_DocTypeTarget().isChargeOrProductMandatory() && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0 && (this.getPriceEntered().signum() != 0 || this.getQtyEntered().signum() != 0)) {
                this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "ChargeOrProductMandatory"));
                return false;
            }
        }
        return true;
    }

    protected boolean updateInvoiceTax(boolean oldTax) {
        boolean isOldTax;
        int C_Tax_ID = this.getC_Tax_ID();
        boolean bl = isOldTax = oldTax && this.is_ValueChanged("C_Tax_ID");
        if (isOldTax) {
            Object old = this.get_ValueOld("C_Tax_ID");
            if (old == null) {
                return true;
            }
            C_Tax_ID = (Integer)old;
        }
        if (C_Tax_ID == 0) {
            return true;
        }
        MTax t = MTax.get(C_Tax_ID);
        if (t.isSummary()) {
            MInvoiceTax[] invoiceTaxes = MInvoiceTax.getChildTaxes(this, this.getPrecision(), oldTax, this.get_TrxName());
            if (invoiceTaxes != null && invoiceTaxes.length > 0) {
                MInvoiceTax[] mInvoiceTaxArray = invoiceTaxes;
                int n = invoiceTaxes.length;
                int n2 = 0;
                while (n2 < n) {
                    MInvoiceTax tax = mInvoiceTaxArray[n2];
                    if (!tax.calculateTaxFromLines()) {
                        return false;
                    }
                    if (!tax.save(this.get_TrxName())) {
                        return false;
                    }
                    ++n2;
                }
            }
        } else {
            MInvoiceTax tax = MInvoiceTax.get(this, this.getPrecision(), oldTax, this.get_TrxName());
            if (tax != null) {
                if (!tax.calculateTaxFromLines()) {
                    return false;
                }
                if (!tax.save(this.get_TrxName())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
        ITaxProvider calculator = Core.getTaxProvider(provider);
        if (calculator == null) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
        }
        return calculator.recalculateTax(provider, this, newRecord);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getM_InOutLine_ID() > 0) {
            MInOutLine sLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            sLine.setIsInvoiced(false);
            sLine.saveEx();
        }
        return this.updateHeaderTax();
    }

    public boolean updateHeaderTax() {
        if (this.isProcessed() && !this.is_ValueChanged("Processed")) {
            return true;
        }
        MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
        ITaxProvider calculator = Core.getTaxProvider(provider);
        if (calculator == null) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
        }
        if (!calculator.updateInvoiceTax(provider, this)) {
            return false;
        }
        return calculator.updateHeaderTax(provider, this);
    }

    public String allocateLandedCosts() {
        MInOutLine iol;
        MLandedCost[] lcs;
        if (this.isProcessed()) {
            return "Processed";
        }
        StringBuilder sql = new StringBuilder("DELETE FROM C_LandedCostAllocation WHERE C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID());
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0 && this.log.isLoggable(Level.INFO)) {
            this.log.info("Deleted #" + no);
        }
        if ((lcs = MLandedCost.getLandedCosts(this)).length == 0) {
            return "";
        }
        int inserted = 0;
        if (lcs.length == 1) {
            MLandedCost lc = lcs[0];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOutLine iol2;
                ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                int i = 0;
                while (i < lines.length) {
                    if (!(lines[i].isDescription() || lines[i].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i].getM_Product_ID())) {
                        list.add(lines[i]);
                    }
                    ++i;
                }
                if (list.size() == 0) {
                    return "No Matching Lines (with Product) in Shipment";
                }
                BigDecimal total = Env.ZERO;
                int i2 = 0;
                while (i2 < list.size()) {
                    iol2 = (MInOutLine)list.get(i2);
                    total = total.add(iol2.getBase(lc.getLandedCostDistribution()));
                    ++i2;
                }
                if (total.signum() == 0) {
                    StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(lc.getLandedCostDistribution());
                    return msgreturn.toString();
                }
                i2 = 0;
                while (i2 < list.size()) {
                    iol2 = (MInOutLine)list.get(i2);
                    MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                    lca.setM_Product_ID(iol2.getM_Product_ID());
                    lca.setM_InOutLine_ID(iol2.getM_InOutLine_ID());
                    lca.setM_AttributeSetInstance_ID(iol2.getM_AttributeSetInstance_ID());
                    BigDecimal base = iol2.getBase(lc.getLandedCostDistribution());
                    lca.setBase(base);
                    lca.setQty(iol2.getMovementQty());
                    if (base.signum() != 0) {
                        double result = this.getLineNetAmt().multiply(base).doubleValue();
                        lca.setAmt(result /= total.doubleValue(), this.getParent().getC_Currency().getStdPrecision());
                    }
                    if (!lca.save()) {
                        StringBuilder msgreturn = new StringBuilder("Cannot save line Allocation = ").append(lca);
                        return msgreturn.toString();
                    }
                    ++inserted;
                    ++i2;
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Inserted " + inserted);
                }
                this.allocateLandedCostRounding();
                return "";
            }
            if (lc.getM_InOutLine_ID() != 0) {
                MInOutLine iol3 = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName());
                if (iol3.isDescription() || iol3.getM_Product_ID() == 0) {
                    StringBuilder msgreturn = new StringBuilder("Invalid Receipt Line - ").append(iol3);
                    return msgreturn.toString();
                }
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(iol3.getM_Product_ID());
                lca.setM_AttributeSetInstance_ID(iol3.getM_AttributeSetInstance_ID());
                lca.setM_InOutLine_ID(iol3.getM_InOutLine_ID());
                BigDecimal base = iol3.getBase(lc.getLandedCostDistribution());
                if (base.signum() == 0) {
                    return "Base value is 0 - " + lc.getLandedCostDistribution();
                }
                lca.setBase(base);
                lca.setAmt(this.getLineNetAmt());
                lca.setQty(iol3.getMovementQty());
                if (lca.save()) {
                    return "";
                }
                StringBuilder msgreturn = new StringBuilder("Cannot save single line Allocation = ").append(lc);
                return msgreturn.toString();
            }
            if (lc.getM_Product_ID() != 0) {
                MLandedCostAllocation lca = new MLandedCostAllocation(this, lc.getM_CostElement_ID());
                lca.setM_Product_ID(lc.getM_Product_ID());
                lca.setAmt(this.getLineNetAmt());
                if (lc.getLandedCostDistribution().equals("C")) {
                    lca.setBase(this.getLineNetAmt());
                    lca.setQty(this.getLineNetAmt());
                } else {
                    lca.setBase(this.getQtyInvoiced());
                    lca.setQty(this.getQtyInvoiced());
                }
                if (lca.save()) {
                    return "";
                }
                StringBuilder msgreturn = new StringBuilder("Cannot save Product Allocation = ").append(lc);
                return msgreturn.toString();
            }
            StringBuilder msgreturn = new StringBuilder("No Reference for ").append(lc);
            return msgreturn.toString();
        }
        String LandedCostDistribution = lcs[0].getLandedCostDistribution();
        int M_CostElement_ID = lcs[0].getM_CostElement_ID();
        int i = 0;
        while (i < lcs.length) {
            MLandedCost lc = lcs[i];
            if (!LandedCostDistribution.equals(lc.getLandedCostDistribution())) {
                return "Multiple Landed Cost Rules must have consistent Landed Cost Distribution";
            }
            if (lc.getM_Product_ID() != 0 && lc.getM_InOut_ID() == 0 && lc.getM_InOutLine_ID() == 0) {
                return "Multiple Landed Cost Rules cannot directly allocate to a Product";
            }
            if (M_CostElement_ID != lc.getM_CostElement_ID()) {
                return "Multiple Landed Cost Rules cannot different Cost Elements";
            }
            ++i;
        }
        ArrayList<MInOutLine> list = new ArrayList<MInOutLine>();
        int ii = 0;
        while (ii < lcs.length) {
            MLandedCost lc = lcs[ii];
            if (lc.getM_InOut_ID() != 0 && lc.getM_InOutLine_ID() == 0) {
                MInOut ship = new MInOut(this.getCtx(), lc.getM_InOut_ID(), this.get_TrxName());
                MInOutLine[] lines = ship.getLines();
                int i3 = 0;
                while (i3 < lines.length) {
                    if (!(lines[i3].isDescription() || lines[i3].getM_Product_ID() == 0 || lc.getM_Product_ID() != 0 && lc.getM_Product_ID() != lines[i3].getM_Product_ID())) {
                        list.add(lines[i3]);
                    }
                    ++i3;
                }
            } else if (lc.getM_InOutLine_ID() != 0 && !(iol = new MInOutLine(this.getCtx(), lc.getM_InOutLine_ID(), this.get_TrxName())).isDescription() && iol.getM_Product_ID() != 0) {
                list.add(iol);
            }
            ++ii;
        }
        if (list.size() == 0) {
            return "No Matching Lines (with Product)";
        }
        BigDecimal total = Env.ZERO;
        int i4 = 0;
        while (i4 < list.size()) {
            iol = (MInOutLine)list.get(i4);
            total = total.add(iol.getBase(LandedCostDistribution));
            ++i4;
        }
        if (total.signum() == 0) {
            StringBuilder msgreturn = new StringBuilder("Total of Base values is 0 - ").append(LandedCostDistribution);
            return msgreturn.toString();
        }
        i4 = 0;
        while (i4 < list.size()) {
            iol = (MInOutLine)list.get(i4);
            MLandedCostAllocation lca = new MLandedCostAllocation(this, lcs[0].getM_CostElement_ID());
            lca.setM_Product_ID(iol.getM_Product_ID());
            lca.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            lca.setM_InOutLine_ID(iol.getM_InOutLine_ID());
            BigDecimal base = iol.getBase(LandedCostDistribution);
            lca.setBase(base);
            lca.setQty(iol.getMovementQty());
            if (base.signum() != 0) {
                double result = this.getLineNetAmt().multiply(base).doubleValue();
                lca.setAmt(result /= total.doubleValue(), this.getParent().getC_Currency().getStdPrecision());
            }
            if (!lca.save()) {
                StringBuilder msgreturn = new StringBuilder("Cannot save line Allocation = ").append(lca);
                return msgreturn.toString();
            }
            ++inserted;
            ++i4;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Inserted " + inserted);
        }
        this.allocateLandedCostRounding();
        return "";
    }

    protected void allocateLandedCostRounding() {
        MLandedCostAllocation[] allocations = MLandedCostAllocation.getOfInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        MLandedCostAllocation largestAmtAllocation = null;
        BigDecimal allocationAmt = Env.ZERO;
        int i = 0;
        while (i < allocations.length) {
            MLandedCostAllocation allocation = allocations[i];
            if (largestAmtAllocation == null || allocation.getAmt().compareTo(largestAmtAllocation.getAmt()) > 0) {
                largestAmtAllocation = allocation;
            }
            allocationAmt = allocationAmt.add(allocation.getAmt());
            ++i;
        }
        BigDecimal difference = this.getLineNetAmt().subtract(allocationAmt);
        if (difference.signum() != 0) {
            largestAmtAllocation.setAmt(largestAmtAllocation.getAmt().add(difference));
            largestAmtAllocation.saveEx();
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Difference=" + String.valueOf(difference) + ", C_LandedCostAllocation_ID=" + largestAmtAllocation.getC_LandedCostAllocation_ID() + ", Amt" + String.valueOf(largestAmtAllocation.getAmt()));
            }
        }
    }

    public MLandedCost[] getLandedCost(String whereClause) {
        ArrayList<MLandedCost> list;
        block7: {
            list = new ArrayList<MLandedCost>();
            Object sql = "SELECT * FROM C_LandedCost WHERE C_InvoiceLine_ID=? ";
            if (whereClause != null) {
                sql = (String)sql + whereClause;
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_InvoiceLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MLandedCost lc = new MLandedCost(this.getCtx(), rs, this.get_TrxName());
                        list.add(lc);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "getLandedCost", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MLandedCost[] landedCost = new MLandedCost[list.size()];
        list.toArray(landedCost);
        return landedCost;
    }

    public int copyLandedCostFrom(MInvoiceLine otherInvoiceLine) {
        if (otherInvoiceLine == null) {
            return 0;
        }
        MLandedCost[] fromLandedCosts = otherInvoiceLine.getLandedCost(null);
        int count = 0;
        int i = 0;
        while (i < fromLandedCosts.length) {
            MLandedCost landedCost = new MLandedCost(this.getCtx(), 0, this.get_TrxName());
            MLandedCost fromLandedCost = fromLandedCosts[i];
            PO.copyValues(fromLandedCost, landedCost, fromLandedCost.getAD_Client_ID(), fromLandedCost.getAD_Org_ID());
            landedCost.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
            landedCost.set_ValueNoCheck("C_LandedCost_ID", I_ZERO);
            if (landedCost.save(this.get_TrxName())) {
                ++count;
            }
            ++i;
        }
        if (fromLandedCosts.length != count) {
            this.log.log(Level.SEVERE, "LandedCost difference - From=" + fromLandedCosts.length + " <> Saved=" + count);
        }
        return count;
    }

    public void setRMALine(MRMALine rmaLine) {
        if (!this.getParent().isCreditMemo()) {
            throw new AdempiereException("InvoiceNotCreditMemo");
        }
        this.setAD_Org_ID(rmaLine.getAD_Org_ID());
        this.setM_RMALine_ID(rmaLine.getM_RMALine_ID());
        this.setDescription(rmaLine.getDescription());
        this.setLine(rmaLine.getLine());
        this.setC_Charge_ID(rmaLine.getC_Charge_ID());
        this.setM_Product_ID(rmaLine.getM_Product_ID());
        this.setC_UOM_ID(rmaLine.getC_UOM_ID());
        this.setC_Tax_ID(rmaLine.getC_Tax_ID());
        this.setPrice(rmaLine.getAmt());
        BigDecimal qty = rmaLine.getQty();
        if (rmaLine.getQtyInvoiced() != null) {
            qty = qty.subtract(rmaLine.getQtyInvoiced());
        }
        this.setQty(qty);
        this.setLineNetAmt();
        this.setTaxAmt();
        this.setLineTotalAmt(rmaLine.getLineNetAmt());
        this.setC_Project_ID(rmaLine.getC_Project_ID());
        this.setC_Activity_ID(rmaLine.getC_Activity_ID());
        this.setC_Campaign_ID(rmaLine.getC_Campaign_ID());
    }

    public BigDecimal getMatchedQty() {
        String sql = "SELECT COALESCE(SUM(Qty),0) FROM M_MatchInv WHERE C_InvoiceLine_ID=? AND Processed=?";
        return DB.getSQLValueBDEx(this.get_TrxName(), sql, this.getC_InvoiceLine_ID(), true);
    }

    public void clearParent() {
        this.m_parent = null;
    }
}

