/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.compiere.model.MatchPOAutoMatch;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class Doc_MatchPO
extends Doc {
    private int m_C_OrderLine_ID = 0;
    private MOrderLine m_oLine = null;
    private int m_M_InOutLine_ID = 0;
    private MInOutLine m_ioLine = null;
    private int m_C_InvoiceLine_ID = 0;
    private ProductCost m_pc;
    private int m_M_AttributeSetInstance_ID = 0;
    private MMatchPO m_matchPO;
    private boolean m_deferPosting = false;

    public Doc_MatchPO(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MMatchPO.class, rs, "MXP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.m_matchPO = (MMatchPO)this.getPO();
        this.setDateDoc(this.m_matchPO.getDateTrx());
        this.m_M_AttributeSetInstance_ID = this.m_matchPO.getM_AttributeSetInstance_ID();
        this.setQty(this.m_matchPO.getQty());
        this.m_C_OrderLine_ID = this.m_matchPO.getC_OrderLine_ID();
        this.m_oLine = new MOrderLine(this.getCtx(), this.m_C_OrderLine_ID, this.getTrxName());
        this.m_M_InOutLine_ID = this.m_matchPO.getM_InOutLine_ID();
        this.m_ioLine = new MInOutLine(this.getCtx(), this.m_M_InOutLine_ID, this.getTrxName());
        this.m_C_InvoiceLine_ID = this.m_matchPO.getC_InvoiceLine_ID();
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.m_M_AttributeSetInstance_ID, this.getTrxName());
        this.m_pc.setQty(this.getQty());
        if (this.m_M_InOutLine_ID == 0) {
            ArrayList<MMatchPO> noInvoiceLines = new ArrayList<MMatchPO>();
            HashMap<Integer, BigDecimal[]> noShipmentLines = new HashMap<Integer, BigDecimal[]>();
            HashMap<Integer, BigDecimal[]> postedNoShipmentLines = new HashMap<Integer, BigDecimal[]>();
            List<MMatchPO> matchPOs = MatchPOAutoMatch.getNotMatchedMatchPOList(this.getCtx(), this.m_oLine.getC_OrderLine_ID(), this.getTrxName());
            for (MMatchPO matchPO : matchPOs) {
                String docStatus;
                if (matchPO.getM_InOutLine_ID() > 0 && matchPO.getC_InvoiceLine_ID() == 0 && matchPO.getReversal_ID() == 0) {
                    docStatus = matchPO.getM_InOutLine().getM_InOut().getDocStatus();
                    if (!docStatus.equals("CO") && !docStatus.equals("CL")) continue;
                    noInvoiceLines.add(matchPO);
                    continue;
                }
                if (matchPO.getM_InOutLine_ID() != 0 || matchPO.getReversal_ID() != 0 || !(docStatus = matchPO.getC_InvoiceLine().getC_Invoice().getDocStatus()).equals("CO") && !docStatus.equals("CL")) continue;
                if (matchPO.isPosted()) {
                    postedNoShipmentLines.put(matchPO.getM_MatchPO_ID(), new BigDecimal[]{matchPO.getQty()});
                    continue;
                }
                noShipmentLines.put(matchPO.getM_MatchPO_ID(), new BigDecimal[]{matchPO.getQty()});
            }
            for (MMatchPO matchPO : noInvoiceLines) {
                BigDecimal[] qtyHolder;
                BigDecimal qty = matchPO.getQty();
                for (Integer matchPOId : postedNoShipmentLines.keySet()) {
                    qtyHolder = (BigDecimal[])postedNoShipmentLines.get(matchPOId);
                    if (qtyHolder[0].compareTo(qty) >= 0) {
                        qtyHolder[0] = qtyHolder[0].subtract(qty);
                        qty = BigDecimal.ZERO;
                    } else if (qtyHolder[0].signum() > 0) {
                        qty = qty.subtract(qtyHolder[0]);
                        qtyHolder[0] = BigDecimal.ZERO;
                    }
                    if (qty.signum() == 0) break;
                }
                if (qty.signum() == 0) continue;
                for (Integer matchPOId : noShipmentLines.keySet()) {
                    qtyHolder = (BigDecimal[])noShipmentLines.get(matchPOId);
                    if (qtyHolder[0].compareTo(qty) >= 0) {
                        qtyHolder[0] = qtyHolder[0].subtract(qty);
                        qty = BigDecimal.ZERO;
                    } else if (qtyHolder[0].signum() > 0) {
                        qty = qty.subtract(qtyHolder[0]);
                        qtyHolder[0] = BigDecimal.ZERO;
                    }
                    if (qtyHolder[0].signum() == 0 && matchPOId.intValue() == this.m_matchPO.getM_MatchPO_ID()) {
                        this.m_M_InOutLine_ID = matchPO.getM_InOutLine_ID();
                        break;
                    }
                    if (qty.signum() == 0) break;
                }
                if (this.m_M_InOutLine_ID > 0) break;
            }
        }
        if (this.m_M_InOutLine_ID == 0) {
            if (this.m_matchPO.getRef_MatchPO_ID() == 0) {
                this.m_deferPosting = true;
            }
        } else {
            String posted = DB.getSQLValueStringEx(this.getTrxName(), "SELECT Posted FROM M_MatchPO WHERE M_MatchPO_ID=?", this.m_matchPO.getM_MatchPO_ID());
            if ("d".equals(posted)) {
                int M_InOut_ID = DB.getSQLValueEx(this.getTrxName(), "SELECT M_InOut_ID FROM M_InOutLine WHERE M_InOutLine_ID=?", this.m_M_InOutLine_ID);
                MInOut inout = new MInOut(this.getCtx(), M_InOut_ID, this.getTrxName());
                if (inout.getDateAcct().after(this.m_matchPO.getDateAcct())) {
                    this.m_matchPO.setDateAcct(inout.getDateAcct());
                    this.m_matchPO.setDateTrx(inout.getDateAcct());
                    this.setDateAcct(inout.getDateAcct());
                    this.setDateDoc(inout.getDateAcct());
                    this.m_matchPO.saveEx();
                }
            }
        }
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        String costingError;
        MOrderLandedCostAllocation[] allocations;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + String.valueOf(this.getQty()));
            }
            return facts;
        }
        if (this.m_M_InOutLine_ID == 0) {
            MMatchPO[] matchPOs;
            MMatchPO[] mMatchPOArray = matchPOs = MMatchPO.getOrderLine(this.getCtx(), this.m_oLine.getC_OrderLine_ID(), this.getTrxName());
            int n = matchPOs.length;
            int n2 = 0;
            while (n2 < n) {
                String docStatus;
                MMatchPO matchPO = mMatchPOArray[n2];
                if (matchPO.getM_InOutLine_ID() > 0 && matchPO.getC_InvoiceLine_ID() == 0 && ((docStatus = matchPO.getM_InOutLine().getM_InOut().getDocStatus()).equals("CO") || docStatus.equals("CL")) && matchPO.getQty().compareTo(this.getQty()) <= 0) {
                    this.m_M_InOutLine_ID = matchPO.getM_InOutLine_ID();
                    break;
                }
                ++n2;
            }
        }
        if (this.m_M_InOutLine_ID == 0) {
            if (this.m_matchPO.getRef_MatchPO_ID() > 0) {
                return facts;
            }
            this.p_Error = Msg.getMsg(Env.getCtx(), "NoPostingIfNotMatchedToShipment");
            return null;
        }
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        BigDecimal poCost = this.m_oLine.getPriceCost();
        if (poCost == null || poCost.signum() == 0) {
            poCost = this.m_oLine.getPriceActual();
            int C_Tax_ID = this.m_oLine.getC_Tax_ID();
            MTax tax = MTax.get(this.getCtx(), C_Tax_ID);
            int stdPrecision = MCurrency.getStdPrecision(this.getCtx(), this.m_oLine.getC_Currency_ID());
            if (this.m_oLine.isTaxIncluded() && C_Tax_ID != 0) {
                if (!tax.isZeroTax()) {
                    BigDecimal costTax = tax.calculateTax(poCost, true, stdPrecision);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Costs=" + String.valueOf(poCost) + " - Tax=" + String.valueOf(costTax));
                    }
                    if (tax.isSummary()) {
                        BigDecimal base = poCost = poCost.subtract(costTax);
                        MTax[] mTaxArray = tax.getChildTaxes(false);
                        int n = mTaxArray.length;
                        var12_25 = 0;
                        while (var12_25 < n) {
                            MTax childTax = mTaxArray[var12_25];
                            if (!childTax.isZeroTax() && childTax.isDistributeTaxWithLineItem()) {
                                BigDecimal taxAmt = childTax.calculateTax(base, false, stdPrecision);
                                poCost = poCost.add(taxAmt);
                            }
                            ++var12_25;
                        }
                    } else if (!tax.isDistributeTaxWithLineItem()) {
                        poCost = poCost.subtract(costTax);
                    }
                }
            } else if (tax.isSummary()) {
                BigDecimal base = poCost;
                MTax[] mTaxArray = tax.getChildTaxes(false);
                var12_25 = mTaxArray.length;
                int childTax = 0;
                while (childTax < var12_25) {
                    MTax childTax2 = mTaxArray[childTax];
                    if (childTax2.isDistributeTaxWithLineItem()) {
                        BigDecimal taxAmt2 = childTax2.calculateTax(base, false, stdPrecision);
                        poCost = poCost.add(taxAmt2);
                    }
                    ++childTax;
                }
            } else if (tax.isDistributeTaxWithLineItem()) {
                BigDecimal taxAmt = tax.calculateTax(poCost, false, stdPrecision);
                poCost = poCost.add(taxAmt);
            }
        }
        MInOutLine receiptLine = new MInOutLine(this.getCtx(), this.m_M_InOutLine_ID, this.getTrxName());
        MInOut inOut = receiptLine.getParent();
        boolean isReturnTrx = inOut.getMovementType().equals("V-");
        LinkedHashMap<Integer, BigDecimal> landedCostMap = new LinkedHashMap<Integer, BigDecimal>();
        BigDecimal landedCost = BigDecimal.ZERO;
        int C_OrderLine_ID = this.m_oLine.getC_OrderLine_ID();
        MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = allocations = MOrderLandedCostAllocation.getOfOrderLine(C_OrderLine_ID, this.getTrxName());
        int taxAmt = allocations.length;
        int taxAmt2 = 0;
        while (taxAmt2 < taxAmt) {
            int elementId;
            BigDecimal elementAmt;
            MOrderLandedCostAllocation allocation = mOrderLandedCostAllocationArray[taxAmt2];
            BigDecimal totalAmt = allocation.getAmt();
            BigDecimal totalQty = allocation.getQty();
            BigDecimal amt = totalAmt.multiply(this.m_ioLine.getMovementQty()).divide(totalQty, 12, RoundingMode.HALF_UP);
            if (this.m_oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
                MOrder order = this.m_oLine.getParent();
                Timestamp dateAcct = inOut.getDateAcct();
                BigDecimal rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), dateAcct, order.getC_ConversionType_ID(), this.m_oLine.getAD_Client_ID(), this.m_oLine.getAD_Org_ID());
                if (rate == null) {
                    this.p_Error = Msg.getMsg(Env.getCtx(), "PurchaseOrderNotConvertible", (Object[])new String[]{as.getName()});
                    return null;
                }
                amt = amt.multiply(rate);
            }
            if ((landedCost = landedCost.add(amt = amt.divide(this.getQty(), 12, RoundingMode.HALF_UP))).scale() > as.getCostingPrecision()) {
                landedCost = landedCost.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            }
            elementAmt = (elementAmt = (BigDecimal)landedCostMap.get(elementId = allocation.getC_OrderLandedCost().getM_CostElement_ID())) == null ? amt : elementAmt.add(amt);
            landedCostMap.put(elementId, elementAmt);
            ++taxAmt2;
        }
        if (this.m_oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
            MOrder order = this.m_oLine.getParent();
            Timestamp dateAcct = inOut.getDateAcct();
            BigDecimal rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), dateAcct, order.getC_ConversionType_ID(), this.m_oLine.getAD_Client_ID(), this.m_oLine.getAD_Org_ID());
            if (rate == null) {
                this.p_Error = Msg.getMsg(Env.getCtx(), "PurchaseOrderNotConvertible", (Object[])new String[]{as.getName()});
                return null;
            }
            if ((poCost = poCost.multiply(rate)).scale() > as.getCostingPrecision()) {
                poCost = poCost.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            }
        }
        if ((costingError = this.createMatchPOCostDetail(as, poCost, landedCostMap)) != null && costingError.trim().length() > 0) {
            this.p_Error = costingError;
            return null;
        }
        BigDecimal deliveredCost = poCost.multiply(this.getQty());
        BigDecimal totalCost = deliveredCost.add(landedCost);
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        String costingMethod = product.getCostingMethod(as);
        BigDecimal costs = this.m_pc.getProductCosts(as, this.getAD_Org_ID(), "S", this.m_C_OrderLine_ID, false);
        if ("S".equals(costingMethod)) {
            if (this.m_matchPO.isReversal()) {
                FactLine dr;
                FactLine cr = fact.createLine(null, this.m_pc.getAccount(5, as), as.getC_Currency_ID(), Env.ONE);
                if (!cr.updateReverseLine(473, this.m_matchPO.getM_MatchPO_ID(), 0, Env.ONE)) {
                    fact.remove(cr);
                    cr = null;
                }
                if (cr != null && !(dr = fact.createLine(null, this.getAccount(101, as), as.getC_Currency_ID(), Env.ONE)).updateReverseLine(473, this.m_matchPO.getM_MatchPO_ID(), 0, Env.ONE, cr)) {
                    this.p_Error = Msg.getMsg(Env.getCtx(), "FailedToCreateReversalEntryForACCTTYPE_PPVOffset");
                    return null;
                }
            } else {
                BigDecimal credit;
                BigDecimal debit;
                BigDecimal difference;
                if (costs == null || costs.signum() == 0) {
                    if (this.m_oLine.getPriceActual().signum() == 0) {
                        costs = BigDecimal.ZERO;
                    } else {
                        this.p_Error = Msg.getMsg(Env.getCtx(), "Resubmit - No Costs for") + product.getName();
                        this.log.log(Level.SEVERE, this.p_Error);
                        return null;
                    }
                }
                if ((difference = totalCost.subtract(costs)).signum() == 0) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "No Cost Difference for M_Product_ID=" + this.getM_Product_ID());
                    }
                    return facts;
                }
                FactLine cr = fact.createLine(null, this.m_pc.getAccount(5, as), as.getC_Currency_ID(), isReturnTrx ? difference.negate() : difference);
                MAccount acct_cr = null;
                if (cr != null) {
                    cr.setQty(isReturnTrx ? this.getQty().negate() : this.getQty());
                    cr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
                    cr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
                    cr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
                    cr.setC_Project_ID(this.m_oLine.getC_Project_ID());
                    cr.setC_ProjectPhase_ID(this.m_oLine.getC_ProjectPhase_ID());
                    cr.setC_ProjectTask_ID(this.m_oLine.getC_ProjectTask_ID());
                    cr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
                    cr.setUser1_ID(this.m_oLine.getUser1_ID());
                    cr.setUser2_ID(this.m_oLine.getUser2_ID());
                    acct_cr = cr.getAccount();
                }
                FactLine dr = fact.createLine(null, this.getAccount(101, as), as.getC_Currency_ID(), isReturnTrx ? difference : difference.negate());
                PO acct_db = null;
                if (dr != null) {
                    dr.setQty(isReturnTrx ? this.getQty() : this.getQty().negate());
                    dr.setC_BPartner_ID(this.m_oLine.getC_BPartner_ID());
                    dr.setC_Activity_ID(this.m_oLine.getC_Activity_ID());
                    dr.setC_Campaign_ID(this.m_oLine.getC_Campaign_ID());
                    dr.setC_Project_ID(this.m_oLine.getC_Project_ID());
                    dr.setC_ProjectPhase_ID(this.m_oLine.getC_ProjectPhase_ID());
                    dr.setC_ProjectTask_ID(this.m_oLine.getC_ProjectTask_ID());
                    dr.setC_UOM_ID(this.m_oLine.getC_UOM_ID());
                    dr.setUser1_ID(this.m_oLine.getUser1_ID());
                    dr.setUser2_ID(this.m_oLine.getUser2_ID());
                    acct_db = dr.getAccount();
                }
                if (!as.isPostIfClearingEqual() && acct_db != null && acct_db.equals(acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
                    fact.remove(dr);
                    fact.remove(cr);
                }
            }
            facts.add(fact);
            return facts;
        }
        return facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        return this.m_ioLine != null && this.m_oLine != null && this.m_ioLine.getAD_Org_ID() != this.m_oLine.getAD_Org_ID();
    }

    private String createMatchPOCostDetail(MAcctSchema as, BigDecimal poCost, Map<Integer, BigDecimal> landedCostMap) {
        if (this.m_ioLine != null && this.m_ioLine.getM_InOutLine_ID() > 0 && this.m_oLine != null && this.m_oLine.getC_OrderLine_ID() > 0) {
            String error;
            String error2;
            MMatchPO mMatchPO = (MMatchPO)this.getPO();
            MInOut inOut = this.m_ioLine.getParent();
            boolean isReturnTrx = inOut.getMovementType().equals("V-");
            MMatchPO[] mPO = MMatchPO.getOrderLine(this.getCtx(), this.m_oLine.getC_OrderLine_ID(), this.getTrxName());
            BigDecimal tQty = Env.ZERO;
            BigDecimal tAmt = Env.ZERO;
            int i2 = 0;
            while (i2 < mPO.length) {
                if (mPO[i2].getM_AttributeSetInstance_ID() == mMatchPO.getM_AttributeSetInstance_ID() && mPO[i2].getM_MatchPO_ID() != mMatchPO.getM_MatchPO_ID()) {
                    BigDecimal qty = isReturnTrx ? mPO[i2].getQty().negate() : mPO[i2].getQty();
                    BigDecimal orderCost = BigDecimal.ZERO;
                    if (mPO[i2].getM_InOutLine_ID() > 0) {
                        tQty = tQty.add(qty);
                        if (this.m_oLine.getC_Currency_ID() != as.getC_Currency_ID()) {
                            MOrder order = this.m_oLine.getParent();
                            MProduct product = new MProduct(this.getCtx(), this.m_oLine.getM_Product_ID(), this.getTrxName());
                            if ("A".equals(product.getCostingMethod(as))) {
                                orderCost = mPO[i2].getM_InOutLine().getC_OrderLine().getPriceActual();
                                Timestamp dateAcct = mPO[i2].getM_InOutLine().getM_InOut().getDateAcct();
                                BigDecimal rate = MConversionRate.getRate(order.getC_Currency_ID(), as.getC_Currency_ID(), dateAcct, order.getC_ConversionType_ID(), this.m_oLine.getAD_Client_ID(), this.m_oLine.getAD_Org_ID());
                                if (rate == null) {
                                    this.p_Error = "Purchase Order not convertible - " + as.getName();
                                    return null;
                                }
                                orderCost = orderCost.multiply(rate);
                                tAmt = tAmt.add(orderCost.multiply(qty));
                            } else {
                                tAmt = tAmt.add(poCost.multiply(qty));
                            }
                        } else {
                            tAmt = tAmt.add(poCost.multiply(qty));
                        }
                    }
                }
                ++i2;
            }
            poCost = poCost.multiply(this.getQty());
            tAmt = tAmt.add(isReturnTrx ? poCost.negate() : poCost);
            tQty = tQty.add(isReturnTrx ? this.getQty().negate() : this.getQty());
            if (mMatchPO.isReversal() && !Util.isEmpty(error2 = this.createLandedCostAdjustments(as, landedCostMap, mMatchPO, tQty))) {
                return error2;
            }
            if (tAmt.scale() > as.getCostingPrecision()) {
                tAmt = tAmt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            }
            if (!MCostDetail.createOrder(as, this.m_oLine.getAD_Org_ID(), this.getM_Product_ID(), mMatchPO.getM_AttributeSetInstance_ID(), this.m_oLine.getC_OrderLine_ID(), 0, tAmt, tQty, this.m_oLine.getDescription(), this.getTrxName())) {
                return "SaveError";
            }
            if (!mMatchPO.isReversal() && !Util.isEmpty(error = this.createLandedCostAdjustments(as, landedCostMap, mMatchPO, tQty))) {
                return error;
            }
        }
        return "";
    }

    private String createLandedCostAdjustments(MAcctSchema as, Map<Integer, BigDecimal> landedCostMap, MMatchPO mMatchPO, BigDecimal tQty) {
        for (Integer elementId : landedCostMap.keySet()) {
            BigDecimal amt = landedCostMap.get(elementId);
            if ((amt = amt.multiply(tQty)).scale() > as.getCostingPrecision()) {
                amt = amt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
            }
            if (MCostDetail.createOrder(as, this.m_oLine.getAD_Org_ID(), this.getM_Product_ID(), mMatchPO.getM_AttributeSetInstance_ID(), this.m_oLine.getC_OrderLine_ID(), elementId, amt, tQty, this.m_oLine.getDescription(), this.getTrxName())) continue;
            return "SaveError";
        }
        return null;
    }

    @Override
    public boolean isDeferPosting() {
        return this.m_deferPosting;
    }
}

