/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.model;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Verification;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.RestUtils;
import com.trekglobal.idempiere.rest.api.model.MOIDCProvider;
import com.trekglobal.idempiere.rest.api.model.X_REST_OIDCService;
import com.trekglobal.idempiere.rest.api.oidc.AuthenticatedUser;
import com.trekglobal.idempiere.rest.api.oidc.IOIDCProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.interfaces.RSAPublicKey;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.Arrays;
import java.util.Properties;
import javax.ws.rs.container.ContainerRequestContext;
import org.compiere.model.MSysConfig;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MOIDCService
extends X_REST_OIDCService
implements ImmutablePOSupport {
    private static final long serialVersionUID = 3717089346846528233L;
    private static ImmutablePOCache<String, MOIDCService> s_issuerCache = new ImmutablePOCache("REST_OIDCService", 10);
    private static CCache<String, AuthenticatedUser> s_authCache = new CCache("AuthenticatedUser_Cache", 40, MSysConfig.getIntValue((String)"REST_TOKEN_EXPIRE_IN_MINUTES", (int)60, (int)Env.getAD_Client_ID((Properties)Env.getCtx())));
    public static final String ROLE_HEADER = "X-ID-Role";
    public static final String ORG_HEADER = "X-ID-Organization";
    public static final String WAREHOUSE_HEADER = "X-ID-Warehouse";
    public static final String LANGUAGE_HEADER = "X-ID-Language";
    public static final String IDTOKEN_HEADER = "X-ID-IdToken";

    public MOIDCService(Properties ctx, int REST_OIDCService_ID, String trxName) {
        super(ctx, REST_OIDCService_ID, trxName);
    }

    public MOIDCService(Properties ctx, int REST_OIDCService_ID, String trxName, String ... virtualColumns) {
        super(ctx, REST_OIDCService_ID, trxName, virtualColumns);
    }

    public MOIDCService(Properties ctx, String REST_OIDCService_UU, String trxName) {
        super(ctx, REST_OIDCService_UU, trxName);
    }

    public MOIDCService(Properties ctx, String REST_OIDCService_UU, String trxName, String ... virtualColumns) {
        super(ctx, REST_OIDCService_UU, trxName, virtualColumns);
    }

    public MOIDCService(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MOIDCService(Properties ctx, MOIDCService copy) {
        this(ctx, copy, null);
    }

    public MOIDCService(Properties ctx, MOIDCService copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MOIDCService fromIssuerAndAudience(String issuer, String audience) {
        String key = String.valueOf(issuer) + "|" + audience;
        if (s_issuerCache.containsKey((Object)key)) {
            return (MOIDCService)s_issuerCache.get(Env.getCtx(), (Object)key, e -> new MOIDCService(Env.getCtx(), (MOIDCService)e));
        }
        Query query = new Query(Env.getCtx(), "REST_OIDCService", "%s=? AND %s=?".formatted("OIDC_IssuerURL", "OIDC_Audience"), null);
        MOIDCService service = (MOIDCService)query.setParameters(new Object[]{issuer, audience}).setOnlyActiveRecords(true).firstOnly();
        if (service != null) {
            s_issuerCache.put((Object)key, (PO)service, e -> new MOIDCService(Env.getCtx(), (MOIDCService)e));
        }
        return service;
    }

    public static MOIDCService findMatchingOIDCService(String token) {
        DecodedJWT decoded = JWT.decode((String)token);
        Instant expire = decoded.getExpiresAtAsInstant();
        if (expire != null && !expire.isAfter(Instant.now())) {
            throw new JWTVerificationException("Token has expired");
        }
        Claim alg = decoded.getHeaderClaim("alg");
        Claim typ = decoded.getHeaderClaim("typ");
        Claim kid = decoded.getHeaderClaim("kid");
        Claim iss = decoded.getClaim("iss");
        Claim aud = decoded.getClaim("aud");
        Claim azp = decoded.getClaim("azp");
        Claim client_id = decoded.getClaim("client_id");
        MOIDCService service = null;
        if (MOIDCService.isWithStringValue(alg) && MOIDCService.isWithStringValue(typ) && "JWT".equals(typ.asString()) && MOIDCService.isWithStringValue(kid) && MOIDCService.isWithStringValue(iss) && MOIDCService.isWithStringValue(aud) && MOIDCService.isWithStringValue(azp) ? (service = MOIDCService.fromIssuerAndAudience(iss.asString(), aud.asString())) == null : MOIDCService.isWithStringValue(kid) && MOIDCService.isWithStringValue(client_id) && (service = MOIDCService.fromIssuerAndAudience(iss.asString(), client_id.asString())) == null) {
            throw new JWTVerificationException("No matching OpenID Connect service configuration for access token");
        }
        return service;
    }

    private static boolean isWithStringValue(Claim claim) {
        return !claim.isMissing() && !claim.isNull() && claim.asString() != null;
    }

    public void validateAccessToken(String token, ContainerRequestContext requestContext) {
        AuthenticatedUser authenticatedUser = (AuthenticatedUser)s_authCache.get((Object)token);
        if (authenticatedUser != null) {
            this.processAuthenticatedUser(requestContext, authenticatedUser);
            return;
        }
        MOIDCProvider oidcProvider = new MOIDCProvider(Env.getCtx(), this.getREST_OIDCProvider_ID(), null);
        IOIDCProvider service = oidcProvider.getProvider();
        if (service == null) {
            throw new JWTVerificationException("No provider service register for %s".formatted(oidcProvider.getName()));
        }
        DecodedJWT decodedJwt = this.getDecodedJWT(token);
        if (this.isValidateScope_OIDC()) {
            String path = requestContext.getUriInfo().getPath();
            Claim scopeClaim = decodedJwt.getClaim("scope");
            if (scopeClaim.isMissing() || scopeClaim.isNull()) {
                throw new JWTVerificationException("Missing scope claim");
            }
            String scopeText = scopeClaim.asString();
            String[] scopes = scopeText.split(" ");
            boolean match = Arrays.stream(scopes).anyMatch(e -> e.equals(path));
            if (!match) {
                throw new JWTVerificationException("API path not part of scope");
            }
        }
        authenticatedUser = service.getAuthenticatedUser(decodedJwt, requestContext, this);
        s_authCache.put((Object)token, (Object)authenticatedUser);
        this.processAuthenticatedUser(requestContext, authenticatedUser);
    }

    private void processAuthenticatedUser(ContainerRequestContext requestContext, AuthenticatedUser authenticatedUser) {
        String warehouseName;
        String AD_Language;
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)authenticatedUser.getTenantId());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)authenticatedUser.getUserId());
        if (authenticatedUser.getRoleId() >= 0) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)authenticatedUser.getRoleId());
        }
        if (authenticatedUser.getOrganizationId() >= 0) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Org_ID", (int)authenticatedUser.getOrganizationId());
        }
        if (authenticatedUser.getsessionId() > 0) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Session_ID", (int)authenticatedUser.getsessionId());
        }
        if (!Util.isEmpty((String)(AD_Language = requestContext.getHeaderString(LANGUAGE_HEADER)))) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Language", (String)AD_Language);
        }
        if (!Util.isEmpty((String)(warehouseName = requestContext.getHeaderString(WAREHOUSE_HEADER)))) {
            Query warehouseQuery = new Query(Env.getCtx(), "M_Warehouse", "AD_Client_ID=? AND Name=?", null);
            MWarehouse wh = (MWarehouse)warehouseQuery.setOnlyActiveRecords(true).setParameters(new Object[]{authenticatedUser.getTenantId(), warehouseName}).first();
            if (wh != null) {
                Env.setContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID", (int)wh.get_ID());
            }
        }
        RestUtils.setSessionContextVariables(Env.getCtx());
    }

    public PO markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        super.makeImmutable();
        return this;
    }

    protected boolean beforeSave(boolean newRecord) {
        String authorityURL;
        boolean success = super.beforeSave(newRecord);
        if (success && newRecord && !Util.isEmpty((String)(authorityURL = this.getOIDC_AuthorityURL()))) {
            if (Util.isEmpty((String)this.getOIDC_IssuerURL())) {
                this.setOIDC_IssuerURL(authorityURL);
            }
            if (Util.isEmpty((String)this.getOIDC_ConfigurationURL()) && this.getREST_OIDCProvider_ID() > 0) {
                MOIDCProvider provider = new MOIDCProvider(Env.getCtx(), this.getREST_OIDCProvider_ID(), null);
                String configurationURL = provider.getOIDC_ConfigurationURL();
                configurationURL = configurationURL.replace("@OIDC_AuthorityURL@", authorityURL);
                this.setOIDC_ConfigurationURL(configurationURL);
            }
        }
        return success;
    }

    private DecodedJWT getDecodedJWT(String token) {
        String jwksUrl = null;
        String wellKnownUrl = this.getOIDC_ConfigurationURL();
        HttpClient httpClient = HttpClient.newBuilder().build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(wellKnownUrl)).GET().build();
        try {
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject json = (JsonObject)new Gson().fromJson(response.body(), JsonObject.class);
            jwksUrl = json.get("jwks_uri").getAsString();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        DecodedJWT decodedJwt = null;
        if (jwksUrl != null) {
            decodedJwt = JWT.decode((String)token);
            try {
                UrlJwkProvider provider = new UrlJwkProvider(new URL(jwksUrl));
                Jwk jwk = provider.get(decodedJwt.getKeyId());
                Algorithm algorithm = Algorithm.RSA256((RSAPublicKey)((RSAPublicKey)jwk.getPublicKey()), null);
                Verification verification = JWT.require((Algorithm)algorithm).acceptExpiresAt(0L).withIssuer(this.getOIDC_IssuerURL());
                Claim aud = decodedJwt.getClaim("aud");
                if (MOIDCService.isWithStringValue(aud)) {
                    verification.withAudience(new String[]{this.getOIDC_Audience()});
                } else {
                    Claim client_id = decodedJwt.getClaim("client_id");
                    if (MOIDCService.isWithStringValue(client_id)) {
                        verification.withClaim("client_id", this.getOIDC_Audience());
                    }
                }
                JWTVerifier verifier = verification.build();
                decodedJwt = verifier.verify(decodedJwt);
            }
            catch (JwkException | JWTVerificationException | MalformedURLException e) {
                if (e instanceof JWTVerificationException) {
                    throw (JWTVerificationException)e;
                }
                throw new JWTVerificationException(e.getMessage(), e);
            }
        } else {
            throw new JWTVerificationException("Failed to retrieve jwks_uri from Configuration URL");
        }
        return decodedJwt;
    }

    public DecodedJWT getDecodedIdToken(ContainerRequestContext requestContext) {
        String idToken = requestContext.getHeaderString(IDTOKEN_HEADER);
        if (Util.isEmpty((String)idToken)) {
            return null;
        }
        return this.getDecodedJWT(idToken);
    }
}

