/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.json;

import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IPOSerializerFactory;
import com.trekglobal.idempiere.rest.api.model.MRestView;
import java.util.List;
import org.adempiere.base.Service;
import org.compiere.model.MTable;
import org.compiere.model.PO;

public interface IPOSerializer {
    default public JsonObject toJson(PO po) {
        return this.toJson(po, null, null);
    }

    default public JsonObject toJson(PO po, MRestView view) {
        return this.toJson(po, view, null, null);
    }

    public JsonObject toJson(PO var1, String[] var2, String[] var3);

    default public JsonObject toJson(PO po, MRestView view, String[] includes, String[] excludes) {
        return this.toJson(po, includes, excludes);
    }

    public PO fromJson(JsonObject var1, MTable var2);

    default public PO fromJson(JsonObject json, MTable table, MRestView view) {
        return this.fromJson(json, table);
    }

    public PO fromJson(JsonObject var1, PO var2);

    default public PO fromJson(JsonObject json, PO po, MRestView view) {
        return this.fromJson(json, po);
    }

    public static IPOSerializer getPOSerializer(String tableName, Class<?> modelClass) {
        IPOSerializer serializer = null;
        List factories = Service.locator().list(IPOSerializerFactory.class).getServices();
        for (IPOSerializerFactory factory : factories) {
            serializer = factory.getPOSerializer(tableName, modelClass);
            if (serializer != null) break;
        }
        if (serializer == null) {
            for (IPOSerializerFactory factory : factories) {
                serializer = factory.getPOSerializer("*", modelClass);
                if (serializer != null) break;
            }
        }
        return serializer;
    }
}

