/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.util.ClusterUtil;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.NodeResource;
import com.trekglobal.idempiere.rest.api.v1.resource.impl.FileResourceImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.compiere.model.MUser;
import org.compiere.server.LogFileInfo;
import org.compiere.server.SystemInfo;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;
import org.idempiere.server.cluster.callable.DeleteLogsCallable;
import org.idempiere.server.cluster.callable.RotateLogCallable;
import org.idempiere.server.cluster.callable.SetTraceLevelCallable;

public class NodeResourceImpl
implements NodeResource {
    private static final CLogger log = CLogger.getCLogger(NodeResourceImpl.class);

    @Override
    public Response getNodes() {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get nodes request");
        }
        JsonArray nodes = new JsonArray();
        IClusterService service = ClusterUtil.getClusterService();
        if (service == null) {
            JsonObject localNode = new JsonObject();
            localNode.addProperty("id", "local");
            try {
                localNode.addProperty("name", InetAddress.getLocalHost().getCanonicalHostName());
            }
            catch (UnknownHostException e) {
                log.log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
            nodes.add((JsonElement)localNode);
            return Response.ok((Object)localNode.toString()).build();
        }
        Collection members = service.getMembers();
        for (IClusterMember member : members) {
            JsonObject node = new JsonObject();
            node.addProperty("id", member.getId());
            node.addProperty("hostName", member.getAddress().getCanonicalHostName());
            node.addProperty("port", (Number)member.getPort());
            nodes.add((JsonElement)node);
        }
        JsonObject json = new JsonObject();
        json.add("nodes", (JsonElement)nodes);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getNodeInfo(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get node info request");
        }
        SystemInfo info = this.getSystemInfo(id);
        if (info == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
        }
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        InetAddress address = null;
        try {
            address = info.getAddress() != null ? info.getAddress() : InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {}
        if (address != null) {
            json.addProperty("hostName", address.getCanonicalHostName());
        }
        json.addProperty("home", info.getIDempiereHome());
        json.addProperty("os", info.getOperatingSystem());
        json.addProperty("jvm", info.getJavaVM());
        json.addProperty("databaseDescription", info.getDatabaseDescription());
        json.addProperty("databaseConnectionURL", info.getDatabaseConnectionURL());
        json.addProperty("databaseStatus", info.getDatabaseStatus());
        json.addProperty("availableProcessors", (Number)info.getAvailableProcessors());
        json.addProperty("averageSystemLoad", (Number)info.getAverageSystemLoad());
        json.addProperty("memoryUsage", info.getMemoryUsage());
        json.addProperty("heapMemoryUsage", info.getHeapMemoryUsage());
        json.addProperty("runtime", info.getRuntimeName());
        json.addProperty("runtimeUptime", TimeUtil.formatElapsed((long)info.getRuntimeUpTime()));
        json.addProperty("threadCount", (Number)info.getThreadCount());
        json.addProperty("peakThreadCount", (Number)info.getPeakThreadCount());
        json.addProperty("daemonThreadCount", (Number)info.getDaemonThreadCount());
        json.addProperty("totalStartedThreadCount", (Number)info.getTotalStartedThreadCount());
        json.addProperty("logLevel", info.getLogLevel().getName());
        json.addProperty("currentLogFile", info.getCurrentLogFile());
        json.addProperty("sessionCount", (Number)info.getSessionCount());
        json.addProperty("garbageCollectionCount", (Number)info.getGarbageCollectionCount());
        json.addProperty("garbageCollectionTime", (Number)info.getGarbageCollectionTime());
        return Response.ok((Object)json.toString()).build();
    }

    private SystemInfo getSystemInfo(String id) {
        IClusterService service;
        SystemInfo info = null;
        info = id.equals("local") ? SystemInfo.getLocalSystemInfo() : ((service = ClusterUtil.getClusterService()) != null && service.getLocalMember().getId().equals(id) ? SystemInfo.getLocalSystemInfo() : SystemInfo.getClusterNodeInfo((String)id));
        return info;
    }

    @Override
    public Response getNodeLogs(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get node logs request");
        }
        SystemInfo info = this.getSystemInfo(id);
        if (info == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
        }
        LogFileInfo[] logInfos = info.getLogFileInfos();
        JsonArray logs = new JsonArray();
        LogFileInfo[] logFileInfoArray = logInfos;
        int n = logInfos.length;
        int n2 = 0;
        while (n2 < n) {
            LogFileInfo logInfo = logFileInfoArray[n2];
            JsonObject log = new JsonObject();
            log.addProperty("fileName", logInfo.getFileName());
            log.addProperty("fileSize", (Number)logInfo.getFileSize());
            logs.add((JsonElement)log);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("logs", (JsonElement)logs);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getNodeLogFile(String id, String fileName, String asJson) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for get node log file request");
        }
        FileResourceImpl fileResource = new FileResourceImpl();
        return fileResource.getFile(fileName, id, asJson);
    }

    @Override
    public Response deleteNodeLogs(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for delete logs request");
        }
        DeleteLogsCallable callable = new DeleteLogsCallable();
        Boolean result = null;
        try {
            if (id.equals("local")) {
                result = callable.call();
            } else {
                IClusterService service = ClusterUtil.getClusterService();
                if (service != null && service.getLocalMember().getId().equals(id)) {
                    result = callable.call();
                } else {
                    if (service == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
                    }
                    IClusterMember member = ClusterUtil.getClusterMember(id);
                    if (member == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
                    }
                    result = (Boolean)service.execute((Callable)callable, member).get();
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(ex.getMessage()).build().toString()).build();
        }
        SystemInfo info = this.getSystemInfo(id);
        JsonObject json = new JsonObject();
        json.addProperty("currentLogFile", info.getCurrentLogFile());
        if (result != null && result.booleanValue()) {
            return Response.ok((Object)json.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)json.toString()).build();
    }

    @Override
    public Response rotateNodeLogs(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for rotate log request");
        }
        RotateLogCallable callable = new RotateLogCallable();
        Boolean result = null;
        try {
            if (id.equals("local")) {
                result = callable.call();
            } else {
                IClusterService service = ClusterUtil.getClusterService();
                if (service != null && service.getLocalMember().getId().equals(id)) {
                    result = callable.call();
                } else {
                    if (service == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
                    }
                    IClusterMember member = ClusterUtil.getClusterMember(id);
                    if (member == null) {
                        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid Node Id").append("No match found for node id: ").append(id).build().toString()).build();
                    }
                    result = (Boolean)service.execute((Callable)callable, member).get();
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(ex.getMessage()).build().toString()).build();
        }
        SystemInfo info = this.getSystemInfo(id);
        JsonObject json = new JsonObject();
        json.addProperty("currentLogFile", info.getCurrentLogFile());
        if (result != null && result.booleanValue()) {
            return Response.ok((Object)json.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)json.toString()).build();
    }

    @Override
    public Response updateNodeLogLevel(String id, String logLevel) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.forbidden("Access denied", "Access denied for set log level request");
        }
        if (Util.isEmpty((String)logLevel, (boolean)true)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("No Log Level").append("No log level parameter").build().toString()).build();
        }
        String levelName = null;
        Level[] levelArray = CLogMgt.LEVELS;
        int n = CLogMgt.LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            Level level = levelArray[n2];
            if (level.getName().equalsIgnoreCase(logLevel)) {
                levelName = level.getName();
                break;
            }
            ++n2;
        }
        if (levelName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Invalid Log Level").append("Invalid log level parameter: " + logLevel).build().toString()).build();
        }
        SetTraceLevelCallable callable = new SetTraceLevelCallable(levelName);
        try {
            if (!Util.isEmpty((String)id, (boolean)true)) {
                ClusterUtil.getClusterService().execute((Callable)callable, ClusterUtil.getClusterMember(id)).get();
            } else {
                callable.call();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(ex.getMessage()).build().toString()).build();
        }
        SystemInfo info = this.getSystemInfo(id);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("logLevel", info.getLogLevel().getName());
        return Response.ok((Object)jsonObject.toString()).build();
    }

    private Response forbidden(String title, String detail) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title(title).append(detail).build().toString()).build();
    }
}

