/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MCommissionDetail;
import org.compiere.model.MCommissionLine;
import org.compiere.model.MCommissionRun;
import org.compiere.model.Query;
import org.compiere.model.X_C_CommissionAmt;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MCommissionAmt
extends X_C_CommissionAmt {
    private static final long serialVersionUID = 1747802539808391638L;

    public MCommissionAmt(Properties ctx, String C_CommissionAmt_UU, String trxName) {
        super(ctx, C_CommissionAmt_UU, trxName);
        if (Util.isEmpty(C_CommissionAmt_UU)) {
            this.setInitialDefaults();
        }
    }

    public MCommissionAmt(Properties ctx, int C_CommissionAmt_ID, String trxName) {
        super(ctx, C_CommissionAmt_ID, trxName);
        if (C_CommissionAmt_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setActualQty(Env.ZERO);
        this.setCommissionAmt(Env.ZERO);
        this.setConvertedAmt(Env.ZERO);
    }

    public MCommissionAmt(MCommissionRun run, int C_CommissionLine_ID) {
        this(run.getCtx(), 0, run.get_TrxName());
        this.setClientOrg(run);
        this.setC_CommissionRun_ID(run.getC_CommissionRun_ID());
        this.setC_CommissionLine_ID(C_CommissionLine_ID);
    }

    public MCommissionAmt(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCommissionAmt(Properties ctx, int C_CommissionAmt_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_CommissionAmt_ID, trxName, virtualColumns);
    }

    public MCommissionDetail[] getDetails() {
        List<MCommissionDetail> list = new Query(this.getCtx(), "C_CommissionDetail", "C_CommissionAmt_ID=?", this.get_TrxName()).setParameters(this.getC_CommissionAmt_ID()).list();
        MCommissionDetail[] retValue = new MCommissionDetail[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void calculateCommission() {
        BigDecimal amt;
        MCommissionDetail[] details = this.getDetails();
        BigDecimal ConvertedAmt = Env.ZERO;
        BigDecimal ActualQty = Env.ZERO;
        int i = 0;
        while (i < details.length) {
            MCommissionDetail detail = details[i];
            amt = detail.getConvertedAmt();
            if (amt == null) {
                amt = Env.ZERO;
            }
            ConvertedAmt = ConvertedAmt.add(amt);
            ActualQty = ActualQty.add(detail.getActualQty());
            ++i;
        }
        this.setConvertedAmt(ConvertedAmt);
        this.setActualQty(ActualQty);
        MCommissionLine cl = new MCommissionLine(this.getCtx(), this.getC_CommissionLine_ID(), this.get_TrxName());
        BigDecimal qty = this.getActualQty().subtract(cl.getQtySubtract());
        if (cl.isPositiveOnly() && qty.signum() < 0) {
            qty = Env.ZERO;
        }
        qty = qty.multiply(cl.getQtyMultiplier());
        amt = this.getConvertedAmt().subtract(cl.getAmtSubtract());
        if (cl.isPositiveOnly() && amt.signum() < 0) {
            amt = Env.ZERO;
        }
        amt = amt.multiply(cl.getAmtMultiplier());
        this.setCommissionAmt(amt.add(qty));
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord) {
            this.updateRunHeader();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.updateRunHeader();
        }
        return success;
    }

    private void updateRunHeader() {
        MCommissionRun run = new MCommissionRun(this.getCtx(), this.getC_CommissionRun_ID(), this.get_TrxName());
        run.updateFromAmt();
        run.saveEx();
    }
}

