/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IDempiereRestException;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.ChartResource;
import com.trekglobal.idempiere.rest.api.v1.resource.file.FileStreamingOutput;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.util.Base64;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.ws.rs.core.Response;
import org.compiere.model.MChart;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ChartResourceImpl
implements ChartResource {
    private static final CLogger log = CLogger.getCLogger(ChartResourceImpl.class);

    @Override
    public Response getChartImage(String id, int width, int height, String asJson) {
        try {
            boolean isUUID = Util.isUUID((String)id);
            int chartId = isUUID ? this.getChartID(id) : Integer.valueOf(id).intValue();
            BufferedImage img = null;
            MChart mc = new MChart(Env.getCtx(), chartId, null);
            if (mc.get_ID() == chartId) {
                img = mc.getChartImage(width, height);
            }
            if (img != null) {
                File file = FileUtil.createTempFile((String)("chart" + chartId), (String)".png");
                ImageIO.write((RenderedImage)img, "png", file);
                if (asJson == null) {
                    FileStreamingOutput fso = new FileStreamingOutput(file);
                    return Response.ok((Object)fso).header("Content-Type", (Object)"image/png").build();
                }
                JsonObject json = new JsonObject();
                byte[] binaryData = Files.readAllBytes(file.toPath());
                String data = Base64.getEncoder().encodeToString(binaryData);
                json.addProperty("data", data);
                return Response.ok((Object)json.toString()).build();
            }
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception ex) {
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            if (ex instanceof IDempiereRestException) {
                status = ((IDempiereRestException)((Object)ex)).getErrorResponseStatus();
            }
            log.log(Level.SEVERE, ex.getMessage(), (Throwable)ex);
            return Response.status((Response.Status)status).entity((Object)new ErrorBuilder().status(status).title("GET Error").append("Get status line with exception: ").append(ex.getMessage()).build().toString()).build();
        }
    }

    private int getChartID(String uuid) {
        String sql = "SELECT AD_Chart_ID FROM AD_Chart WHERE AD_Chart_UU = ?";
        return DB.getSQLValue(null, (String)sql, (String)uuid);
    }

    @Override
    public Response getChartData(String id) {
        boolean isUUID = Util.isUUID((String)id);
        int chartId = isUUID ? this.getChartID(id) : Integer.valueOf(id).intValue();
        MChart mc = new MChart(Env.getCtx(), chartId, null);
        return Response.ok((Object)mc.getData().toString()).build();
    }
}

