/*
 * Decompiled with CFR 0.152.
 */
package com.trekglobal.idempiere.rest.api.v1.resource.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.trekglobal.idempiere.rest.api.json.IPOSerializer;
import com.trekglobal.idempiere.rest.api.util.ClusterUtil;
import com.trekglobal.idempiere.rest.api.util.ErrorBuilder;
import com.trekglobal.idempiere.rest.api.v1.resource.ServerResource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MRole;
import org.compiere.model.MScheduler;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.server.IServerManager;
import org.compiere.server.ServerInstance;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.server.cluster.ClusterServerMgr;

public class ServerResourceImpl
implements ServerResource {
    @Override
    public Response getServers() {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.accessDenied("", "get servers");
        }
        IServerManager serverMgr = this.getServerManager();
        ServerInstance[] instances = serverMgr.getServerInstances();
        JsonArray servers = new JsonArray();
        ServerInstance[] serverInstanceArray = instances;
        int n = instances.length;
        int n2 = 0;
        while (n2 < n) {
            ServerInstance instance = serverInstanceArray[n2];
            JsonObject server = new JsonObject();
            server.addProperty("id", instance.getServerId());
            server.addProperty("name", instance.getModel().getName());
            if (instance.getClusterMember() != null) {
                server.addProperty("nodeId", instance.getClusterMember().getId());
                server.addProperty("hostName", instance.getClusterMember().getAddress().getCanonicalHostName());
                server.addProperty("port", (Number)instance.getClusterMember().getPort());
            }
            server.addProperty("started", Boolean.valueOf(instance.isStarted()));
            servers.add((JsonElement)server);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("servers", (JsonElement)servers);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response getServer(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.accessDenied(id, "get server");
        }
        IServerManager serverMgr = this.getServerManager();
        ServerInstance instance = serverMgr.getServerInstance(id);
        if (instance == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid server Id").append("No match found for server id: ").append(id).build().toString()).build();
        }
        JsonObject server = new JsonObject();
        server.addProperty("id", instance.getServerId());
        server.addProperty("name", instance.getModel().getName());
        if (instance.getClusterMember() != null) {
            server.addProperty("nodeId", instance.getClusterMember().getId());
            server.addProperty("hostName", instance.getClusterMember().getAddress().getCanonicalHostName());
            server.addProperty("port", (Number)instance.getClusterMember().getPort());
        }
        if (!Util.isEmpty((String)instance.getModel().getDescription())) {
            server.addProperty("description", instance.getModel().getDescription());
        }
        if (instance.getModel().getDateLastRun() != null) {
            server.addProperty("lastRun", DisplayType.getDateFormat((int)16).format(instance.getModel().getDateLastRun()));
        }
        server.addProperty("info", instance.getServerInfo());
        if (instance.getModel().getDateNextRun(false) != null) {
            server.addProperty("nextRun", DisplayType.getDateFormat((int)16).format(instance.getModel().getDateNextRun(false)));
        }
        server.addProperty("statistics", instance.getStatistics());
        server.addProperty("started", Boolean.valueOf(instance.isStarted()));
        server.addProperty("sleeping", Boolean.valueOf(instance.isSleeping()));
        server.addProperty("interruptd", Boolean.valueOf(instance.isInterrupted()));
        return Response.ok((Object)server.toString()).build();
    }

    @Override
    public Response getServerLogs(String id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.accessDenied(id, "get server logs");
        }
        IServerManager serverMgr = this.getServerManager();
        ServerInstance instance = serverMgr.getServerInstance(id);
        if (instance == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid server Id").append("No match found for server id: ").append(id).build().toString()).build();
        }
        AdempiereProcessorLog[] instanceLogs = instance.getModel().getLogs();
        JsonArray logs = new JsonArray();
        AdempiereProcessorLog[] adempiereProcessorLogArray = instanceLogs;
        int n = instanceLogs.length;
        int n2 = 0;
        while (n2 < n) {
            AdempiereProcessorLog instanceLog = adempiereProcessorLogArray[n2];
            JsonObject log = new JsonObject();
            log.addProperty("created", DisplayType.getDateFormat((int)16).format(instanceLog.getCreated()));
            if (!Util.isEmpty((String)instanceLog.getSummary())) {
                log.addProperty("summary", instanceLog.getSummary());
            }
            if (!Util.isEmpty((String)instanceLog.getDescription())) {
                log.addProperty("description", instanceLog.getDescription());
            }
            if (!Util.isEmpty((String)instanceLog.getReference())) {
                log.addProperty("reference", instanceLog.getReference());
            }
            if (!Util.isEmpty((String)instanceLog.getTextMsg())) {
                log.addProperty("textMessage", instanceLog.getTextMsg());
            }
            log.addProperty("error", Boolean.valueOf(instanceLog.isError()));
            logs.add((JsonElement)log);
            ++n2;
        }
        JsonObject json = new JsonObject();
        json.add("logs", (JsonElement)logs);
        return Response.ok((Object)json.toString()).build();
    }

    @Override
    public Response changeServerState(String id) {
        IServerManager serverMgr = this.getServerManager();
        ServerInstance instance = serverMgr.getServerInstance(id);
        if (instance == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid server Id").append("No match found for server id: ").append(id).build().toString()).build();
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            AdempiereProcessor model = instance.getModel();
            if (model instanceof PO) {
                PO po = (PO)model;
                MTable table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
                if (!this.hasAccess(table, true)) {
                    return this.accessDenied(id, "change server state");
                }
                if (po.getAD_Client_ID() != Env.getAD_Client_ID((Properties)Env.getCtx())) {
                    return this.accessDenied(id, "change server state");
                }
                MRole role = MRole.getDefault();
                if (!role.isOrgAccess(po.getAD_Org_ID(), true)) {
                    return this.accessDenied(id, "change server state");
                }
            } else {
                return this.accessDenied(id, "change server state");
            }
        }
        String error = null;
        error = instance.isStarted() ? serverMgr.stop(id) : serverMgr.start(id);
        if (!Util.isEmpty((String)error, (boolean)true)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(error).build().toString()).build();
        }
        return this.getServer(id);
    }

    private Response accessDenied(String id, String request) {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorBuilder().status(Response.Status.FORBIDDEN).title("Access denied").append("Access denied for " + request + " request: " + id).build().toString()).build();
    }

    @Override
    public Response runServer(String id) {
        String error;
        IServerManager serverMgr = this.getServerManager();
        ServerInstance instance = serverMgr.getServerInstance(id);
        if (instance == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid server Id").append("No match found for server id: ").append(id).build().toString()).build();
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            AdempiereProcessor model = instance.getModel();
            if (model instanceof PO) {
                PO po = (PO)model;
                MTable table = MTable.get((Properties)Env.getCtx(), (int)po.get_Table_ID());
                if (!this.hasAccess(table, true)) {
                    return this.accessDenied(id, "run now");
                }
                if (po.getAD_Client_ID() != Env.getAD_Client_ID((Properties)Env.getCtx())) {
                    return this.accessDenied(id, "run now");
                }
                MRole role = MRole.getDefault();
                if (!role.isOrgAccess(po.getAD_Org_ID(), true)) {
                    return this.accessDenied(id, "run now");
                }
            } else {
                return this.accessDenied(id, "run now");
            }
        }
        if (!Util.isEmpty((String)(error = serverMgr.runNow(id)), (boolean)true)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(error).build().toString()).build();
        }
        return this.getServer(id);
    }

    private IServerManager getServerManager() {
        if (ClusterUtil.getClusterService() != null) {
            return ClusterServerMgr.getInstance();
        }
        return AdempiereServerMgr.get();
    }

    @Override
    public Response reloadServers() {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.accessDenied("", "reload servers");
        }
        IServerManager serverMgr = this.getServerManager();
        String error = serverMgr.reload();
        if (!Util.isEmpty((String)error, (boolean)true)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(error).build().toString()).build();
        }
        return this.getServers();
    }

    @Override
    public Response getScheduler(int id) {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            return this.accessDenied(String.valueOf(id), "get scheduler");
        }
        if (id <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Invalid scheduler id").append("Invalid scheduler id: ").append(id).build().toString()).build();
        }
        MScheduler scheduler = new MScheduler(Env.getCtx(), id, null);
        if (scheduler.getAD_Scheduler_ID() != id) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid scheduler Id").append("No match found for scheduler id: ").append(id).build().toString()).build();
        }
        IServerManager serverMgr = this.getServerManager();
        ServerInstance instance = serverMgr.getServerInstance(scheduler.getServerID());
        JsonObject json = this.toSchedulerJson(scheduler, instance);
        return Response.ok((Object)json.toString()).build();
    }

    private JsonObject toSchedulerJson(MScheduler scheduler, ServerInstance instance) {
        String state = null;
        state = instance == null ? Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerNotSchedule") : (instance.isStarted() ? Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStarted") : Msg.getMsg((Properties)Env.getCtx(), (String)"SchedulerStopped"));
        IPOSerializer serializer = IPOSerializer.getPOSerializer("AD_Scheduler", scheduler.getClass());
        JsonObject json = serializer.toJson((PO)scheduler);
        json.addProperty("server-id", scheduler.getServerID());
        json.addProperty("scheduler-state", state);
        if (instance != null && instance.getClusterMember() != null) {
            json.addProperty("node-id", instance.getClusterMember().getId());
            json.addProperty("node-host-name", instance.getClusterMember().getAddress().getCanonicalHostName());
            json.addProperty("node-port", (Number)instance.getClusterMember().getPort());
        }
        return json;
    }

    @Override
    public Response addScheduler(int id) {
        IServerManager serverMgr;
        ServerInstance instance;
        if (id <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Invalid scheduler id").append("Invalid scheduler id: ").append(id).build().toString()).build();
        }
        MScheduler scheduler = new MScheduler(Env.getCtx(), id, null);
        if (scheduler.getAD_Scheduler_ID() != id) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid scheduler Id").append("No match found for scheduler id: ").append(id).build().toString()).build();
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            MTable table = MTable.get((Properties)Env.getCtx(), (int)688);
            if (!this.hasAccess(table, true)) {
                return this.accessDenied(scheduler.getServerID(), "add scheduler");
            }
            if (scheduler.getAD_Client_ID() != Env.getAD_Client_ID((Properties)Env.getCtx())) {
                return this.accessDenied(scheduler.getServerID(), "add scheduler");
            }
            MRole role = MRole.getDefault();
            if (!role.isOrgAccess(scheduler.getAD_Org_ID(), true)) {
                return this.accessDenied(scheduler.getServerID(), "add scheduler");
            }
        }
        if ((instance = (serverMgr = this.getServerManager()).getServerInstance(scheduler.getServerID())) != null) {
            JsonObject json = this.toSchedulerJson(scheduler, instance);
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)json.toString()).build();
        }
        String error = serverMgr.addScheduler(scheduler);
        if (!Util.isEmpty((String)error, (boolean)true)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(error).build().toString()).build();
        }
        instance = serverMgr.getServerInstance(scheduler.getServerID());
        JsonObject json = this.toSchedulerJson(scheduler, instance);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)json.toString()).build();
    }

    @Override
    public Response removeScheduler(int id) {
        IServerManager serverMgr;
        String error;
        if (id <= 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorBuilder().status(Response.Status.BAD_REQUEST).title("Invalid scheduler id").append("Invalid scheduler id: ").append(id).build().toString()).build();
        }
        MScheduler scheduler = new MScheduler(Env.getCtx(), id, null);
        if (scheduler.getAD_Scheduler_ID() != id) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorBuilder().status(Response.Status.NOT_FOUND).title("Invalid scheduler Id").append("No match found for scheduler id: ").append(id).build().toString()).build();
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            MTable table = MTable.get((Properties)Env.getCtx(), (int)688);
            if (!this.hasAccess(table, true)) {
                return this.accessDenied(scheduler.getServerID(), "remove scheduler");
            }
            if (scheduler.getAD_Client_ID() != Env.getAD_Client_ID((Properties)Env.getCtx())) {
                return this.accessDenied(scheduler.getServerID(), "remove scheduler");
            }
            MRole role = MRole.getDefault();
            if (!role.isOrgAccess(scheduler.getAD_Org_ID(), true)) {
                return this.accessDenied(scheduler.getServerID(), "remove scheduler");
            }
        }
        if (!Util.isEmpty((String)(error = (serverMgr = this.getServerManager()).removeScheduler(scheduler)), (boolean)true)) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorBuilder().status(Response.Status.INTERNAL_SERVER_ERROR).title("Server error").append("Server error with exception: ").append(error).build().toString()).build();
        }
        ServerInstance instance = serverMgr.getServerInstance(scheduler.getServerID());
        JsonObject json = this.toSchedulerJson(scheduler, instance);
        return Response.ok((Object)json.toString()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAccess(MTable table, boolean rw) {
        MRole role = MRole.getDefault();
        if (role == null) {
            return false;
        }
        StringBuilder builder = new StringBuilder("SELECT DISTINCT a.AD_Window_ID FROM AD_Window a JOIN AD_Tab b ON a.AD_Window_ID=b.AD_Window_ID ");
        builder.append("WHERE a.IsActive='Y' AND b.IsActive='Y' AND b.AD_Table_ID=?");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)builder.toString(), null);){
                stmt.setInt(1, table.getAD_Table_ID());
                ResultSet rs = stmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        return false;
                    }
                    int windowId = rs.getInt(1);
                    Boolean b = role.getWindowAccess(windowId);
                    if (b == null) continue;
                    if (!rw) return true;
                    if (b.booleanValue()) break;
                }
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

