/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.timeplot;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.zkforge.timeline.data.OccurEvent;
import org.zkforge.timeplot.Timeplot;
import org.zkforge.timeplot.data.PlotData;
import org.zkforge.timeplot.data.PlotDataSource;
import org.zkforge.timeplot.event.OverPlotEvent;
import org.zkforge.timeplot.geometry.TimeGeometry;
import org.zkforge.timeplot.geometry.ValueGeometry;
import org.zkforge.timeplot.operator.Operator;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSetAttribute;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class Plotinfo
extends HtmlBasedComponent {
    private ListModel _dataModel;
    private LinkedList _dataList;
    private ListModel _eventModel;
    private LinkedList _eventList;
    private transient ListDataListener _dataListener;
    private transient ListDataListener _eventListener;
    private String _fillColor;
    private String _dotColor;
    private String _lineColor;
    private float _lineWidth;
    private float _eventLineWidth;
    private float _dotRadius;
    private boolean _showValues;
    private boolean _hideValueFlag;
    private boolean _roundValues;
    private int _valuesOpacity;
    private int _bubbleWidth;
    private int _bubbleHeight;
    private PlotDataSource _pds;
    private Operator _operator;
    private String _eventSourceUri;
    private ValueGeometry _valueGeometry;
    private TimeGeometry _timeGeometry;
    private List _addEvtList;
    private List _mdyEvtList;
    private List _rmEvtList;
    private List _addDataList;
    private List _mdyDataList;
    private List _rmDataList;
    private static final String ATTR_ON_ADD_EVENT_RESPONSE = "org.zkforge.timeplot.onAddEventResponse";
    private static final String ATTR_ON_REMOVE_EVENT_RESPONSE = "org.zkforge.timeplot.onRemoveEventResponse";
    private static final String ATTR_ON_MODIFY_EVENT_RESPONSE = "org.zkforge.timeplot.onModifyEventResponse";
    private static final String ATTR_ON_ADD_DATA_RESPONSE = "org.zkforge.timeplot.onAddDataResponse";
    private static final String ATTR_ON_REMOVE_DATA_RESPONSE = "org.zkforge.timeplot.onRemoveDataResponse";
    private static final String ATTR_ON_MODIFY_DATA_RESPONSE = "org.zkforge.timeplot.onModifyDataResponse";

    public Plotinfo() {
        Plotinfo.addClientEvent((Class)Plotinfo.class, (String)"onOverPlotData", (int)0);
        this._dataList = new LinkedList();
        this._eventList = new LinkedList();
        this._lineWidth = 1.0f;
        this._eventLineWidth = 1.0f;
        this._dotRadius = 2.0f;
        this._showValues = false;
        this._hideValueFlag = false;
        this._roundValues = false;
        this._valuesOpacity = 75;
        this._bubbleWidth = 300;
        this._bubbleHeight = 200;
        this._pds = null;
        this._operator = null;
        this._eventSourceUri = null;
        this._valueGeometry = null;
        this._timeGeometry = null;
    }

    public int getBubbleHeight() {
        return this._bubbleHeight;
    }

    public void setBubbleHeight(int bubbleHeight) {
        if (this._bubbleHeight != bubbleHeight) {
            this._bubbleHeight = bubbleHeight;
            this.smartUpdate("bubbleHeight", this._bubbleHeight);
        }
    }

    public int getBubbleWidth() {
        return this._bubbleWidth;
    }

    public void setBubbleWidth(int bubbleWidth) {
        if (this._bubbleWidth != bubbleWidth) {
            this._bubbleWidth = bubbleWidth;
            this.smartUpdate("bubbleWidth", this._bubbleWidth);
        }
    }

    public PlotDataSource getPlotDataSource() {
        return this._pds;
    }

    public void setPlotDataSource(PlotDataSource pds) {
        if (!Objects.equals((Object)this._pds, (Object)pds)) {
            this._pds = pds;
            this.smartUpdate("separator", this._pds.getSeparator());
            this.smartUpdate("dataSourceColumn", this._pds.getDataSourceColumn());
            this.smartUpdate("dataSourceUri", new EncodedURL(this._pds.getDataSourceUri()));
        }
    }

    public String getDotColor() {
        return this._dotColor;
    }

    public void setDotColor(String dotColor) {
        if (!Objects.equals((Object)this._dotColor, (Object)dotColor)) {
            this._dotColor = dotColor;
            this.smartUpdate("dotColor", this._dotColor);
        }
    }

    public float getDotRadius() {
        return this._dotRadius;
    }

    public void setDotRadius(float dotRadius) {
        if (this._dotRadius != dotRadius) {
            this._dotRadius = dotRadius;
            this.smartUpdate("dotRadius", String.valueOf(this._dotRadius));
        }
    }

    public float getEventLineWidth() {
        return this._eventLineWidth;
    }

    public void setEventLineWidth(float eventLineWidth) {
        if (this._eventLineWidth != eventLineWidth) {
            this._eventLineWidth = eventLineWidth;
            this.smartUpdate("eventLineWidth", String.valueOf(this._eventLineWidth));
        }
    }

    public String getEventSourceUri() {
        return this._eventSourceUri;
    }

    public void setEventSourceUri(String eventSourceUri) {
        if (!Objects.equals((Object)this._eventSourceUri, (Object)eventSourceUri)) {
            this._eventSourceUri = eventSourceUri;
            this.smartUpdate("eventSourceUri", new EncodedURL(this._eventSourceUri));
        }
    }

    public void repaint() {
        Component parent = this.getParent();
        if (parent != null) {
            ((Timeplot)this.getParent()).repaint();
        }
    }

    public String getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(String fillColor) {
        if (!Objects.equals((Object)this._fillColor, (Object)fillColor)) {
            this._fillColor = fillColor;
            this.smartUpdate("fillColor", this._fillColor);
        }
    }

    public String getLineColor() {
        return this._lineColor;
    }

    public void setLineColor(String lineColor) {
        if (!Objects.equals((Object)this._lineColor, (Object)lineColor)) {
            this._lineColor = lineColor;
            this.smartUpdate("lineColor", this._lineColor);
        }
    }

    public float getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        if (this._lineWidth != lineWidth) {
            this._lineWidth = lineWidth;
            this.smartUpdate("lineWidth", String.valueOf(this._lineWidth));
        }
    }

    public boolean isRoundValues() {
        return this._roundValues;
    }

    public void setRoundValues(boolean roundValues) {
        if (this._roundValues != roundValues) {
            this._roundValues = roundValues;
            this.smartUpdate("roundValues", this._roundValues);
        }
    }

    public boolean isShowValues() {
        return this._showValues;
    }

    public void setShowValues(boolean showValues) {
        if (this._showValues != showValues) {
            this._showValues = showValues;
            this.smartUpdate("showValues", this._showValues);
            this.repaint();
        }
    }

    public boolean isHideValueFlag() {
        return this._hideValueFlag;
    }

    public void setHideValueFlag(boolean hideValueFlag) {
        if (this._hideValueFlag != hideValueFlag) {
            this._hideValueFlag = hideValueFlag;
            this.smartUpdate("hideValueFlag", this._hideValueFlag);
            this.repaint();
        }
    }

    public int getValuesOpacity() {
        return this._valuesOpacity;
    }

    public void setValuesOpacity(int valuesOpacity) {
        if (this._valuesOpacity != valuesOpacity) {
            this._valuesOpacity = valuesOpacity;
            this.smartUpdate("valuesOpacity", this._valuesOpacity);
            this.repaint();
        }
    }

    private String getJSONResponse(List list) {
        StringBuffer sb = new StringBuffer().append('[');
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(']');
        list.clear();
        return sb.toString();
    }

    public void onAddEventResponse() {
        this.removeAttribute(ATTR_ON_ADD_EVENT_RESPONSE);
        this.response("addPlotEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "addPlotEvent", (Object)this.getJSONResponse(this._addEvtList)));
    }

    public void onRemoveEventResponse() {
        this.removeAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE);
        this.response("removePlotEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "removePlotEvent", (Object)this.getJSONResponse(this._rmEvtList)));
    }

    public void onModifyEventResponse() {
        this.removeAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE);
        this.response("modifyPlotEvent" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "modifyPlotEvent", (Object)this.getJSONResponse(this._mdyEvtList)));
    }

    public void onAddDataResponse() {
        this.removeAttribute(ATTR_ON_ADD_DATA_RESPONSE);
        this.response("addPlotData" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "addPlotData", (Object)this.getJSONResponse(this._addDataList)));
    }

    public void onRemoveDataResponse() {
        this.removeAttribute(ATTR_ON_REMOVE_DATA_RESPONSE);
        this.response("removePlotData" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "removePlotData", (Object)this.getJSONResponse(this._rmDataList)));
    }

    public void onModifyDataResponse() {
        this.removeAttribute(ATTR_ON_MODIFY_DATA_RESPONSE);
        this.response("modifyPlotData" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "modifyPlotData", (Object)this.getJSONResponse(this._mdyDataList)));
    }

    public void addPlotEvent(OccurEvent oe) {
        if (this._addEvtList == null) {
            this._addEvtList = new LinkedList();
        }
        this._addEvtList.add(oe);
        if (this.getAttribute(ATTR_ON_ADD_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_ADD_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onAddEventResponse", (Component)this, null);
        }
    }

    public void modifyPlotEvent(OccurEvent oe) {
        if (this._mdyEvtList == null) {
            this._mdyEvtList = new LinkedList();
        }
        this._mdyEvtList.add(oe);
        if (this.getAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_MODIFY_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onModifyEventResponse", (Component)this, null);
        }
    }

    public void removePlotEvent(OccurEvent oe) {
        if (this._rmEvtList == null) {
            this._rmEvtList = new LinkedList();
        }
        this._rmEvtList.add(oe);
        if (this.getAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_REMOVE_EVENT_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onRemoveEventResponse", (Component)this, null);
        }
    }

    public void addPlotData(PlotData pd) {
        if (this._addDataList == null) {
            this._addDataList = new LinkedList();
        }
        this._addDataList.add(pd);
        if (this.getAttribute(ATTR_ON_ADD_DATA_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_ADD_DATA_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onAddDataResponse", (Component)this, null);
        }
    }

    public void modifyPlotData(PlotData pd) {
        if (this._mdyDataList == null) {
            this._mdyDataList = new LinkedList();
        }
        this._mdyDataList.add(pd);
        if (this.getAttribute(ATTR_ON_MODIFY_DATA_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_MODIFY_DATA_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onModifyDataResponse", (Component)this, null);
        }
    }

    public void removePlotData(PlotData pd) {
        if (this._rmDataList == null) {
            this._rmDataList = new LinkedList();
        }
        this._rmDataList.add(pd);
        if (this.getAttribute(ATTR_ON_REMOVE_DATA_RESPONSE) == null) {
            this.setAttribute(ATTR_ON_REMOVE_DATA_RESPONSE, Boolean.TRUE);
            Events.postEvent((int)-20000, (String)"onRemoveDataResponse", (Component)this, null);
        }
    }

    public ListModel getDataModel() {
        return this._dataModel;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Plotinfo.this.onListDataChange(event);
                }
            };
        }
        this._dataModel.addListDataListener(this._dataListener);
    }

    public void setDataModel(ListModel dataModel) {
        if (dataModel == null) {
            return;
        }
        if (this._dataModel != null) {
            this._dataModel.removeListDataListener(this._dataListener);
            this.response("removeAllPlotData" + this.getUuid(), (AuResponse)new AuSetAttribute((Component)this, "removeAllPlotData", null));
        }
        this._dataModel = dataModel;
        if (this._dataModel != null) {
            this.initDataListener();
            int j = this._dataModel.getSize();
            for (int i = 0; i < j; ++i) {
                PlotData pd = (PlotData)this._dataModel.getElementAt(i);
                this._dataList.add(pd);
                this.addPlotData(pd);
            }
        }
    }

    protected void onListDataChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        block0 : switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    PlotData pd = (PlotData)this._dataModel.getElementAt(i);
                    this._dataList.add(pd);
                    this.addPlotData(pd);
                }
                break;
            }
            case 2: {
                int count = upper - lower + 1;
                int nowCount = 0;
                ListIterator it = this._dataList.listIterator(upper + 1);
                while (it.hasPrevious()) {
                    PlotData pd = (PlotData)it.previous();
                    if (count == nowCount) break block0;
                    it.remove();
                    this._dataList.remove(pd);
                    this.removePlotData(pd);
                    ++nowCount;
                }
                break;
            }
            case 0: {
                for (int i = lower; i <= upper; ++i) {
                    PlotData pd = (PlotData)this._dataModel.getElementAt(i);
                    this._dataList.set(i, pd);
                    this.modifyPlotData(pd);
                }
                break;
            }
        }
    }

    public ListModel getEventModel() {
        return this._eventModel;
    }

    private void initEventListener() {
        if (this._eventListener == null) {
            this._eventListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Plotinfo.this.onListEventChange(event);
                }
            };
        }
        this._eventModel.addListDataListener(this._eventListener);
    }

    public void setEventModel(ListModel eventModel) {
        int i;
        int j;
        if (this._eventModel != null) {
            this._eventModel.removeListDataListener(this._eventListener);
            j = this._eventList.size();
            for (i = 0; i < j; ++i) {
                this.removePlotEvent((OccurEvent)this._eventList.removeFirst());
            }
        }
        this._eventModel = eventModel;
        if (this._eventModel != null) {
            this.initEventListener();
            j = this._eventModel.getSize();
            for (i = 0; i < j; ++i) {
                OccurEvent oe = (OccurEvent)this._eventModel.getElementAt(i);
                this._eventList.add(oe);
                this.addPlotEvent(oe);
            }
        }
    }

    protected void onListEventChange(ListDataEvent event) {
        int lower = event.getIndex0();
        int upper = event.getIndex1();
        block0 : switch (event.getType()) {
            case 1: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._eventModel.getElementAt(i);
                    this._eventList.add(oe);
                    this.addPlotEvent(oe);
                }
                break;
            }
            case 2: {
                int count = upper - lower + 1;
                int nowCount = 0;
                ListIterator it = this._eventList.listIterator(upper + 1);
                while (it.hasPrevious()) {
                    OccurEvent oe = (OccurEvent)it.previous();
                    if (count == nowCount) break block0;
                    it.remove();
                    this._eventList.remove(oe);
                    this.removePlotEvent(oe);
                    ++nowCount;
                }
                break;
            }
            case 0: {
                for (int i = lower; i <= upper; ++i) {
                    OccurEvent oe = (OccurEvent)this._eventModel.getElementAt(i);
                    this._eventList.set(i, oe);
                    this.modifyPlotEvent(oe);
                }
                break;
            }
        }
    }

    public TimeGeometry getTimeGeometry() {
        return this._timeGeometry;
    }

    public void setTimeGeometry(TimeGeometry timeGeometry) {
        if (!Objects.equals((Object)this._timeGeometry, (Object)timeGeometry)) {
            this._timeGeometry = timeGeometry;
            this.smartUpdate("timeGeometry", this.converTimeGeometryToJSON());
        }
    }

    public ValueGeometry getValueGeometry() {
        return this._valueGeometry;
    }

    public void setValueGeometry(ValueGeometry valueGeometry) {
        if (!Objects.equals((Object)this._valueGeometry, (Object)valueGeometry)) {
            this._valueGeometry = valueGeometry;
            this.smartUpdate("valueGeometry", this.converValueGeometryToJSON());
        }
    }

    public Operator getOperator() {
        return this._operator;
    }

    public void setOperator(Operator operator) {
        if (!Objects.equals((Object)this._operator, (Object)operator)) {
            this._operator = operator;
            super.invalidate();
            if (this.getParent() != null) {
                this.getParent().invalidate();
            }
        }
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Timeplot)) {
            throw new UiException("Unsupported parent for plotinfo: " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        throw new UiException("no allow child in plotinfo");
    }

    List getEventModelList() {
        return Collections.unmodifiableList(this._eventList);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onEventClick")) {
            Plotinfo comp = (Plotinfo)request.getComponent();
            if (comp == null) {
                throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
            }
            JSONArray data = (JSONArray)request.getData().get("data");
            if (data != null && data.size() != 1) {
                throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
            }
            OccurEvent oe = null;
            Iterator it = comp.getEventModelList().iterator();
            while (it.hasNext()) {
                OccurEvent o = (OccurEvent)it.next();
                if (!((String)data.get(0)).equals(o.getId())) continue;
                oe = o;
                break;
            }
            Events.postEvent((Event)new Event("onEventClick", (Component)comp, oe));
        } else if (cmd.equals("onOverPlotData")) {
            Events.postEvent((Event)OverPlotEvent.getOverPlotEvent(request));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "fillColor", this._fillColor);
        this.render(renderer, "dotColor", this._dotColor);
        this.render(renderer, "lineColor", this._lineColor);
        if (this._lineWidth != 1.0f) {
            renderer.render("lineWidth", this._lineWidth);
        }
        if (this._eventLineWidth != 1.0f) {
            renderer.render("eventLineWidth", this._eventLineWidth);
        }
        if (this._dotRadius != 2.0f) {
            renderer.render("dotRadius", this._dotRadius);
        }
        if (this._showValues) {
            renderer.render("showValues", this._showValues);
        }
        if (this._hideValueFlag) {
            renderer.render("hideValueFlag", this._hideValueFlag);
        }
        if (!this._roundValues) {
            renderer.render("roundValues", this._roundValues);
        }
        if (this._valuesOpacity != 75) {
            renderer.render("valuesOpacity", this._valuesOpacity);
        }
        if (this._bubbleWidth != 300) {
            renderer.render("bubbleWidth", this._bubbleWidth);
        }
        if (this._bubbleHeight != 200) {
            renderer.render("bubbleHeight", this._bubbleHeight);
        }
        if (this._operator != null) {
            this.render(renderer, "operator", this._operator.getOperator());
            String params = this._operator.getParams();
            if (params != null) {
                this.render(renderer, "operatorParams", params);
            }
        }
        if (this._pds != null) {
            this.render(renderer, "separator", this._pds.getSeparator());
            renderer.render("dataSourceColumn", this._pds.getDataSourceColumn());
            this.render(renderer, "dataSourceUri", this.getEncodedURL(this._pds.getDataSourceUri()));
        }
        if (this._eventSourceUri != null) {
            this.render(renderer, "eventSourceUri", this.getEncodedURL(this._eventSourceUri));
        }
        if (this._valueGeometry != null) {
            this.render(renderer, "valueGeometry", this.converValueGeometryToJSON());
        }
        if (this._timeGeometry != null) {
            this.render(renderer, "timeGeometry", this.converTimeGeometryToJSON());
        }
    }

    private String converValueGeometryToJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)this._valueGeometry.toString());
        json.put((Object)"id", (Object)this._valueGeometry.getValueGeometryId());
        json.put((Object)"axisColor", (Object)this._valueGeometry.getAxisColor());
        json.put((Object)"gridColor", (Object)this._valueGeometry.getGridColor());
        json.put((Object)"gridLineWidth", (Object)String.valueOf(this._valueGeometry.getGridLineWidth()));
        json.put((Object)"axisLabelsPlacement", (Object)this._valueGeometry.getAxisLabelsPlacement());
        json.put((Object)"gridSpacing", (Object)String.valueOf(this._valueGeometry.getGridSpacing()));
        json.put((Object)"gridType", (Object)this._valueGeometry.getGridType());
        json.put((Object)"gridShortSize", (Object)String.valueOf(this._valueGeometry.getGridShortSize()));
        json.put((Object)"min", (Object)String.valueOf(this._valueGeometry.getMin()));
        json.put((Object)"max", (Object)String.valueOf(this._valueGeometry.getMax()));
        return json.toString();
    }

    private String converTimeGeometryToJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)this._timeGeometry.getTimeGeometryId());
        json.put((Object)"axisColor", (Object)this._timeGeometry.getAxisColor());
        json.put((Object)"gridColor", (Object)this._timeGeometry.getGridColor());
        json.put((Object)"gridLineWidth", (Object)String.valueOf(this._timeGeometry.getGridLineWidth()));
        json.put((Object)"axisLabelsPlacement", (Object)this._timeGeometry.getAxisLabelsPlacement());
        json.put((Object)"gridStep", (Object)String.valueOf(this._timeGeometry.getGridStep()));
        json.put((Object)"gridStepRange", (Object)String.valueOf(this._timeGeometry.getGridStepRange()));
        json.put((Object)"min", (Object)this.getTimeStr(this._timeGeometry.getMin()));
        json.put((Object)"max", (Object)this.getTimeStr(this._timeGeometry.getMax()));
        json.put((Object)"timeValuePosition", (Object)this._timeGeometry.getTimeValuePosition());
        Map formats = this._timeGeometry.getFormats();
        if (formats.size() > 0) {
            JSONObject formatJson = new JSONObject();
            Iterator it = formats.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                formatJson.put(me.getKey(), me.getValue());
            }
            json.put((Object)"formats", (Object)formatJson.toString());
        }
        return json.toString();
    }

    private String getTimeStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        if (date != null) {
            return format.format(date);
        }
        return "0";
    }

    private String getEncodedURL(String url) {
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(url) : "";
    }

    public boolean isChildable() {
        return false;
    }

    static {
        Plotinfo.addClientEvent((Class)Plotinfo.class, (String)"onEventClick", (int)16384);
    }

    private class EncodedURL
    implements DeferredValue {
        private String url;

        public EncodedURL(String url) {
            this.url = url;
        }

        public Object getValue() {
            return Plotinfo.this.getEncodedURL(this.url);
        }
    }
}

