/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.gmaps.AbstractMapModel;
import org.zkoss.zk.ui.UiException;

public class MapModelList
extends AbstractMapModel
implements List,
Serializable {
    private static final long serialVersionUID = 200807141409L;
    protected List _list;

    public MapModelList(List list, boolean live) {
        this._list = live ? list : new ArrayList(list);
    }

    public MapModelList() {
        this._list = new ArrayList();
    }

    public MapModelList(Collection c) {
        this._list = new ArrayList(c);
    }

    public MapModelList(Object[] array) {
        this._list = new ArrayList(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._list.add(array[j]);
        }
    }

    public MapModelList(int initialCapacity) {
        this._list = new ArrayList(initialCapacity);
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new UiException("fromIndex must less than toIndex: fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        int sz = this._list.size();
        if (sz == fromIndex) {
            return;
        }
        LinkedList lst = new LinkedList();
        ListIterator it = this._list.listIterator(fromIndex);
        for (int index = fromIndex; it.hasNext() && index < toIndex; ++index) {
            Object item = it.next();
            it.remove();
            lst.add(item);
        }
        this.fireEvent(2, lst);
    }

    public List getInnerList() {
        return this._list;
    }

    public void clear() {
        if (!this._list.isEmpty()) {
            this._list.clear();
            this.fireEvent(4, null);
        }
    }

    public Collection getItemsIn(double swlat, double swlng, double nelat, double nelng, double cenlat, double cenlng, int zoom) {
        return Collections.unmodifiableList(this._list);
    }

    public void add(int index, Object element) {
        this._list.add(index, element);
        this.fireEvent(1, this._list.subList(index, index + 1));
    }

    public boolean add(Object o) {
        int i1 = this._list.size();
        boolean ret = this._list.add(o);
        this.fireEvent(1, this._list.subList(i1, i1 + 1));
        return ret;
    }

    public boolean addAll(Collection c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i1 = this._list.size();
        int i2 = i1 + sz - 1;
        boolean ret = this._list.addAll(c);
        this.fireEvent(1, this._list.subList(i1, i2));
        return ret;
    }

    public boolean addAll(int index, Collection c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i2 = index + sz - 1;
        boolean ret = this._list.addAll(index, c);
        this.fireEvent(1, this._list.subList(index, i2));
        return ret;
    }

    public boolean contains(Object elem) {
        boolean ret = this._list.contains(elem);
        return ret;
    }

    public boolean containsAll(Collection c) {
        return this._list.containsAll(c);
    }

    public boolean equals(Object o) {
        return this._list.equals(o instanceof MapModelList ? ((MapModelList)o)._list : o);
    }

    public Object get(int index) {
        return this._list.get(index);
    }

    public int hashCode() {
        return this._list.hashCode();
    }

    public String toString() {
        return this._list.toString();
    }

    public int indexOf(Object elem) {
        return this._list.indexOf(elem);
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator _it;
            private Object _current;
            {
                this._it = MapModelList.this._list.iterator();
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                this._it.remove();
                MapModelList.this.fireEvent(2, Collections.singletonList(this._current));
            }
        };
    }

    public int lastIndexOf(Object elem) {
        return this._list.lastIndexOf(elem);
    }

    public ListIterator listIterator() {
        return this._list.listIterator();
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private ListIterator _it;
            private Object _current;
            {
                this._it = MapModelList.this._list.listIterator(index);
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                this._it.remove();
                MapModelList.this.fireEvent(2, Collections.singletonList(this._current));
            }

            public void add(Object arg0) {
                this._it.add(arg0);
                MapModelList.this.fireEvent(1, Collections.singletonList(arg0));
            }

            public boolean hasPrevious() {
                return this._it.hasPrevious();
            }

            public int nextIndex() {
                return this._it.nextIndex();
            }

            public Object previous() {
                this._current = this._it.previous();
                return this._current;
            }

            public int previousIndex() {
                return this._it.previousIndex();
            }

            public void set(Object arg0) {
                this._it.set(arg0);
                MapModelList.this.fireEvent(2, Collections.singletonList(this._current));
                MapModelList.this.fireEvent(1, Collections.singletonList(arg0));
            }
        };
    }

    public Object remove(int index) {
        Object ret = this._list.remove(index);
        if (ret != null) {
            this.fireEvent(2, Collections.singleton(ret));
        }
        return ret;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this._list == c || this == c) {
            this.clear();
            return true;
        }
        return this.removePartial(c, true);
    }

    public boolean retainAll(Collection c) {
        if (this._list == c || this == c) {
            return false;
        }
        return this.removePartial(c, false);
    }

    private boolean removePartial(Collection c, boolean exclude) {
        boolean removed = false;
        int index = 0;
        int begin = -1;
        LinkedList lst = new LinkedList();
        Iterator it = this._list.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (c.contains(item) == exclude) {
                if (begin < 0) {
                    begin = index;
                }
                removed = true;
                it.remove();
                lst.add(item);
            }
            ++index;
        }
        if (begin >= 0) {
            this.fireEvent(2, lst);
        }
        return removed;
    }

    public Object set(int index, Object element) {
        Object ret = this._list.set(index, element);
        this.fireEvent(2, Collections.singletonList(ret));
        this.fireEvent(1, Collections.singletonList(element));
        return ret;
    }

    public int size() {
        return this._list.size();
    }

    public List subList(int fromIndex, int toIndex) {
        List list = this._list.subList(fromIndex, toIndex);
        return new MapModelList(list);
    }

    public Object[] toArray() {
        return this._list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._list.toArray(a);
    }
}

