/*
 * Decompiled with CFR 0.152.
 */
package net.sf.compilo.report;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import net.sf.compilo.report.FileFilter;
import net.sf.compilo.report.ReportProcessor;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ReportInfo {
    private String reportFile;
    private boolean directPrint;
    private int ReportViewID = 0;
    private int PrintFormatID = 0;
    private int m_AD_Process_ID;
    private JasperReport jasperReport;
    private HashMap<String, String> subReport = new HashMap();
    private boolean hasSubReport = false;
    private boolean hasError = false;
    private ArrayList<String> errorMsg = new ArrayList();
    private static final CLogger log = CLogger.getCLogger(ReportInfo.class);

    public ReportInfo() {
    }

    public ReportInfo(int AD_Process_ID) {
        this.m_AD_Process_ID = AD_Process_ID;
        this.getReportDefinition(AD_Process_ID);
        if (this.hasError) {
            return;
        }
        this.processReport(this.reportFile);
    }

    protected File processReport(String reportFile) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("ReportInfo.processReport - " + reportFile);
        }
        File JasperDesignFile = new File(reportFile);
        String JasperReportFile = reportFile.replaceAll(".jrxml", ".jasper").replaceAll(".xml", ".jasper");
        File jasperFile = new File(JasperReportFile);
        JasperReport jasperReport = null;
        if (jasperFile.exists()) {
            if (JasperDesignFile.lastModified() <= jasperFile.lastModified()) {
                try {
                    jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)jasperFile.getAbsolutePath());
                }
                catch (JRException e) {
                    this.jasperReport = null;
                    log.saveError("ReportServer.processReport: Can not load report - ", (Exception)((Object)e));
                }
            } else {
                jasperReport = this.compileReport(JasperDesignFile, jasperFile);
            }
        } else {
            jasperReport = this.compileReport(JasperDesignFile, jasperFile);
        }
        if (this.hasError) {
            return null;
        }
        if (this.jasperReport == null) {
            this.jasperReport = jasperReport;
        }
        if (jasperReport != null) {
            String[] extension = new String[]{".xml", "jrxml"};
            File[] subreports = JasperDesignFile.getParentFile().listFiles(new FileFilter(JasperReportFile.replaceAll(".jasper", "") + "Subreport", JasperDesignFile.getParentFile(), extension));
            int i = 0;
            while (i < subreports.length) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("The subreport file @ " + subreports[i].getAbsolutePath());
                }
                File sub = this.processReport(subreports[i].getAbsolutePath());
                String subName = sub.getName();
                int pos = sub.getName().indexOf(46);
                if (pos != -1) {
                    subName = subName.substring(0, pos);
                }
                this.subReport.put(subName, sub.getAbsolutePath());
                this.hasSubReport = true;
                ++i;
            }
        }
        if (this.hasError) {
            return null;
        }
        return jasperFile;
    }

    private JasperReport compileReport(File reportFile, File jasperFile) {
        JasperReport res = null;
        try {
            JasperCompileManager.compileReportToFile((String)reportFile.getAbsolutePath(), (String)jasperFile.getAbsolutePath());
            jasperFile.setLastModified(reportFile.lastModified());
            res = (JasperReport)JRLoader.loadObjectFromFile((String)jasperFile.getAbsolutePath());
        }
        catch (JRException e) {
            if (log.isLoggable(Level.INFO)) {
                log.info("ReportInfo.compileReport- " + String.valueOf((Object)e));
            }
            this.errorMsg.add("ReportInfo.compileReport- " + e.getMessage());
            this.hasError = true;
        }
        return res;
    }

    private void getReportDefinition(int AD_Process_ID) {
        String tmp;
        String path;
        ResultSet rs;
        CPreparedStatement pstmt;
        String sql;
        block11: {
            sql = "SELECT pr.JasperReport, pr.AD_ReportView_ID, pr.AD_PrintFormat_ID, pr.IsDirectPrint from AD_Process pr WHERE pr.AD_Process_Id=? ";
            pstmt = null;
            rs = null;
            pstmt = DB.prepareStatement((String)sql, (int)1003, (int)1007, null);
            pstmt.setInt(1, AD_Process_ID);
            rs = pstmt.executeQuery();
            path = null;
            tmp = null;
            if (rs.next()) {
                path = rs.getString(1);
                this.ReportViewID = rs.getInt(2);
                this.PrintFormatID = rs.getInt(3);
                tmp = rs.getString(4);
                break block11;
            }
            String err = "ReportData.getReportFileName data not found -" + sql;
            this.errorMsg.add(err);
            this.hasError = true;
            log.saveError(err, "");
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            return;
        }
        try {
            this.directPrint = tmp.equalsIgnoreCase("y");
            File xmlfile = new File(ReportProcessor.REPORT_HOME, path);
            if (xmlfile != null && xmlfile.exists()) {
                this.reportFile = xmlfile.getAbsolutePath();
            } else {
                this.hasError = true;
                log.saveError("Error", "The Report File not exists");
            }
        }
        catch (SQLException e) {
            log.saveError("ReportData.getReportFileName - " + sql, (Exception)e);
            this.errorMsg.add("ReportData.getReportFileName - " + sql);
            this.hasError = true;
            this.directPrint = false;
            this.reportFile = null;
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception ee) {
            try {
                log.saveError("ReportData.getReportFileName - " + sql, ee);
                this.errorMsg.add("ReportData.getReportFileName - " + sql);
                this.hasError = true;
                this.directPrint = false;
                this.reportFile = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Get ReportDefinition-" + this.toString());
        }
    }

    protected boolean isDirty() {
        if (this.reportFile == null) {
            return true;
        }
        if (this.jasperReport == null) {
            return true;
        }
        if (this.isDirty(this.reportFile)) {
            return true;
        }
        if (this.hasSubReport) {
            String[] extension = new String[]{".xml", "jrxml"};
            File reportDesighFile = new File(this.reportFile);
            File[] subreports = reportDesighFile.getParentFile().listFiles(new FileFilter(this.reportFile.replaceAll(".jasper", "") + "Subreport", reportDesighFile.getParentFile(), extension));
            int i = 0;
            while (i < subreports.length) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("The subreport file @ " + subreports[i].getAbsolutePath());
                }
                if (this.isDirty(subreports[i].getAbsolutePath())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isDirty(String file) {
        File JasperDesignFile = new File(file);
        String JasperReportFile = this.reportFile.replaceAll(".jrxml", ".jasper").replaceAll(".xml", ".jasper");
        File jasperFile = new File(JasperReportFile);
        if (jasperFile.exists()) {
            return JasperDesignFile.lastModified() > jasperFile.lastModified();
        }
        return true;
    }

    public String toString() {
        return "AD_Process_ID:" + this.m_AD_Process_ID + " XMLFile:" + this.reportFile + " ReportView_ID:" + this.ReportViewID;
    }

    public int getReportViewID() {
        return this.ReportViewID;
    }

    protected void setReportViewID(int reportViewID) {
        this.ReportViewID = reportViewID;
    }

    protected boolean isDirectPrint() {
        return this.directPrint;
    }

    protected ArrayList<String> getErrorMsg() {
        return this.errorMsg;
    }

    protected boolean hasError() {
        return this.hasError;
    }

    public JasperReport getJasperReport() {
        return this.jasperReport;
    }

    protected HashMap<String, String> getSubReport() {
        return this.subReport;
    }
}

