/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import org.compiere.model.AccessSqlParser;
import org.compiere.model.MColumn;
import org.compiere.model.MColumnAccess;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MInfoWindowTest
extends AbstractTestCase {
    @Test
    public void testColumnAccess() {
        MInfoWindow infoWindow = new MInfoWindow(Env.getCtx(), 0, this.getTrxName());
        MInfoColumn infoColumn1 = new MInfoColumn(Env.getCtx(), 0, this.getTrxName());
        MInfoColumn infoColumn2 = new MInfoColumn(Env.getCtx(), 0, this.getTrxName());
        infoWindow.setAD_Table_ID(135);
        infoWindow.setName("testColumnAccess");
        infoWindow.setFromClause("Test t");
        infoWindow.saveCrossTenantSafeEx();
        infoColumn1.setAD_InfoWindow_ID(infoWindow.get_ID());
        infoColumn1.setName("T_Amount");
        infoColumn1.setEntityType("U");
        infoColumn1.setSelectClause("t.T_Amount");
        infoColumn1.setSeqNo(10);
        infoColumn1.setAD_Reference_ID(12);
        infoColumn1.setColumnName("T_Amount");
        infoColumn1.saveCrossTenantSafeEx();
        infoColumn2.setAD_InfoWindow_ID(infoWindow.get_ID());
        infoColumn2.setName("T_DateTime");
        infoColumn2.setEntityType("U");
        infoColumn2.setSelectClause("t.T_DateTime");
        infoColumn2.setSeqNo(10);
        infoColumn2.setAD_Reference_ID(16);
        infoColumn2.setColumnName("T_DateTime");
        infoColumn2.saveCrossTenantSafeEx();
        infoWindow.getInfoColumns(true, true);
        AccessSqlParser.TableInfo[] tableInfos = infoWindow.getTableInfos();
        MInfoColumn[] infoColumns = infoWindow.getInfoColumns(tableInfos);
        Assertions.assertNotNull((Object)infoColumns);
        Assertions.assertEquals((int)2, (int)infoColumns.length);
        MRole role = MRole.getDefault();
        MTable table = MTable.get((int)infoWindow.getAD_Table_ID());
        MColumn column = table.getColumn(infoColumn2.getColumnName());
        Assertions.assertNotNull((Object)column);
        MColumnAccess ca = new MColumnAccess(Env.getCtx(), 0, null);
        ca.setAD_Role_ID(role.getAD_Role_ID());
        ca.setIsExclude(true);
        ca.setAD_Table_ID(table.get_ID());
        ca.setAD_Column_ID(column.get_ID());
        ca.setIsReadOnly(false);
        ca.saveEx();
        try {
            role.loadAccess(true);
            infoColumns = infoWindow.getInfoColumns(tableInfos);
            Assertions.assertNotNull((Object)infoColumns);
            Assertions.assertEquals((int)1, (int)infoColumns.length);
            try {
                PO.setCrossTenantSafe();
                infoColumn1.setSelectClause("Test.T_Amount");
                infoColumn1.saveEx();
                infoColumn2.setSelectClause("Test.T_DateTime");
                infoColumn2.saveEx();
                infoWindow.setFromClause("Test");
                infoWindow.getInfoColumns(true, true);
                infoWindow.saveEx();
            }
            finally {
                PO.clearCrossTenantSafe();
            }
            infoWindow.getInfoColumns(true, true);
            tableInfos = infoWindow.getTableInfos();
            infoColumns = infoWindow.getInfoColumns(tableInfos);
            Assertions.assertNotNull((Object)infoColumns);
            Assertions.assertEquals((int)1, (int)infoColumns.length);
            try {
                PO.setCrossTenantSafe();
                infoColumn1.setSelectClause("T_Amount");
                infoColumn1.saveEx();
                infoColumn2.setSelectClause("T_DateTime");
                infoColumn2.saveEx();
                infoWindow.setFromClause("Test");
                infoWindow.getInfoColumns(true, true);
                infoWindow.saveEx();
            }
            finally {
                PO.clearCrossTenantSafe();
            }
            infoWindow.getInfoColumns(true, true);
            tableInfos = infoWindow.getTableInfos();
            infoColumns = infoWindow.getInfoColumns(tableInfos);
            Assertions.assertNotNull((Object)infoColumns);
            Assertions.assertEquals((int)1, (int)infoColumns.length);
        }
        finally {
            this.rollback();
            ca.deleteEx(true);
        }
    }
}

