/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.adempiere.util.Callback;
import org.adempiere.webui.apps.BackgroundJob;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MNote;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class ReportTest
extends AbstractTestCase {
    @Test
    public void testPDFFileName() {
        MProcess orderReport = MProcess.get((Properties)Env.getCtx(), (int)110);
        MOrder order = new MOrder(Env.getCtx(), 108, this.getTrxName());
        String fileName = order.getDocumentNo() + ".pdf";
        ProcessInfo pi = new ProcessInfo(orderReport.getName(), orderReport.getAD_Process_ID());
        pi.setRecord_ID(order.getC_Order_ID());
        pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        pi.setTable_ID(order.get_Table_ID());
        pi.setPrintPreview(true);
        pi.setIsBatch(true);
        pi.setPDFFileName(fileName);
        pi.setReportType("PDF");
        MPInstance instance = new MPInstance(orderReport, order.get_Table_ID(), order.getC_Order_ID(), order.getC_Order_UU());
        instance.saveEx();
        ServerProcessCtl.process((ProcessInfo)pi, null);
        File file = pi.getPDFReport();
        Assertions.assertEquals((Object)file.getName(), (Object)fileName);
    }

    @Test
    public void testBackgroundJob() {
        MProcess process = MProcess.get((int)236);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        pi.setReportType("PDF");
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        Callback createParaCallback = id -> {
            if (id > 0) {
                MPInstancePara para = new MPInstancePara(Env.getCtx(), id.intValue(), 10);
                para.setParameter("M_Product_Category_ID", "" + DictionaryIDs.M_Product_Category.PATIO.id);
                para.saveEx();
            }
        };
        ScheduledFuture future = BackgroundJob.create((ProcessInfo)pi).withNotificationType("N").withInitialDelay(10).run(createParaCallback);
        Assertions.assertNotNull((Object)future, (String)"Failed to schedule background job");
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        Assertions.assertTrue((pi.getAD_PInstance_ID() > 0 ? 1 : 0) != 0, (String)"Failed to create background process instance");
        Assertions.assertFalse((boolean)pi.isError(), (String)("Error creating background job: " + pi.getSummary()));
        MPInstance pinstance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        Assertions.assertEquals((int)pi.getAD_PInstance_ID(), (int)pinstance.get_ID(), (String)"Failed to retrive background process instance");
        try {
            pi = (ProcessInfo)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
        Assertions.assertFalse((boolean)pi.isError(), (String)("Error running background job: " + pi.getSummary()));
        pinstance.load(null, new String[0]);
        Assertions.assertFalse((boolean)pinstance.isProcessing(), (String)"Timeout waiting for background job to complete");
        Query query = new Query(Env.getCtx(), "AD_Note", "AD_Table_ID=? AND Record_ID=?", null);
        MNote note = (MNote)query.setParameters(new Object[]{282, pinstance.getAD_PInstance_ID()}).first();
        Assertions.assertNotNull((Object)note, (String)"Failed to retrieve notice");
        MAttachment attachment = note.getAttachment();
        Assertions.assertEquals((int)1, (int)attachment.getEntryCount(), (String)"Unexpected number of notice attachment");
        MAttachmentEntry entry = attachment.getEntry(0);
        Assertions.assertNotNull((Object)entry, (String)"Failed to retrieve attachment entry");
        Assertions.assertTrue((entry.getName() != null && entry.getName().toUpperCase().contains(".PDF") ? 1 : 0) != 0, (String)"No PDF report attach to notice");
    }
}

