/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.POWrapper;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.compiere.model.I_Test;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.MTest;
import org.compiere.model.MUser;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={SoftAssertionsExtension.class})
public class QueryTest
extends AbstractTestCase {
    @InjectSoftAssertions
    SoftAssertions softly;

    @Test
    public void testNoTable() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Query(Env.getCtx(), "NO_TABLE_DEFINED", null, this.getTrxName()));
    }

    @Test
    public void testList() throws Exception {
        List list = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").list();
        Assertions.assertEquals((int)2, (int)list.size(), (String)"Invalid list size");
        Assertions.assertEquals((Object)((MTable)list.get(0)).getTableName(), (Object)"C_Invoice", (String)"Invalid object 1");
        Assertions.assertEquals((Object)((MTable)list.get(1)).getTableName(), (Object)"M_InOut", (String)"Invalid object 2");
    }

    @Test
    public void testStream() throws Exception {
        Stream stream = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").stream();
        this.softly.assertThat(stream.map(X_AD_Table::getTableName)).containsExactly((Object[])new String[]{"C_Invoice", "M_InOut"});
    }

    @Test
    public void testScroll() throws Exception {
        POResultSet rs = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").scroll();
        try {
            int i = 0;
            while (rs.hasNext()) {
                MTable t = (MTable)rs.next();
                if (i == 0) {
                    Assertions.assertEquals((Object)"C_Invoice", (Object)t.getTableName(), (String)("Invalid object " + i));
                } else if (i == 1) {
                    Assertions.assertEquals((Object)"M_InOut", (Object)t.getTableName(), (String)("Invalid object " + i));
                } else {
                    Assertions.fail((String)"More objects retrieved than expected");
                }
                ++i;
            }
        }
        finally {
            DB.close((POResultSet)rs);
        }
    }

    @Test
    public void testIterate() throws Exception {
        Iterator it = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").iterate();
        int i = 0;
        while (it.hasNext()) {
            MTable t = (MTable)it.next();
            if (i == 0) {
                Assertions.assertEquals((Object)"C_Invoice", (Object)t.getTableName(), (String)("Invalid object " + i));
            } else if (i == 1) {
                Assertions.assertEquals((Object)"M_InOut", (Object)t.getTableName(), (String)("Invalid object " + i));
            } else {
                Assertions.fail((String)"More objects retrieved than expected");
            }
            ++i;
        }
    }

    @Test
    public void testCount() throws Exception {
        int count = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").count();
        Assertions.assertEquals((int)2, (int)count, (String)"Invalid count");
    }

    @Test
    public void testCount_BadSQL() throws Exception {
        Assertions.assertThrows(DBException.class, () -> new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?) AND BAD_SQL", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").count());
    }

    @Test
    public void testCount_NoValues() throws Exception {
        int count = new Query(Env.getCtx(), "AD_Table", "1=2", this.getTrxName()).count();
        Assertions.assertEquals((int)0, (int)count, (String)"Counter should be ZERO");
    }

    @Test
    public void testFirst() throws Exception {
        MTable t = (MTable)new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").first();
        Assertions.assertEquals((Object)"C_Invoice", (Object)t.getTableName(), (String)"Invalid object");
    }

    @Test
    public void testFirstId() throws Exception {
        int id = new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").firstId();
        int expectedId = 318;
        Assertions.assertEquals((int)expectedId, (int)id, (String)"Invalid ID");
    }

    @Test
    public void testFirstOnly() throws Exception {
        MTable t = (MTable)new Query(Env.getCtx(), "AD_Table", "AD_Table_ID=?", this.getTrxName()).setParameters(new Object[]{318}).firstOnly();
        Assertions.assertEquals((int)318, (int)t.get_ID(), (String)"Invalid table ID");
        Assertions.assertThrows(DBException.class, () -> new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").firstOnly());
    }

    @Test
    public void testFirstIdOnly() throws Exception {
        int expectedId = 318;
        int id = new Query(Env.getCtx(), "AD_Table", "AD_Table_ID=?", this.getTrxName()).setParameters(new Object[]{expectedId}).firstIdOnly();
        Assertions.assertEquals((int)expectedId, (int)id, (String)"Invalid table ID");
        Assertions.assertThrows(DBException.class, () -> new Query(Env.getCtx(), "AD_Table", "TableName IN (?,?)", this.getTrxName()).setParameters(new Object[]{"C_Invoice", "M_InOut"}).setOrderBy("TableName").firstIdOnly());
    }

    @Test
    public void testPaging() {
        DB.executeUpdateEx((String)"DELETE FROM Test WHERE Name LIKE 'QueryTest%'", (String)this.getTrxName());
        int i = 101;
        while (i <= 130) {
            MTest testPo = new MTest(Env.getCtx(), "QueryTest", i, this.getTrxName());
            testPo.save();
            ++i;
        }
        Query query = new Query(Env.getCtx(), "Test", "Name LIKE 'QueryTest%'", this.getTrxName()).setClient_ID().setOrderBy("T_Integer");
        List list = query.list();
        Assertions.assertEquals((int)list.size(), (int)30, (String)"Query list without paging brought more records than expected");
        MTest test = (MTest)query.first();
        Assertions.assertEquals((int)test.getT_Integer(), (int)101, (String)"Query first get wrong record");
        query.setPageSize(10);
        list = query.list();
        Assertions.assertEquals((int)list.size(), (int)10, (String)"Query list with paging no skip brought more records than expected");
        Assertions.assertEquals((int)((MTest)list.get(0)).getT_Integer(), (int)101, (String)"Query list with paging no skip get wrong first record");
        query.setRecordstoSkip(10);
        list = query.list();
        Assertions.assertEquals((int)list.size(), (int)10, (String)"Query list with paging and skip brought more records than expected");
        Assertions.assertEquals((int)((MTest)list.get(0)).getT_Integer(), (int)111, (String)"Query list with paging and skip get wrong first record");
        query.setRecordstoSkip(25);
        list = query.list();
        Assertions.assertEquals((int)list.size(), (int)5, (String)"Query list last page with paging and skipbrought more records than expected");
        Assertions.assertEquals((int)((MTest)list.get(0)).getT_Integer(), (int)126, (String)"Query list last page with paging and skip get wrong first record");
        query.setPageSize(0);
        query.setRecordstoSkip(10);
        list = query.list();
        Assertions.assertEquals((int)list.size(), (int)20, (String)"Query list with skip without paging brought more records than expected");
        Assertions.assertEquals((int)((MTest)list.get(0)).getT_Integer(), (int)111, (String)"Query list with skip without paging get wrong first record");
    }

    @Test
    public void testSetClient_ID() throws Exception {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        String sql = "SELECT COUNT(*) FROM C_Invoice WHERE IsActive='Y' AND AD_Client_ID=" + AD_Client_ID;
        int targetCount = DB.getSQLValue(null, (String)sql);
        int count = new Query(Env.getCtx(), "C_Invoice", "1=1", this.getTrxName()).setOnlyActiveRecords(true).setClient_ID().count();
        Assertions.assertEquals((int)targetCount, (int)count, (String)"Invoice # not match");
    }

    @Test
    public void testGet_IDs() throws Exception {
        int[] ids = new Query(Env.getCtx(), "AD_Element", "AD_Element_ID IN (101, 102)", this.getTrxName()).setOrderBy("AD_Element_ID").getIDs();
        Assertions.assertNotNull((Object)ids);
        Assertions.assertEquals((int)2, (int)ids.length);
        Assertions.assertEquals((int)101, (int)ids[0]);
        Assertions.assertEquals((int)102, (int)ids[1]);
    }

    @Test
    public void testAggregate() throws Exception {
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        String sqlFrom = "FROM C_InvoiceLine WHERE IsActive='Y' AND AD_Client_ID=" + AD_Client_ID;
        Query query = new Query(Env.getCtx(), "C_InvoiceLine", null, this.getTrxName()).setOnlyActiveRecords(true).setClient_ID();
        Assertions.assertEquals((Object)DB.getSQLValueBDEx((String)this.getTrxName(), (String)("SELECT COUNT(*) " + sqlFrom), (Object[])new Object[0]), (Object)query.aggregate(null, "COUNT"), (String)"COUNT not match");
        Assertions.assertEquals((Object)DB.getSQLValueBDEx((String)this.getTrxName(), (String)("SELECT SUM(LineNetAmt+TaxAmt) " + sqlFrom), (Object[])new Object[0]), (Object)query.aggregate("LineNetAmt+TaxAmt", "SUM"), (String)"SUM not match");
        Assertions.assertEquals((Object)DB.getSQLValueBDEx((String)this.getTrxName(), (String)("SELECT MIN(LineNetAmt) " + sqlFrom), (Object[])new Object[0]), (Object)query.aggregate("LineNetAmt", "MIN"), (String)"MIN not match");
        Assertions.assertEquals((Object)DB.getSQLValueBDEx((String)this.getTrxName(), (String)("SELECT MAX(LineNetAmt) " + sqlFrom), (Object[])new Object[0]), (Object)query.aggregate("LineNetAmt", "MAX"), (String)"MAX not match");
        Assertions.assertEquals((Object)DB.getSQLValueStringEx((String)this.getTrxName(), (String)("SELECT MAX(Description) " + sqlFrom), (Object[])new Object[0]), (Object)((String)query.aggregate("Description", "MAX", String.class)), (String)"MAX not match (String)");
        Assertions.assertEquals((Object)DB.getSQLValueTSEx((String)this.getTrxName(), (String)("SELECT MAX(Updated) " + sqlFrom), (Object[])new Object[0]), (Object)((Timestamp)query.aggregate("Updated", "MAX", Timestamp.class)), (String)"MAX not match (Timestamp)");
        Assertions.assertThrows(DBException.class, () -> query.aggregate("*", null), (String)"No Aggregate Function defined");
        Assertions.assertThrows(DBException.class, () -> query.aggregate(null, "SUM"), (String)"No Expression defined");
    }

    @Test
    public void testOnlySelection() throws Exception {
        int AD_PInstance_ID;
        int count = DB.getSQLValueEx(null, (String)"SELECT Count(AD_PInstance_ID) FROM AD_PInstance", (Object[])new Object[0]);
        if (count == 0) {
            new MPInstance(MProcess.get((Properties)Env.getCtx(), (int)199), 0, 0, null);
        }
        Assertions.assertTrue(((AD_PInstance_ID = DB.getSQLValueEx(null, (String)"SELECT MAX(AD_PInstance_ID) FROM AD_PInstance", (Object[])new Object[0])) > 0 ? 1 : 0) != 0);
        ArrayList<KeyNamePair> elements = new ArrayList<KeyNamePair>();
        elements.add(new KeyNamePair(102, null));
        elements.add(new KeyNamePair(104, null));
        DB.executeUpdateEx((String)("DELETE FROM T_Selection WHERE AD_PInstance_ID=" + AD_PInstance_ID), (String)this.getTrxName());
        DB.createT_SelectionNew((int)AD_PInstance_ID, elements, (String)this.getTrxName());
        String whereClause = "1=1";
        int[] ids = new Query(Env.getCtx(), "AD_Element", whereClause, this.getTrxName()).setOnlySelection(AD_PInstance_ID).setOrderBy("AD_Element_ID").getIDs();
        Assertions.assertEquals((int)elements.size(), (int)ids.length, (String)"Resulting number of elements differ");
        int i = 0;
        while (i < elements.size()) {
            int expected = ((KeyNamePair)elements.get(i)).getKey();
            Assertions.assertEquals((int)expected, (int)ids[i], (String)("Element " + i + " not equals"));
            ++i;
        }
    }

    @Test
    public void testVirtualColumnLoad() {
        MTest testPo = new MTest(Env.getCtx(), this.getClass().getName(), 1, this.getTrxName());
        testPo.save();
        BigDecimal expected = new BigDecimal("123.45");
        Query query = new Query(Env.getCtx(), "Test", "Test_ID=?", this.getTrxName());
        testPo = query.setParameters(new Object[]{testPo.get_ID()}).first();
        I_Test testRecord = (I_Test)POWrapper.create((Object)testPo, I_Test.class);
        Assertions.assertTrue((testPo.get_ValueOld("TestVirtualQty") == null ? 1 : 0) != 0);
        Assertions.assertEquals((Object)expected.setScale(2, RoundingMode.HALF_UP), (Object)testRecord.getTestVirtualQty().setScale(2, RoundingMode.HALF_UP), (String)"Wrong value returned");
        testPo = query.setNoVirtualColumn(false).setParameters(new Object[]{testPo.get_ID()}).first();
        Assertions.assertTrue((testPo.get_ValueOld("TestVirtualQty") != null ? 1 : 0) != 0);
        testRecord = (I_Test)POWrapper.create((Object)testPo, I_Test.class);
        Assertions.assertEquals((Object)expected, (Object)testRecord.getTestVirtualQty().setScale(2, RoundingMode.HALF_UP), (String)"Wrong value returned");
        testPo = query.setVirtualColumns(new String[]{"TestVirtualQty"}).setParameters(new Object[]{testPo.get_ID()}).first();
        Assertions.assertTrue((testPo.get_ValueOld("TestVirtualQty") != null ? 1 : 0) != 0);
        testRecord = (I_Test)POWrapper.create((Object)testPo, I_Test.class);
        Assertions.assertEquals((Object)expected, (Object)testRecord.getTestVirtualQty().setScale(2, RoundingMode.HALF_UP), (String)"Wrong value returned");
    }

    @Test
    public void testTableDirectJoin() {
        Query query = new Query(Env.getCtx(), "AD_User", "AD_User_ID=?", this.getTrxName());
        query.addTableDirectJoin("C_BPartner");
        query.setParameters(new Object[]{DictionaryIDs.AD_User.GARDEN_USER.id});
        MUser user = (MUser)query.first();
        Assertions.assertNotNull((Object)user, (String)"Failed to retrieve garden user record");
        String sql = query.getSQL();
        Assertions.assertTrue((boolean)sql.toLowerCase().contains("inner join c_bpartner on (ad_user.c_bpartner_id=c_bpartner.c_bpartner_id)"), (String)"Unexpected SQL clause generated from query");
    }

    @Test
    public void testPartialPO() {
        Query query = new Query(Env.getCtx(), "M_Product", "M_Product_ID=?", this.getTrxName());
        MProduct product = (MProduct)query.setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).first();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNotNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)product.is_Immutable());
        product = (MProduct)query.selectColumns(new String[]{"Name", "Value"}).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).first();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)product.is_Immutable());
        product = (MProduct)query.selectColumns(new String[0]).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).first();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNotNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)product.is_Immutable());
        List list = query.selectColumns(new String[]{"Name", "Value"}).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).list();
        product = (MProduct)list.get(0);
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)product.is_Immutable());
        product = (MProduct)query.selectColumns(new String[]{"Name", "Value"}).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).firstOnly();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)product.is_Immutable());
        product = (MProduct)query.selectColumns(new String[]{"Name", "Value"}).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).scroll().next();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)product.is_Immutable());
        Stream stream = query.selectColumns(new String[]{"Name", "Value"}).setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id}).stream();
        product = (MProduct)stream.findFirst().get();
        Assertions.assertTrue((product.getM_Product_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((product.getAD_Client_ID() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)product.getName());
        Assertions.assertNotNull((Object)product.getValue());
        Assertions.assertNull((Object)product.getProductType());
        Assertions.assertTrue((product.getM_Product_Category_ID() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)product.is_Immutable());
    }
}

