/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.GenericPaymentExport;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GenericPaymentExportTest
extends AbstractTestCase {
    @Test
    public void testGenericPaymentExport() {
        if (DB.isPostgreSQL()) {
            Ini.setProperty((String)"PostgreSQLNative", (String)"Y");
        }
        int seedFarm = 120;
        int moneyBankCheckAccount = 100;
        int commissionCharge = 101;
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setIsSOTrx(false);
        invoice.setC_DocTypeTarget_ID();
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setBPartner(new MBPartner(Env.getCtx(), seedFarm, this.getTrxName()));
        invoice.setDateInvoiced(TimeUtil.getDay((long)System.currentTimeMillis()));
        invoice.setGrandTotal(new BigDecimal("10.00"));
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine il = new MInvoiceLine(invoice);
        il.setLine(10);
        il.setC_Charge_ID(commissionCharge);
        il.setPrice(new BigDecimal("10.00"));
        il.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        String paymentRule = "S";
        MPaySelection ps = new MPaySelection(Env.getCtx(), 0, this.getTrxName());
        ps.setAD_Org_ID(this.getAD_Org_ID());
        ps.setC_BankAccount_ID(moneyBankCheckAccount);
        ps.setPayDate(TimeUtil.getDay((long)System.currentTimeMillis()));
        ps.setName("Test@" + System.currentTimeMillis());
        ps.setTotalAmt(new BigDecimal("10.00"));
        ps.saveEx();
        MPaySelectionLine psl = new MPaySelectionLine(ps, 10, paymentRule);
        psl.setIsSOTrx(false);
        psl.setPayAmt(ps.getTotalAmt());
        psl.setDifferenceAmt(BigDecimal.ZERO);
        psl.setDiscountAmt(BigDecimal.ZERO);
        psl.setOpenAmt(ps.getTotalAmt());
        psl.setWriteOffAmt(BigDecimal.ZERO);
        psl.setC_Invoice_ID(invoice.getC_Invoice_ID());
        psl.saveEx();
        MPaySelectionCheck psc = new MPaySelectionCheck(psl, paymentRule);
        psc.saveEx();
        GenericPaymentExport export = new GenericPaymentExport();
        StringBuffer err = new StringBuffer();
        File file = null;
        try {
            file = File.createTempFile("GenericPaymentExportTest", "csv");
        }
        catch (IOException e) {
            Assertions.fail((Throwable)e);
            return;
        }
        int noOfLines = export.exportToFile(new MPaySelectionCheck[]{psc}, false, "S", file, err);
        Assertions.assertEquals((int)2, (int)noOfLines);
    }
}

