/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.apps.form.Match;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchFormTest
extends AbstractTestCase {
    @Test
    public void testMatchReceiptToPO() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(Env.getCtx(), 0, this.getTrxName());
        receipt.setBPartner(bpartner);
        receipt.setIsSOTrx(false);
        receipt.setC_DocType_ID(DictionaryIDs.C_DocType.MM_RECEIPT.id);
        receipt.setM_Warehouse_ID(this.getM_Warehouse_ID());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        BigDecimal receiptQty = new BigDecimal("1");
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setProduct(product);
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.setLine(10);
        receiptLine.setQty(receiptQty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] columnLayout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl();
        MiniTableImpl toTable = new MiniTableImpl();
        fromTable.prepareTable(columnLayout, null, null, false, null);
        toTable.prepareTable(columnLayout, null, null, false, null);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for Material Receipt line");
                int qty = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(2), 1, true, true, true, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Order Line: " + fromTable.getRowCount()));
        int selectedOrderRow = -1;
        int i2 = 0;
        while (i2 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i2, 1);
            if (order.getDocumentNo().equals(docNo)) {
                int matched = ((Number)toTable.getValueAt(i2, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for PO line");
                int qty = ((Number)toTable.getValueAt(i2, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for PO line");
                selectedOrderRow = i2;
                break;
            }
            ++i2;
        }
        Assertions.assertTrue((selectedOrderRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched PO line");
        IDColumn idColumn = (IDColumn)toTable.getValueAt(selectedOrderRow, 0);
        idColumn.setSelected(true);
        match.cmd_process((IMiniTable)fromTable, (IMiniTable)toTable, 0, 1, match.getMatchTypeText(2), new BigDecimal(1));
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
    }

    @Test
    public void testMatchInvoiceToReceipt() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setBPartner(bpartner);
        invoice.setDateAcct(order.getDateAcct());
        invoice.setDateInvoiced(order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        BigDecimal qtyInvoiced = new BigDecimal(1);
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setProduct(product);
        invoiceLine.setLine(10);
        invoiceLine.setQty(qtyInvoiced);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] columnLayout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl(columnLayout);
        MiniTableImpl toTable = new MiniTableImpl(columnLayout);
        match.cmd_search((IMiniTable)fromTable, 0, match.getMatchTypeText(1), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched vendor invoice: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (invoice.getDocumentNo().equals(docNo)) {
                int matched = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for purchase order line");
                int qty = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for vendor invoice line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched vendor invoice line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(1), 0, true, true, true, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched material receipt Line: " + fromTable.getRowCount()));
        int selectedReceiptRow = -1;
        int i2 = 0;
        while (i2 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i2, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched = ((Number)toTable.getValueAt(i2, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for material receipt line");
                int qty = ((Number)toTable.getValueAt(i2, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for material receipt line");
                selectedReceiptRow = i2;
                break;
            }
            ++i2;
        }
        Assertions.assertTrue((selectedReceiptRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched material receipt line");
        IDColumn idColumn = (IDColumn)toTable.getValueAt(selectedReceiptRow, 0);
        idColumn.setSelected(true);
        match.cmd_process((IMiniTable)fromTable, (IMiniTable)toTable, 0, 0, match.getMatchTypeText(1), new BigDecimal(1));
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        receiptLine.load(this.getTrxName(), new String[0]);
        MMatchInv[] matchInvs = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvs.length, (String)"Unexpected number of MatchInv for invoice line");
    }

    @Test
    public void testMatchReceiptToInvoice() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setC_OrderLine_ID(orderLine.get_ID());
        receiptLine.setLine(10);
        receiptLine.setProduct(product);
        receiptLine.setQty(BigDecimal.ONE);
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        receiptLine.setM_Locator_ID(M_Locator_ID);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        if (!receipt.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt.getAD_Client_ID(), (int)319, (int)receipt.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)receipt.isPosted());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setBPartner(bpartner);
        invoice.setDateAcct(order.getDateAcct());
        invoice.setDateInvoiced(order.getDateOrdered());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        BigDecimal qtyInvoiced = new BigDecimal(1);
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setProduct(product);
        invoiceLine.setLine(10);
        invoiceLine.setQty(qtyInvoiced);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0);
        }
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)invoice.isPosted());
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] columnLayout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl(columnLayout);
        MiniTableImpl toTable = new MiniTableImpl(columnLayout);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(0), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched material receipt: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for material receipt line");
                int qty = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for material receipt line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched material receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(0), 1, true, true, true, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched vendor invoice Line: " + fromTable.getRowCount()));
        int selectedInvoiceRow = -1;
        int i2 = 0;
        while (i2 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i2, 1);
            if (invoice.getDocumentNo().equals(docNo)) {
                int matched = ((Number)toTable.getValueAt(i2, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for vendor invoice line");
                int qty = ((Number)toTable.getValueAt(i2, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for vendor invoice line");
                selectedInvoiceRow = i2;
                break;
            }
            ++i2;
        }
        Assertions.assertTrue((selectedInvoiceRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched vendor invoice line");
        IDColumn idColumn = (IDColumn)toTable.getValueAt(selectedInvoiceRow, 0);
        idColumn.setSelected(true);
        match.cmd_process((IMiniTable)fromTable, (IMiniTable)toTable, 0, 1, match.getMatchTypeText(0), new BigDecimal(1));
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced value");
        receiptLine.load(this.getTrxName(), new String[0]);
        MMatchInv[] matchInvs = MMatchInv.getInvoiceLine((Properties)Env.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvs.length, (String)"Unexpected number of MatchInv for invoice line");
    }
}

