/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTest;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MTestTest
extends AbstractTestCase {
    private static final String TestInGardenWorld = "6846b9eb-aff1-47c8-8b50-e9632b39c0c7";
    private static final String TestInSystem = "d08e9de9-39e5-485c-ad50-e8bc7ee0f575";

    @Test
    public void testReadingUpdatingTest() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTest test = new MTest(ctx, TestInGardenWorld, trxName);
        test.setDescription("Test setting description");
        test.saveEx();
        test.load(trxName, new String[0]);
        String newDescription = test.getDescription();
        Assertions.assertTrue((boolean)newDescription.startsWith("Test setting description"));
        MTest testSys = new MTest(ctx, TestInSystem, trxName);
        testSys.setDescription("Test setting description");
        AdempiereException thrown = (AdempiereException)Assertions.assertThrows(AdempiereException.class, () -> testSys.saveEx(), (String)"Expected test.SaveEx() to throw cross tenant error, but it didn't");
        Assertions.assertTrue((boolean)thrown.getMessage().startsWith("Cross tenant PO "));
    }

    @Test
    public void testInsertingTest() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTest test = new MTest(ctx, "", trxName);
        test.setName("Test UU record created on JUnit test");
        test.saveEx();
        test.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"Test UU record created on JUnit test", (Object)test.getName());
        String uukey = test.getTest_UU();
        String uuid = test.get_UUID();
        Assertions.assertTrue((boolean)Util.isUUID((String)uukey));
        Assertions.assertEquals((Object)uukey, (Object)uuid);
    }

    @Test
    public void testDeletingTest() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MTest test = new MTest(ctx, TestInGardenWorld, trxName);
        test.deleteEx(true);
        MTest test2 = new MTest(ctx, TestInGardenWorld, trxName);
        Assertions.assertFalse((boolean)test2.get_UUID().equals(TestInGardenWorld));
    }
}

