/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class BankStatementTest
extends AbstractTestCase {
    @Test
    public void testCompleteStatement() {
        MBankStatement stmt = new MBankStatement(Env.getCtx(), 0, this.getTrxName());
        stmt.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        stmt.setStatementDate(today);
        stmt.setDateAcct(today);
        stmt.setName("" + System.currentTimeMillis());
        stmt.setDocAction("CO");
        stmt.setDocStatus("DR");
        stmt.saveEx();
        MBankStatementLine line = new MBankStatementLine(stmt);
        line.setValutaDate(today);
        line.setStatementLineDate(today);
        line.setStmtAmt(new BigDecimal("10.00"));
        line.setTrxAmt(new BigDecimal("10.00"));
        line.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        line.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)stmt, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        stmt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)stmt.getDocStatus());
    }

    @Test
    @ResourceLock(value="ALLOW_REVERSAL_OF_RECONCILED_PAYMENT")
    public void testReversalOfReconciledPayment1() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Query query = new Query(Env.getCtx(), "AD_SysConfig", "Name=? AND AD_Client_ID IN (0, ?)", null);
        MSysConfig sysConfig = (MSysConfig)query.setOrderBy("AD_Client_ID Desc").setParameters(new Object[]{"ALLOW_REVERSAL_OF_RECONCILED_PAYMENT", this.getAD_Client_ID()}).first();
        if (!sysConfig.getValue().equals("Y")) {
            sysConfig.setValue("Y");
            sysConfig.saveCrossTenantSafeEx();
            CacheMgt.get().reset();
        } else {
            sysConfig = null;
        }
        try {
            MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.C_AND_W.id, this.getTrxName());
            DB.getDatabase().forUpdate((PO)bp, 0);
            MPayment payment1 = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment1.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
            payment1.setC_DocType_ID(true);
            payment1.setDocStatus("DR");
            payment1.setDocAction("CO");
            payment1.setPayAmt(Env.ONEHUNDRED);
            payment1.setTenderType("K");
            payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
            payment1.setDateTrx(today);
            payment1.setDateAcct(today);
            payment1.saveEx();
            ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
            payment1.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)pi.isError(), (String)("Error processing payment: " + pi.getSummary()));
            Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
            MBankStatement stmt = new MBankStatement(Env.getCtx(), 0, this.getTrxName());
            stmt.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            stmt.setStatementDate(today);
            stmt.setDateAcct(today);
            stmt.setName("" + System.currentTimeMillis());
            stmt.setDocAction("CO");
            stmt.setDocStatus("DR");
            stmt.saveEx();
            MBankStatementLine line = new MBankStatementLine(stmt);
            line.setValutaDate(today);
            line.setStatementLineDate(today);
            line.setStmtAmt(payment1.getPayAmt());
            line.setTrxAmt(payment1.getPayAmt());
            line.setC_Payment_ID(payment1.getC_Payment_ID());
            line.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
            line.saveEx();
            pi = MWorkflow.runDocumentActionWorkflow((PO)stmt, (String)"CO");
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            stmt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)stmt.getDocStatus());
            payment1.load(this.getTrxName(), new String[0]);
            payment1.setDocAction("RC");
            payment1.saveEx();
            pi = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"RC");
            Assertions.assertFalse((boolean)pi.isError(), (String)("Error reversing payment: " + pi.getSummary()));
            Assertions.assertEquals((Object)"RE", (Object)payment1.getDocStatus(), (String)"Unexpected Payment Document Status");
        }
        finally {
            if (sysConfig != null) {
                sysConfig.setValue("N");
                sysConfig.saveCrossTenantSafeEx();
            }
        }
    }

    @Test
    @ResourceLock(value="ALLOW_REVERSAL_OF_RECONCILED_PAYMENT")
    public void testReversalOfReconciledPayment2() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Query query = new Query(Env.getCtx(), "AD_SysConfig", "Name=? AND AD_Client_ID IN (0, ?)", null);
        MSysConfig sysConfig = (MSysConfig)query.setOrderBy("AD_Client_ID Desc").setParameters(new Object[]{"ALLOW_REVERSAL_OF_RECONCILED_PAYMENT", this.getAD_Client_ID()}).first();
        if (!sysConfig.getValue().equals("N")) {
            sysConfig.setValue("N");
            sysConfig.saveCrossTenantSafeEx();
            CacheMgt.get().reset();
        } else {
            sysConfig = null;
        }
        try {
            MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.C_AND_W.id, this.getTrxName());
            DB.getDatabase().forUpdate((PO)bp, 0);
            MPayment payment1 = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment1.setC_BPartner_ID(DictionaryIDs.C_BPartner.C_AND_W.id);
            payment1.setC_DocType_ID(true);
            payment1.setDocStatus("DR");
            payment1.setDocAction("CO");
            payment1.setPayAmt(Env.ONEHUNDRED);
            payment1.setTenderType("K");
            payment1.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            payment1.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
            payment1.setDateTrx(today);
            payment1.setDateAcct(today);
            payment1.saveEx();
            ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"CO");
            payment1.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)pi.isError(), (String)("Error processing payment: " + pi.getSummary()));
            Assertions.assertEquals((Object)"CO", (Object)payment1.getDocStatus(), (String)("Payment document status is not completed: " + payment1.getDocStatus()));
            MBankStatement stmt = new MBankStatement(Env.getCtx(), 0, this.getTrxName());
            stmt.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            stmt.setStatementDate(today);
            stmt.setDateAcct(today);
            stmt.setName("" + System.currentTimeMillis());
            stmt.setDocAction("CO");
            stmt.setDocStatus("DR");
            stmt.saveEx();
            MBankStatementLine line = new MBankStatementLine(stmt);
            line.setValutaDate(today);
            line.setStatementLineDate(today);
            line.setStmtAmt(payment1.getPayAmt());
            line.setTrxAmt(payment1.getPayAmt());
            line.setC_Payment_ID(payment1.getC_Payment_ID());
            line.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
            line.saveEx();
            pi = MWorkflow.runDocumentActionWorkflow((PO)stmt, (String)"CO");
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            stmt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)stmt.getDocStatus());
            payment1.load(this.getTrxName(), new String[0]);
            payment1.setDocAction("RC");
            payment1.saveEx();
            pi = MWorkflow.runDocumentActionWorkflow((PO)payment1, (String)"RC");
            Assertions.assertTrue((boolean)pi.isError(), (String)"Reversal of reconciled payment should fail here.");
            Assertions.assertTrue((pi.getSummary() != null && pi.getSummary().contains(Msg.getMsg((Properties)Env.getCtx(), (String)"NotAllowReversalOfReconciledPayment")) ? 1 : 0) != 0, (String)("Unexpected error message: " + pi.getSummary()));
        }
        finally {
            if (sysConfig != null) {
                sysConfig.setValue("Y");
                sysConfig.saveCrossTenantSafeEx();
            }
        }
    }
}

