/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.apps.form.TreeMaintenance;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MColumn;
import org.compiere.model.MOrder;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_Test;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.LoginDetails;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Execution(value=ExecutionMode.SAME_THREAD)
public class DBTest
extends AbstractTestCase {
    private static final int TEST_RECORD_ID = 103;
    public static Pattern REG_ACTIVE_CONNECT = Pattern.compile("# Busy Connections:\\s*(\\d+)\\s*,", 66);

    @Test
    public void test_getSQLValueEx() throws Exception {
        int result = DB.getSQLValueEx(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((int)10, (int)result);
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2");
        Assertions.assertEquals((int)-1, (int)result, (String)"No value should be returned");
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueEx(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]));
        int t_integer = DB.getSQLValueEx(null, (String)"select t_integer from test where test_id=?", (Object[])new Object[]{103});
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueEx(null, (String)"update test set t_integer=1 where test_id=?", (Object[])new Object[]{103}));
        int t_integer1 = DB.getSQLValueEx(null, (String)"select t_integer from test where test_id=?", (Object[])new Object[]{103});
        Assertions.assertEquals((int)t_integer, (int)t_integer1, (String)"test.t_integer wrongly updated");
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueEx((String)this.getTrxName(), (String)"update test set t_integer=1 where test_id=?;select t_integer from test where test_id=?", (Object[])new Object[]{103}));
        this.rollback();
        t_integer1 = DB.getSQLValueEx(null, (String)"select t_integer from test where test_id=?", (Object[])new Object[]{103});
        Assertions.assertEquals((int)t_integer, (int)t_integer1, (String)"test.t_integer wrongly updated");
    }

    @Test
    public void test_getSQLValue() throws Exception {
        int result = DB.getSQLValue(null, (String)"SELECT 10 FROM DUAL");
        Assertions.assertEquals((int)10, (int)result);
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2");
        Assertions.assertEquals((int)-1, (int)result, (String)"No value should be returned");
        result = DB.getSQLValue(null, (String)"SELECT 10 FROM INEXISTENT_TABLE");
        Assertions.assertEquals((int)-1, (int)result, (String)"Error should be signaled");
    }

    @Test
    public void test_getSQLValueBDEx() throws Exception {
        BigDecimal result = DB.getSQLValueBDEx(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((Object)BigDecimal.TEN, (Object)result);
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueBDEx(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]));
    }

    @Test
    public void test_getSQLValueBD() throws Exception {
        BigDecimal result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((Object)BigDecimal.TEN, (Object)result);
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        result = DB.getSQLValueBD(null, (String)"SELECT 10 FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"Error should be signaled");
    }

    @Test
    public void test_getSQLValueStringEx() throws Exception {
        String result = DB.getSQLValueStringEx(null, (String)"SELECT 'string' FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((Object)"string", (Object)result);
        result = DB.getSQLValueStringEx(null, (String)"SELECT 10 FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueStringEx(null, (String)"SELECT 'string' FROM INEXISTENT_TABLE", (Object[])new Object[0]));
    }

    @Test
    public void test_getSQLValueString() throws Exception {
        String result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((Object)"string", (Object)result);
        result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        result = DB.getSQLValueString(null, (String)"SELECT 'string' FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"Error should be signaled");
    }

    @Test
    public void test_getSQLValueTSEx() throws Exception {
        Timestamp target = TimeUtil.getDay((int)2008, (int)1, (int)1);
        Timestamp result = DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM", (Object[])new Object[0]);
        Assertions.assertEquals((Object)target, (Object)result);
        result = DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        Assertions.assertThrows(DBException.class, () -> DB.getSQLValueTSEx(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM INEXISTENT_TABLE", (Object[])new Object[0]));
    }

    @Test
    public void test_getSQLValueTS() throws Exception {
        Timestamp target = TimeUtil.getDay((int)2008, (int)1, (int)1);
        Timestamp result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM DUAL", (Object[])new Object[0]);
        Assertions.assertEquals((Object)target, (Object)result);
        result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM AD_SYSTEM WHERE 1=2", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"No value should be returned");
        result = DB.getSQLValueTS(null, (String)"SELECT TO_DATE('2008-01-01','YYYY-MM-DD') FROM INEXISTENT_TABLE", (Object[])new Object[0]);
        Assertions.assertNull((Object)result, (String)"Error should be signaled");
    }

    @Test
    public void test_getValueNamePairs() throws Exception {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(5);
        ValueNamePair[] arr = DB.getValueNamePairs((String)"SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)true, params);
        Assertions.assertEquals((int)7, (int)arr.length, (String)"Invalid size");
        Assertions.assertSame((Object)ValueNamePair.EMPTY, (Object)arr[0], (String)"First value should be EMPTY");
        Assertions.assertEquals((Object)arr[1].getValue(), (Object)"1");
        Assertions.assertEquals((Object)arr[2].getValue(), (Object)"2");
        Assertions.assertEquals((Object)arr[3].getValue(), (Object)"3");
        Assertions.assertEquals((Object)arr[4].getValue(), (Object)"4");
        Assertions.assertEquals((Object)arr[5].getValue(), (Object)"6");
        Assertions.assertEquals((Object)arr[6].getValue(), (Object)"7");
        arr = DB.getValueNamePairs((String)"SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)false, params);
        Assertions.assertEquals((int)6, (int)arr.length, (String)"Invalid size");
        Assertions.assertEquals((Object)arr[0].getValue(), (Object)"1");
        Assertions.assertEquals((Object)arr[1].getValue(), (Object)"2");
        Assertions.assertEquals((Object)arr[2].getValue(), (Object)"3");
        Assertions.assertEquals((Object)arr[3].getValue(), (Object)"4");
        Assertions.assertEquals((Object)arr[4].getValue(), (Object)"6");
        Assertions.assertEquals((Object)arr[5].getValue(), (Object)"7");
    }

    @Test
    public void test_getKeyNamePairs() throws Exception {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(5);
        KeyNamePair[] arr = DB.getKeyNamePairs((String)"SELECT AD_Ref_List_ID, Value FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)true, params);
        Assertions.assertEquals((int)7, (int)arr.length, (String)"Invalid size");
        Assertions.assertSame((Object)KeyNamePair.EMPTY, (Object)arr[0], (String)"First value should be EMPTY");
        Assertions.assertEquals((Object)arr[1].getName(), (Object)"1");
        Assertions.assertEquals((Object)arr[2].getName(), (Object)"2");
        Assertions.assertEquals((Object)arr[3].getName(), (Object)"3");
        Assertions.assertEquals((Object)arr[4].getName(), (Object)"4");
        Assertions.assertEquals((Object)arr[5].getName(), (Object)"6");
        Assertions.assertEquals((Object)arr[6].getName(), (Object)"7");
        arr = DB.getKeyNamePairs((String)"SELECT AD_Ref_List_ID, Value FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Value", (boolean)false, params);
        Assertions.assertEquals((int)6, (int)arr.length, (String)"Invalid size");
        Assertions.assertEquals((Object)arr[0].getName(), (Object)"1");
        Assertions.assertEquals((Object)arr[1].getName(), (Object)"2");
        Assertions.assertEquals((Object)arr[2].getName(), (Object)"3");
        Assertions.assertEquals((Object)arr[3].getName(), (Object)"4");
        Assertions.assertEquals((Object)arr[4].getName(), (Object)"6");
        Assertions.assertEquals((Object)arr[5].getName(), (Object)"7");
    }

    @Test
    public void test_getSQLValueObjectsEx() {
        StringBuilder sql = new StringBuilder("SELECT ").append("Test_ID").append(", ").append("Test_UU").append(" FROM Test WHERE Test_ID=?");
        List objects = DB.getSQLValueObjectsEx(null, (String)sql.toString(), (Object[])new Object[]{103});
        Assertions.assertEquals((int)2, (int)objects.size());
        X_Test test = new X_Test(Env.getCtx(), 103, this.getTrxName());
        Assertions.assertEquals((int)test.get_ID(), (int)((Number)objects.get(0)).intValue());
        Assertions.assertEquals((Object)test.getTest_UU(), objects.get(1));
        objects = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{103});
        Assertions.assertEquals((int)2, (int)objects.size());
        Assertions.assertEquals((int)test.get_ID(), (int)((Number)objects.get(0)).intValue());
        Assertions.assertEquals((Object)test.getTest_UU(), objects.get(1));
    }

    @Test
    public void test_getSQLArrayObjectsEx() {
        Number id;
        String sql = "SELECT M_Product_ID, Name FROM M_Product WHERE M_Product_ID IN (?, ?, ?)";
        List rows = DB.getSQLArrayObjectsEx(null, (String)sql, (Object[])new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id, DictionaryIDs.M_Product.MULCH.id, DictionaryIDs.M_Product.FERTILIZER_50.id});
        Assertions.assertEquals((int)3, (int)rows.size());
        int match = 0;
        for (List row : rows) {
            Assertions.assertEquals((int)2, (int)row.size());
            id = (Number)row.get(0);
            if (id.intValue() != DictionaryIDs.M_Product.AZALEA_BUSH.id && id.intValue() != DictionaryIDs.M_Product.MULCH.id && id.intValue() != DictionaryIDs.M_Product.FERTILIZER_50.id) continue;
            ++match;
        }
        Assertions.assertEquals((int)3, (int)match);
        rows = DB.getSQLArrayObjectsEx((String)this.getTrxName(), (String)sql, (Object[])new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id, DictionaryIDs.M_Product.MULCH.id, DictionaryIDs.M_Product.FERTILIZER_50.id});
        Assertions.assertEquals((int)3, (int)rows.size());
        match = 0;
        for (List row : rows) {
            Assertions.assertEquals((int)2, (int)row.size());
            id = (Number)row.get(0);
            if (id.intValue() != DictionaryIDs.M_Product.AZALEA_BUSH.id && id.intValue() != DictionaryIDs.M_Product.MULCH.id && id.intValue() != DictionaryIDs.M_Product.FERTILIZER_50.id) continue;
            ++match;
        }
        Assertions.assertEquals((int)3, (int)match);
    }

    @Test
    public void test_NVL() throws Exception {
        BigDecimal result = DB.getSQLValueBDEx(null, (String)"SELECT NVL(GrandTotal, 0) FROM C_Order WHERE C_Order_ID=100", (Object[])new Object[0]);
        Assertions.assertTrue((result != null ? 1 : 0) != 0);
        result = DB.getSQLValueBDEx(null, (String)"SELECT NVL(10, C_Order_ID) FROM C_Order WHERE C_Order_ID=100", (Object[])new Object[0]);
        Assertions.assertTrue((result != null ? 1 : 0) != 0);
        String resultStr = DB.getSQLValueStringEx(null, (String)"SELECT NVL(Description, C_Charge_ID||' ') FROM C_Charge WHERE C_Charge_ID=101", (Object[])new Object[0]);
        Assertions.assertTrue((resultStr != null ? 1 : 0) != 0);
    }

    @Test
    public void testForUpdateAndForeignKey() {
        try {
            MOrder order;
            SQLException sqlException;
            block9: {
                MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, this.getTrxName());
                DB.getDatabase().forUpdate((PO)bp, 0);
                sqlException = null;
                Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);
                order = null;
                try {
                    try {
                        order = new MOrder(Env.getCtx(), 0, trx2.getTrxName());
                        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.STANDARD_ORDER.id);
                        order.setC_BPartner_ID(bp.get_ID());
                        order.setDateOrdered(this.getLoginDate());
                        Thread thread = new Thread(() -> {
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (trx2.isActive()) {
                                trx2.rollbackAndCloseOnTimeout();
                            }
                        });
                        thread.start();
                        order.saveEx();
                        trx2.commit(true);
                    }
                    catch (SQLException e) {
                        sqlException = e;
                        order = null;
                        trx2.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    trx2.close();
                    throw throwable;
                }
                trx2.close();
            }
            Assertions.assertNull((Object)sqlException, (String)("Failed to save and commit order: " + (sqlException != null ? sqlException.getMessage() : "")));
            if (order != null && order.get_ID() > 0) {
                order.set_TrxName(null);
                order.deleteEx(true);
            }
        }
        finally {
            this.rollback();
        }
    }

    @Test
    public void testPostgreSQLSyncColumn() {
        if (!DB.isPostgreSQL() || !DB.getDatabase().isNativeMode()) {
            return;
        }
        MTable table = MTable.get((int)259);
        MColumn column = table.getColumn("Description");
        MColumn description = new MColumn(Env.getCtx(), column.getAD_Column_ID(), this.getTrxName());
        description.setFieldLength(description.getFieldLength() + 1);
        description.saveEx();
        String error = null;
        String sql = description.getSQLModify(table, false);
        try {
            DB.executeUpdateEx((String)sql, (String)this.getTrxName());
        }
        catch (Exception ex) {
            error = ex.getMessage();
        }
        Assertions.assertNull((Object)error, (String)error);
    }

    @Override
    protected LoginDetails newLoginDetails(TestInfo testInfo) {
        if (((Method)testInfo.getTestMethod().get()).getName().equals("testPostgreSQLSyncColumn")) {
            return new LoginDetails(DictionaryIDs.AD_Client.SYSTEM.id, 0, DictionaryIDs.AD_User.SUPER_USER.id, DictionaryIDs.AD_Role.SYSTEM_ADMINISTRATOR.id, DictionaryIDs.AD_Role.SYSTEM_ADMINISTRATOR.id, new Timestamp(System.currentTimeMillis()), Language.getLanguage((String)"en_US"));
        }
        return super.newLoginDetails(testInfo);
    }

    @Test
    public void testTrxTimeout() {
        try {
            Exception exception;
            block8: {
                MBPartner bp = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, this.getTrxName());
                DB.getDatabase().forUpdate((PO)bp, 0);
                exception = null;
                Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);
                MBPartner bp2 = new MBPartner(Env.getCtx(), DictionaryIDs.C_BPartner.JOE_BLOCK.id, trx2.getTrxName());
                try {
                    try {
                        Thread thread = new Thread(() -> {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            if (trx2.isActive()) {
                                trx2.rollbackAndCloseOnTimeout();
                            }
                        });
                        thread.start();
                        DB.getDatabase().forUpdate((PO)bp2, 10);
                    }
                    catch (Exception e) {
                        exception = e;
                        trx2.close();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    trx2.close();
                    throw throwable;
                }
                trx2.close();
            }
            Assertions.assertNotNull((Object)exception, (String)"Exception not happens as expected");
            Assertions.assertTrue((boolean)(exception instanceof DBException), (String)"Exception not instanceof DBException");
        }
        finally {
            this.rollback();
        }
    }

    public static int getNumConnectPerStatus(String poolStatus, Pattern patternStatus) {
        int numActiveConn = -1;
        try {
            Matcher regexMatcher = patternStatus.matcher(poolStatus);
            if (regexMatcher.find()) {
                String activeConnectionStr = regexMatcher.group(1);
                numActiveConn = Integer.parseInt(activeConnectionStr);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {}
        return numActiveConn;
    }

    @Test
    public void testTrxTimeout2() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {}
        Trx.TrxMonitor monitor = new Trx.TrxMonitor();
        ScheduledFuture<?> future = Adempiere.getThreadPoolExecutor().scheduleWithFixedDelay((Runnable)monitor, 0L, 6L, TimeUnit.SECONDS);
        int beforeActiveConnection = DBTest.getNumConnectPerStatus(DB.getDatabase().getStatus(), REG_ACTIVE_CONNECT);
        Trx trx2 = Trx.get((String)Trx.createTrxName(), (boolean)true);
        trx2.setTimeout(3);
        DB.getSQLValueEx((String)trx2.getTrxName(), (String)"SELECT 1 FROM DUAL", (Object[])new Object[0]);
        try {
            try {
                Thread.sleep(8000L);
                int afterActiveConnection = DBTest.getNumConnectPerStatus(DB.getDatabase().getStatus(), REG_ACTIVE_CONNECT);
                Assertions.assertEquals((int)beforeActiveConnection, (int)afterActiveConnection);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                future.cancel(true);
            }
        }
        finally {
            future.cancel(true);
        }
    }

    @Test
    public void testUUIDColumnName() {
        Assertions.assertEquals((Object)PO.getUUIDColumnName((String)"MyTable"), (Object)"MyTable_UU");
        Assertions.assertEquals((Object)PO.getUUIDColumnName((String)"XCUSTOM_ThisIsAVeryLongTableNameWithSixtyCharactersOnTheName"), (Object)"XCUSTOM_ThisIsAVeryLongTableNameWithSixtyCharactersOnTheName_UU");
        Assertions.assertEquals((Object)PO.getUUIDColumnName((String)"CUSTOM_AVeryLongTableNameWithMoreThanSixtyCharactersOnTheName"), (Object)"CUSTOM_AVeryLongTableNameWithMoreThanSixtyCharactersOnTheNam_UU");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"MyTable"), (Object)"MyTable_UU_idx");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"XCUSTOM_ThisIsAVeryLongTableNameWithSixtyCharactersOnTheName"), (Object)"XCUSTOM_ThisIsAVeryLongTableNameWithSixtyCharactersOnTheNauuidx");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"CUSTOM_AVeryLongTableNameWithMoreThanSixtyCharactersOnTheName"), (Object)"CUSTOM_AVeryLongTableNameWithMoreThanSixtyCharactersOnTheNuuidx");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"XYCUSTOM_ThisIsAVeryLongTableNameWith55CharactersOnName"), (Object)"XYCUSTOM_ThisIsAVeryLongTableNameWith55CharactersOnName_UU_idx");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"XYZCUSTOM_ThisIsAVeryLongTableNameWith56CharactersOnName"), (Object)"XYZCUSTOM_ThisIsAVeryLongTableNameWith56CharactersOnName_UU_idx");
        Assertions.assertEquals((Object)MTable.getUUIDIndexName((String)"XYZACUSTOM_ThisIsAVeryLongTableNameWith57CharactersOnName"), (Object)"XYZACUSTOM_ThisIsAVeryLongTableNameWith57CharactersOnName_uuidx");
    }

    @Test
    public void testGetKeyNamePairs() {
        TreeMaintenance tm = new TreeMaintenance();
        KeyNamePair[] treeKeyNamePairs = tm.getTreeData();
        Assertions.assertTrue((treeKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve tree records");
        Optional<KeyNamePair> optional = Arrays.stream(treeKeyNamePairs).filter(e -> e.getKey() == DictionaryIDs.AD_Tree.GARDENWORLD_ORGANIZATION.id).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Garden World Organization tree");
        KeyNamePair[] wfKeyNamePairs = MWorkflow.getWorkflowKeyNamePairs((boolean)false);
        Assertions.assertTrue((wfKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve workflow records");
        optional = Arrays.stream(wfKeyNamePairs).filter(e -> e.getKey() == DictionaryIDs.AD_Workflow.PROCESS_ORDER.id).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Process Order workflow");
        KeyNamePair[] asiKeyNamePairs = MAttributeSetInstance.getWithProductAttributeKeyNamePairs((int)DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id, (boolean)false);
        Assertions.assertTrue((asiKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve Attribute Set Instance records");
        optional = Arrays.stream(asiKeyNamePairs).filter(e -> e.getKey() == DictionaryIDs.M_AttributeSetInstance.MEDIUM.id).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Medium Patio Chair Attribute Set Instance record");
        asiKeyNamePairs = MAttributeSetInstance.getWithProductAttributeKeyNamePairs((int)DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id, (boolean)true);
        Assertions.assertTrue((asiKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve Attribute Set Instance records");
        Assertions.assertTrue((asiKeyNamePairs[0].getKey() == -1 ? 1 : 0) != 0, (String)"First element of return array is not en empty element as expected");
        asiKeyNamePairs = MAttributeSetInstance.getWithProductAttributeKeyNamePairs((int)DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id, (boolean)false);
        Assertions.assertTrue((asiKeyNamePairs.length == 0 ? 1 : 0) != 0, (String)"Unexpected number of Attribute Set Instance records");
        KeyNamePair[] roleKeyNamePairs = MRole.getRoleKeyNamePairs();
        Assertions.assertTrue((roleKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve Role records");
        optional = Arrays.stream(roleKeyNamePairs).filter(e -> e.getKey() == DictionaryIDs.AD_Role.GARDEN_WORLD_USER.id).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Garden World User role record");
        KeyNamePair[] tableKeyNamePairs = MTable.getWithWindowAccessKeyNamePairs((boolean)false, null);
        Assertions.assertTrue((tableKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve Table records");
        optional = Arrays.stream(tableKeyNamePairs).filter(e -> e.getKey() == 259).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find C_Order table record");
        KeyNamePair[] userKeyNamePairs = MUser.getWithRoleKeyNamePairs((boolean)false, null);
        Assertions.assertTrue((userKeyNamePairs.length > 0 ? 1 : 0) != 0, (String)"Failed to retrieve User records");
        optional = Arrays.stream(userKeyNamePairs).filter(e -> e.getKey() == DictionaryIDs.AD_User.GARDEN_USER.id).findFirst();
        Assertions.assertTrue((boolean)optional.isPresent(), (String)"Failed to find Garden_User user record");
    }
}

