/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MConversionRate;
import org.compiere.model.Query;
import org.compiere.util.Env;

public final class ConversionRateHelper {
    private ConversionRateHelper() {
    }

    public static MConversionRate createConversionRate(int C_Currency_ID, int C_Currency_ID_To, int C_ConversionType_ID, Timestamp date, BigDecimal rate, boolean isMultiplyRate) {
        MConversionRate cr = new MConversionRate(Env.getCtx(), 0, null);
        cr.setC_Currency_ID(C_Currency_ID);
        cr.setC_Currency_ID_To(C_Currency_ID_To);
        cr.setC_ConversionType_ID(C_ConversionType_ID);
        cr.setValidFrom(date);
        cr.setValidTo(date);
        if (isMultiplyRate) {
            cr.setMultiplyRate(rate);
        } else {
            cr.setDivideRate(rate);
        }
        cr.saveEx();
        return cr;
    }

    public static void deleteConversionRate(MConversionRate cr) {
        String whereClause = "ValidFrom=? AND ValidTo=? AND C_Currency_ID=? AND C_Currency_ID_To=? AND C_ConversionType_ID=? AND AD_Client_ID=? AND AD_Org_ID=?";
        MConversionRate reciprocal = (MConversionRate)new Query(Env.getCtx(), "C_Conversion_Rate", whereClause, null).setParameters(new Object[]{cr.getValidFrom(), cr.getValidTo(), cr.getC_Currency_ID_To(), cr.getC_Currency_ID(), cr.getC_ConversionType_ID(), cr.getAD_Client_ID(), cr.getAD_Org_ID()}).firstOnly();
        if (reciprocal != null) {
            reciprocal.deleteEx(true);
        }
        cr.deleteEx(true);
    }
}

