/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.minigrid;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.TableColumn;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.util.KeyNamePair;

public class MiniTableImpl
implements IMiniTable {
    private List<TableColumn> m_tableColumns = new ArrayList<TableColumn>();
    private List<Map<String, Object>> model = new ArrayList<Map<String, Object>>();
    private ColumnInfo[] m_layout;
    private int m_keyColumnIndex;
    private int m_selectedRow = -1;

    public MiniTableImpl() {
    }

    public MiniTableImpl(ColumnInfo[] layout) {
        this.prepareTable(layout, null, null, false, null);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (column < this.m_tableColumns.size()) {
            String columnName = this.m_tableColumns.get(column).getHeaderValue();
            if (row < this.model.size()) {
                return this.model.get(row).get(columnName);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (column < this.m_tableColumns.size()) {
            String columnName = this.m_tableColumns.get(column).getHeaderValue();
            if (row < this.model.size()) {
                this.model.get(row).put(columnName, value);
            }
        }
    }

    @Override
    public int convertColumnIndexToModel(int viewColumnIndex) {
        return viewColumnIndex;
    }

    @Override
    public void setColumnReadOnly(int index, boolean readOnly) {
    }

    @Override
    public String prepareTable(ColumnInfo[] layout, String from, String where, boolean multiSelection, String tableName) {
        this.m_layout = layout;
        this.m_tableColumns.clear();
        this.model.clear();
        StringBuilder sql = new StringBuilder("SELECT ");
        int columnIndex = 0;
        while (columnIndex < layout.length) {
            if (columnIndex > 0) {
                sql.append(", ");
            }
            sql.append(layout[columnIndex].getColSQL());
            if (layout[columnIndex].isKeyPairCol()) {
                sql.append(",").append(layout[columnIndex].getKeyPairColSQL());
            }
            this.addColumn(layout[columnIndex].getColHeader(), layout[columnIndex].getColDescription(), layout[columnIndex].getAD_Reference_ID(), layout[columnIndex].getColClass());
            if (layout[columnIndex].getColClass() == IDColumn.class) {
                this.m_keyColumnIndex = columnIndex;
            }
            ++columnIndex;
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(where);
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), tableName, true, false);
        return finalSQL;
    }

    @Override
    public void addColumn(String header) {
        this.addColumn(header, null, 0, null);
    }

    @Override
    public void setColumnClass(int index, Class<?> classType, boolean readOnly, String header) {
        if (index < this.m_tableColumns.size()) {
            this.m_tableColumns.get(index).setColumnClass(classType);
        }
    }

    @Override
    public void setColumnClass(int index, Class<?> classType, boolean readOnly) {
        if (index < this.m_tableColumns.size()) {
            this.m_tableColumns.get(index).setColumnClass(classType);
        }
    }

    @Override
    public void loadTable(ResultSet rs) {
        this.model.clear();
        try {
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                int rsColOffset = 1;
                int col = 0;
                while (col < this.m_layout.length) {
                    Object data = null;
                    Class<?> columnClass = this.m_layout[col].getColClass();
                    int rsColIndex = col + rsColOffset;
                    if (columnClass == IDColumn.class) {
                        data = new IDColumn(rs.getInt(rsColIndex));
                    } else if (columnClass == Boolean.class) {
                        data = rs.getString(rsColIndex).equals("Y");
                    } else if (columnClass == Timestamp.class) {
                        data = rs.getTimestamp(rsColIndex);
                    } else if (columnClass == BigDecimal.class) {
                        data = rs.getBigDecimal(rsColIndex);
                    } else if (columnClass == Double.class) {
                        data = rs.getDouble(rsColIndex);
                    } else if (columnClass == Integer.class) {
                        data = rs.getInt(rsColIndex);
                    } else if (columnClass == KeyNamePair.class) {
                        String display = rs.getString(rsColIndex);
                        int key = rs.getInt(rsColIndex + 1);
                        data = new KeyNamePair(key, display);
                        ++rsColOffset;
                    } else {
                        String s = rs.getString(rsColIndex);
                        data = s != null ? s.trim() : null;
                    }
                    row.put(this.m_tableColumns.get((int)col).headerValue, data);
                    ++col;
                }
                this.model.add(row);
            }
        }
        catch (SQLException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void loadTable(PO[] pos) {
        this.model.clear();
        int poIndex = 0;
        while (poIndex < pos.length) {
            PO myPO = pos[poIndex];
            HashMap<String, Object> row = new HashMap<String, Object>();
            int col = 0;
            while (col < this.m_layout.length) {
                String columnName = this.m_layout[col].getColSQL();
                Object data = myPO.get_Value(columnName);
                if (data != null) {
                    Class<?> columnClass = this.m_layout[col].getColClass();
                    if (columnClass == IDColumn.class) {
                        data = new IDColumn((int)((Integer)data));
                    } else if (columnClass == Double.class) {
                        data = ((BigDecimal)data).doubleValue();
                    }
                }
                row.put(this.m_tableColumns.get((int)col).headerValue, data);
                ++col;
            }
            this.model.add(row);
            ++poIndex;
        }
    }

    @Override
    public <T extends Serializable> T getSelectedRowKey() {
        int row = this.getSelectedRow();
        return this.getRowKeyAt(row);
    }

    public <T extends Serializable> T getRowKeyAt(int index) {
        if (index < 0 || this.m_keyColumnIndex < 0 || index >= this.model.size()) {
            return null;
        }
        Object data = this.model.get(index).get(this.m_tableColumns.get((int)this.m_keyColumnIndex).headerValue);
        if (data instanceof IDColumn) {
            data = ((IDColumn)data).getRecord_ID();
        }
        if (data instanceof Integer) {
            return (T)((Serializable)data);
        }
        return null;
    }

    @Override
    public int getSelectedRow() {
        return this.m_selectedRow;
    }

    public void setSelectedRow(int selected) {
        if (selected < this.model.size()) {
            this.m_selectedRow = selected;
        }
    }

    @Override
    public void setRowCount(int rowCount) {
        while (this.model.size() < rowCount) {
            this.model.add(new HashMap());
        }
    }

    @Override
    public ColumnInfo[] getLayoutInfo() {
        return this.m_layout;
    }

    @Override
    public int getColumnCount() {
        return this.m_tableColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    @Override
    public void setMultiSelection(boolean multiSelection) {
    }

    @Override
    public boolean isMultiSelection() {
        return false;
    }

    @Override
    public int getColorCode(int row) {
        return 0;
    }

    @Override
    public void setColorCompare(Object dataCompare) {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void autoSize() {
    }

    @Override
    public void setShowTotals(boolean show) {
    }

    public void addColumn(String header, String description, int AD_Reference_ID, Class<?> colClass) {
        TableColumn column = new TableColumn();
        column.setHeaderValue(header);
        column.setTooltipText(description);
        column.setAD_Reference_ID(AD_Reference_ID);
        column.setColumnClass(colClass);
        this.m_tableColumns.add(column);
    }
}

