/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.OSTask;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MTask;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.South;

public class WTask
extends Window
implements EventListener<Event>,
IHelpContext {
    private static final long serialVersionUID = -1235619876719378703L;
    private MTask m_task;
    private Thread taskThread;
    private static final CLogger log = CLogger.getCLogger(WTask.class);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Html info = new Html();

    public static void start(String title, MTask task) {
        new WTask(title, task);
    }

    public WTask(String title, MTask task) {
        this.setTitle(title);
        try {
            this.zkInit();
            this.setAttribute("mode", "embedded");
            this.m_task = task;
            this.info.setContent("Executing task ...");
            this.addEventListener("onWindowContainerSelectionChanged", this);
            SessionManager.getAppDesktop().showWindow(this);
            this.addEventListener("onExecuteTask", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WTask.this.executeTask();
                }
            });
            Events.echoEvent((String)"onExecuteTask", (Component)this, null);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, task.toString(), (Throwable)e);
        }
    }

    public void executeTask() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Desktop desktop = WTask.this.getDesktop();
                String cmd = Msg.parseTranslation((Properties)Env.getCtx(), (String)WTask.this.m_task.getOS_Command()).trim();
                if (cmd == null || cmd.equals("")) {
                    WTask.this.info.setContent("Cannot execute '" + WTask.this.m_task.getOS_Command() + "'");
                }
                OSTask osTask = new OSTask(cmd);
                osTask.start();
                try {
                    while (true) {
                        Thread.sleep(500L);
                        Executions.activate((Desktop)desktop, (long)500L);
                        try {
                            StringBuilder sb = new StringBuilder();
                            sb.append("<pre><code>").append(osTask.getOut()).append("-----------<br><p style=\"color:red\">").append(osTask.getErr()).append("</p>-----------<br>").append("</code></pre>");
                            WTask.this.info.setContent(sb.toString().replace("\n", "<br>"));
                            if (osTask.isAlive()) continue;
                            WTask.this.confirmPanel.getButton("Cancel").setEnabled(false);
                            WTask.this.confirmPanel.getOKButton().setEnabled(true);
                        }
                        finally {
                            Executions.deactivate((Desktop)desktop);
                            continue;
                        }
                        break;
                    }
                }
                catch (DesktopUnavailableException e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, e.getLocalizedMessage(), (Throwable)e);
                    }
                    osTask.interrupt();
                }
                catch (InterruptedException e) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, e.getLocalizedMessage(), (Throwable)e);
                    }
                    osTask.interrupt();
                }
            }
        };
        this.taskThread = new Thread(runnable);
        this.taskThread.start();
    }

    private void zkInit() throws Exception {
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        layout.setStyle("position: absolute;");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        this.appendChild((Component)layout);
        Center center = new Center();
        layout.appendChild((Component)center);
        Div div = new Div();
        div.setStyle("width: 100%; height:100%; overflow: auto");
        div.appendChild((Component)this.info);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
        center.appendChild((Component)div);
        South south = new South();
        layout.appendChild((Component)south);
        south.setStyle("border: none");
        south.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    public void onEvent(Event e) {
        if (this.taskThread != null && this.taskThread.isAlive()) {
            this.taskThread.interrupt();
        } else if (e.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("K", this.m_task.getAD_Task_ID());
        } else if (e.getName().equals("onClick")) {
            SessionManager.getAppDesktop().closeActiveWindow();
        }
    }
}

