/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.Serializable;
import java.util.Properties;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.FindWindow;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WRecordIDDialog;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Div;

public abstract class WRecordEditor<T>
extends WEditor
implements ContextMenuListener,
IZoomableEditor {
    private boolean m_ReadWrite;
    protected Object recordIDValue;
    protected Object tableIDValue;
    protected GridField tableIDGridField;
    int windowNo;
    int tabNo;
    protected Textbox recordTextBox;
    protected ToolBarButton editButton;
    protected ToolBarButton zoomButton;
    private static final String IMAGES_CONTEXT_ZOOM_PNG = "images/Zoom16.png";
    private static final String IMAGES_CONTEXT_EDIT_RECORD_PNG = "images/EditRecord16.png";

    public WRecordEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Div(), gridField, tableEditor, editorConfiguration);
        this.tabNo = this.gridTab != null ? this.gridTab.getTabNo() : 99;
        this.windowNo = this.gridTab != null ? this.gridTab.getWindowNo() : gridField.getWindowNo();
        this.getComponent().setSclass("recordid-editor");
        this.getComponent().addEventListener("onRightClick", (EventListener)this);
        this.init();
    }

    protected void init() {
        if (this.gridTab != null) {
            this.tableIDGridField = this.gridTab.getField("AD_Table_ID");
            if (this.tableIDGridField == null) {
                throw new RuntimeException("AD_Table_ID field not found");
            }
            this.tableIDGridField.addPropertyChangeListener(evt -> {
                if ("FieldValue".equals(evt.getPropertyName())) {
                    this.tableIDValue = evt.getNewValue();
                }
            });
        } else {
            String tableIdTxt = Env.getContext((Properties)this.gridField.getVO().ctx, (int)this.gridField.getWindowNo(), (int)99, (String)"AD_Table_ID", (boolean)true);
            if (!Util.isEmpty((String)tableIdTxt, (boolean)true)) {
                this.tableIDValue = Integer.parseInt(tableIdTxt);
            }
            this.getComponent().addCallback("afterPageAttached", (Callback & Serializable)t -> this.afterPageAttached(t));
        }
        this.recordTextBox = new Textbox();
        this.recordTextBox.setParent((Component)this.getComponent());
        this.recordTextBox.setWidth("100%");
        this.recordTextBox.setReadonly(true);
        this.editButton = new ToolBarButton();
        this.editButton.setStyle("right: 21px;");
        if (ThemeManager.isUseFontIconForImage()) {
            this.editButton.setIconSclass("z-icon-Edit");
        } else {
            this.editButton.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_EDIT_RECORD_PNG));
        }
        this.editButton.setParent((Component)this.getComponent());
        this.editButton.addEventListener("onClick", this);
        this.editButton.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Edit"));
        this.zoomButton = new ToolBarButton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.zoomButton.setIconSclass("z-icon-Zoom");
        } else {
            this.zoomButton.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_ZOOM_PNG));
        }
        this.zoomButton.setParent((Component)this.getComponent());
        this.zoomButton.addEventListener("onClick", this);
        this.zoomButton.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom"));
        if (this.gridField != null) {
            this.popupMenu = new WEditorPopupMenu(true, true, this.isShowPreference());
            this.popupMenu.addMenuListener(this);
            this.addChangeLogMenu(this.popupMenu);
        }
    }

    private void afterPageAttached(Object t) {
        if (t instanceof Component) {
            FindWindow fw;
            GridField field;
            Component component = (Component)t;
            Component parent = component.getParent();
            while (parent != null) {
                if (parent instanceof FindWindow) break;
                parent = parent.getParent();
            }
            if (parent != null && parent instanceof FindWindow && (field = (fw = (FindWindow)parent).getTargetMField("AD_Table_ID")) != null) {
                field = field.clone(this.gridField.getVO().ctx);
                field.loadLookupNoValidate();
                Lookup lookup = field.getLookup();
                if (lookup != null && lookup instanceof MLookup) {
                    MLookup mLookup = (MLookup)lookup;
                    mLookup.getLookupInfo().tabNo = 99;
                    if (field.getVO().ValidationCodeLookup != null && !field.getVO().ValidationCodeLookup.isEmpty()) {
                        mLookup.getLookupInfo().ValidationCode = field.getVO().ValidationCodeLookup;
                        mLookup.getLookupInfo().IsValidated = false;
                    }
                }
                this.tableIDGridField = field;
                if (this.tableIDValue != null) {
                    this.tableIDGridField.setValue(this.tableIDValue, false);
                }
            }
        }
    }

    private void actionRefresh() {
        this.recordTextBox.setValue(this.getDisplay());
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.isShowPreference()) {
            ValuePreference.start((Component)this.getComponent(), this.gridField, this.getValue());
        }
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.m_ReadWrite = readWrite;
        if (this.editButton != null) {
            this.editButton.setDisabled(!readWrite);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.m_ReadWrite;
    }

    @Override
    public void setValue(Object value) {
        this.setValue(value, true);
    }

    protected void setValue(Object value, boolean fire) {
        if (value == null || Util.isEmpty((String)value.toString(), (boolean)true)) {
            this.recordTextBox.setValue("");
            value = null;
        } else {
            Serializable recordID;
            int tableID;
            this.recordTextBox.setValue(value.toString());
            if (this.tableIDValue == null && this.tableIDGridField != null) {
                this.tableIDValue = this.tableIDGridField.getValue();
            }
            if (value != null && this.tableIDValue != null && (tableID = Integer.parseInt(String.valueOf(this.tableIDValue))) > 0 && (recordID = (Serializable)this.toKeyValue(value)) != null && tableID > 0) {
                this.recordTextBox.setValue(MLookup.getIdentifier((int)tableID, (Serializable)recordID, (int)this.tabNo, (int)this.windowNo, (boolean)this.isUseUUIDKey()));
            }
        }
        if (fire && (value == null && this.recordIDValue != null || value != null && this.recordIDValue == null || value != null && !value.equals(this.recordIDValue))) {
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.recordIDValue, value);
            super.fireValueChange(changeEvent);
        }
        this.recordIDValue = value;
    }

    @Override
    public Object getValue() {
        return this.recordIDValue;
    }

    @Override
    public String getDisplay() {
        if (this.recordIDValue == null) {
            return "";
        }
        if (this.tableIDValue != null && this.recordIDValue != null) {
            Serializable recordID;
            int tableID;
            try {
                tableID = Integer.parseInt(String.valueOf(this.tableIDValue));
                recordID = (Serializable)this.toKeyValue(this.recordIDValue);
            }
            catch (NumberFormatException numberFormatException) {
                return this.recordIDValue.toString();
            }
            return MLookup.getIdentifier((int)tableID, (Serializable)recordID, (int)this.tabNo, (int)this.windowNo, (boolean)this.isUseUUIDKey());
        }
        return this.recordIDValue.toString();
    }

    @Override
    public String getDisplayTextForGridView(GridRowCtx gridRowCtx, Object value) {
        if (value == null) {
            return "";
        }
        if (this.gridTab != null) {
            Serializable rowRecordID;
            int rowTableID;
            String key = this.gridTab.getWindowNo() + "|AD_Table_ID";
            Object rowTableIdValue = gridRowCtx.get((Object)key);
            try {
                rowTableID = Integer.parseInt(String.valueOf(rowTableIdValue));
                rowRecordID = (Serializable)this.toKeyValue(value);
            }
            catch (NumberFormatException numberFormatException) {
                return value.toString();
            }
            return MLookup.getIdentifier((int)rowTableID, (Serializable)rowRecordID, (int)this.tabNo, (int)this.windowNo, (boolean)this.isUseUUIDKey());
        }
        return value.toString();
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equalsIgnoreCase("onClick")) {
            if (event.getTarget().equals((Object)this.zoomButton)) {
                this.actionZoom();
            } else if (event.getTarget().equals((Object)this.editButton) && this.tableIDGridField != null) {
                String error;
                String tableIdTxt;
                if (this.gridTab == null && !Util.isEmpty((String)(tableIdTxt = Env.getContext((Properties)this.gridField.getVO().ctx, (int)this.gridField.getWindowNo(), (int)99, (String)"AD_Table_ID", (boolean)true)), (boolean)true)) {
                    this.tableIDValue = Integer.parseInt(tableIdTxt);
                }
                if (this.tableIDValue != null && this.tableIDValue instanceof Integer && !Util.isEmpty((String)(error = this.validateTableIdValue((Integer)this.tableIDValue)))) {
                    Dialog.error(this.tableIDGridField.getWindowNo(), error);
                    return;
                }
                new WRecordIDDialog(this.recordTextBox.getPage(), this, this.tableIDGridField);
            }
        } else if (event.getName().equalsIgnoreCase("onRightClick") && event.getTarget().equals(this.getComponent())) {
            this.popupMenu.open((Component)this.getComponent());
        }
    }

    public Object getAD_Table_ID() {
        return this.tableIDValue;
    }

    public void setAD_Table_ID(Object tableID) {
        if (this.gridTab != null) {
            Object oldValue = this.gridTab.getValue("AD_Table_ID");
            this.gridTab.setValue(this.tableIDGridField, tableID);
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, "AD_Table_ID", oldValue, tableID);
            super.fireValueChange(changeEvent);
        } else {
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, "AD_Table_ID", this.tableIDValue, tableID);
            super.fireValueChange(changeEvent);
        }
        this.tableIDValue = tableID;
    }

    public Div getComponent() {
        return (Div)super.getComponent();
    }

    public abstract boolean isUseUUIDKey();

    public abstract T toKeyValue(Object var1);

    public abstract String validateTableIdValue(int var1);
}

