/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import org.adempiere.base.event.AbstractEventHandler;
import org.adempiere.base.event.EventManager;
import org.adempiere.webui.AdempiereWebUI;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.X_AD_SysConfig;
import org.osgi.service.event.Event;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.util.WebAppInit;

public class DefaultWebAppInit
implements WebAppInit {
    private static SystemConfigHandler systemConfigChangeHandler;
    protected WebApp webApp = null;

    public void init(WebApp wapp) throws Exception {
        this.webApp = wapp;
        AdempiereWebUI.APP_NAME = this.webApp.getAppName();
        String appNameConfig = MSysConfig.getValue((String)"ZK_BROWSER_TITLE");
        if (appNameConfig != null) {
            this.webApp.setAppName(appNameConfig);
        }
        this.createStaticListeners();
    }

    private synchronized void createStaticListeners() {
        if (systemConfigChangeHandler == null) {
            systemConfigChangeHandler = new SystemConfigHandler(this.webApp);
            systemConfigChangeHandler.bindEventManager(EventManager.getInstance());
        }
    }

    static class SystemConfigHandler
    extends AbstractEventHandler {
        String IS_DELETE = "org.compiere.util.SystemConfigHandler.isDelete";
        protected WebApp webApp = null;

        public SystemConfigHandler(WebApp webApp) {
            this.webApp = webApp;
        }

        protected void doHandleEvent(Event event) {
            PO po = this.getPO(event);
            int nameColumnIndex = po.get_ColumnIndex("Name");
            int valueColumnIndex = po.get_ColumnIndex("Value");
            boolean isChangeValue = po.is_ValueChanged(valueColumnIndex);
            boolean isChangeName = po.is_ValueChanged(nameColumnIndex);
            if ("adempiere/po/beforeDelete".equals(event.getTopic()) || "adempiere/po/beforeChange".equals(event.getTopic()) && isChangeName) {
                this.beforeDelete(po);
                if ("adempiere/po/beforeChange".equals(event.getTopic()) && isChangeName) {
                    this.beforeChange(po);
                }
                return;
            }
            if ("adempiere/po/afterDelete".equals(event.getTopic()) || "adempiere/po/afterChange".equals(event.getTopic()) && isChangeName) {
                this.afterDelete(po);
                if ("adempiere/po/afterChange".equals(event.getTopic()) && isChangeName) {
                    this.afterChange(po);
                }
                return;
            }
            if ("adempiere/po/beforeNew".equals(event.getTopic()) || "adempiere/po/beforeChange".equals(event.getTopic()) && !isChangeName && isChangeValue) {
                this.beforeChange(po);
                return;
            }
            if ("adempiere/po/afterNew".equals(event.getTopic()) || "adempiere/po/afterChange".equals(event.getTopic()) && !isChangeName && isChangeValue) {
                this.afterChange(po);
                return;
            }
        }

        protected void beforeDelete(PO po) {
        }

        protected void afterDelete(PO po) {
            if (po instanceof X_AD_SysConfig && "ZK_BROWSER_TITLE".equals(this.getOldValueOfName(po))) {
                this.webApp.setAppName(AdempiereWebUI.APP_NAME);
            }
        }

        protected String getOldValueOfName(PO po) {
            int nameColumnIndex = po.get_ColumnIndex("Name");
            return po.get_ValueOld(nameColumnIndex).toString();
        }

        protected void beforeChange(PO po) {
        }

        protected void afterChange(PO po) {
            if (po instanceof X_AD_SysConfig && "ZK_BROWSER_TITLE".equals(((X_AD_SysConfig)po).getName())) {
                String configAppname = ((X_AD_SysConfig)po).getValue();
                this.webApp.setAppName(configAppname);
            }
        }

        protected void initialize() {
            this.registerTableEvent("adempiere/po/afterChange", "AD_SysConfig");
            this.registerTableEvent("adempiere/po/afterNew", "AD_SysConfig");
            this.registerTableEvent("adempiere/po/afterDelete", "AD_SysConfig");
            this.registerTableEvent("adempiere/po/beforeChange", "AD_SysConfig");
            this.registerTableEvent("adempiere/po/beforeDelete", "AD_SysConfig");
            this.registerTableEvent("adempiere/po/beforeNew", "AD_SysConfig");
        }
    }
}

