/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.X_AD_Column_Access;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MColumnAccess
extends X_AD_Column_Access {
    private static final long serialVersionUID = -4824730344123047467L;
    private String m_tableName;
    private String m_columnName;

    public MColumnAccess(Properties ctx, String AD_Column_Access_UU, String trxName) {
        super(ctx, AD_Column_Access_UU, trxName);
    }

    public MColumnAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MColumnAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MColumnAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(",AD_Column_ID=").append(this.getAD_Column_ID()).append(",Exclude=").append(this.isExclude());
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        String in = Msg.getMsg(ctx, "Include");
        String ex = Msg.getMsg(ctx, "Exclude");
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Table_ID")).append("=").append(this.getTableName(ctx)).append(", ").append(Msg.translate(ctx, "AD_Column_ID")).append("=").append(this.getColumnName(ctx)).append(" (").append(Msg.translate(ctx, "IsReadOnly")).append("=").append(this.isReadOnly()).append(") - ").append(this.isExclude() ? ex : in);
        return sb.toString();
    }

    public String getTableName(Properties ctx) {
        if (this.m_tableName == null) {
            this.getColumnName(ctx);
        }
        return this.m_tableName;
    }

    public String getColumnName(Properties ctx) {
        if (this.m_columnName == null) {
            block9: {
                String sql = "SELECT t.TableName,c.ColumnName, t.AD_Table_ID FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE AD_Column_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Column_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_tableName = rs.getString(1);
                            this.m_columnName = rs.getString(2);
                            if (rs.getInt(3) != this.getAD_Table_ID()) {
                                this.log.log(Level.SEVERE, "AD_Table_ID inconsistent - Access=" + this.getAD_Table_ID() + " - Table=" + rs.getInt(3));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            StringBuilder msgrn = new StringBuilder(this.m_tableName).append("_ID");
            String realName = Msg.translate(ctx, msgrn.toString());
            if (!realName.equals(msgrn.toString())) {
                this.m_tableName = realName;
            }
            this.m_columnName = Msg.translate(ctx, this.m_columnName);
        }
        return this.m_columnName;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            Adempiere.getThreadPoolExecutor().submit(() -> CacheMgt.get().reset("AD_Role", this.getAD_Role_ID()));
        }
        return success;
    }
}

