/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Document;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ResourceCache;
import org.zkoss.web.util.resource.ResourceCaches;
import org.zkoss.web.util.resource.ResourceLoader;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.Parser;

public class PageDefinitions {
    private static final Logger log = LoggerFactory.getLogger(PageDefinitions.class);
    private static final String ATTR_PAGE_CACHE = "org.zkoss.zk.ui.PageCache";

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, String content, String extension) {
        try {
            return PageDefinitions.getPageDefinitionDirectly(wapp, locator, new StringReader(content), extension);
        }
        catch (IOException ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, Reader reader, String extension) throws IOException {
        try {
            return new Parser(wapp, locator).parse(reader, extension);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinitionDirectly(WebApp wapp, Locator locator, Document doc, String extension) {
        try {
            return new Parser(wapp, locator).parse(doc, extension);
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    public static final PageDefinition getPageDefinition(WebApp wapp, Locator locator, String path) {
        wapp.getConfiguration().invokeURIInterceptors(path);
        return (PageDefinition)ResourceCaches.get(PageDefinitions.getCache(wapp), (ServletContext)wapp.getServletContext(), (String)path, (Object)locator);
    }

    public static final Locator getLocator(WebApp wapp, String path) {
        if (wapp == null) {
            throw new IllegalArgumentException("null");
        }
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            int j = path.lastIndexOf(47);
            path = j > 0 ? path.substring(0, j + 1) : "/";
        } else {
            Execution exec = Executions.getCurrent();
            if (exec != null) {
                path = exec.getDesktop().getCurrentDirectory();
            }
        }
        return new ServletContextLocator(wapp.getServletContext(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final ResourceCache<PageDefinition> getCache(WebApp wapp) {
        ResourceCache cache = (ResourceCache)wapp.getAttribute(ATTR_PAGE_CACHE);
        if (cache != null) return cache;
        Class<PageDefinitions> clazz = PageDefinitions.class;
        synchronized (PageDefinitions.class) {
            cache = (ResourceCache)wapp.getAttribute(ATTR_PAGE_CACHE);
            if (cache != null) return cache;
            MyLoader loader = null;
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.metainfo.page.Loader.class");
            if (clsnm != null) {
                try {
                    Object o = Classes.newInstanceByThread((String)clsnm, (Class[])new Class[]{WebApp.class}, (Object[])new Object[]{wapp});
                    if (o instanceof ResourceLoader) {
                        loader = (ResourceLoader)o;
                    } else {
                        log.warn(clsnm + " must implement " + ResourceLoader.class.getName());
                    }
                }
                catch (Throwable ex) {
                    log.warn("Unable to instantiate " + clsnm, ex);
                }
            }
            if (loader == null) {
                loader = new MyLoader(wapp);
            }
            cache = new ResourceCache((ResourceLoader)loader, 167);
            cache.setMaxSize(1024);
            cache.setLifetime(3600000);
            wapp.setAttribute(ATTR_PAGE_CACHE, cache);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache;
        }
    }

    private static class MyLoader
    extends ResourceLoader<PageDefinition> {
        private final WebApp _wapp;

        private MyLoader(WebApp wapp) {
            this._wapp = wapp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PageDefinition parse(String path, File file, Object extra) throws Exception {
            Locator locator = extra != null ? (Locator)extra : PageDefinitions.getLocator(this._wapp, path);
            Parser parser = new Parser(this._wapp, locator);
            if (file.exists()) {
                return parser.parse(file, path);
            }
            InputStream stream = parser.getLocator().getResourceAsStream(path);
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader(stream));
                PageDefinition pgdef = parser.parse(reader, Servlets.getExtension((String)path));
                pgdef.setRequestPath(path);
                PageDefinition pageDefinition = pgdef;
                return pageDefinition;
            }
        }

        protected PageDefinition parse(String path, URL url, Object extra) throws Exception {
            Locator locator = extra != null ? (Locator)extra : PageDefinitions.getLocator(this._wapp, path);
            return new Parser(this._wapp, locator).parse(url, path);
        }
    }
}

