/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.util.List;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.rewrite.handler.RuleContainer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class RewriteHandler
extends Handler.Wrapper {
    private final RuleContainer _rules;

    public RewriteHandler() {
        this(null, new RuleContainer());
    }

    public RewriteHandler(RuleContainer rules) {
        this(null, rules);
    }

    public RewriteHandler(Handler handler) {
        this(handler, new RuleContainer());
    }

    public RewriteHandler(Handler handler, RuleContainer rules) {
        super(handler);
        this._rules = rules;
        this.installBean(this._rules);
    }

    public RuleContainer getRuleContainer() {
        return this._rules;
    }

    public List<Rule> getRules() {
        return this._rules.getRules();
    }

    public void setRules(List<Rule> rules) {
        this._rules.setRules(rules);
    }

    public void addRule(Rule rule) {
        this._rules.addRule(rule);
    }

    public void clear() {
        this._rules.clear();
    }

    public String getOriginalPathAttribute() {
        return this._rules.getOriginalPathAttribute();
    }

    public void setOriginalPathAttribute(String originalPathAttribute) {
        this._rules.setOriginalPathAttribute(originalPathAttribute);
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (!this.isStarted()) {
            return false;
        }
        Rule.Handler input = new Rule.Handler(request);
        Rule.Handler result = this.getRuleContainer().matchAndApply(input);
        if (result == null) {
            return super.handle(request, response, callback);
        }
        new LastRuleHandler(result, (Request.Handler)this.getHandler());
        return input.handle(response, callback);
    }

    private static class LastRuleHandler
    extends Rule.Handler {
        private final Request.Handler _handler;

        private LastRuleHandler(Rule.Handler ruleHandler, Request.Handler handler) {
            super(ruleHandler);
            this._handler = handler;
        }

        @Override
        protected boolean handle(Response response, Callback callback) throws Exception {
            return this._handler.handle(this.getWrapped(), response, callback);
        }
    }
}

