/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.lang.Generics;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Checksums;
import org.zkoss.util.Locales;
import org.zkoss.util.URLs;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.portlet.RenderHttpServletRequest;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ServletContextLocator;

public class Servlets {
    private static final Logger log = LoggerFactory.getLogger(Servlets.class);
    private static ClientIdentifier _clientId;
    private static final Pattern _rwebkit;
    private static final Pattern _ropera;
    private static final Pattern _rmozilla;
    private static final Pattern _rchrome;
    private static final Pattern _randroid;
    private static final Pattern _redge;
    private static final Pattern _redgeLegacy;
    private static final Pattern _rsafari;
    private static final Pattern _rtrident;
    private static final boolean _svl24;
    private static final boolean _svl23;
    private static final boolean _svl3;
    private static final String[] _ios;
    public static final int OVERWRITE_URI = 0;
    public static final int IGNORE_PARAM = 1;
    public static final int APPEND_PARAM = 2;
    public static final int PASS_THRU_ATTR = 3;

    protected Servlets() {
    }

    public static final boolean isUniversalURL(String uri) {
        if (uri == null || uri.length() == 0) {
            return false;
        }
        char cc = uri.charAt(0);
        return cc >= 'a' && cc <= 'z' && (uri.indexOf("://") > 0 || uri.startsWith("mailto:") || uri.startsWith("javascript:") || uri.startsWith("about:") || uri.startsWith("data:")) || uri.startsWith("//");
    }

    public static final boolean isServlet3() {
        return _svl3;
    }

    public static final boolean isServlet24() {
        return _svl24;
    }

    public static final boolean isServlet23() {
        return _svl23;
    }

    public static final String locate(ServletContext ctx, ServletRequest request, String pgpath, Locator locator) throws ServletException {
        Locale locale;
        URIIndex index;
        Object uri;
        boolean byLocale;
        String qstr;
        if (pgpath == null) {
            return pgpath;
        }
        int f = ((String)pgpath).indexOf(42);
        if (f < 0 || Servlets.isUniversalURL((String)pgpath)) {
            return pgpath;
        }
        int jquest = ((String)pgpath).indexOf(63);
        if (jquest >= 0 && f > jquest) {
            return pgpath;
        }
        if (jquest >= 0) {
            qstr = ((String)pgpath).substring(jquest);
            pgpath = ((String)pgpath).substring(0, jquest);
        } else {
            qstr = null;
        }
        int l = ((String)pgpath).lastIndexOf(42);
        if (l > f) {
            String bc = Servlets.isBrowser(request, "safari") ? "saf" : (Servlets.isBrowser(request, "opera") ? "opr" : "moz");
            l += bc.length() - 1;
            pgpath = ((String)pgpath).substring(0, f) + bc + ((String)pgpath).substring(f + 1);
        }
        boolean bl = byLocale = l == ((String)(pgpath = ((String)pgpath).substring(0, l) + ((String)pgpath).substring(l + 1))).length() || ((String)pgpath).charAt(l) == '.' && ((String)pgpath).indexOf(47, l + 1) < 0;
        if (byLocale) {
            int j = l;
            while (--j >= 0) {
                char cc = ((String)pgpath).charAt(j);
                if (cc == '.') {
                    byLocale = false;
                    break;
                }
                if (cc != '/') continue;
                break;
            }
        }
        if (!byLocale) {
            return qstr != null ? (String)pgpath + qstr : pgpath;
        }
        String PGPATH_CACHE = "org.zkoss.web.pgpath.cache";
        Map<URIIndex, Object> map = (Map<URIIndex, Object>)ctx.getAttribute("org.zkoss.web.pgpath.cache");
        if (map == null) {
            map = Collections.synchronizedMap(new CacheMap(500, 600000));
            ctx.setAttribute("org.zkoss.web.pgpath.cache", map);
        }
        if ((uri = (String)map.get(index = new URIIndex((String)pgpath, locale = Locales.getCurrent()))) == null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Path path = Path.of(httpServletRequest.getServletPath(), new String[0]);
            if (!path.endsWith("/")) {
                path = path.getParent();
            }
            Locators.URLLocation loc = Locators.locate((String)pgpath, (Locale)locale, (Locator)(locator != null ? locator : new ServletContextLocator(ctx, path.toString())));
            uri = loc != null ? loc.file : pgpath;
            map.put(index, uri);
        }
        return qstr != null ? (String)uri + qstr : uri;
    }

    public static void setClientIdentifier(ClientIdentifier clientId) {
        _clientId = clientId;
    }

    public static ClientIdentifier getClientIdentifier() {
        return _clientId;
    }

    public static Double getBrowser(ServletRequest request, String name) {
        return (Double)Servlets.browserInfo(request).get(name);
    }

    public static String getBrowser(ServletRequest request) {
        return (String)((Map)Servlets.browserInfo(request).get("browser")).get("name");
    }

    public static Double getBrowser(String userAgent, String name) {
        HashMap<String, Object> zk = new HashMap<String, Object>();
        Servlets.browserInfo(zk, userAgent);
        return (Double)zk.get(name);
    }

    public static String getBrowser(String userAgent) {
        HashMap<String, Object> zk = new HashMap<String, Object>();
        Servlets.browserInfo(zk, userAgent);
        return (String)((Map)zk.get("browser")).get("name");
    }

    private static Map browserInfo(ServletRequest request) {
        HashMap<String, Object> zk = Generics.cast((Map)((Map)request.getAttribute("zk")));
        if (zk == null) {
            zk = new HashMap<String, Object>(4);
            request.setAttribute("zk", zk);
        }
        if (!zk.containsKey("browser")) {
            Servlets.browserInfo(zk, Servlets.getUserAgent(request));
        }
        return zk;
    }

    private static void browserInfo(Map<String, Object> zk, String ua) {
        if (ua != null) {
            double version;
            ClientIdentifier ci;
            ua = ua.toLowerCase(Locale.ENGLISH);
            if (_clientId != null && (ci = _clientId.matches(ua)) != null) {
                Servlets.browserInfo(zk, ci.getName(), ci.getVersion());
                return;
            }
            Matcher m = _randroid.matcher(ua);
            if (m.matches()) {
                double v = Servlets.getVersion(m);
                zk.put("android", v);
                zk.put("mobile", v);
            }
            if ((m = _rwebkit.matcher(ua)).matches()) {
                version = Servlets.getVersion(m);
                Servlets.browserInfo(zk, "webkit", version);
                boolean matchChrome = false;
                m = _rchrome.matcher(ua);
                if (m.matches()) {
                    zk.put("chrome", Servlets.getVersion(m));
                    matchChrome = true;
                }
                m = _rsafari.matcher(ua);
                if (!matchChrome && m.matches()) {
                    zk.put("safari", Servlets.getVersion(m));
                }
                if ((m = _redge.matcher(ua)).matches()) {
                    zk.put("edge", Servlets.getVersion(m));
                }
                if ((m = _redgeLegacy.matcher(ua)).matches()) {
                    zk.put("edge_legacy", Servlets.getVersion(m));
                }
                int j = _ios.length;
                while (--j >= 0) {
                    if (ua.indexOf(_ios[j]) < 0) continue;
                    zk.put(_ios[j], version);
                    zk.put("ios", version);
                    zk.put("mobile", version);
                    return;
                }
                return;
            }
            m = _ropera.matcher(ua);
            if (m.matches()) {
                Servlets.browserInfo(zk, "opera", Servlets.getVersion(m));
                return;
            }
            if (ua.indexOf("compatible") < 0 && (m = _rmozilla.matcher(ua)).matches()) {
                int k;
                int j;
                version = Servlets.getVersion(m);
                if (version < 5.0 && (j = ua.indexOf("firefox/")) >= 0 && (k = ua.indexOf(46, j += 8)) >= 0) {
                    char cc;
                    int len = ua.length();
                    while (++k < len && (cc = ua.charAt(k)) >= '0' && cc <= '9') {
                    }
                    try {
                        version = Double.parseDouble(ua.substring(j, k));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                Servlets.browserInfo(zk, "gecko", version);
                zk.put("ff", version);
                return;
            }
        }
        zk.put("browser", Collections.emptyMap());
    }

    private static void browserInfo(Map<String, Object> zk, String name, double version) {
        HashMap<String, Object> bi = new HashMap<String, Object>(4);
        bi.put("name", name);
        bi.put("version", version);
        zk.put("browser", bi);
        zk.put(name, version);
    }

    private static double getVersion(Matcher m) {
        return m.groupCount() < 2 ? 1.0 : Servlets.getVersion(m.group(2));
    }

    private static double getVersion(String version) {
        try {
            int j = version.indexOf(46);
            if (j >= 0 && (j = version.indexOf(46, j + 1)) >= 0) {
                version = version.substring(0, j);
            }
            return Double.parseDouble(version);
        }
        catch (Throwable t) {
            return 1.0;
        }
    }

    public static boolean isBrowser(ServletRequest req, String type) {
        return req instanceof HttpServletRequest && Servlets.isBrowser(Servlets.getUserAgent(req), type);
    }

    public static boolean isBrowser(String userAgent, String type) {
        String[] types = type.split(",");
        for (int j = 0; j < types.length; ++j) {
            if (!Servlets.browser(userAgent, types[j])) continue;
            return true;
        }
        return false;
    }

    private static boolean browser(String userAgent, String type) {
        String btype;
        Double vclient;
        int j;
        boolean equals;
        if (userAgent == null) {
            return false;
        }
        int last = (type = type.trim()).length();
        if (last == 0) {
            return false;
        }
        char cc = type.charAt(last - 1);
        boolean bl = equals = cc == '-' || cc == '_';
        if (equals || cc == '+') {
            --last;
        }
        for (j = last; j > 0 && ((cc = type.charAt(j - 1)) == '.' || cc >= '0' && cc <= '9'); --j) {
        }
        Double vtype = null;
        if (j < last) {
            try {
                vtype = Double.parseDouble(type.substring(j, last));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            last = j;
        }
        if ((vclient = Servlets.getBrowser(userAgent, btype = type.substring(0, last))) == null && userAgent.indexOf(btype) < 0) {
            return false;
        }
        if (vtype == null) {
            return true;
        }
        if (vclient == null) {
            return false;
        }
        double v1 = vclient;
        double v2 = vtype;
        return equals ? v1 == v2 : v1 >= v2;
    }

    public static final String getUserAgent(ServletRequest req) {
        String s;
        if (req instanceof HttpServletRequest && (s = ((HttpServletRequest)req).getHeader("user-agent")) != null) {
            String cache = (String)req.getAttribute("$$zkagent$$");
            if (cache != null) {
                return cache;
            }
            req.setAttribute("$$zkagent$$", (Object)s);
            return s;
        }
        return "";
    }

    public static final boolean isIncluded(ServletRequest request) {
        return request.getAttribute("javax.servlet.include.context_path") != null || request.getAttribute("org.zkoss.web.servlet.include") != null;
    }

    public static final boolean isForwarded(ServletRequest request) {
        return request.getAttribute("javax.servlet.forward.context_path") != null || request.getAttribute("org.zkoss.web.servlet.forward") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        if (Servlets.isIncluded(request)) {
            Servlets.include(ctx, request, response, uri, params, mode);
            return;
        }
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri = Servlets.locate(ctx, request, uri, null), params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to forward to " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.forward(request, response);
                return;
            }
            catch (ClassCastException ex) {
                if (request instanceof RenderHttpServletRequest) return;
                throw ex;
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.forward(request, response);
        }
    }

    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.forward(ctx, request, response, uri, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        request.setAttribute("org.mortbay.jetty.servlet.Dispatcher.shared_session", (Object)Boolean.TRUE);
        uri = Servlets.locate(ctx, request, uri, null);
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri, params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to include " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.include(request, response);
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.include(request, response);
        }
    }

    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.include(ctx, request, response, uri, null, 0);
    }

    private static final Map setPassThruAttr(ServletRequest request, Map params) {
        Map old = (Map)request.getAttribute("arg");
        request.setAttribute("arg", (Object)params);
        return old;
    }

    private static final void restorePassThruAttr(ServletRequest request, Map old) {
        if (old != null) {
            request.setAttribute("arg", (Object)old);
        } else {
            request.removeAttribute("arg");
        }
    }

    public static final RequestDispatcher getRequestDispatcher(ServletContext ctx, ServletRequest request, String uri, Map params, int mode) throws ServletException {
        char cc;
        char c = cc = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (ctx == null || cc != '/' && cc != '~') {
            if (request == null) {
                throw new IllegalArgumentException((String)(ctx == null ? "Servlet context and request cannot be both null" : "Request is required to use revalant URI: " + uri));
            }
            if (cc == '~') {
                throw new IllegalArgumentException("Servlet context is required to use foreign URI: " + uri);
            }
            uri = Servlets.generateURI(uri, params, mode);
            return request.getRequestDispatcher(uri);
        }
        return new ParsedURI(ctx, uri).getRequestDispatcher(params, mode);
    }

    public static final URL getResource(ServletContext ctx, String uri) throws UnsupportedEncodingException {
        try {
            if (uri != null && uri.toLowerCase(Locale.ENGLISH).startsWith("file://")) {
                File file = new File(new URI(uri));
                return file.exists() ? file.toURI().toURL() : null;
            }
            URL url = Servlets.toURL(uri);
            if (url != null) {
                return url;
            }
            return new ParsedURI(ctx, uri).getResource();
        }
        catch (Throwable ex) {
            log.warn("Ignored: failed to load " + Encodes.encodeURI(uri), ex);
            return null;
        }
    }

    public static final InputStream getResourceAsStream(ServletContext ctx, String uri) throws IOException {
        try {
            if (uri != null && uri.toLowerCase(Locale.ENGLISH).startsWith("file://")) {
                File file = new File(new URI(uri));
                return file.exists() ? new BufferedInputStream(new FileInputStream(file)) : null;
            }
            URL url = Servlets.toURL(uri);
            if (url != null) {
                url = URLs.sanitizeURL((URL)url);
                return url.openStream();
            }
            return new ParsedURI(ctx, uri).getResourceAsStream();
        }
        catch (Throwable ex) {
            log.warn("Ignored: failed to load " + Encodes.encodeURI(uri), ex);
            return null;
        }
    }

    private static URL toURL(String uri) throws MalformedURLException {
        String s;
        if (uri != null && ((s = uri.toLowerCase(Locale.ENGLISH)).startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://"))) {
            return new URL(uri);
        }
        return null;
    }

    public static final String generateURI(String uri, Map params, int mode) {
        if (uri.startsWith("~")) {
            throw new IllegalArgumentException("~ctx not supported here: " + uri);
        }
        int j = uri.indexOf(63);
        String qstr = null;
        if (j >= 0) {
            qstr = uri.substring(j);
            uri = uri.substring(0, j);
        }
        try {
            boolean noParams;
            uri = Encodes.encodeURI(uri);
            boolean noQstr = qstr == null;
            boolean bl = noParams = mode == 3 || params == null || params.isEmpty();
            if (noQstr && noParams) {
                return uri;
            }
            if (noQstr != noParams) {
                mode = 2;
            }
            StringBuffer sb = new StringBuffer(80).append(uri);
            if (qstr != null) {
                sb.append(qstr);
            }
            switch (mode) {
                case 1: {
                    Iterator it = params.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        String nm = (String)me.getKey();
                        if (!Encodes.containsQuery(qstr, nm)) continue;
                        it.remove();
                    }
                }
                case 0: {
                    return Encodes.setToQueryString(sb, params).toString();
                }
                case 2: {
                    return Encodes.addToQueryString(sb, params).toString();
                }
            }
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    public static final List<String> getContextPaths() {
        return ContextRootsHolder.INSTANCE;
    }

    public static final String getLimitTimeOffer() {
        String lto = Long.toHexString(System.currentTimeMillis());
        return lto + Checksums.getChecksum((String)lto, (String)"");
    }

    public static final boolean isOfferExpired(String lto, int timeout) {
        int len;
        if (lto == null || (len = lto.length()) <= 1) {
            return true;
        }
        char cksm = lto.charAt(len - 1);
        if (cksm != Checksums.getChecksum((String)(lto = lto.substring(0, len - 1)), (String)"")) {
            return true;
        }
        try {
            return Long.parseLong(lto, 16) + (long)timeout * 1000L < System.currentTimeMillis();
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    public static final ExtendletContext addExtendletContext(ServletContext ctx, String name, ExtendletContext extctx) {
        if (name == null || extctx == null) {
            throw new IllegalArgumentException("null");
        }
        return Servlets.getExtWebCtxs(ctx).put(name, extctx);
    }

    public static final ExtendletContext removeExtendletContext(ServletContext ctx, String name) {
        return Servlets.getExtWebCtxs(ctx).remove(name);
    }

    public static final ExtendletContext getExtendletContext(ServletContext ctx, String name) {
        return Servlets.getExtWebCtxs(ctx).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, ExtendletContext> getExtWebCtxs(ServletContext ctx) {
        String attr = "javax.zkoss.web.servlets.ExtendletContexts";
        Class<Servlets> clazz = Servlets.class;
        synchronized (Servlets.class) {
            Map ctxs = (Map)ctx.getAttribute("javax.zkoss.web.servlets.ExtendletContexts");
            if (ctxs == null) {
                ctxs = Collections.synchronizedMap(new HashMap(4));
                ctx.setAttribute("javax.zkoss.web.servlets.ExtendletContexts", ctxs);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ctxs;
        }
    }

    public static final String getExtension(String path) {
        int j;
        if (path != null && (j = path.lastIndexOf(46)) >= 0 && path.indexOf(47, j + 1) < 0) {
            return path.substring(j + 1).toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    public static final String getExtension(String path, boolean lastOnly) {
        if (lastOnly) {
            return Servlets.getExtension(path);
        }
        if (path == null) {
            return null;
        }
        int dot = -1;
        int j = path.length();
        while (--j >= 0) {
            char cc = path.charAt(j);
            if (cc == '.') {
                dot = j;
                continue;
            }
            if (cc != '/') continue;
            break;
        }
        return dot >= 0 ? path.substring(dot + 1).toLowerCase(Locale.ENGLISH) : "";
    }

    public static String getDetail(ServletRequest request) {
        HttpServletRequest hreq = request instanceof HttpServletRequest ? (HttpServletRequest)request : null;
        StringBuffer sb = new StringBuffer(128);
        if (hreq != null) {
            sb.append(" sid: ").append(hreq.getHeader("ZK-SID")).append('\n');
            Servlets.addHeaderInfo(sb, hreq, "user-agent");
            Servlets.addHeaderInfo(sb, hreq, "content-length");
            Servlets.addHeaderInfo(sb, hreq, "content-type");
        }
        sb.append(" ip: ").append(request.getRemoteAddr());
        return sb.toString();
    }

    private static void addHeaderInfo(StringBuffer sb, HttpServletRequest request, String header) {
        sb.append(' ').append(header).append(": ").append(request.getHeader(header)).append('\n');
    }

    public static String getNormalPath(String path) {
        StringBuffer sb = new StringBuffer(path);
        IntStack slashes = new IntStack(32);
        slashes.push(-1);
        int colon = -100;
        int dot1 = -100;
        int dot2 = -100;
        block5: for (int j = 0; j < sb.length(); ++j) {
            char c = sb.charAt(j);
            switch (c) {
                case '/': {
                    if (dot1 >= 0) {
                        if (dot2 >= 0) {
                            int preslash = slashes.pop();
                            if (preslash == 0) {
                                throw new IllegalArgumentException("Illegal path: " + path);
                            }
                            if (slashes.isEmpty()) {
                                slashes.push(-1);
                            }
                            dot2 = -100;
                        }
                        int b = slashes.peek();
                        sb.delete(b + 1, j + 1);
                        j = b;
                        dot1 = -100;
                        continue block5;
                    }
                    int s = slashes.peek();
                    if (s >= 0 && j == s + 1) {
                        if (colon == s - 1) {
                            slashes.clear();
                            slashes.push(-1);
                            slashes.push(j);
                            continue block5;
                        }
                        sb.delete(--j, j + 1);
                        continue block5;
                    }
                    slashes.push(j);
                    continue block5;
                }
                case '.': {
                    if (dot1 < 0) {
                        if (slashes.peek() != j - 1) continue block5;
                        dot1 = j;
                        continue block5;
                    }
                    if (dot2 < 0) {
                        dot2 = j;
                        continue block5;
                    }
                    throw new IllegalArgumentException("Illegal path: " + path);
                }
                case ':': {
                    if (colon >= 0) {
                        throw new IllegalArgumentException("Illegal path: " + path);
                    }
                    colon = j;
                }
                default: {
                    dot2 = -100;
                    dot1 = -100;
                }
            }
        }
        return sb.toString();
    }

    static {
        _rwebkit = Pattern.compile(".*(webkit)[ /]([\\w.]+).*");
        _ropera = Pattern.compile(".*+(opera)(?:.*version)?[ /]([\\w.]+).*");
        _rmozilla = Pattern.compile(".*(mozilla)(?:.*? rv:([\\w.]+))?.*");
        _rchrome = Pattern.compile(".*(chrome)[ /]([\\w.]+).*");
        _randroid = Pattern.compile(".*(android)[ /]([\\w.]+).*");
        _redge = Pattern.compile(".*(edg)[ /]([\\w.]+).*");
        _redgeLegacy = Pattern.compile(".*(edge)[ /]([\\w.]+).*");
        _rsafari = Pattern.compile(".*(safari)[ /]([\\w.]+).*");
        _rtrident = Pattern.compile("trident/([0-9\\.]+)");
        boolean b = false;
        try {
            Class.forName("javax.servlet.annotation.WebServlet");
            b = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _svl3 = b;
        if (!b) {
            try {
                ServletResponse.class.getMethod("getContentType", new Class[0]);
                b = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _svl24 = b;
        if (!b) {
            try {
                HttpSession.class.getMethod("getServletContext", new Class[0]);
                b = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _svl23 = b;
        _ios = new String[]{"ipod", "iphone", "ipad"};
    }

    private static class IntStack {
        private int _top = -1;
        private int[] _value;

        public IntStack(int sz) {
            this._value = new int[sz];
        }

        public boolean isEmpty() {
            return this._top < 0;
        }

        public int peek() {
            return this._top >= 0 && this._top < this._value.length ? this._value[this._top] : -100;
        }

        public int pop() {
            return this._value[this._top--];
        }

        public void push(int val) {
            this._value[++this._top] = val;
        }

        public void clear() {
            this._top = -1;
        }
    }

    public static interface ClientIdentifier {
        public ClientIdentifier matches(String var1);

        public String getName();

        public double getVersion();
    }

    private static class ContextRootsHolder {
        private static final List<String> INSTANCE = Collections.unmodifiableList(ContextRootsHolder.myGetContextPaths());

        private ContextRootsHolder() {
        }

        private static final List<String> myGetContextPaths() {
            String APP_XML = "/META-INF/application.xml";
            LinkedList<Object> ctxroots = new LinkedList<Object>();
            URL xmlURL = Locators.getDefault().getResource("/META-INF/application.xml");
            if (xmlURL == null) {
                throw new SystemException("File not found: /META-INF/application.xml");
            }
            Element root = null;
            try {
                root = new SAXBuilder(false, false, true).build(xmlURL).getRootElement();
            }
            catch (Exception ex) {
                throw SystemException.Aide.wrap((Throwable)ex);
            }
            for (Element e : root.getElements("module")) {
                String ctxroot = (String)e.getContent("web/context-root");
                if (ctxroot == null) continue;
                ctxroots.add(ctxroot.startsWith("/") ? ctxroot : "/" + ctxroot);
            }
            return new ArrayList<String>(ctxroots);
        }
    }

    private static class ParsedURI {
        private ServletContext _svlctx;
        private ExtendletContext _extctx;
        private String _uri;

        private ParsedURI(ServletContext ctx, String uri) {
            if (uri != null && uri.length() > 0 && uri.charAt(0) == '~') {
                String ctxroot;
                int j = uri.indexOf(47, 1);
                if (j >= 0) {
                    ctxroot = "/" + uri.substring(1, j);
                    this._uri = uri.substring(j);
                } else {
                    ctxroot = "/" + uri.substring(1);
                    this._uri = "/";
                }
                this._extctx = Servlets.getExtendletContext(ctx, ctxroot.substring(1));
                if (this._extctx == null) {
                    this._svlctx = ctx.getContext(ctxroot);
                    if (this._svlctx == null) {
                        throw new SystemException("Context not found or not visible to " + ctx + ": " + ctxroot);
                    }
                }
            } else {
                this._svlctx = ctx;
                this._uri = uri;
            }
        }

        private RequestDispatcher getRequestDispatcher(Map params, int mode) {
            if (this._extctx == null && this._svlctx == null) {
                return null;
            }
            String uri = Servlets.generateURI(this._uri, params, mode);
            return this._svlctx != null ? this._svlctx.getRequestDispatcher(uri) : this._extctx.getRequestDispatcher(uri);
        }

        private URL getResource() throws MalformedURLException {
            return this._svlctx != null ? this._svlctx.getResource(this._uri) : (this._extctx != null ? this._extctx.getResource(this._uri) : null);
        }

        private InputStream getResourceAsStream() {
            return this._svlctx != null ? this._svlctx.getResourceAsStream(this._uri) : (this._extctx != null ? this._extctx.getResourceAsStream(this._uri) : null);
        }
    }

    private static class URIIndex {
        private final String _uri;
        private final Locale _locale;

        private URIIndex(String uri, Locale locale) {
            if (uri == null || locale == null) {
                throw new IllegalArgumentException("null");
            }
            this._uri = uri;
            this._locale = locale;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof URIIndex)) {
                return false;
            }
            URIIndex idx = (URIIndex)o;
            return this._uri.equals(idx._uri) && this._locale.equals(idx._locale);
        }
    }
}

