/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl;

import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.ExpressionFactory;
import org.zkoss.zel.MethodExpression;
import org.zkoss.zel.ValueExpression;
import org.zkoss.zel.impl.ValueExpressionLiteral;
import org.zkoss.zel.impl.lang.ELSupport;
import org.zkoss.zel.impl.lang.ExpressionBuilder;
import org.zkoss.zel.impl.stream.StreamELResolverImpl;
import org.zkoss.zel.impl.util.MessageFactory;

public class ExpressionFactoryImpl
extends ExpressionFactory {
    @Override
    public Object coerceToType(Object obj, Class<?> type) {
        return ELSupport.coerceToType(obj, type);
    }

    @Override
    public MethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
        ExpressionBuilder builder = this.newExpressionBuilder(expression, context);
        return builder.createMethodExpression(expectedReturnType, expectedParamTypes);
    }

    @Override
    public ValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        ExpressionBuilder builder = this.newExpressionBuilder(expression, context);
        return builder.createValueExpression(expectedType);
    }

    @Override
    public ValueExpression createValueExpression(Object instance, Class<?> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException(MessageFactory.get("error.value.expectedType"));
        }
        return new ValueExpressionLiteral(instance, expectedType);
    }

    @Override
    public ELResolver getStreamELResolver() {
        return new StreamELResolverImpl();
    }

    protected ExpressionBuilder newExpressionBuilder(String expression, ELContext context) {
        return new ExpressionBuilder(expression, context);
    }
}

