/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.event;

import org.zkoss.zul.TreeModel;

public class TreeDataEvent {
    public static final int CONTENTS_CHANGED = 0;
    public static final int INTERVAL_ADDED = 1;
    public static final int INTERVAL_REMOVED = 2;
    public static final int STRUCTURE_CHANGED = 3;
    public static final int SELECTION_CHANGED = 4;
    public static final int OPEN_CHANGED = 5;
    public static final int MULTIPLE_CHANGED = 6;
    public static final int TRISTATE_CHANGED = 8;
    public static final int DISABLE_CLIENT_UPDATE = 11;
    public static final int ENABLE_CLIENT_UPDATE = 12;
    private final TreeModel _model;
    private final int _type;
    private final int _indexFrom;
    private final int _indexTo;
    private final int[] _nodePath;
    private final int[] _affectedPath;
    private final int[][] _affectedPaths;

    public TreeDataEvent(TreeModel model, int type, int[] nodePath, int indexFrom, int indexTo) {
        this._model = model;
        this._type = type;
        this._nodePath = nodePath;
        this._indexFrom = indexFrom;
        this._indexTo = indexTo;
        this._affectedPath = null;
        this._affectedPaths = null;
    }

    public TreeDataEvent(TreeModel model, int type, int[] nodePath, int indexFrom, int indexTo, int[] affectedPath) {
        this._model = model;
        this._type = type;
        this._nodePath = nodePath;
        this._indexFrom = indexFrom;
        this._indexTo = indexTo;
        this._affectedPath = affectedPath;
        this._affectedPaths = new int[][]{affectedPath};
    }

    public TreeDataEvent(TreeModel model, int type, int[] nodePath, int indexFrom, int indexTo, int[][] affectedPaths) {
        this._model = model;
        this._type = type;
        this._nodePath = nodePath;
        this._indexFrom = indexFrom;
        this._indexTo = indexTo;
        this._affectedPath = (int[])(affectedPaths != null && affectedPaths.length > 0 ? affectedPaths[0] : null);
        this._affectedPaths = affectedPaths;
    }

    public TreeModel getModel() {
        return this._model;
    }

    public int getType() {
        return this._type;
    }

    public int[] getPath() {
        return this._nodePath;
    }

    public int getIndexFrom() {
        return this._indexFrom;
    }

    public int getIndexTo() {
        return this._indexTo;
    }

    public int[] getAffectedPath() {
        return this._affectedPath;
    }

    public int[][] getAffectedPaths() {
        return this._affectedPaths;
    }
}

