/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.common;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicStreamEndPoint
extends AbstractEndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(QuicStreamEndPoint.class);
    private static final ByteBuffer LAST_FLAG = ByteBuffer.allocate(0);
    private static final ByteBuffer EMPTY_WRITABLE_BUFFER = ByteBuffer.allocate(0);
    private final QuicSession session;
    private final long streamId;

    public QuicStreamEndPoint(Scheduler scheduler, QuicSession session, long streamId) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
    }

    public void opened() {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("opened {}", (Object)this);
        }
        if ((connection = this.getConnection()) != null) {
            connection.onOpen();
        }
    }

    public void closed(Throwable failure) {
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("closed {}", (Object)this);
        }
        if ((connection = this.getConnection()) != null) {
            connection.onClose(failure);
        }
    }

    public QuicSession getQuicSession() {
        return this.session;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.session.getLocalAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.session.getRemoteAddress();
    }

    public boolean isStreamFinished() {
        return this.session.isFinished(this.streamId);
    }

    public void shutdownInput(long error) {
        block3: {
            try {
                this.shutdownInput();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("shutting down input with error 0x{} on {}", (Object)Long.toHexString(error), (Object)this);
                }
                this.session.shutdownInput(this.streamId, error);
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("error shutting down input with error 0x{} on {}", new Object[]{Long.toHexString(error), this, x});
            }
        }
    }

    public void shutdownOutput(long error) {
        block3: {
            try {
                this.shutdownOutput();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("shutting down output with error 0x{} on {}", (Object)Long.toHexString(error), (Object)this);
                }
                this.session.shutdownOutput(this.streamId, error);
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("error shutting down output with error 0x{} on {}", new Object[]{Long.toHexString(error), this, x});
            }
        }
    }

    public void close(long error, Throwable failure) {
        this.shutdownInput(error);
        FillInterest fillInterest = this.getFillInterest();
        if (failure == null) {
            fillInterest.onClose();
        } else {
            fillInterest.onFail(failure);
        }
        this.shutdownOutput(error);
        WriteFlusher writeFlusher = this.getWriteFlusher();
        if (failure == null) {
            writeFlusher.onClose();
        } else {
            writeFlusher.onFail(failure);
        }
        this.session.remove(this, failure);
        if (LOG.isDebugEnabled()) {
            LOG.debug("closed with error 0x{} {}", new Object[]{Long.toHexString(error), this, failure});
        }
    }

    public void onClose(Throwable failure) {
    }

    public int fill(ByteBuffer buffer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("filling buffer finished={} from {}", (Object)this.isStreamFinished(), (Object)this);
        }
        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
        int drained = this.session.fill(this.streamId, buffer);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
        return drained;
    }

    public boolean flush(ByteBuffer ... buffers) throws IOException {
        boolean last;
        int length = buffers.length;
        boolean bl = last = buffers[length - 1] == LAST_FLAG;
        if (last) {
            --length;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} buffer(s) to {}", (Object)length, (Object)this);
        }
        for (int i = 0; i < length; ++i) {
            ByteBuffer buffer = buffers[i];
            int flushed = this.session.flush(this.streamId, buffer, i == length - 1 && last);
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} bytes window={}/{} to {}", new Object[]{flushed, this.session.getWindowCapacity(this.streamId), this.session.getWindowCapacity(), this});
            }
            if (!buffer.hasRemaining()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("incomplete flushing of {}", (Object)this);
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushed {}", (Object)this);
        }
        return true;
    }

    public void write(Callback callback, List<ByteBuffer> buffers, boolean last) {
        ByteBuffer[] array;
        if (last) {
            int size = buffers.size();
            array = new ByteBuffer[size + 1];
            IntStream.range(0, size).forEach(i -> {
                array[i] = (ByteBuffer)buffers.get(i);
            });
            array[size] = LAST_FLAG;
        } else {
            array = (ByteBuffer[])buffers.toArray(ByteBuffer[]::new);
        }
        this.write(callback, array);
    }

    public Object getTransport() {
        return this.session;
    }

    public EndPoint.SslSessionData getSslSessionData() {
        X509Certificate[] peerCertificates = this.getQuicSession().getPeerCertificates();
        if (peerCertificates == null) {
            return null;
        }
        return EndPoint.SslSessionData.from(null, null, null, (X509Certificate[])peerCertificates);
    }

    public void onWritable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream #{} is writable", (Object)this.streamId);
        }
        this.getWriteFlusher().completeWrite();
    }

    public boolean onReadable() {
        boolean interested = this.isFillInterested();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream #{} is readable, processing: {}", (Object)this.streamId, (Object)interested);
        }
        if (interested) {
            this.getFillInterest().fillable();
        } else if (this.isStreamFinished()) {
            try {
                this.fill(EMPTY_WRITABLE_BUFFER);
            }
            catch (EOFException x) {
                this.getFillInterest().onFail((Throwable)x);
                this.getQuicSession().onFailure(x);
            }
            catch (Throwable x) {
                EofException e = new EofException(x);
                this.getFillInterest().onFail((Throwable)e);
                this.getQuicSession().onFailure((Throwable)e);
            }
        }
        return interested;
    }

    public void fillInterested(Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting fill interest on {}", (Object)this);
        }
        if (!this.isFillInterested()) {
            super.fillInterested(callback);
        }
        this.getQuicSession().getProtocolSession().produce();
    }

    public boolean tryFillInterested(Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("try setting fill interest on {}", (Object)this);
        }
        boolean result = super.tryFillInterested(callback);
        this.getQuicSession().getProtocolSession().produce();
        return result;
    }

    protected void onIncompleteFlush() {
    }

    protected void needsFillInterest() {
    }

    public String toString() {
        return String.format("%s@%x#%d[%s]->[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getStreamId(), this.toEndPointString(), this.toConnectionString());
    }
}

