/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.zkoss.lang.Strings;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.select.impl.ComponentLocalProperties;
import org.zkoss.zk.ui.select.impl.ComponentMatchCtx;
import org.zkoss.zk.ui.select.impl.Parser;
import org.zkoss.zk.ui.select.impl.PseudoClassDef;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class ComponentIterator
implements Iterator<Component> {
    private final Page _page;
    private final Component _root;
    private final List<Selector> _selectorList;
    private final int _posOffset;
    private final boolean _allIds;
    private final boolean _lookingForShadow;
    private final Map<String, PseudoClassDef> _localDefs = new HashMap<String, PseudoClassDef>();
    private Component _offsetRoot;
    private ComponentMatchCtx _currCtx;
    private Set<String> _trackedUuid;
    private boolean _ready = false;
    private Component _next;
    private int _index = -1;

    public ComponentIterator(Page page, String selector) {
        this(page, null, selector);
    }

    public ComponentIterator(Component root, String selector) {
        this(root.getPage(), root, selector);
    }

    private ComponentIterator(Page page, Component root, String selector) {
        if (page == null && root == null) {
            throw new IllegalArgumentException("Page or root component cannot be null.");
        }
        if (Strings.isEmpty((String)selector)) {
            throw new IllegalArgumentException("Selector string cannot be empty.");
        }
        this._selectorList = new Parser().parse(selector.replaceAll("^::shadow", "*::shadow").replaceAll("::shadow", " > ::shadow"));
        if (this._selectorList.isEmpty()) {
            throw new IllegalStateException("Empty selector");
        }
        this._posOffset = ComponentIterator.getCommonSeqLength(this._selectorList);
        this._allIds = ComponentIterator.isAllIds(this._selectorList, this._posOffset);
        this._lookingForShadow = ComponentIterator.lookingForShadow(this._selectorList);
        if (this._lookingForShadow) {
            this._trackedUuid = new HashSet<String>();
        }
        this._root = root;
        this._page = page;
    }

    private static int getCommonSeqLength(List<Selector> list) {
        ArrayList<String> strs = null;
        int max = 0;
        for (Selector selector : list) {
            if (strs == null) {
                SimpleSelectorSequence seq;
                strs = new ArrayList<String>();
                Iterator iterator = selector.iterator();
                while (iterator.hasNext() && !Strings.isEmpty((String)(seq = (SimpleSelectorSequence)iterator.next()).getId())) {
                    strs.add(seq.toString());
                    strs.add(seq.getCombinator().toString());
                }
                max = strs.size();
                continue;
            }
            int i = 0;
            for (SimpleSelectorSequence seq : selector) {
                if (i < max && !Strings.isEmpty((String)seq.getId()) && ((String)strs.get(i++)).equals(seq.toString()) && ((String)strs.get(i++)).equals(seq.getCombinator().toString())) continue;
                break;
            }
            if (i-- >= max) continue;
            max = i;
        }
        return (max + 1) / 2;
    }

    private static boolean isAllIds(List<Selector> list, int offset) {
        for (Selector s : list) {
            if (s.size() <= offset) continue;
            return false;
        }
        return true;
    }

    private static boolean lookingForShadow(List<Selector> list) {
        for (Selector s : list) {
            for (SimpleSelectorSequence seq : s) {
                if (seq.getPseudoElements().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPseudoClassDef(String name, PseudoClassDef def) {
        this._localDefs.put(name, def);
    }

    public PseudoClassDef removePseudoClassDef(String name) {
        return this._localDefs.remove(name);
    }

    public void clearPseudoClassDefs() {
        this._localDefs.clear();
    }

    @Override
    public boolean hasNext() {
        this.loadNext();
        return this._next != null;
    }

    @Override
    public Component next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this._ready = false;
        return this._next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Component peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._next;
    }

    public int nextIndex() {
        return this._ready ? this._index : this._index + 1;
    }

    private void loadNext() {
        if (this._ready) {
            return;
        }
        this._next = this.seekNext();
        this._ready = true;
        if (this._next == null && this._trackedUuid != null) {
            this._trackedUuid.clear();
        }
    }

    private Component seekNext() {
        this._currCtx = this._index < 0 ? this.buildRootCtx() : (this._lookingForShadow ? this.buildNextShadowCtx() : this.buildNextCtx());
        while (this._currCtx != null && !this._currCtx.isMatched()) {
            this._currCtx = this._lookingForShadow ? this.buildNextShadowCtx() : this.buildNextCtx();
        }
        if (this._currCtx != null) {
            ++this._index;
            return this._currCtx.getComponent();
        }
        return null;
    }

    private ComponentMatchCtx buildRootCtx() {
        Component rt;
        Component component = rt = this._root == null ? this._page.getFirstRoot() : this._root;
        if (this._posOffset > 0) {
            Selector selector = this._selectorList.get(0);
            for (int i = 0; i < this._posOffset; ++i) {
                SimpleSelectorSequence seq = (SimpleSelectorSequence)selector.get(i);
                Component rt2 = null;
                if (!seq.getPseudoElements().isEmpty()) {
                    if (((ComponentCtrl)((Object)rt)).getShadowRoots().isEmpty() || seq.getId() == null) continue;
                    rt2 = (Component)((Object)((ComponentCtrl)((Object)rt)).getShadowFellowIfAny(seq.getId()));
                } else {
                    rt2 = rt.getFellowIfAny(seq.getId());
                }
                if (rt2 == null) {
                    return null;
                }
                if (!(ComponentLocalProperties.matchType(rt2, seq.getType()) && ComponentLocalProperties.matchClasses(rt2, seq.getClasses()) && ComponentLocalProperties.matchAttributes(rt2, seq.getAttributes()) && ComponentLocalProperties.matchPseudoClasses(rt2, seq.getPseudoClasses(), this._localDefs))) {
                    return null;
                }
                if (i > 0) {
                    switch (selector.getCombinator(i - 1)) {
                        case DESCENDANT: {
                            if (ComponentIterator.isDescendant(rt2, rt)) break;
                            return null;
                        }
                        case CHILD: {
                            if (!(rt2 instanceof ShadowElement ? ((ShadowElement)((Object)rt2)).getShadowHost() != rt : rt2.getParent() != rt)) break;
                            return null;
                        }
                        case GENERAL_SIBLING: {
                            if (ComponentIterator.isGeneralSibling(rt2, rt)) break;
                            return null;
                        }
                        case ADJACENT_SIBLING: {
                            if (rt2.getPreviousSibling() == rt) break;
                            return null;
                        }
                    }
                }
                rt = rt2;
            }
            this._offsetRoot = rt.getParent();
        }
        ComponentMatchCtx ctx = new ComponentMatchCtx(rt, this._selectorList);
        if (this._posOffset > 0) {
            for (Selector selector : this._selectorList) {
                ctx.setQualified(selector.getSelectorIndex(), this._posOffset - 1);
            }
        } else {
            this.matchLevel0(ctx);
        }
        return ctx;
    }

    private ComponentMatchCtx buildNextCtx() {
        if (this._allIds) {
            return null;
        }
        if (this._currCtx.getComponent().getFirstChild() != null) {
            return this.buildFirstChildCtx(this._currCtx);
        }
        while (this._currCtx.getComponent().getNextSibling() == null) {
            this._currCtx = this._currCtx.getParent();
            if (this._currCtx != null && this._currCtx.getComponent() != (this._posOffset > 0 ? this._offsetRoot : this._root)) continue;
            return null;
        }
        return this.buildNextSiblingCtx(this._currCtx);
    }

    private Component getNextUntrackedChild(Component comp) {
        Component child;
        for (child = comp.getFirstChild(); child != null && this._trackedUuid.contains(child.getUuid()); child = child.getNextSibling()) {
        }
        return child;
    }

    private Component getNextUntrackedDistributedChild(List<Component> distributedChildren) {
        Optional<Component> matched = distributedChildren.stream().filter(comp -> !this._trackedUuid.contains(comp.getUuid())).findFirst();
        return matched.orElse(null);
    }

    private Pair<Integer, ShadowElement> getNextUntrackedShadowRoot(List<ShadowElement> shadowRoots) {
        AtomicInteger index = new AtomicInteger(-1);
        Optional<ShadowElement> matched = shadowRoots.stream().filter(shadowElement -> {
            index.getAndIncrement();
            return !this._trackedUuid.contains(((HtmlShadowElement)shadowElement).getUuid());
        }).findFirst();
        return matched.map(shadowElement -> new Pair((Object)index.get(), shadowElement)).orElse(null);
    }

    private ComponentMatchCtx buildNextShadowCtx() {
        Component comp = this._currCtx.getComponent();
        boolean isShadow = comp instanceof ShadowElement;
        Component child = this.getNextUntrackedChild(comp);
        if (!isShadow) {
            boolean isShadowHost = this._currCtx.isShadowHost();
            if (isShadowHost) {
                int shadowIndex;
                Pair<Integer, ShadowElement> nextUntrackedShadowRoot = this.getNextUntrackedShadowRoot(((ComponentCtrl)((Object)comp)).getShadowRoots());
                HtmlShadowElement shadow = nextUntrackedShadowRoot != null ? (HtmlShadowElement)nextUntrackedShadowRoot.getY() : null;
                ComponentMatchCtx componentMatchCtx = this.buildChildCtxWithShadowOrComponent(child, shadow, (shadowIndex = nextUntrackedShadowRoot != null ? (Integer)nextUntrackedShadowRoot.getX() : -1) == 0);
                if (componentMatchCtx != null) {
                    return componentMatchCtx;
                }
            } else if (child != null) {
                return this.buildChildCtx(child);
            }
        } else {
            ComponentMatchCtx componentMatchCtx;
            HtmlShadowElement htmlShadowElement = (HtmlShadowElement)comp;
            Component distributedChild = this.getNextUntrackedDistributedChild(htmlShadowElement.getDistributedChildren());
            HtmlShadowElement shadowChild = (HtmlShadowElement)this.getNextUntrackedChild(htmlShadowElement);
            int shadowIndex = -1;
            if (shadowChild != null) {
                shadowIndex = comp.getChildren().indexOf(shadowChild);
            }
            if ((componentMatchCtx = this.buildChildCtxWithShadowOrComponent(distributedChild, shadowChild, shadowIndex == 0)) != null) {
                return componentMatchCtx;
            }
        }
        ComponentMatchCtx componentMatchCtx = this._currCtx = this._currCtx._shadowOwner != null ? this._currCtx._shadowOwner : this._currCtx.getParent();
        if (this._currCtx == null) {
            return null;
        }
        Component currComp = this._currCtx.getComponent();
        if (!(currComp != (this._posOffset > 0 ? this._offsetRoot : this._root) || this._currCtx.isShadowHost() && this.getNextUntrackedShadowRoot(((ComponentCtrl)((Object)currComp)).getShadowRoots()) != null || this.getNextUntrackedChild(currComp) != null)) {
            return null;
        }
        return this.buildNextShadowCtx();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComponentMatchCtx buildChildCtxWithShadowOrComponent(Component comp, HtmlShadowElement htmlShadowElement, boolean isFirstShadow) {
        if (comp != null && htmlShadowElement != null) {
            try {
                switch (HtmlShadowElement.inRange(htmlShadowElement, comp)) {
                    case PREVIOUS: 
                    case BEFORE_PREVIOUS: {
                        return this.buildChildCtx(comp);
                    }
                    case IN_RANGE: 
                    case FIRST: 
                    case LAST: 
                    case NEXT: 
                    case AFTER_NEXT: 
                    case UNKNOWN: {
                        return this.buildShadowCtx(this._currCtx, htmlShadowElement, isFirstShadow);
                    }
                }
                return null;
            }
            catch (IllegalStateException ex) {
                if (!htmlShadowElement.getDistributedChildren().contains(comp)) return null;
                return this.buildShadowCtx(this._currCtx, htmlShadowElement, isFirstShadow);
            }
        } else {
            if (comp != null) {
                return this.buildChildCtx(comp);
            }
            if (htmlShadowElement == null) return null;
            return this.buildShadowCtx(this._currCtx, htmlShadowElement, isFirstShadow);
        }
    }

    private ComponentMatchCtx buildShadowCtx(ComponentMatchCtx parent, HtmlShadowElement htmlShadowElement, boolean isFirstChild) {
        this._trackedUuid.add(htmlShadowElement.getUuid());
        if (this._currCtx.getComponent() instanceof ShadowElement) {
            return this.buildShadowChildCtx(htmlShadowElement);
        }
        return isFirstChild ? this.buildFirstShadowRootCtx(parent, htmlShadowElement) : this.buildNextShadowRootSiblingCtx(parent._lastShadowRoot, htmlShadowElement);
    }

    private ComponentMatchCtx buildNextShadowRootSiblingCtx(ComponentMatchCtx ctx, HtmlShadowElement htmlShadowElement) {
        ctx.moveToNextShadowSibling(htmlShadowElement);
        for (Selector selector : this._selectorList) {
            int i = selector.getSelectorIndex();
            int posEnd = this._posOffset > 0 ? this._posOffset - 1 : 0;
            int len = selector.size();
            block7: for (int j = len - 2; j >= posEnd; --j) {
                Selector.Combinator cb = selector.getCombinator(j);
                ComponentMatchCtx parent = ctx.getParent();
                if (cb == Selector.Combinator.DESCENDANT || cb == Selector.Combinator.CHILD) {
                    ctx.setQualified(i, j, false);
                }
                switch (cb) {
                    case DESCENDANT: {
                        boolean parentPass = parent != null && parent.isQualified(i, j);
                        ctx.setQualified(i, j, parentPass && ComponentIterator.checkIdSpace(selector, j + 1, ctx));
                        if (!parentPass || !this.match(selector, ctx, j + 1)) continue block7;
                        ctx.setQualified(i, j + 1);
                        continue block7;
                    }
                    case CHILD: {
                        ctx.setQualified(i, j + 1, parent != null && parent.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        continue block7;
                    }
                    case GENERAL_SIBLING: {
                        if (!ctx.isQualified(i, j)) continue block7;
                        ctx.setQualified(i, j + 1, this.match(selector, ctx, j + 1));
                        continue block7;
                    }
                    case ADJACENT_SIBLING: {
                        ctx.setQualified(i, j + 1, ctx.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        ctx.setQualified(i, j, false);
                    }
                }
            }
        }
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        return ctx;
    }

    private ComponentMatchCtx buildFirstShadowRootCtx(ComponentMatchCtx parent, HtmlShadowElement htmlShadowElement) {
        ComponentMatchCtx ctx;
        parent._lastShadowRoot = ctx = new ComponentMatchCtx((Component)htmlShadowElement, parent);
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        for (Selector selector : this._selectorList) {
            int posStart;
            int i = selector.getSelectorIndex();
            block4: for (int j = posStart = this._posOffset > 0 ? this._posOffset - 1 : 0; j < selector.size() - 1; ++j) {
                switch (selector.getCombinator(j)) {
                    case CHILD: {
                        if (!parent.isQualified(i, j) || !this.match(selector, ctx, j + 1)) continue block4;
                        ctx.setQualified(i, j + 1);
                    }
                }
            }
        }
        return ctx;
    }

    private ComponentMatchCtx buildShadowChildCtx(HtmlShadowElement se) {
        this._trackedUuid.add(se.getUuid());
        ComponentMatchCtx parent = this._currCtx;
        ComponentMatchCtx lastCtx = parent._lastChild;
        if (lastCtx == null) {
            return this.buildFirstChildCtx(parent);
        }
        return this.buildNextSiblingCtx(lastCtx);
    }

    private ComponentMatchCtx buildChildCtx(Component comp) {
        ComponentMatchCtx lastCtx;
        ComponentMatchCtx parent;
        this._trackedUuid.add(comp.getUuid());
        boolean insideShadow = false;
        if (parent.getComponent() instanceof ShadowElement) {
            insideShadow = true;
            for (parent = this._currCtx; parent != null && parent.getComponent() instanceof ShadowElement; parent = parent.getParent()) {
            }
        }
        ComponentMatchCtx ctx = parent != null ? ((lastCtx = parent._lastChild) == null ? this.buildFirstChildCtx(parent) : this.buildNextSiblingCtx(lastCtx)) : this.buildCompCtx0(new ComponentMatchCtx(comp, this._currCtx));
        if (insideShadow) {
            ctx._shadowOwner = this._currCtx;
        }
        return ctx;
    }

    private ComponentMatchCtx buildFirstChildCtx(ComponentMatchCtx parent) {
        ComponentMatchCtx ctx;
        parent._lastChild = ctx = new ComponentMatchCtx(parent.getComponent().getFirstChild(), parent);
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        for (Selector selector : this._selectorList) {
            int posStart;
            int i = selector.getSelectorIndex();
            block5: for (int j = posStart = this._posOffset > 0 ? this._posOffset - 1 : 0; j < selector.size() - 1; ++j) {
                switch (selector.getCombinator(j)) {
                    case DESCENDANT: {
                        if (parent.isQualified(i, j) && ComponentIterator.checkIdSpace(selector, j + 1, ctx)) {
                            ctx.setQualified(i, j);
                        }
                    }
                    case CHILD: {
                        if (!parent.isQualified(i, j) || !this.match(selector, ctx, j + 1)) continue block5;
                        ctx.setQualified(i, j + 1);
                    }
                }
            }
        }
        return ctx;
    }

    private ComponentMatchCtx buildNextSiblingCtx(ComponentMatchCtx ctx) {
        ctx.moveToNextSibling();
        return this.buildCompCtx0(ctx);
    }

    private ComponentMatchCtx buildCompCtx0(ComponentMatchCtx ctx) {
        for (Selector selector : this._selectorList) {
            int i = selector.getSelectorIndex();
            int posEnd = this._posOffset > 0 ? this._posOffset - 1 : 0;
            int len = selector.size();
            ctx.setQualified(i, len - 1, false);
            block7: for (int j = len - 2; j >= posEnd; --j) {
                Selector.Combinator cb = selector.getCombinator(j);
                ComponentMatchCtx parent = ctx.getParent();
                if (cb == Selector.Combinator.DESCENDANT || cb == Selector.Combinator.CHILD) {
                    ctx.setQualified(i, j, false);
                }
                switch (cb) {
                    case DESCENDANT: {
                        boolean parentPass = parent != null && parent.isQualified(i, j);
                        ctx.setQualified(i, j, parentPass && ComponentIterator.checkIdSpace(selector, j + 1, ctx));
                        if (!parentPass || !this.match(selector, ctx, j + 1)) continue block7;
                        ctx.setQualified(i, j + 1);
                        continue block7;
                    }
                    case CHILD: {
                        ctx.setQualified(i, j + 1, parent != null && parent.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        continue block7;
                    }
                    case GENERAL_SIBLING: {
                        if (!ctx.isQualified(i, j)) continue block7;
                        ctx.setQualified(i, j + 1, this.match(selector, ctx, j + 1));
                        continue block7;
                    }
                    case ADJACENT_SIBLING: {
                        ctx.setQualified(i, j + 1, ctx.isQualified(i, j) && this.match(selector, ctx, j + 1));
                        ctx.setQualified(i, j, false);
                    }
                }
            }
        }
        if (this._posOffset == 0) {
            this.matchLevel0(ctx);
        }
        return ctx;
    }

    private static boolean checkIdSpace(Selector selector, int index, ComponentMatchCtx ctx) {
        return !selector.requiresIdSpace(index) || !(ctx.getComponent() instanceof IdSpace);
    }

    private static boolean isDescendant(Component c1, Component c2) {
        if (c1 == c2) {
            return true;
        }
        while ((c1 = c1.getParent()) != null) {
            if (c1 == c2) {
                return true;
            }
            if (!(c1 instanceof IdSpace)) continue;
            return c1 == c2;
        }
        return false;
    }

    private static boolean isGeneralSibling(Component c1, Component c2) {
        while (c1 != null) {
            if (c1 == c2) {
                return true;
            }
            c1 = c1.getPreviousSibling();
        }
        return false;
    }

    private void matchLevel0(ComponentMatchCtx ctx) {
        for (Selector selector : this._selectorList) {
            if (!this.match(selector, ctx, 0)) continue;
            ctx.setQualified(selector.getSelectorIndex(), 0);
        }
    }

    private boolean match(Selector selector, ComponentMatchCtx ctx, int index) {
        return ctx.match((SimpleSelectorSequence)selector.get(index), this._localDefs);
    }
}

