/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.image;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.image.Image;
import org.zkoss.io.Files;
import org.zkoss.util.media.ContentTypes;

public class AImage
implements Image,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AImage.class);
    private byte[] _data;
    private String _format;
    private String _ctype;
    private String _name;
    private int _width;
    private int _height;

    public AImage(String name, byte[] data) throws IOException {
        this.init(name, data);
    }

    public AImage(String name, InputStream is) throws IOException {
        try {
            this.init(name, Files.readAll(is));
        }
        finally {
            is.close();
        }
    }

    public AImage(String filename) throws IOException {
        this(new File(filename));
    }

    public AImage(File file) throws IOException {
        this(file.getName(), new BufferedInputStream(new FileInputStream(file)));
    }

    public AImage(URL url) throws IOException {
        this(AImage.getName(url), url.openStream());
    }

    private void init(String name, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        this._name = name;
        this._data = data;
        String format = null;
        try {
            ImageInputStream imis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            Iterator<ImageReader> it = ImageIO.getImageReaders(imis);
            if (it.hasNext()) {
                ImageReader rd = it.next();
                format = rd.getFormatName().toLowerCase(Locale.ENGLISH);
            }
        }
        catch (IOException imis) {
            // empty catch block
        }
        if (format == null) {
            this._format = AImage.getFormatByName(name);
            if (this._format == null) {
                throw new IOException("Unknown image format: " + name);
            }
            log.warn("Unsupported image format: " + this._format + "; its width and height are assumed to zero");
            this._height = 0;
            this._width = 0;
        } else {
            this._format = format;
            ImageIcon ii = new ImageIcon(this._data);
            this._width = ii.getIconWidth();
            this._height = ii.getIconHeight();
        }
        this._ctype = AImage.getContentType(this._format);
    }

    private static String getName(URL url) {
        String name = url.getPath();
        if (name != null) {
            int j = name.lastIndexOf(File.pathSeparatorChar);
            if (j >= 0) {
                name = name.substring(j + 1);
            }
            if (File.pathSeparatorChar != '/' && (j = name.lastIndexOf(47)) >= 0) {
                name = name.substring(j + 1);
            }
        }
        return name;
    }

    private static String getContentType(String format) {
        String ctype = ContentTypes.getContentType(format);
        return ctype != null ? ctype : "image/" + format;
    }

    private static String getFormatByName(String name) {
        int k;
        int j;
        if (name != null && (j = name.lastIndexOf(46) + 1) > (k = name.lastIndexOf(47) + 1) && j < name.length()) {
            return name.substring(j);
        }
        return null;
    }

    @Override
    public final boolean isBinary() {
        return true;
    }

    @Override
    public final boolean inMemory() {
        return true;
    }

    @Override
    public byte[] getByteData() {
        return this._data;
    }

    @Override
    public final String getStringData() {
        throw new IllegalStateException("Use getByteData() instead");
    }

    @Override
    public final InputStream getStreamData() {
        return new ByteArrayInputStream(this._data);
    }

    @Override
    public final Reader getReaderData() {
        throw new IllegalStateException("Use getStreamData() instead");
    }

    @Override
    public final String getName() {
        return this._name;
    }

    @Override
    public final String getFormat() {
        return this._format;
    }

    @Override
    public final String getContentType() {
        return this._ctype;
    }

    @Override
    public final int getWidth() {
        return this._width;
    }

    @Override
    public final int getHeight() {
        return this._height;
    }

    @Override
    public final ImageIcon toImageIcon() {
        return new ImageIcon(this._data, this._format);
    }

    @Override
    public boolean isContentDisposition() {
        return true;
    }
}

