/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.data.RewindableDataSourceProvider;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonDataSource;
import net.sf.jasperreports.engine.data.JsonDataSourceProvider;
import net.sf.jasperreports.engine.data.TextDataSourceAttributes;
import net.sf.jasperreports.engine.query.AbstractJsonQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;

public class JsonQueryExecuter
extends AbstractJsonQueryExecuter<JsonDataSource> {
    public static final String CANONICAL_LANGUAGE = "JSON";

    public JsonQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(SimpleQueryExecutionContext.of(jasperReportsContext), dataset, parametersMap);
    }

    public JsonQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    protected JsonDataSource getJsonDataInstance(InputStream jsonInputStream) throws JRException {
        return new JsonDataSource(jsonInputStream, this.getQueryString());
    }

    @Override
    protected JsonDataSource getJsonDataInstance(String jsonSource) throws JRException {
        return new JsonDataSource(this.getRepositoryContext(), jsonSource, this.getQueryString());
    }

    @Override
    protected RewindableDataSourceProvider<JsonDataSource> getJsonDataProviderInstance(String source, TextDataSourceAttributes textAttributes) {
        return new JsonDataSourceProvider(this.getJasperReportsContext(), source, this.getQueryString(), textAttributes);
    }
}

