/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.format;

import java.util.Locale;
import java.util.logging.Logger;
import org.zkoss.util.CacheMap;

public abstract class CellFormatter {
    protected final String format;
    protected final Locale locale;
    protected static final CacheMap _formatters = new CacheMap(8);
    static final Logger logger;

    public CellFormatter(String format, Locale locale) {
        this.format = format;
        this.locale = locale;
    }

    public abstract void formatValue(StringBuffer var1, Object var2);

    public abstract void simpleValue(StringBuffer var1, Object var2);

    public String format(Object value) {
        StringBuffer sb = new StringBuffer();
        this.formatValue(sb, value);
        return sb.toString();
    }

    public String simpleFormat(Object value) {
        StringBuffer sb = new StringBuffer();
        this.simpleValue(sb, value);
        return sb.toString();
    }

    static String quote(String str) {
        return '\"' + str + '\"';
    }

    static {
        _formatters.setLifetime(86400000);
        logger = Logger.getLogger(CellFormatter.class.getName());
    }
}

