/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.poifs.eventfilesystem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.zkoss.poi.poifs.filesystem.DocumentDescriptor;
import org.zkoss.poi.poifs.filesystem.POIFSDocumentPath;

class POIFSReaderRegistry {
    private Set omnivorousListeners = new HashSet();
    private Map selectiveListeners = new HashMap();
    private Map chosenDocumentDescriptors = new HashMap();

    POIFSReaderRegistry() {
    }

    void registerListener(POIFSReaderListener listener, POIFSDocumentPath path, String documentName) {
        if (!this.omnivorousListeners.contains(listener)) {
            DocumentDescriptor descriptor;
            HashSet<DocumentDescriptor> descriptors = (HashSet<DocumentDescriptor>)this.selectiveListeners.get(listener);
            if (descriptors == null) {
                descriptors = new HashSet<DocumentDescriptor>();
                this.selectiveListeners.put(listener, descriptors);
            }
            if (descriptors.add(descriptor = new DocumentDescriptor(path, documentName))) {
                HashSet<POIFSReaderListener> listeners = (HashSet<POIFSReaderListener>)this.chosenDocumentDescriptors.get(descriptor);
                if (listeners == null) {
                    listeners = new HashSet<POIFSReaderListener>();
                    this.chosenDocumentDescriptors.put(descriptor, listeners);
                }
                listeners.add(listener);
            }
        }
    }

    void registerListener(POIFSReaderListener listener) {
        if (!this.omnivorousListeners.contains(listener)) {
            this.removeSelectiveListener(listener);
            this.omnivorousListeners.add(listener);
        }
    }

    Iterator getListeners(POIFSDocumentPath path, String name) {
        HashSet rval = new HashSet(this.omnivorousListeners);
        Set selectiveListeners = (Set)this.chosenDocumentDescriptors.get(new DocumentDescriptor(path, name));
        if (selectiveListeners != null) {
            rval.addAll(selectiveListeners);
        }
        return rval.iterator();
    }

    private void removeSelectiveListener(POIFSReaderListener listener) {
        Set selectedDescriptors = (Set)this.selectiveListeners.remove(listener);
        if (selectedDescriptors != null) {
            Iterator iter = selectedDescriptors.iterator();
            while (iter.hasNext()) {
                this.dropDocument(listener, (DocumentDescriptor)iter.next());
            }
        }
    }

    private void dropDocument(POIFSReaderListener listener, DocumentDescriptor descriptor) {
        Set listeners = (Set)this.chosenDocumentDescriptors.get(descriptor);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.chosenDocumentDescriptors.remove(descriptor);
        }
    }
}

