/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hslf.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.zkoss.poi.hslf.model.SimpleShape;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class ShapePainter {
    protected static POILogger logger = POILogFactory.getLogger(ShapePainter.class);

    public static void paint(SimpleShape shape, Graphics2D graphics) {
        Color lineColor;
        Color fillColor;
        double angle;
        Rectangle2D anchor = shape.getLogicalAnchor2D();
        Shape outline = shape.getOutline();
        if (shape.getFlipVertical()) {
            graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
            graphics.scale(1.0, -1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        if (shape.getFlipHorizontal()) {
            graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
            graphics.scale(-1.0, 1.0);
            graphics.translate(-anchor.getX(), -anchor.getY());
        }
        if ((angle = (double)shape.getRotation()) != 0.0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            graphics.translate(centerX, centerY);
            graphics.rotate(Math.toRadians(angle));
            graphics.translate(-centerX, -centerY);
        }
        if ((fillColor = shape.getFill().getForegroundColor()) != null) {
            graphics.setPaint(fillColor);
            graphics.fill(outline);
        }
        if ((lineColor = shape.getLineColor()) != null) {
            graphics.setPaint(lineColor);
            float width = (float)shape.getLineWidth();
            int dashing = shape.getLineDashing();
            float[] dashptrn = null;
            switch (dashing) {
                case 1: {
                    dashptrn = null;
                    break;
                }
                case 2: {
                    dashptrn = new float[]{width, width};
                    break;
                }
                case 6: {
                    dashptrn = new float[]{width * 4.0f, width * 3.0f};
                    break;
                }
                default: {
                    logger.log(5, "unsupported dashing: " + dashing);
                    dashptrn = new float[]{width, width};
                }
            }
            BasicStroke stroke = new BasicStroke(width, 0, 0, 10.0f, dashptrn, 0.0f);
            graphics.setStroke(stroke);
            graphics.draw(outline);
        }
    }
}

