/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ddf;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.poi.ddf.EscherBSERecord;
import org.zkoss.poi.ddf.EscherBitmapBlip;
import org.zkoss.poi.ddf.EscherBlipRecord;
import org.zkoss.poi.ddf.EscherChildAnchorRecord;
import org.zkoss.poi.ddf.EscherClientAnchorRecord;
import org.zkoss.poi.ddf.EscherClientDataRecord;
import org.zkoss.poi.ddf.EscherContainerRecord;
import org.zkoss.poi.ddf.EscherDgRecord;
import org.zkoss.poi.ddf.EscherDggRecord;
import org.zkoss.poi.ddf.EscherMetafileBlip;
import org.zkoss.poi.ddf.EscherOptRecord;
import org.zkoss.poi.ddf.EscherRecord;
import org.zkoss.poi.ddf.EscherRecordFactory;
import org.zkoss.poi.ddf.EscherSpRecord;
import org.zkoss.poi.ddf.EscherSpgrRecord;
import org.zkoss.poi.ddf.EscherSplitMenuColorsRecord;
import org.zkoss.poi.ddf.EscherTertiaryOptRecord;
import org.zkoss.poi.ddf.EscherTextboxRecord;
import org.zkoss.poi.ddf.UnknownEscherRecord;
import org.zkoss.poi.util.LittleEndian;

public class DefaultEscherRecordFactory
implements EscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherBSERecord.class, EscherOptRecord.class, EscherTertiaryOptRecord.class, EscherClientAnchorRecord.class, EscherDgRecord.class, EscherSpgrRecord.class, EscherSpRecord.class, EscherClientDataRecord.class, EscherDggRecord.class, EscherSplitMenuColorsRecord.class, EscherChildAnchorRecord.class, EscherTextboxRecord.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = DefaultEscherRecordFactory.recordsToMap(escherRecordClasses);

    @Override
    public EscherRecord createRecord(byte[] data, int offset) {
        short recordId;
        short options = LittleEndian.getShort(data, offset);
        if (DefaultEscherRecordFactory.isContainer(options, recordId = LittleEndian.getShort(data, offset + 2))) {
            EscherContainerRecord r = new EscherContainerRecord();
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        if (recordId >= -4072 && recordId <= -3817) {
            EscherBlipRecord r = recordId == -4065 || recordId == -4067 || recordId == -4066 ? new EscherBitmapBlip() : (recordId == -4070 || recordId == -4069 || recordId == -4068 ? new EscherMetafileBlip() : new EscherBlipRecord());
            r.setRecordId(recordId);
            r.setOptions(options);
            return r;
        }
        Constructor<? extends EscherRecord> recordConstructor = recordsMap.get(recordId);
        EscherRecord escherRecord = null;
        if (recordConstructor == null) {
            return new UnknownEscherRecord();
        }
        try {
            escherRecord = recordConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new UnknownEscherRecord();
        }
        escherRecord.setRecordId(recordId);
        escherRecord.setOptions(options);
        return escherRecord;
    }

    private static Map<Short, Constructor<? extends EscherRecord>> recordsToMap(Class<?>[] recClasses) {
        HashMap<Short, Constructor<? extends EscherRecord>> result = new HashMap<Short, Constructor<? extends EscherRecord>>();
        Class[] EMPTY_CLASS_ARRAY = new Class[]{};
        for (int i = 0; i < recClasses.length; ++i) {
            Constructor<?> constructor;
            short sid;
            Class<?> recCls = recClasses[i];
            try {
                sid = recCls.getField("RECORD_ID").getShort(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            try {
                constructor = recCls.getConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            result.put(sid, constructor);
        }
        return result;
    }

    public static boolean isContainer(short options, short recordId) {
        if (recordId >= -4096 && recordId <= -4091) {
            return true;
        }
        if (recordId == -4083) {
            return false;
        }
        return (options & 0xF) == 15;
    }
}

