/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.ui.impl.undo.AbstractCellDataStyleAction;

public class PasteSpecialCellAction
extends AbstractCellDataStyleAction {
    private static final long serialVersionUID = 2071474055576279372L;
    protected final int _destRow;
    protected final int _destColumn;
    protected final int _destLastRow;
    protected final int _destLastColumn;
    protected final int _reservedDestLastRow;
    protected final int _reservedDestLastColumn;
    protected final Sheet _destSheet;
    protected final Range.PasteType _pasteType;
    protected final Range.PasteOperation _pasteOperation;
    protected final boolean _skipBlank;
    protected final boolean _transpose;
    private Range _pastedRange;

    public PasteSpecialCellAction(String label, Sheet sheet, int srcRow, int srcColumn, int srcLastRow, int srcLastColumn, Sheet destSheet, int destRow, int destColumn, int destLastRow, int destLastColumn, Range.PasteType pasteType, Range.PasteOperation pasteOperation, boolean skipBlank, boolean transpose) {
        super(label, sheet, srcRow, srcColumn, srcLastRow, srcLastColumn, 7);
        this._transpose = transpose;
        this._destRow = destRow;
        this._destColumn = destColumn;
        this._destLastRow = destLastRow;
        this._destLastColumn = destLastColumn;
        int srcColNum = srcLastColumn - srcColumn;
        int srcRowNum = srcLastRow - srcRow;
        int destWidth = Math.max(destLastColumn - destColumn, transpose ? srcRowNum : srcColNum);
        int destHeight = Math.max(destLastRow - destRow, transpose ? srcColNum : srcRowNum);
        this._reservedDestLastRow = this._destRow + destHeight;
        this._reservedDestLastColumn = this._destColumn + destWidth;
        this._destSheet = destSheet;
        this._pasteType = pasteType;
        this._pasteOperation = pasteOperation;
        this._skipBlank = skipBlank;
    }

    @Override
    protected boolean isSheetProtected() {
        return this.isAnyCellProtected(this._destSheet, this.computePastingRegion()) && (this._pasteType != Range.PasteType.FORMATS || !Ranges.range(this._sheet).getSheetProtection().isFormatCellsAllowed());
    }

    @Override
    public Sheet getUndoSheet() {
        return this._destSheet;
    }

    @Override
    public Sheet getRedoSheet() {
        return this._destSheet;
    }

    @Override
    protected int getReservedRow() {
        return this._destRow;
    }

    @Override
    protected int getReservedColumn() {
        return this._destColumn;
    }

    @Override
    protected int getReservedLastRow() {
        return this._reservedDestLastRow;
    }

    @Override
    protected int getReservedLastColumn() {
        return this._reservedDestLastColumn;
    }

    @Override
    protected Sheet getReservedSheet() {
        return this._destSheet;
    }

    @Override
    public AreaRef getUndoSelection() {
        return this._pastedRange == null ? new AreaRef(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn) : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }

    @Override
    public AreaRef getRedoSelection() {
        return this._pastedRange == null ? new AreaRef(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn) : new AreaRef(this._pastedRange.getRow(), this._pastedRange.getColumn(), this._pastedRange.getLastRow(), this._pastedRange.getLastColumn());
    }

    @Override
    protected void applyAction() {
        Range src = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        Range dest = Ranges.range(this._destSheet, this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
        this._pastedRange = CellOperationUtil.pasteSpecial(src, dest, this._pasteType, this._pasteOperation, this._skipBlank, this._transpose);
        if (this.isDstSheetProtected()) {
            EditableCellStyle recoveredStyle = this._pastedRange.getCellStyleHelper().createCellStyle(dest.getCellStyle());
            recoveredStyle.setLocked(false);
            this._pastedRange.setCellStyle(recoveredStyle);
        }
        CellOperationUtil.fitFontHeightPoints(Ranges.range(this._destSheet, dest.getRow(), dest.getColumn(), dest.getRow() + (this._lastRow - this._row), dest.getColumn() + (this._lastColumn - this._column)));
    }

    private CellRegion computePastingRegion() {
        CellRegion destinationRegion = new CellRegion(this._destRow, this._destColumn, this._destLastRow, this._destLastColumn);
        if (destinationRegion.isSingle()) {
            return new CellRegion(this._destRow, this._destColumn, this._destRow + (this._lastRow - this._row), this._destColumn + (this._lastColumn - this._column));
        }
        return destinationRegion;
    }

    protected boolean isDstSheetProtected() {
        try {
            return this._destSheet.isProtected();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

