/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBorder;
import io.keikai.model.SCFValueObject;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SColor;
import io.keikai.model.SColorFilter;
import io.keikai.model.SColorScale;
import io.keikai.model.SColumnArray;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDataBar;
import io.keikai.model.SDataValidation;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SIconSet;
import io.keikai.model.SPicture;
import io.keikai.model.SRichText;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STableColumn;
import io.keikai.model.STableStyle;
import io.keikai.model.STableStyleElem;
import io.keikai.model.STableStyleInfo;
import io.keikai.model.STop10Filter;
import io.keikai.model.ViewAnchor;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractColorAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.SheetImpl;
import io.keikai.range.impl.imexp.AbstractExcelExporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.UnitUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfvo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColorScale;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDataBar;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTIconSet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCfvoType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STConditionalFormattingOperator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STIconSetType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STTimePeriod;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.CreationHelper;
import org.zkoss.poi.ss.usermodel.CustomFilter;
import org.zkoss.poi.ss.usermodel.DataFormat;
import org.zkoss.poi.ss.usermodel.DataValidation;
import org.zkoss.poi.ss.usermodel.DataValidationConstraint;
import org.zkoss.poi.ss.usermodel.DxfCellStyle;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.RichTextString;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.TableStyle;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.usermodel.charts.AxisPosition;
import org.zkoss.poi.ss.usermodel.charts.CategoryAxis;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartData;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartLegend;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.ss.usermodel.charts.XYData;
import org.zkoss.poi.ss.usermodel.charts.XYZData;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.poi.ss.util.CellRangeAddressList;
import org.zkoss.poi.xssf.usermodel.XSSFAutoFilter;
import org.zkoss.poi.xssf.usermodel.XSSFCellStyle;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFColorFilter;
import org.zkoss.poi.xssf.usermodel.XSSFConditionalFormatting;
import org.zkoss.poi.xssf.usermodel.XSSFCustomFilters;
import org.zkoss.poi.xssf.usermodel.XSSFDxfCellStyle;
import org.zkoss.poi.xssf.usermodel.XSSFDynamicFilter;
import org.zkoss.poi.xssf.usermodel.XSSFFont;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import org.zkoss.poi.xssf.usermodel.XSSFSheet;
import org.zkoss.poi.xssf.usermodel.XSSFTable;
import org.zkoss.poi.xssf.usermodel.XSSFTableColumn;
import org.zkoss.poi.xssf.usermodel.XSSFTableStyle;
import org.zkoss.poi.xssf.usermodel.XSSFTableStyleInfo;
import org.zkoss.poi.xssf.usermodel.XSSFTop10Filter;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;
import org.zkoss.poi.xssf.usermodel.charts.XSSFArea3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFAreaChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBar3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBarChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFBubbleChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumn3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFColumnChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFDoughnutChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLine3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFLineChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPie3DChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFPieChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFScatChartData;
import org.zkoss.poi.xssf.usermodel.charts.XSSFView3D;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellFill;

public class ExcelXlsxExporter
extends AbstractExcelExporter {
    private static final long serialVersionUID = 20141231175402L;

    @Override
    protected void exportColumnArray(SSheet sheet, Sheet poiSheet, SColumnArray columnArr) {
        XSSFSheet xssfSheet = (XSSFSheet)poiSheet;
        CTWorksheet ctSheet = xssfSheet.getCTWorksheet();
        if (xssfSheet.getCTWorksheet().sizeOfColsArray() == 0) {
            xssfSheet.getCTWorksheet().addNewCols();
        }
        int defaultWidth = sheet.getDefaultColumnWidth();
        int columnWidth = columnArr.getWidth();
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        int charWidth = book.getCharWidth();
        CTCol col = ctSheet.getColsArray(0).addNewCol();
        col.setMin((long)(columnArr.getIndex() + 1));
        col.setMax((long)(columnArr.getLastIndex() + 1));
        col.setStyle((long)this.toPOICellStyle(columnArr.getCellStyle()).getIndex());
        col.setCustomWidth(columnArr.isCustomWidth() || columnWidth != defaultWidth);
        col.setWidth(UnitUtil.pxToCTChar(columnWidth, charWidth));
        col.setHidden(columnArr.isHidden());
    }

    @Override
    protected Workbook createPoiBook() {
        return new XSSFWorkbook();
    }

    @Override
    protected void exportChart(SSheet sheet, Sheet poiSheet) {
        for (SChart chart : sheet.getCharts()) {
            ChartData chartData = this.fillPoiChartData(chart);
            if (chartData == null) continue;
            this.plotPoiChart(chart, chartData, sheet, poiSheet);
        }
    }

    @Override
    protected void exportPicture(SSheet sheet, Sheet poiSheet) {
        for (SPicture picture : sheet.getPictures()) {
            int poiPictureIndex = (Integer)this.exportedPicDataMap.get(picture.getPictureData().getIndex());
            poiSheet.createDrawingPatriarch().createPicture(this.toClientAnchor(picture.getAnchor(), sheet), poiPictureIndex);
        }
    }

    protected ChartData fillPoiChartData(SChart chart) {
        XSSFDoughnutChartData categoryData = null;
        XSSFBubbleChartData chartData = null;
        switch (chart.getType()) {
            case AREA: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFArea3DChartData();
                    ((XSSFArea3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    break;
                }
                categoryData = new XSSFAreaChartData();
                ((XSSFAreaChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                break;
            }
            case BAR: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFBar3DChartData();
                    ((XSSFBar3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    ((XSSFBar3DChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                    break;
                }
                categoryData = new XSSFBarChartData();
                ((XSSFBarChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                ((XSSFBarChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                ((XSSFBarChartData)categoryData).setBarOverlap(chart.getBarOverlap());
                break;
            }
            case BUBBLE: {
                XSSFBubbleChartData xyzData = new XSSFBubbleChartData();
                this.fillXYZData((SGeneralChartData)chart.getData(), (XYZData)xyzData);
                chartData = xyzData;
                break;
            }
            case COLUMN: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFColumn3DChartData();
                    ((XSSFColumn3DChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                    ((XSSFColumn3DChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                    break;
                }
                categoryData = new XSSFColumnChartData();
                ((XSSFColumnChartData)categoryData).setGrouping(PoiEnumConversion.toPoiGrouping(chart.getGrouping()));
                ((XSSFColumnChartData)categoryData).setBarDirection(PoiEnumConversion.toPoiBarDirection(chart.getBarDirection()));
                ((XSSFColumnChartData)categoryData).setBarOverlap(chart.getBarOverlap());
                break;
            }
            case DOUGHNUT: {
                categoryData = new XSSFDoughnutChartData();
                break;
            }
            case LINE: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFLine3DChartData();
                    break;
                }
                categoryData = new XSSFLineChartData();
                break;
            }
            case PIE: {
                if (chart.isThreeD()) {
                    categoryData = new XSSFPie3DChartData();
                    break;
                }
                categoryData = new XSSFPieChartData();
                break;
            }
            case SCATTER: {
                XSSFScatChartData xyData = new XSSFScatChartData();
                this.fillXYData((SGeneralChartData)chart.getData(), (XYData)xyData);
                chartData = xyData;
                break;
            }
            default: {
                return chartData;
            }
        }
        if (categoryData != null) {
            this.fillCategoryData((SGeneralChartData)chart.getData(), (CategoryData)categoryData);
            chartData = categoryData;
        }
        return chartData;
    }

    protected void plotPoiChart(SChart chart, ChartData chartData, SSheet sheet, Sheet poiSheet) {
        Chart poiChart = poiSheet.createDrawingPatriarch().createChart(this.toClientAnchor(chart.getAnchor(), sheet));
        if (chart.isThreeD()) {
            XSSFView3D view3d = (XSSFView3D)poiChart.getOrCreateView3D();
            if (chart.getRotX() != 0) {
                view3d.setRotX(chart.getRotX());
            }
            if (chart.getRotY() != 0) {
                view3d.setRotY(chart.getRotY());
            }
            if (chart.getPerspective() != 30) {
                view3d.setPerspective(chart.getPerspective());
            }
            if (chart.getHPercent() != 100) {
                view3d.setHPercent(chart.getHPercent());
            }
            if (chart.getDepthPercent() != 100) {
                view3d.setDepthPercent(chart.getDepthPercent());
            }
            if (!chart.isRightAngleAxes()) {
                view3d.setRightAngleAxes(false);
            }
        }
        if (chart.getLegendPosition() != null) {
            ChartLegend legend = poiChart.getOrCreateLegend();
            legend.setPosition(PoiEnumConversion.toPoiLegendPosition(chart.getLegendPosition()));
        }
        CategoryAxis bottomAxis = null;
        switch (chart.getType()) {
            case AREA: 
            case BAR: 
            case COLUMN: 
            case LINE: {
                bottomAxis = poiChart.getChartAxisFactory().createCategoryAxis(AxisPosition.BOTTOM);
                break;
            }
            case BUBBLE: 
            case SCATTER: {
                bottomAxis = poiChart.getChartAxisFactory().createValueAxis(AxisPosition.BOTTOM);
            }
        }
        if (bottomAxis != null) {
            poiChart.plot(chartData, new ChartAxis[]{bottomAxis, poiChart.getChartAxisFactory().createValueAxis(AxisPosition.LEFT)});
        } else {
            poiChart.plot(chartData, new ChartAxis[0]);
        }
        poiChart.setPlotOnlyVisibleCells(chart.isPlotOnlyVisibleCells());
    }

    protected ClientAnchor toClientAnchor(ViewAnchor viewAnchor, SSheet sheet) {
        ViewAnchor rightBottomAnchor = viewAnchor.getRightBottomAnchor(sheet);
        XSSFClientAnchor clientAnchor = new XSSFClientAnchor(UnitUtil.pxToEmu(viewAnchor.getXOffset()), UnitUtil.pxToEmu(viewAnchor.getYOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getXOffset()), UnitUtil.pxToEmu(rightBottomAnchor.getYOffset()), viewAnchor.getColumnIndex(), viewAnchor.getRowIndex(), rightBottomAnchor.getColumnIndex(), rightBottomAnchor.getRowIndex());
        return clientAnchor;
    }

    protected void fillCategoryData(SGeneralChartData chartData, CategoryData categoryData) {
        ChartDataSource<?> categories = this.createCategoryChartDataSource(chartData);
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> values = this.createXValueDataSource(series);
            categoryData.addSerie(title, categories, values);
        }
    }

    protected void fillXYData(SGeneralChartData chartData, XYData xyData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> xValues = this.createXValueDataSource(series);
            ChartDataSource<Number> yValues = this.createYValueDataSource(series);
            xyData.addSerie(title, xValues, yValues);
        }
    }

    protected void fillXYZData(SGeneralChartData chartData, XYZData xyzData) {
        for (int i = 0; i < chartData.getNumOfSeries(); ++i) {
            SSeries series = chartData.getSeries(i);
            ChartTextSource title = this.createChartTextSource(series);
            ChartDataSource<Number> xValues = this.createXValueDataSource(series);
            ChartDataSource<Number> yValues = this.createYValueDataSource(series);
            ChartDataSource<Number> zValues = this.createZValueDataSource(series);
            xyzData.addSerie(title, xValues, yValues, zValues);
        }
    }

    protected ChartDataSource<Number> createXValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfXValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getXValue(index).toString());
                }
                catch (NumberFormatException nfe) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getXValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    protected ChartDataSource<Number> createYValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfYValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getYValue(index).toString());
                }
                catch (NumberFormatException nfe) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getYValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    protected ChartDataSource<Number> createZValueDataSource(final SSeries series) {
        return new ChartDataSource<Number>(){

            public int getPointCount() {
                return series.getNumOfZValue();
            }

            public Number getPointAt(int index) {
                try {
                    return Double.parseDouble(series.getZValue(index).toString());
                }
                catch (NumberFormatException e) {
                    return index;
                }
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return true;
            }

            public String getFormulaString() {
                return series.getZValuesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    protected ChartTextSource createChartTextSource(final SSeries series) {
        return new ChartTextSource(){

            public void renameSheet(String oldname, String newname) {
            }

            public boolean isReference() {
                return true;
            }

            public String getTextString() {
                return series.getName();
            }

            public String getFormulaString() {
                return series.getNameFormula();
            }
        };
    }

    protected ChartDataSource<?> createCategoryChartDataSource(final SGeneralChartData chartData) {
        return new ChartDataSource<String>(){

            public int getPointCount() {
                return chartData.getNumOfCategory();
            }

            public String getPointAt(int index) {
                return chartData.getCategory(index).toString();
            }

            public boolean isReference() {
                return true;
            }

            public boolean isNumeric() {
                return false;
            }

            public String getFormulaString() {
                return chartData.getCategoriesFormula();
            }

            public void renameSheet(String oldname, String newname) {
            }
        };
    }

    @Override
    protected void exportValidation(SSheet sheet, Sheet poiSheet) {
        block10: for (SDataValidation validation : sheet.getDataValidations()) {
            int operatorType = PoiEnumConversion.toPoiOperatorType(validation.getOperatorType());
            String formula1 = ((AbstractDataValidationAdv)validation).getEscapedFormula1();
            String formula2 = ((AbstractDataValidationAdv)validation).getEscapedFormula2();
            DataValidationConstraint constraint = null;
            switch (validation.getValidationType()) {
                case TIME: {
                    constraint = poiSheet.getDataValidationHelper().createTimeConstraint(operatorType, formula1, formula2);
                    break;
                }
                case TEXT_LENGTH: {
                    constraint = poiSheet.getDataValidationHelper().createTextLengthConstraint(operatorType, formula1, formula2);
                    break;
                }
                case DATE: {
                    constraint = poiSheet.getDataValidationHelper().createDateConstraint(operatorType, formula1, formula2, "");
                    break;
                }
                case LIST: {
                    constraint = poiSheet.getDataValidationHelper().createFormulaListConstraint(formula1);
                    break;
                }
                case INTEGER: {
                    constraint = poiSheet.getDataValidationHelper().createIntegerConstraint(operatorType, formula1, formula2);
                    break;
                }
                case CUSTOM: {
                    constraint = poiSheet.getDataValidationHelper().createCustomConstraint(formula1);
                    break;
                }
                case DECIMAL: {
                    constraint = poiSheet.getDataValidationHelper().createDecimalConstraint(operatorType, formula1, formula2);
                    break;
                }
                case ANY: {
                    constraint = poiSheet.getDataValidationHelper().createAnyConstraint();
                    break;
                }
                default: {
                    continue block10;
                }
            }
            if (validation.getRegions().isEmpty()) continue;
            CellRangeAddressList rgnList = new CellRangeAddressList();
            for (CellRegion rgn : validation.getRegions()) {
                rgnList.addCellRangeAddress(rgn.getRow(), rgn.getColumn(), rgn.getLastRow(), rgn.getLastColumn());
            }
            DataValidation poiValidation = poiSheet.getDataValidationHelper().createValidation(constraint, rgnList);
            poiValidation.setEmptyCellAllowed(validation.isIgnoreBlank());
            poiValidation.setSuppressDropDownArrow(validation.isInCellDropdown());
            poiValidation.setErrorStyle(PoiEnumConversion.toPoiErrorStyle(validation.getAlertStyle()));
            poiValidation.createErrorBox(validation.getErrorTitle(), validation.getErrorMessage());
            poiValidation.setShowErrorBox(validation.isShowError());
            poiValidation.createPromptBox(validation.getInputTitle(), validation.getInputMessage());
            poiValidation.setShowPromptBox(validation.isShowInput());
            poiSheet.addValidationData(poiValidation);
        }
    }

    @Override
    protected void exportAutoFilter(SSheet sheet, Sheet poiSheet) {
        SAutoFilter autoFilter = sheet.getAutoFilter();
        if (autoFilter != null) {
            CellRegion region = autoFilter.getRegion();
            XSSFAutoFilter poiAutoFilter = (XSSFAutoFilter)poiSheet.setAutoFilter(new CellRangeAddress(region.getRow(), region.getLastRow(), region.getColumn(), region.getLastColumn()));
            int numberOfColumn = region.getLastColumn() - region.getColumn() + 1;
            this.exportFilterColumns(poiAutoFilter, autoFilter, numberOfColumn);
        }
    }

    protected void exportFilterColumns(XSSFAutoFilter poiAutoFilter, SAutoFilter autoFilter, int numberOfColumn) {
        HashMap<String, Object> extra = new HashMap<String, Object>();
        for (int i = 0; i < numberOfColumn; ++i) {
            STop10Filter top10Filter;
            SDynamicFilter dynamicFilter;
            SAutoFilter.NFilterColumn srcFilterColumn = autoFilter.getFilterColumn(i, false);
            if (srcFilterColumn == null) continue;
            XSSFAutoFilter.XSSFFilterColumn destFilterColumn = (XSSFAutoFilter.XSSFFilterColumn)poiAutoFilter.getOrCreateFilterColumn(i);
            String[] criteria1 = null;
            if (srcFilterColumn.getCriteria1() != null) {
                criteria1 = srcFilterColumn.getCriteria1().toArray(new String[0]);
            }
            String[] criteria2 = null;
            if (srcFilterColumn.getCriteria1() != null) {
                criteria2 = srcFilterColumn.getCriteria2().toArray(new String[0]);
            }
            SColorFilter colorFilter = srcFilterColumn.getColorFilter();
            XSSFColorFilter poiFilter = null;
            if (colorFilter != null) {
                SExtraStyle extraStyle = colorFilter.getExtraStyle();
                this.addPOIDxfCellStyle(extraStyle);
                XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
                poiFilter = new XSSFColorFilter((DxfCellStyle)poiCellStyle, colorFilter.isByFontColor());
            }
            extra.put("colorFilter", poiFilter);
            SCustomFilters customFilters = srcFilterColumn.getCustomFilters();
            if (customFilters != null) {
                XSSFCustomFilters poiCustomFilters = new XSSFCustomFilters(destFilterColumn);
                poiCustomFilters.setAnd(customFilters.isAnd());
                SCustomFilter srcFilter1 = customFilters.getCustomFilter1();
                SCustomFilter srcFilter2 = customFilters.getCustomFilter2();
                poiCustomFilters.addCustomFilter(this.toPOIOpertor(srcFilter1.getOperator()), srcFilter1.getValue());
                if (srcFilter2 != null) {
                    poiCustomFilters.addCustomFilter(this.toPOIOpertor(srcFilter2.getOperator()), srcFilter2.getValue());
                }
                extra.put("customFilters", poiCustomFilters);
            }
            if ((dynamicFilter = srcFilterColumn.getDynamicFilter()) != null) {
                XSSFDynamicFilter poiDynamicFilter = new XSSFDynamicFilter(destFilterColumn);
                poiDynamicFilter.setProperties(dynamicFilter.getMaxValue(), dynamicFilter.getValue(), dynamicFilter.getType());
                extra.put("dynamicFilter", poiDynamicFilter);
            }
            if ((top10Filter = srcFilterColumn.getTop10Filter()) != null) {
                XSSFTop10Filter poiTop10Filter = new XSSFTop10Filter(destFilterColumn);
                poiTop10Filter.setProperties(top10Filter.isTop(), top10Filter.getValue(), top10Filter.isPercent(), top10Filter.getFilterValue());
                extra.put("top10Filter", poiTop10Filter);
            }
            destFilterColumn.setProperties((Object)criteria1, PoiEnumConversion.toPoiFilterOperator(srcFilterColumn.getOperator()), (Object)criteria2, Boolean.valueOf(srcFilterColumn.isShowButton()), extra);
        }
    }

    private CustomFilter.Operator toPOIOpertor(SAutoFilter.FilterOp op) {
        return CustomFilter.Operator.valueOf((String)op.name());
    }

    @Override
    protected void exportPassword(SSheet sheet, Sheet poiSheet) {
        String hashValue = ((SheetImpl)sheet).getHashValue();
        if (hashValue != null) {
            String saltValue = ((SheetImpl)sheet).getSaltValue();
            String spinCount = ((SheetImpl)sheet).getSpinCount();
            String algName = ((SheetImpl)sheet).getAlgName();
            ((XSSFSheet)poiSheet).setHashValue(hashValue);
            ((XSSFSheet)poiSheet).setSaltValue(saltValue);
            ((XSSFSheet)poiSheet).setSpinCount(spinCount);
            ((XSSFSheet)poiSheet).setAlgName(algName);
        } else {
            short hashpass = sheet.getHashedPassword();
            if (hashpass != 0) {
                ((XSSFSheet)poiSheet).setPasswordHash(hashpass);
            }
        }
    }

    @Override
    protected CellStyle toPOIDefaultCellStyle(SCellStyle cellStyle) {
        short bottom = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderBottom());
        short left = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderLeft());
        short right = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderRight());
        short top = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderTop());
        Color bottomColor = this.toPOIColor(cellStyle.getBorderBottomColor());
        Color leftColor = this.toPOIColor(cellStyle.getBorderLeftColor());
        Color rightColor = this.toPOIColor(cellStyle.getBorderRightColor());
        Color topColor = this.toPOIColor(cellStyle.getBorderTopColor());
        CTBorder ct = CTBorder.Factory.newInstance();
        XSSFCellBorder border = new XSSFCellBorder(ct);
        border.prepareBorder(left, leftColor, top, topColor, right, rightColor, bottom, bottomColor);
        SColor fgColor = cellStyle.getFillColor();
        SColor bgColor = cellStyle.getBackColor();
        if (cellStyle.getFillPattern() == SFill.FillPattern.SOLID) {
            SColor tmp = fgColor;
            fgColor = bgColor;
            bgColor = tmp;
        }
        Color fillColor = this.toPOIColor(fgColor);
        Color backColor = this.toPOIColor(bgColor);
        short pattern = PoiEnumConversion.toPoiFillPattern(cellStyle.getFillPattern());
        CTFill ctf = CTFill.Factory.newInstance();
        XSSFCellFill fill = new XSSFCellFill(ctf);
        fill.prepareFill(fillColor, backColor, pattern);
        XSSFFont font = (XSSFFont)this.toPOIFont(cellStyle.getFont());
        DataFormat df = this.workbook.createDataFormat();
        short fmt = df.getFormat(cellStyle.getDataFormat());
        XSSFCellStyle poiCellStyle = (XSSFCellStyle)((XSSFWorkbook)this.workbook).createDefaultCellStyle(border, fill, font, (int)fmt);
        short hAlign = PoiEnumConversion.toPoiHorizontalAlignment(cellStyle.getAlignment());
        short vAlign = PoiEnumConversion.toPoiVerticalAlignment(cellStyle.getVerticalAlignment());
        boolean wrapText = cellStyle.isWrapText();
        poiCellStyle.setDefaultCellAlignment(hAlign, vAlign, wrapText);
        boolean locked = cellStyle.isLocked();
        boolean hidden = cellStyle.isHidden();
        poiCellStyle.setDefaultProtection(locked, hidden);
        return poiCellStyle;
    }

    @Override
    protected int exportTables(SSheet sheet, Sheet poiSheet0, int tbId) {
        XSSFSheet poiSheet = (XSSFSheet)poiSheet0;
        for (STable table : sheet.getTables()) {
            XSSFTable poiTable = poiSheet.createTable();
            poiTable.setName(table.getName());
            poiTable.setDisplayName(table.getDisplayName());
            poiTable.setRef(table.getAllRegion().getRegion().getReferenceString());
            poiTable.setTotalsRowCount(table.getTotalsRowCount());
            poiTable.setHeaderRowCount(table.getHeaderRowCount());
            XSSFTableStyleInfo poiInfo = poiTable.createTableStyleInfo();
            STableStyleInfo info = table.getTableStyleInfo();
            poiInfo.setName(info.getName());
            poiInfo.setShowColumnStripes(info.isShowColumnStripes());
            poiInfo.setShowRowStripes(info.isShowRowStripes());
            poiInfo.setShowLastColumn(info.isShowLastColumn());
            poiInfo.setShowFirstColumn(info.isShowFirstColumn());
            SAutoFilter filter = table.getAutoFilter();
            if (filter != null) {
                CellRegion region = filter.getRegion();
                XSSFAutoFilter poiFilter = poiTable.createAutoFilter();
                poiFilter.setRef(region.getReferenceString());
                this.exportFilterColumns(poiFilter, filter, region.getColumnCount());
            } else {
                poiTable.clearAutoFilter();
            }
            int j = 0;
            for (STableColumn tbCol : table.getColumns()) {
                XSSFTableColumn poiTbCol = poiTable.addTableColumn();
                poiTbCol.setName(tbCol.getName());
                poiTbCol.setId(++j);
                if (tbCol.getTotalsRowFunction() != null) {
                    poiTbCol.setTotalsRowFunction(XSSFTableColumn.TotalsRowFunction.values()[tbCol.getTotalsRowFunction().ordinal()]);
                }
                if (tbCol.getTotalsRowFunction() == STableColumn.STotalsRowFunction.none && tbCol.getTotalsRowLabel() != null) {
                    poiTbCol.setTotalsRowLabel(tbCol.getTotalsRowLabel());
                    continue;
                }
                if (tbCol.getTotalsRowFunction() != STableColumn.STotalsRowFunction.custom || tbCol.getTotalsRowFormula() == null) continue;
                poiTbCol.setTotalsRowFormula(tbCol.getTotalsRowFormula());
            }
            poiTable.setId(++tbId);
            ((XSSFWorkbook)this.workbook).addTableName(poiTable);
        }
        return tbId;
    }

    @Override
    protected void addPOIDxfCellStyle(SExtraStyle extraStyle) {
        String dataFormat;
        AbstractFillAdv fill;
        XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
        if (poiCellStyle != null) {
            return;
        }
        poiCellStyle = (XSSFDxfCellStyle)this.workbook.createDxfCellStyle();
        if (extraStyle.getBorder() != null) {
            SBorder.BorderType btb = extraStyle.getBorderBottom();
            SBorder.BorderType btl = extraStyle.getBorderLeft();
            SBorder.BorderType btr = extraStyle.getBorderRight();
            SBorder.BorderType btt = extraStyle.getBorderTop();
            SBorder.BorderType btd = extraStyle.getBorderDiagonal();
            SBorder.BorderType bth = extraStyle.getBorderHorizontal();
            SBorder.BorderType btv = extraStyle.getBorderVertical();
            short bottom = btb == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btb);
            short left = btl == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btl);
            short right = btr == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btr);
            short top = btt == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btt);
            short diagonal = btd == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btd);
            short horizontal = bth == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(bth);
            short vertical = btv == null ? (short)-1 : (short)PoiEnumConversion.toPoiBorderType(btv);
            Color bottomColor = this.toPOIColor(extraStyle.getBorderBottomColor());
            Color leftColor = this.toPOIColor(extraStyle.getBorderLeftColor());
            Color rightColor = this.toPOIColor(extraStyle.getBorderRightColor());
            Color topColor = this.toPOIColor(extraStyle.getBorderTopColor());
            Color diagonalColor = this.toPOIColor(extraStyle.getBorderDiagonalColor());
            Color horizontalColor = this.toPOIColor(extraStyle.getBorderHorizontalColor());
            Color verticalColor = this.toPOIColor(extraStyle.getBorderVerticalColor());
            boolean diaUp = extraStyle.isShowDiagonalUpBorder();
            boolean diaDn = extraStyle.isShowDiagonalDownBorder();
            poiCellStyle.setBorder(left, leftColor, top, topColor, right, rightColor, bottom, bottomColor, diagonal, diagonalColor, horizontal, horizontalColor, vertical, verticalColor, diaUp, diaDn);
        }
        if ((fill = (AbstractFillAdv)extraStyle.getFill()) != null) {
            SColor fgColor = fill.getRawFillColor();
            SColor bgColor = fill.getRawBackColor();
            SFill.FillPattern fillPattern = fill.getRawFillPattern();
            Color fillColor = fgColor == null ? null : this.toPOIColor(fgColor);
            Color backColor = bgColor == null ? null : this.toPOIColor(bgColor);
            short pattern = fillPattern == null ? (short)-1 : (short)PoiEnumConversion.toPoiFillPattern(extraStyle.getFillPattern());
            poiCellStyle.setFill(fillColor, backColor, pattern);
        }
        if ((dataFormat = extraStyle.getDataFormat()) != null) {
            DataFormat df = this.workbook.createDataFormat();
            short fmt = df.getFormat(dataFormat);
            poiCellStyle.setDataFormat(fmt);
        }
        poiCellStyle.setFont(this.toPOIDxfFont(extraStyle.getFont()));
        this.styleTable.put(extraStyle, poiCellStyle);
    }

    protected Font toPOIDxfFont(SFont font0) {
        if (font0 == null) {
            return null;
        }
        XSSFFont poiFont = XSSFFont.createDxfFont();
        AbstractFontAdv font = (AbstractFontAdv)font0;
        if (font.isOverrideBold()) {
            poiFont.setBoldweight(PoiEnumConversion.toPoiBoldweight(font.getBoldweight()));
        }
        if (font.isOverrideStrikeout()) {
            poiFont.setStrikeout(font.isStrikeout());
        }
        if (font.isOverrideItalic()) {
            poiFont.setItalic(font.isItalic());
        }
        if (font.isOverrideColor()) {
            BookHelper.setFontColor(this.workbook, (Font)poiFont, this.toPOIColor(font.getColor()));
        }
        if (font.isOverrideHeightPoints()) {
            poiFont.setFontHeightInPoints((short)font.getHeightPoints());
        }
        if (font.isOverrideName()) {
            poiFont.setFontName(font.getName());
        }
        if (font.isOverrideTypeOffset()) {
            poiFont.setTypeOffset(PoiEnumConversion.toPoiTypeOffset(font.getTypeOffset()));
        }
        if (font.isOverrideUnderline()) {
            poiFont.setUnderline(PoiEnumConversion.toPoiUnderline(font.getUnderline()));
        }
        return poiFont;
    }

    @Override
    protected void exportConditionalFormatting(SSheet sheet, Sheet poiSheet) {
        List<SConditionalFormatting> formattings = sheet.getConditionalFormattings();
        int priority = formattings.size();
        for (SConditionalFormatting cf : formattings) {
            XSSFConditionalFormatting poicf = new XSSFConditionalFormatting((XSSFSheet)poiSheet);
            ((XSSFSheet)poiSheet).addCondtionalFormatting(poicf);
            CTConditionalFormatting ctcf = poicf.getCTConditionalFormatting();
            this.addSqref(ctcf, cf);
            for (SConditionalFormattingRule rule : cf.getRules()) {
                CTCfRule ctRule = ctcf.addNewCfRule();
                this.addPoiRule(sheet, ctRule, rule, priority--);
            }
        }
    }

    protected void addSqref(CTConditionalFormatting ctcf, SConditionalFormatting cf) {
        StringBuilder sb = new StringBuilder();
        for (CellRegion rgn : cf.getRegions()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(rgn.getReferenceString());
        }
        ArrayList<String> sqrefs = new ArrayList<String>();
        sqrefs.add(sb.toString());
        ctcf.setSqref(sqrefs);
    }

    protected void addPoiRule(SSheet sheet, CTCfRule ctRule, SConditionalFormattingRule rule, int priority) {
        SExtraStyle extraStyle;
        ctRule.setType(this.toConditionalFormattingRuleType(rule.getType()));
        ctRule.setPriority(priority);
        if (rule.isStopIfTrue()) {
            ctRule.setStopIfTrue(true);
        }
        if ((extraStyle = rule.getExtraStyle()) != null) {
            this.addPOIDxfCellStyle(extraStyle);
            XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(extraStyle);
            int index = poiCellStyle.getIndex();
            if (index >= 0) {
                ctRule.setDxfId((long)index);
            }
        }
        switch (rule.getType()) {
            case ABOVE_AVERAGE: {
                if (!rule.isAboveAverage()) {
                    ctRule.setAboveAverage(false);
                }
                if (rule.isEqualAverage()) {
                    ctRule.setEqualAverage(true);
                }
                if (rule.getStandardDeviation() == null) break;
                ctRule.setStdDev(rule.getStandardDeviation().intValue());
                break;
            }
            case CELL_IS: {
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case COLOR_SCALE: {
                if (rule.getColorScale() == null) break;
                this.addColorScale(ctRule, rule);
                break;
            }
            case CONTAINS_BLANKS: 
            case NOT_CONTAINS_BLANKS: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case CONTAINS_ERRORS: 
            case NOT_CONTAINS_ERRORS: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case CONTAINS_TEXT: 
            case NOT_CONTAINS_TEXT: {
                if (rule.getText() != null) {
                    ctRule.setText(rule.getText());
                }
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case DATA_BAR: {
                if (rule.getDataBar() == null) break;
                this.addDataBar(ctRule, rule);
                break;
            }
            case BEGINS_WITH: 
            case ENDS_WITH: {
                if (rule.getText() != null) {
                    ctRule.setText(rule.getText());
                }
                if (rule.getOperator() != null) {
                    ctRule.setOperator(this.toCFRuleOperator(rule.getOperator()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case EXPRESSION: {
                this.addFormulas(ctRule, rule);
                break;
            }
            case ICON_SET: {
                if (rule.getIconSet() == null) break;
                this.addIconSet(ctRule, rule);
                break;
            }
            case TIME_PERIOD: {
                if (rule.getTimePeriod() != null) {
                    ctRule.setTimePeriod(this.toTimePeriod(rule.getTimePeriod()));
                }
                this.addFormulas(ctRule, rule);
                break;
            }
            case TOP_10: {
                if (rule.getRank() != null) {
                    ctRule.setRank(rule.getRank().longValue());
                }
                if (rule.isPercent()) {
                    ctRule.setPercent(true);
                }
                if (!rule.isBottom()) break;
                ctRule.setBottom(true);
                break;
            }
        }
    }

    protected void addIconSet(CTCfRule ctRule, SConditionalFormattingRule rule) {
        CTIconSet ctIconSet = ctRule.addNewIconSet();
        SIconSet iconSet = rule.getIconSet();
        for (SCFValueObject vo : iconSet.getCFValueObjects()) {
            CTCfvo ctvo = ctIconSet.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        ctIconSet.setIconSet(this.toIconSetType(iconSet.getType()));
        if (iconSet.isPercent()) {
            ctIconSet.setPercent(true);
        }
        if (iconSet.isReverse()) {
            ctIconSet.setReverse(true);
        }
        if (!iconSet.isShowValue()) {
            ctIconSet.setShowValue(false);
        }
    }

    protected void addColorScale(CTCfRule ctRule, SConditionalFormattingRule rule) {
        SColorScale colorScale = rule.getColorScale();
        CTColorScale ctColorScale = ctRule.addNewColorScale();
        for (SCFValueObject vo : colorScale.getCFValueObjects()) {
            CTCfvo ctvo = ctColorScale.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        for (SColor color : colorScale.getColors()) {
            CTColor ctColor = ctColorScale.addNewColor();
            ctColor.setRgb(((AbstractColorAdv)color).getARGB());
        }
    }

    protected void addDataBar(CTCfRule ctRule, SConditionalFormattingRule rule) {
        CTDataBar ctDataBar = ctRule.addNewDataBar();
        SDataBar dataBar = rule.getDataBar();
        for (SCFValueObject vo : dataBar.getCFValueObjects()) {
            CTCfvo ctvo = ctDataBar.addNewCfvo();
            this.addValueObject(ctvo, vo);
        }
        CTColor ctColor = ctDataBar.addNewColor();
        ctColor.setRgb(((AbstractColorAdv)dataBar.getColor()).getARGB());
        if (dataBar.getMaxLength() != 90) {
            ctDataBar.setMaxLength((long)dataBar.getMaxLength());
        }
        if (dataBar.getMinLength() != 10) {
            ctDataBar.setMinLength((long)dataBar.getMinLength());
        }
        if (!dataBar.isShowValue()) {
            ctDataBar.setShowValue(false);
        }
    }

    protected void addFormulas(CTCfRule ctRule, SConditionalFormattingRule rule) {
        if (rule.getFormula1() != null) {
            ctRule.addFormula(rule.getFormula1().substring(1));
        }
        if (rule.getFormula2() != null) {
            ctRule.addFormula(rule.getFormula2().substring(1));
        }
        if (rule.getFormula3() != null) {
            ctRule.addFormula(rule.getFormula3().substring(1));
        }
    }

    protected void addValueObject(CTCfvo ctvo, SCFValueObject vo) {
        if (vo.isGreaterOrEqual() && ctvo.isSetGte()) {
            ctvo.unsetGte();
        }
        ctvo.setType(this.toValueObjectType(vo.getType()));
        if (vo.getValue() != null) {
            ctvo.setVal(vo.getValue());
        }
    }

    protected STTimePeriod.Enum toTimePeriod(SConditionalFormattingRule.RuleTimePeriod ctPeriod) {
        return STTimePeriod.Enum.forInt((int)ctPeriod.value);
    }

    protected STConditionalFormattingOperator.Enum toCFRuleOperator(SConditionalFormattingRule.RuleOperator ctType) {
        return STConditionalFormattingOperator.Enum.forInt((int)ctType.value);
    }

    protected STIconSetType.Enum toIconSetType(SIconSet.IconSetType ctType) {
        return STIconSetType.Enum.forInt((int)ctType.value);
    }

    protected STCfvoType.Enum toValueObjectType(SCFValueObject.CFValueObjectType ctType) {
        return STCfvoType.Enum.forInt((int)ctType.value);
    }

    protected STCfType.Enum toConditionalFormattingRuleType(SConditionalFormattingRule.RuleType cfType) {
        return STCfType.Enum.forInt((int)cfType.value);
    }

    protected STCfType.Enum toConditionalFormatingRuleType(SConditionalFormattingRule.RuleType stype) {
        return STCfType.Enum.forInt((int)stype.value);
    }

    @Override
    protected void addPOITableStyle(STableStyle tbStyle) {
        STableStyleElem lastTotalCell;
        STableStyleElem firstTotalCell;
        STableStyleElem lastHeaderCell;
        STableStyleElem firstHeaderCell;
        STableStyleElem totalRow;
        STableStyleElem headerRow;
        STableStyleElem firstColumn;
        STableStyleElem lastColumn;
        int dxfId;
        STableStyleElem rowStripe2;
        STableStyleElem rowStripe1;
        STableStyleElem colStripe2;
        STableStyleElem colStripe1;
        XSSFTableStyle poiTbStyle = (XSSFTableStyle)this.tbStyleTable.get(tbStyle);
        if (poiTbStyle != null) {
            this.workbook.addTableStyle((TableStyle)poiTbStyle);
            return;
        }
        poiTbStyle = (XSSFTableStyle)this.workbook.createTableStyle(tbStyle.getName());
        STableStyleElem wholeTable = tbStyle.getWholeTableStyle();
        if (wholeTable != null) {
            int dxfId2 = this.getOrCreateDxfId(wholeTable);
            poiTbStyle.addTableStyleElement(dxfId2, "wholeTable");
        }
        if ((colStripe1 = tbStyle.getColStripe1Style()) != null) {
            int colStripe1Size = tbStyle.getColStripe1Size();
            int dxfId3 = this.getOrCreateDxfId(colStripe1);
            poiTbStyle.addTableStyleElement(dxfId3, "firstColumnStripe", colStripe1Size);
        }
        if ((colStripe2 = tbStyle.getColStripe2Style()) != null) {
            int colStripe2Size = tbStyle.getColStripe2Size();
            int dxfId4 = this.getOrCreateDxfId(colStripe2);
            poiTbStyle.addTableStyleElement(dxfId4, "SecondColumnStripe", colStripe2Size);
        }
        if ((rowStripe1 = tbStyle.getRowStripe1Style()) != null) {
            int rowStripe1Size = tbStyle.getRowStripe1Size();
            int dxfId5 = this.getOrCreateDxfId(rowStripe1);
            poiTbStyle.addTableStyleElement(dxfId5, "firstRowStripe", rowStripe1Size);
        }
        if ((rowStripe2 = tbStyle.getRowStripe2Style()) != null) {
            int rowStripe2Size = tbStyle.getRowStripe2Size();
            dxfId = this.getOrCreateDxfId(rowStripe2);
            poiTbStyle.addTableStyleElement(dxfId, "firstColumnStripe", rowStripe2Size);
        }
        if ((lastColumn = tbStyle.getLastColumnStyle()) != null) {
            dxfId = this.getOrCreateDxfId(lastColumn);
            poiTbStyle.addTableStyleElement(dxfId, "lastColumn");
        }
        if ((firstColumn = tbStyle.getFirstColumnStyle()) != null) {
            int dxfId6 = this.getOrCreateDxfId(firstColumn);
            poiTbStyle.addTableStyleElement(dxfId6, "firstColumn");
        }
        if ((headerRow = tbStyle.getHeaderRowStyle()) != null) {
            int dxfId7 = this.getOrCreateDxfId(headerRow);
            poiTbStyle.addTableStyleElement(dxfId7, "headerRow");
        }
        if ((totalRow = tbStyle.getTotalRowStyle()) != null) {
            int dxfId8 = this.getOrCreateDxfId(totalRow);
            poiTbStyle.addTableStyleElement(dxfId8, "totalRow");
        }
        if ((firstHeaderCell = tbStyle.getFirstHeaderCellStyle()) != null) {
            int dxfId9 = this.getOrCreateDxfId(firstHeaderCell);
            poiTbStyle.addTableStyleElement(dxfId9, "firstHeaderCell");
        }
        if ((lastHeaderCell = tbStyle.getLastHeaderCellStyle()) != null) {
            int dxfId10 = this.getOrCreateDxfId(lastHeaderCell);
            poiTbStyle.addTableStyleElement(dxfId10, "lastHeaderCell");
        }
        if ((firstTotalCell = tbStyle.getFirstTotalCellStyle()) != null) {
            int dxfId11 = this.getOrCreateDxfId(firstTotalCell);
            poiTbStyle.addTableStyleElement(dxfId11, "firstTotalCell");
        }
        if ((lastTotalCell = tbStyle.getLastTotalCellStyle()) != null) {
            int dxfId12 = this.getOrCreateDxfId(lastTotalCell);
            poiTbStyle.addTableStyleElement(dxfId12, "lastTotalCell");
        }
        this.tbStyleTable.put(tbStyle, poiTbStyle);
    }

    protected int getOrCreateDxfId(STableStyleElem tbStyleElem) {
        int index = this.getOrCreateDxfId0(tbStyleElem);
        if (index < 0) {
            this.addPOIDxfCellStyle(tbStyleElem);
            return this.getOrCreateDxfId0(tbStyleElem);
        }
        return index;
    }

    private int getOrCreateDxfId0(STableStyleElem tbStyleElem) {
        XSSFDxfCellStyle poiCellStyle = (XSSFDxfCellStyle)this.styleTable.get(tbStyleElem);
        if (poiCellStyle != null) {
            return this.workbook.getDxfIndex((DxfCellStyle)poiCellStyle);
        }
        return -1;
    }

    @Override
    protected RichTextString toPOIRichText(SRichText richText) {
        CreationHelper helper = this.workbook.getCreationHelper();
        XSSFRichTextString poiRichTextString = (XSSFRichTextString)helper.createRichTextString(richText.getText());
        for (SRichText.Segment sg : richText.getSegments()) {
            SFont font = sg.getFont();
            String text = sg.getText();
            poiRichTextString.addRun(text, (XSSFFont)this.toPOIFont(font));
        }
        return poiRichTextString;
    }
}

